/*
 *  Copyright (C) 2004-2006 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.buchung;

import de.lunqual.rzpro.database.DBBuchung;

public class StatistikListenItem {

	BuchungsItem	bi;
	BuchungsListe	liste;

	double liter;
	double kg;
	double la;

	double rest_liter;
	double rest_kg;
	double rest_la;

	double gesamtLiter;
	double gesamtKg;
	double gesamtLa;

	double gesamtRestLiter;
	double gesamtRestKg;
	double gesamtRestLa;

	String losnummern;

	boolean berechnet;

	public StatistikListenItem(BuchungsItem bi) {
		this.bi = bi;
		liste = new BuchungsListe();
		berechnet = false;
		losnummern = "";
	}

	private void calc() {
		if(!berechnet) {
			if(liste.size()>0) {
				for(int i = 0;i < liste.size();i++) {
					final BuchungsItem bi1 = liste.getItem(i);
					if(bi1.typ == DBBuchung.TYP_ZUGANG) {
						liter += bi1.getLiter();
						kg += bi1.getKg();
						la += bi1.getLa();
						losnummern += bi1.getLosnummer()+",";
						if(bi1.isRest()) {
							rest_liter += bi1.getRest_liter();
							rest_kg += bi1.getRest_kg();
							rest_la += bi1.getRest_la();
						}
					}
				}
			}
			if(losnummern.endsWith(",")) {
				losnummern = losnummern.substring(0,losnummern.length()-1);
			}
			berechnet=true;
		}
	}

	public BuchungsItem getBi() {
		return bi;
	}

	public BuchungsListe getListe() {
		return liste;
	}

	public double getKg() {
		calc();
		return kg;
	}

	public double getLa() {
		calc();
		return la;
	}

	public double getLiter() {
		calc();
		return liter;
	}

	public double getRest_kg() {
		calc();
		return rest_kg;
	}

	public double getRest_la() {
		calc();
		return rest_la;
	}

	public double getRest_liter() {
		calc();
		return rest_liter;
	}

	public String getLosnummern() {
		calc();
		return losnummern;
	}



	public double getGesamtKg() {
		return gesamtKg;
	}

	public double getGesamtLa() {
		return gesamtLa;
	}

	public double getGesamtLiter() {
		return gesamtLiter;
	}


	public void setGesamtKg(double gesamtKg) {
		this.gesamtKg = gesamtKg;
	}

	public void setGesamtLa(double gesamtLa) {
		this.gesamtLa = gesamtLa;
	}

	public void setGesamtLiter(double gesamtLiter) {
		this.gesamtLiter = gesamtLiter;
	}

	public void setListe(BuchungsListe liste) {
		this.liste = liste;
	}

	public double getGesamtRestKg() {
		return gesamtRestKg;
	}

	public void setGesamtRestKg(double gesamtRestKg) {
		this.gesamtRestKg = gesamtRestKg;
	}

	public double getGesamtRestLa() {
		return gesamtRestLa;
	}

	public void setGesamtRestLa(double gesamtRestLa) {
		this.gesamtRestLa = gesamtRestLa;
	}

	public double getGesamtRestLiter() {
		return gesamtRestLiter;
	}

	public void setGesamtRestLiter(double gesamtRestLiter) {
		this.gesamtRestLiter = gesamtRestLiter;
	}

}
