/*
 * Created on 07.10.2004
 *
 */
package de.lunqual.rzpro.items.buchung;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class LosnummerItem {

    RzPro		rz;
    int			zugangsBuchung;
    Date			zugangsDatum;
    int			rezeptur;
    String		losnummer;
    String		comment;
    int			lager;
    double		staerke;
    double		liter;
    double 	kg;
    double		la;
    SimpleDateFormat df;
    String		bezeichnung;
    int			herstellung;
    boolean   r_probe_erforderlich;
    boolean   r_probe_vorhanden;
    int			proben_anzahl;
    String		r_probenliste;
    long			mhd;

    public LosnummerItem(RzPro rz ,int zugangsBuchung,Date zugangsDatum,int rezeptur,String losnummer,String comment,int lager,double staerke,double liter,double kg,double la,String bezeichnung,int herstellung,long mhd) {
        this.rz=rz;
        this.zugangsBuchung=zugangsBuchung;
        this.zugangsDatum = zugangsDatum;
        this.rezeptur=rezeptur;
        this.losnummer=losnummer;
        this.liter=liter;
        this.kg=kg;
        this.la=la;
        this.staerke=staerke;
        this.comment=comment;
        this.bezeichnung=bezeichnung;
        this.herstellung=herstellung;
        this.mhd=mhd;
        this.proben_anzahl = 0;
        checkProbe();
        df = new SimpleDateFormat("dd.MM.yyyy");
    }

    public long getMhd() {
    	return mhd;
    }
    
    private void checkProbe() {
    	if(herstellung != 0) {
    		r_probe_erforderlich=rz.getDatabase().getBuchungen().isRProbe(herstellung);
    	}else {
    		r_probe_erforderlich=false;
    	}
    	proben_anzahl=rz.getDatabase().getBuchungen().isRProbeVorhanden(losnummer);
    	if (proben_anzahl>0) {
        	r_probe_vorhanden=true;
    	} else {
        	r_probe_vorhanden=false;
    	}
    	if(r_probe_vorhanden) {
    		r_probenliste=rz.getDatabase().getProben().getProbenListeLosnummer(losnummer);
    	}
    }
    
    public boolean isProbeErforderlich() {
    	return r_probe_erforderlich;
    }

    public boolean isProbeVorhanden() {
    	return r_probe_vorhanden;
    }
    

    public boolean freigabe() {
    	boolean ret = false;
    	if(r_probe_erforderlich && r_probe_vorhanden) {
    		ret = true;
    	}else {
    		if(!r_probe_erforderlich) {
    			ret = true;
    		}
    	}
    	return ret;
    }
    
    public String getProbenliste() {
    	return r_probenliste;
    }
    
    public String getBezeichnung() {
		return bezeichnung;
	}

    public int getProbenAnzahl() {
    	return proben_anzahl;
    }

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}



	public double getKg() {
        return kg;
    }
    public double getLa() {
        return la;
    }
    public double getLiter() {
        return liter;
    }
    public String getLosnummer() {
        return losnummer;
    }
    public int getZugangsBuchung() {
        return zugangsBuchung;
    }

    public int getRezeptur() {
        return rezeptur;
    }

    public void setComment(String comment) {
    	this.comment=comment;
    }

    public String getCommentLink() {
    	String ret = comment + "<br><h5>Hier klicken um Tanks/Stellplätze zu ändern</h5><br>";
//    	ArrayList<String> tanks = rz.getDatabase().getLager().extractTank(comment);
//    	for(String tank:tanks) {
//    		if(!tank.equals("")) {
//    			ret += rz.getAusgabeFactory().insertGfx("abgang.icon_discard_empty.png") + "&nbsp;" + tank +"<br>&nbsp;";
//    		}
//    	}
    	return ret;
    }
    public String getComment() {
        return comment;
    }

    public double getStaerke() {
        return staerke;
    }

	public int getLager() {
		return lager;
	}
	


	public void setLiter(double liter) {
		this.liter = liter;
	}

	public void setKg(double kg) {
		this.kg = kg;
	}

	public void setLa(double la) {
		this.la = la;
	}

	public String toGrayString() {
        String ret = "<html><div style=\"background-color:#b4b4b4;\"><center>";
        ret +="<b><font color = \"blue\">" + rz.getLocale().getString("buchungsitem.losnummer")+losnummer+"</font></b>  ";
        ret += " ( " + rz.getLocale().getString("losnummer.string_zugang") +  df.format(zugangsDatum) + " )<br>";
        ret +=   rz.getLocale().formatNumber(liter,OptionFactory.NF_NORMAL) + " " +rz.getLocale().getString("string_liter") + ",&nbsp;";
        ret +=   rz.getLocale().formatNumber(kg,OptionFactory.NF_NORMAL) + " " +rz.getLocale().getString("string_kg") + ",&nbsp;";
        ret +=    rz.getLocale().formatNumber(la,OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_la")  +  "<br>";
        if(r_probe_erforderlich) {
        	ret+="<font color=\"red\">" +rz.getLocale().getString("losnummer.string_rprobe_erforderlich") +  "</font><br>";
        }
        if(r_probe_vorhanden) {
        	ret+="<font color=\"green\">" +rz.getLocale().getString("losnummer.string_rprobe_vorhanden") +  "</font><br>";
        }
        return ret + "</center></div></html>";
    }

    @Override
	public String toString() {
        String ret = "<html><div style=\"background-color:white;\"><center>";
        ret +="<b><font color = \"blue\">" + rz.getLocale().getString("buchungsitem.losnummer")+losnummer+"</font></b>  ";
        ret += " ( " + rz.getLocale().getString("losnummer.string_zugang") + 
        df.format(zugangsDatum) + " ) " +    rz.getLocale().getString("losnummer.string_bemerkungen") + comment +  "<br>";
        ret +=   rz.getLocale().formatNumber(liter,OptionFactory.NF_NORMAL) + " " +rz.getLocale().getString("string_liter") + "<br>";
        ret +=   rz.getLocale().formatNumber(kg,OptionFactory.NF_NORMAL) + " " +rz.getLocale().getString("string_kg") + "<br>";
        ret +=    rz.getLocale().formatNumber(la,OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_la")  +  "<br>";
        if(r_probe_erforderlich) {
        	ret+="<font color=\"red\">" +rz.getLocale().getString("losnummer.string_rprobe_erforderlich") +  "</font><br>";
        }
        if(r_probe_vorhanden) {
        	ret+="<font color=\"green\">" +rz.getLocale().getString("losnummer.string_rprobe_vorhanden") +  "</font><br>";
        }
        return ret + "</center></div></html>";
    }
    public String toPlainString() {
        String ret = "";
        ret +=   rz.getLocale().getString("buchungsitem.losnummer")+losnummer + "\n";
        ret += " ( " + rz.getLocale().getString("losnummer.string_zugang") +  df.format(zugangsDatum) + " )\n";
        ret +=   rz.getLocale().formatNumber(liter,OptionFactory.NF_NORMAL) + " " +rz.getLocale().getString("string_liter") + "\n";
        ret +=   rz.getLocale().formatNumber(kg,OptionFactory.NF_NORMAL) + " " +rz.getLocale().getString("string_kg") + "\n";
        ret +=    rz.getLocale().formatNumber(la,OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_la")  +  "\n";
        return ret + "--------------------------------------------------------------------\n\n";
    }
}
