/*
 * Created on 18.10.2004
 *
 */
package de.lunqual.rzpro.items.buchung;

import java.awt.Color;
import java.util.Date;

import de.lunqual.rzpro.RzPro;

/**
 * @author labor
 *
 */
public class HerstellungsItem {

	RzPro						rz;
    int							id;
    int							rezeptur;
    String						bezeichnung;
    Date							datum;
    String						losnummer;
    boolean					erledigt;
    boolean					uebernommen;
    double						liter;
    double						kg;
    double						la;
    double						schwundsatz;
    double						endmenge_liter;
    double						endmenge_kg;
    double						endmenge_la;
    String 						user;
    int							lager;
    String						hg;
    String						vg;
    Color							c_hg;
    Color							c_vg;
    String						tank;
    String						probeNummer;
    int							probenID;
    String						bemerkungen;
    boolean					r_probe;
    boolean					rest;

    public HerstellungsItem(
    	RzPro						rz,
        int 							id,
        int							rezeptur,
        String						bezeichnung,
        Date							datum,
        String						losnummer,
        boolean					erledigt,
        boolean					uebernommen,
        double						liter,
        double						kg,
        double						la,
        double						schwundsatz,
        double						endmenge_liter,
        double						endmenge_kg,
        double						endmenge_la,
        String							user,
        int								lager,
        String							hg,
        String							vg,
        String							tank,
        String 							probeNummer,
        int								probenID,
        boolean						r_probe,
        boolean 						rest
    	) {
    	this.rz = rz;
        this.id=id;
        this.rezeptur=rezeptur;
        this.bezeichnung=bezeichnung;
        this.datum=datum;
        this.losnummer=losnummer;
        this.erledigt=erledigt;
        this.uebernommen=uebernommen;
        this.liter=liter;
        this.kg=kg;
        this.la=la;
        this.schwundsatz=schwundsatz;
        this.endmenge_liter=endmenge_liter;
        this.endmenge_kg=endmenge_kg;
        this.endmenge_la=endmenge_la;
        this.user=user;
        this.lager=lager;
        this.tank=tank;
        this.probeNummer=probeNummer;
        this.probenID=probenID;
        this.bemerkungen="";
        this.r_probe=r_probe;
        this.rest=rest;
        setHg(hg);
        setVg(vg);
    }

    public boolean isRest() {
    	return rest;
    }
    
    public boolean isRProbe() {
    	return r_probe;
    }
    
    public void setRProbe(boolean p) {
    	r_probe = p;
    }
    
    public boolean isProbe() {
    	return probenID >0?true:false;
    }
 
    public String getProbe() {
    	String ret="";
    	if(probeNummer != null ) {
    		if (!probeNummer.equals(""))ret = String.valueOf(probenID);
    	}
    	return ret;
    }
    
	public String getTank() {
		return tank;
	}

    
	public String getTankHTML() {
		String ret = "";
	    	String nummern[] = tank.split("\\s|,|;|:|-");
	    	for(String n:nummern) {
	    		try {
	    			if(rz.getDatabase().getTank().tankExists(n)) {
	    				ret +="<a href=\"ttt:" +  n + "\">" + n + "</a>&nbsp;&nbsp;";
	    			} else {
	    				ret += " " + n + " ";
	    			}
	    		}catch(Exception e) {}
	    	}
		return ret;
	}


	public void setTank(String tank) {
		this.tank = tank;
	}



	public String getBezeichnung() {
        return bezeichnung;
    }
    public void setBezeichnung(String bezeichnung) {
        this.bezeichnung = bezeichnung;
    }
    public Date getDatum() {
        return datum;
    }
    public void setDatum(Date datum) {
        this.datum = datum;
    }
    public double getEndmenge_kg() {
        return endmenge_kg;
    }
    public void setEndmenge_kg(double endmenge_kg) {
        this.endmenge_kg = endmenge_kg;
    }
    public double getEndmenge_la() {
        return endmenge_la;
    }
    public void setEndmenge_la(double endmenge_la) {
        this.endmenge_la = endmenge_la;
    }
    public double getEndmenge_liter() {
        return endmenge_liter;
    }
    public void setEndmenge_liter(double endmenge_liter) {
        this.endmenge_liter = endmenge_liter;
    }
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }
    public double getKg() {
        return kg;
    }
    public void setKg(double kg) {
        this.kg = kg;
    }
    public double getLa() {
        return la;
    }
    public void setLa(double la) {
        this.la = la;
    }
    public double getLiter() {
        return liter;
    }
    public void setLiter(double liter) {
        this.liter = liter;
    }
    public String getLosnummer() {
        return losnummer;
    }
    public void setLosnummer(String losnummer) {
        this.losnummer = losnummer;
    }
    public int getRezeptur() {
        return rezeptur;
    }
    public void setRezeptur(int rezeptur) {
        this.rezeptur = rezeptur;
    }
    public double getSchwundsatz() {
        return schwundsatz;
    }
    public void setSchwundsatz(double schwundsatz) {
        this.schwundsatz = schwundsatz;
    }
    public String getUser() {
        return user;
    }
    public void setUser(String user) {
        this.user = user;
    }

    public boolean isErledigt() {
        return erledigt;
    }
    public void setErledigt(boolean erledigt) {
        this.erledigt = erledigt;
    }
    public boolean isUebernommen() {
        return uebernommen;
    }
    public void setUebernommen(boolean uebernommen) {
        this.uebernommen = uebernommen;
    }

    public void setLager(int lager) {
    	this.lager =lager;
    }

    public int getLager() {
    	return lager;
    }

	public String getHg() {
		return hg;
	}

	public String getVg() {
		return vg;
	}

	public void setHg(String hg) {
		this.hg = hg;
		c_hg = getRGBColorString(hg) ;
	}

	public void setVg(String vg) {
		this.vg = vg;
		c_vg = getRGBColorString(vg) ;
	}

	public Color getC_hg() {
		return c_hg;
	}

	public Color getC_vg() {
		return c_vg;
	}

	/**
	 * gibt eine Farbe aus einem String zurück
	 * @param key
	 * @return
	 */
	public Color getRGBColorString(String c) {
		int r =0;
		int g = 0;
		int b=0;
		if(c.equals("")) {
			c = "000000";
		}
		try {
			r = Integer.decode("#" + c.substring(0,2)).intValue();
			g = Integer.decode("#" + c.substring(2,4)).intValue();
			b= Integer.decode("#" + c.substring(4,6)).intValue();
		}
		catch(final Exception e) {
			r=0;g=0;b=0;
		}
		return new Color(r,g,b);
	}

	public String getBemerkungen() {
		return bemerkungen;
	}

	public void setBemerkungen(String bemerkungen) {
		this.bemerkungen = bemerkungen;
	}
	
	
}
