/*
 * Created on 06.10.2004
 *
 */
package de.lunqual.rzpro.items.buchung;

import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.rezeptur.RezepturBuchungsItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
/**
 * @author labor
 *
 */
public class BuchungsItem {



    RzPro								rz;
    int									id;
    int									typ;
    int									code;
    int									lager;
    int									herstellung;
    String								herstellung_losnummer;
    int									rezeptur_id;
    RezepturBuchungsItem				rezeptur;
    Date								datum;
    String								user;
    String								bezeichnung;
    String								losnummer;
    int									losnummer_reihe;
    String								comment;

    boolean								erledigt;
    boolean								uebernommen;

    int									einheit;
    double								staerke;
    double								litergewicht;

    double 								liter;
    double								kg;
    double								la;

    double								rest_liter;
    double								rest_kg;
    double								rest_la;
    boolean								rest;

    LosnummerListe						losnummerListe;

    EinheitsItem						einheitsItem;
    double								value;
    
    String								herstellung_bezeichnung;
    String								herstellungProbe;

    long								mhd;
    String								adressen;
    StichwortListe						adressliste;
    
    int									mischung;
    
    String								steuer_artikel;
    int									sorte;
    int									steuerlager;
    String								strSorte;
    String								strSteuerlager;
    

    public BuchungsItem(
            RzPro								rz,
            int									id,
            int									typ,
            int									code,
			int									lager,
            int									herstellung,
            int									rezeptur_id,
            RezepturBuchungsItem	rezeptur,
            Date									datum,
            String								user,
            String								bezeichnung,
            String								losnummer,
            int									losnummer_reihe,
            String								comment,
            boolean								erledigt,
            boolean								uebernommen,
            int									einheit,
            double								staerke,
            double								litergewicht,
            double								liter,
            double								kg,
            double								la,

            double								rest_liter,
            double								rest_kg,
            double								rest_la,
            boolean								rest,
            boolean								rezeptur_holen,
            long								mhd,
            String								adressen,
            int 								mischung,
            	String								steuer_artikel,
            	int									sorte,
            	int									steuerlager,
            	String								strSorte,
            	String								strSteuerlager
    ) {
        this.rz = rz;
        this.id=id;
        this.typ=typ;
        this.code=code;
        this.lager = lager;
        this.herstellung = herstellung;
        this.rezeptur_id=rezeptur_id;
        this.datum = datum;
        this.user=user;
        this.bezeichnung=bezeichnung;
        this.losnummer = losnummer;
        this.losnummer_reihe = losnummer_reihe;
        this.comment=comment;
        this.erledigt=erledigt;
        this.uebernommen=uebernommen;
        this.einheit = einheit;
        this.liter=liter;
        this.la = la;
        this.kg =kg;
        this.rest_liter=rest_liter;
        this.rest_kg=rest_kg;
        this.rest_la=rest_la;
        this.rest = rest;
        this.rezeptur = rezeptur;
        this.losnummerListe = new LosnummerListe(rz);
        if(id == 0 ) {
            // neues Item, Daten aus der Rezeptur auslesen;
            if(this.rezeptur != null) {
                this.staerke = this.rezeptur.getStaerke();
                this.litergewicht = this.rezeptur.getLitergewicht();
                this.bezeichnung = this.rezeptur.getTitel();
                this.einheit = this.rezeptur.getBestandseinheit();
                this.lager = this.rezeptur.getLager();
                if(losnummer.equals("")) {
					this.losnummer=rezeptur.getLosnummer();
				}
            }
        }
        if((rezeptur_id != 0) && rezeptur_holen) {
            // rezepturdaten holen
            RezepturBuchungsItem r1 = rz.getDatabase().getRezeptur().getRezepturBuchung(rezeptur_id);
            if(r1.getVerweis() != 0) {
                this.rezeptur = rz.getDatabase().getRezeptur().getRezepturBuchung(r1.getVerweis());
                this.rezeptur.setTitel(r1.getTitel());
                //this.rezeptur.setAdressListe(r1.getAdressListe().copyList());
                //this.rezeptur.setStichwortListe(r1.getStichwortListe().copyList());
                r1 = null;
            } else {
                this.rezeptur = r1;
            }
            this.bezeichnung=this.rezeptur.getTitel();
            this.staerke = this.rezeptur.getStaerke();
            this.litergewicht = this.rezeptur.getLitergewicht();
            this.einheit = this.rezeptur.getBestandseinheit();
            this.lager = this.rezeptur.getLager();
            if (losnummer.equals("")) {
				this.losnummer = this.rezeptur.getLosnummer();
			}

        }
        // Stärke/ litergewicht /bezeichnung auf jeden Fall aus dem BuchungsItem beziehen, wenn die
        // Daten aus einem bereits gespeicherten Datensatz stammen
        if (this.id != 0) {
        	this.staerke=staerke;
        	this.litergewicht=litergewicht;
            this.bezeichnung=bezeichnung;
            this.lager = lager;
            this.datum=datum;
        }
        this.herstellung_bezeichnung="";
        this.herstellungProbe="";
        this.mhd=mhd;
        this.adressen=adressen;
        this.adressliste=rz.getDatabase().getSTW().dbGetAdressenListe(this.adressen);
        this.mischung=mischung;
        this.steuer_artikel=steuer_artikel;
        this.sorte = sorte;
        	this.steuerlager = steuerlager;
        	this.strSorte = strSorte;
        	this.strSteuerlager = strSteuerlager;
     }

    
    public BuchungsItem(
            RzPro							rz,
            int								id,
            int								typ,
            int								code,
			int								lager,
            int								herstellung,
            int								rezeptur_id,
            RezepturBuchungsItem			rezeptur,
            Date							datum,
            String							user,
            String							bezeichnung,
            String							losnummer,
            int								losnummer_reihe,
            String							comment,
            boolean							erledigt,
            boolean							uebernommen,
            int								einheit,
            double							staerke,
            double							litergewicht,
            double							liter,
            double							kg,
            double							la,

            double							rest_liter,
            double							rest_kg,
            double							rest_la,
            boolean							rest,
            boolean							rezeptur_holen,
            long							mhd,
            int								mischung,
            	String							steuer_artikel,
            	int								sorte,
            	int								steuerlager,
            	String							strSorte,
            	String							strSteuerlager

    ) {
        this.rz = rz;
        this.id=id;
        this.typ=typ;
        this.code=code;
        this.lager = lager;
        this.herstellung = herstellung;
        this.rezeptur_id=rezeptur_id;
        this.datum = datum;
        this.user=user;
        this.bezeichnung=bezeichnung;
        this.losnummer = losnummer;
        this.losnummer_reihe = losnummer_reihe;
        this.comment=comment;
        this.erledigt=erledigt;
        this.uebernommen=uebernommen;
        this.einheit = einheit;
        this.liter=liter;
        this.la = la;
        this.kg =kg;
        this.rest_liter=rest_liter;
        this.rest_kg=rest_kg;
        this.rest_la=rest_la;
        this.rest = rest;
        this.rezeptur = rezeptur;
        this.losnummerListe = new LosnummerListe(rz);
        if(id == 0 ) {
            // neues Item, Daten aus der Rezeptur auslesen;
            if(this.rezeptur != null) {
                this.staerke = this.rezeptur.getStaerke();
                this.litergewicht = this.rezeptur.getLitergewicht();
                this.bezeichnung = this.rezeptur.getTitel();
                this.einheit = this.rezeptur.getBestandseinheit();
                this.lager = this.rezeptur.getLager();
                if(losnummer.equals("")) {
					this.losnummer=rezeptur.getLosnummer();
				}
            }
        }
        if((rezeptur_id != 0) && rezeptur_holen) {
            // rezepturdaten holen
            RezepturBuchungsItem r1 = rz.getDatabase().getRezeptur().getRezepturBuchung(rezeptur_id);
            if(r1.getVerweis() != 0) {
                this.rezeptur = rz.getDatabase().getRezeptur().getRezepturBuchung(r1.getVerweis());
                this.rezeptur.setTitel(r1.getTitel());
                //this.rezeptur.setAdressListe(r1.getAdressListe().copyList());
                //this.rezeptur.setStichwortListe(r1.getStichwortListe().copyList());
                r1 = null;
            } else {
                this.rezeptur = r1;
            }
            this.bezeichnung=this.rezeptur.getTitel();
            this.staerke = this.rezeptur.getStaerke();
            this.litergewicht = this.rezeptur.getLitergewicht();
            this.einheit = this.rezeptur.getBestandseinheit();
            this.lager = this.rezeptur.getLager();
            if (losnummer.equals("")) {
				this.losnummer = this.rezeptur.getLosnummer();
			}

        }
        // Stärke/ litergewicht /bezeichnung auf jeden Fall aus dem BuchungsItem beziehen, wenn die
        // Daten aus einem bereits gespeicherten Datensatz stammen
        if (this.id != 0) {
        	this.staerke=staerke;
        	this.litergewicht=litergewicht;
            this.bezeichnung=bezeichnung;
            this.lager = lager;
            this.datum=datum;
        }
        this.herstellung_bezeichnung="";
        this.herstellungProbe="";
        this.mhd=mhd;
        this.adressen = "";
        this.adressliste=new StichwortListe();
        this.mischung = mischung;
        this.steuer_artikel=steuer_artikel;
        this.sorte = sorte;
        	this.steuerlager = steuerlager;
        	this.strSorte = strSorte;
        	this.strSteuerlager = strSteuerlager;
    }

    
    
    public String getStrSorte() {
		return strSorte;
	}
	public void setStrSorte(String strSorte) {
		this.strSorte = strSorte;
	}
	public String getStrSteuerlager() {
		return strSteuerlager;
	}
	public void setStrSteuerlager(String strSteuerlager) {
		this.strSteuerlager = strSteuerlager;
	}
	public String getSteuer_artikel() {
		return steuer_artikel;
	}
	public void setSteuer_artikel(String steuer_artikel) {
		this.steuer_artikel = steuer_artikel;
	}
	public int getSorte() {
		return sorte;
	}
	public void setSorte(int sorte) {
		this.sorte = sorte;
		this.strSorte = rz.getDatabase().getMischungen().getSorte(sorte).getBezeichnung();
	}
	public int getSteuerlager() {
		return steuerlager;
	}
	public void setSteuerlager(int steuerlager) {
		this.steuerlager = steuerlager;
		this.strSteuerlager = rz.getDatabase().getRezeptur().getSteuerLager(steuerlager).getBezeichnung();
	}
	public int getMischung() {
		return mischung;
	}
	public void setMischung(int mischung) {
		this.mischung = mischung;
	}
	public String getAdressenString() {
    	return adressen;
    }
    
    public StichwortListe getAdressliste() {
    	return adressliste;
    }

    public boolean isMhd() {
		return mhd==0?false:true;
	}
    
    public void setMhd(long value) {
    	mhd=value;
    }
    public long getMhdLong() {
    	return mhd;
    }
    public Date getMhd() {
    	Date d = null;
    	if(mhd != 0) {
    		d = new Date();
    		d.setTime(mhd);
    	}
    	return d;
    }
    
    public String getHerstellung_bezeichnung() {
		return herstellung_bezeichnung;
	}
	public void setHerstellung_bezeichnung(String herstellung_bezeichnung) {
		this.herstellung_bezeichnung = herstellung_bezeichnung;
	}
	public String getHerstellungProbe() {
		return herstellungProbe ;
	}
	
	public void addHerstellungProbe(int Probe) { 
		if(Probe != 0) {
			if(this.herstellungProbe.equals("")) {
				this.herstellungProbe=String.valueOf(Probe);
			}else {
				this.herstellungProbe += "," + String.valueOf(Probe);
			}
		}
	}
	public void setHerstellungProbe(int herstellungProbe) {
		if(herstellungProbe != 0) {
			this.herstellungProbe = String.valueOf(herstellungProbe);
		}else {
			this.herstellungProbe="";
		}
	}
	
	public String getBezeichnung() {
        return bezeichnung;
    }
    public void setBezeichnung(String bezeichnung) {
        this.bezeichnung = bezeichnung;
    }
    public int getCode() {
        return code;
    }
    public void setCode(int code) {
        this.code = code;
    }
    public Date getDatum() {
        return datum;
    }
    public void setDatum(Date datum) {
        this.datum = datum;
    }
    public boolean isErledigt() {
        return erledigt;
    }
    public void setErledigt(boolean erledigt) {
        this.erledigt = erledigt;
    }
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }
    public double getKg() {
        return kg;
    }
    public void setKg(double kg) {
        this.kg = kg;
    }
    public double getLa() {
        return la;
    }
    public void setLa(double la) {
        this.la = la;
    }
    public double getLiter() {
        return liter;
    }
    public void setLiter(double liter) {
        this.liter = liter;
    }
    public double getLitergewicht() {
        return litergewicht;
    }
    public void setLitergewicht(double litergewicht) {
        this.litergewicht = litergewicht;
    }
    public String getLosnummer() {
        return losnummer;
    }
    public void setLosnummer(String losnummer) {
        this.losnummer = losnummer;
    }
    public double getRest_liter() {
        return rest_liter;
    }
    public void setRest_liter(double rest_liter) {
        this.rest_liter = rest_liter;
    }
    public int getRezeptur_id() {
        return rezeptur_id;
    }
    public void setRezeptur_id(int rezeptur_id) {
        this.rezeptur_id = rezeptur_id;
    }
    public double getStaerke() {
        return staerke;
    }
    public void setStaerke(double staerke) {
        this.staerke = staerke;
    }
    public int getTyp() {
        return typ;
    }
    public void setTyp(int typ) {
        this.typ = typ;
    }
    public boolean isUebernommen() {
        return uebernommen;
    }
    public void setUebernommen(boolean uebernommen) {
        this.uebernommen = uebernommen;
    }
    public String getUser() {
        return user;
    }
    public void setUser(String user) {
        this.user = user;
    }

    public double getRest_kg() {
        return rest_kg;
    }
    public void setRest_kg(double rest_kg) {
        this.rest_kg = rest_kg;
    }
    public double getRest_la() {
        return rest_la;
    }
    public void setRest_la(double rest_la) {
        this.rest_la = rest_la;
    }
    public RezepturBuchungsItem getRezeptur() {
        return rezeptur;
    }
    public void setRezeptur(RezepturBuchungsItem rezeptur) {
        this.rezeptur = rezeptur;
    }

    public int getHerstellung() {
        return herstellung;
    }
    public void setHerstellung(int herstellung) {
        this.herstellung = herstellung;
    }

    public int getEinheit() {
        return einheit;
    }
    public void setEinheit(int einheit) {
        this.einheit = einheit;
    }
    @Override
	public String toString() {
        return getRezeptur() != null ? getRezeptur().getTitel() : "keine rezeptur";
    }

    public String getComment() {
        return comment.length() > rz.getDatabase().getBuchungen().getMaxCommentSize()?comment.substring(0,rz.getDatabase().getBuchungen().getMaxCommentSize()-1):comment;
    }
   
    public void setComment(String comment) {
        this.comment = comment;
    }

    public LosnummerListe getLosnummerListe() {
        return losnummerListe;
    }
    public void setLosnummerListe(LosnummerListe losnummerListe) {
        this.losnummerListe = losnummerListe;
    }

    public boolean isRest() {
        return rest;
    }
    public void setRest(boolean rest) {
        this.rest = rest;
    }

    public int getLosnummer_reihe() {
        return losnummer_reihe;
    }
    public void setLosnummer_reihe(int losnummer_reihe) {
        this.losnummer_reihe = losnummer_reihe;
    }

	public EinheitsItem getEinheitsItem() {
		return einheitsItem;
	}
	public void setEinheitsItem(EinheitsItem einheitsItem) {
		this.einheitsItem = einheitsItem;
	}
	public int getLager() {
		return lager;
	}
	public void setLager(int lager) {
		this.lager = lager;
	}

	public String getHerstellung_losnummer() {
		return herstellung_losnummer;
	}
	public void setHerstellung_losnummer(String herstellung_losnummer) {
		this.herstellung_losnummer = herstellung_losnummer;
	}
	
	
	  public String getLiterToolTip() {
			double l01=0.0,l02=0.0,l035=0.0,l05=0.0,l07=0.0,l1=0.0;
			l1=Math.abs(liter);
			l07=Math.abs(liter*(1/0.7));
			l05=Math.abs(liter*2);
			l035=Math.abs(liter*(1/0.35));
			l02=Math.abs(liter*(1/0.2));
			l01=Math.abs(liter*10);
			String tt = "<html><table border=\"1\">";
			tt+="<tr><td>" + Double.toString(Math.round(l1)) + "&nbsp * 1 " + rz.getLocale().getString("string_liter") + "</td></tr>";
			tt+="<tr><td>" + Double.toString(Math.round(l07)) + "&nbsp* 0,7 " + rz.getLocale().getString("string_liter") + "</td></tr>";
			tt+="<tr><td>" + Double.toString(Math.round(l05)) + "&nbsp* 0,5 " + rz.getLocale().getString("string_liter") + "</td></tr>";
			tt+="<tr><td>" + Double.toString(Math.round(l035)) + "&nbsp* 0,35 " + rz.getLocale().getString("string_liter") + "</td></tr>";
			tt+="<tr><td>" + Double.toString(Math.round(l02)) + "&nbsp* 0,2 " + rz.getLocale().getString("string_liter") + "</td></tr>";
			tt+="<tr><td>" + Double.toString(Math.round(l01)) + "&nbsp* 0,1 " + rz.getLocale().getString("string_liter") + "</td></tr>";
			tt += "</table></html>";
			return tt;
	    }
}
