package de.lunqual.rzpro.items.buchung;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

public class BuchungLosnummerItem {
	RzPro	rz;
	int 	id;
	int rezeptur_id;
	String	bezeichnung;
	String	losnummer;
	double 	liter;
	Date	datum;
	SimpleDateFormat df;
	
	
	public BuchungLosnummerItem(RzPro rz,int id,int rezeptur_id, String bezeichnung, String losnummer, double liter,Date datum) {
		this.rz = rz;
		this.id = id;
		this.rezeptur_id=rezeptur_id;
		this.bezeichnung = bezeichnung;
		this.losnummer = losnummer;
		this.datum = datum;
		this.liter = liter;
        df = new SimpleDateFormat("EEEE dd. MMMM yyyy HH:mm");
	}
	
	public int getRezeptur_id() {
		return rezeptur_id;
	}

	public double getLiter() {
		return liter;
	}
	
	public int getId() {
		return id;
	}
	public String getBezeichnung() {
		return bezeichnung;
	}
	public String getLosnummer() {
		return losnummer;
	}
	public Date getDatum() {
		return datum;
	}
	
	public BuchungLosnummerItem copyItem() {
		return new BuchungLosnummerItem(rz,id,rezeptur_id,bezeichnung,losnummer,liter,datum);
	}
	public String toString() {
		String ret = "<html>";
		ret += "<b>"+losnummer + "</b><br>";
		ret += rz.getLocale().formatNumber(liter,OptionFactory.NF_ONE) + "&nbsp;" + rz.getLocale().getString("string_liter")+ "&nbsp;"+ bezeichnung +"<br>";
		ret += df.format(datum);
		return ret + "</html>";
	}
}
