package de.lunqual.rzpro.items.bewertungen;

import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBBewertungen;
import de.lunqual.rzpro.options.OptionFactory;

public class UnterkategorieListe extends ArrayList{

	RzPro							rz;

	public UnterkategorieListe(RzPro rz) {
		super();
		this.rz = rz;
	}

	public void addItem(UnterkategorieItem uki) {
		this.add(uki);
	}
	
	public UnterkategorieItem getItem(int i) {
		return (UnterkategorieItem)this.get(i);
	}
	
	public boolean isValid() {
		for(int i = 0;i < this.size();i++) {
			if(this.getItem(i).getBewertung() >= 0) {
				return true;
			}
		}
		return false;
	}
	
	public String getErgebnisseListe() {
		String ret = "";
		for(int i = 0;i < this.size();i++) {
			UnterkategorieItem uki = this.getItem(i);
			if(uki != null) {
				ret += uki.getBezeichnung() + DBBewertungen.LISTENTRENNER + Double.toString(uki.getBewertung()) + "\n";
			}
		}
		return ret;
	}
	
	public String getErgebnisseListeString() {
		String ret = "";
		for(int i = 0;i < this.size();i++) {
			UnterkategorieItem uki = this.getItem(i);
			if(uki != null && uki.getBewertung() >= 0) {
				ret += rz.getLocale().getString("bewertungdrucken.string_unterkategorie")
						.replaceAll("%v",rz.getLocale().formatNumber(uki.getBewertung(), OptionFactory.NF_TWO))
						.replaceAll("%b", uki.getBezeichnung()) + "\n";
			}
		}
		return ret;
	}
}
