package de.lunqual.rzpro.items.bewertungen;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBBewertungen;

public class KategorieItem {
	
	RzPro					rz;
	int						id;
	String					bezeichnung;
	double					gewichtung;
	double					bewertung;
	String					rawListe;
	UnterkategorieListe		liste;
	UnterkategorieListe		liste_leer;


	
	public KategorieItem(RzPro rz, int id, String bezeichnung, double gewichtung,double bewertung, String rawListe) {
		this.rz = rz;
		this.id = id;
		this.bezeichnung = bezeichnung;
		this.gewichtung = gewichtung;
		this.rawListe = rawListe;
		this.bewertung = bewertung;
		initListe();
	}
	
	public UnterkategorieListe getListe() {
		return (bewertung < 0 || (rz.isZero(DBBewertungen.MAX_BEWERTUNG - bewertung)))?liste_leer:liste;
	}
	
	public  UnterkategorieListe getOriginalListe() {
		return liste;
	}
	private void initListe() {
		liste = new UnterkategorieListe(rz);
		liste_leer = new UnterkategorieListe(rz);
		if(rawListe != null && !rawListe.equals("")) {
			String[] zeilen = rawListe.split("\\n");
			for(String zeile:zeilen) {
				double value = -1;
				if(zeile.indexOf(DBBewertungen.LISTENTRENNER) != -1) {
					try {
						value = Double.valueOf(zeile.substring(zeile.indexOf(DBBewertungen.LISTENTRENNER)+DBBewertungen.LISTENTRENNER.length()));
						zeile = zeile.substring(0,zeile.indexOf(DBBewertungen.LISTENTRENNER));
					}catch(Exception e) {}
				}
				liste.addItem(new UnterkategorieItem(zeile,value));
			}
		}
	}

	public boolean isValid() {
		if(bewertung < 0) {
			return false;
		} else if(bewertung < DBBewertungen.MAX_BEWERTUNG) {
			if(!liste.isValid()) {
				return false;
			}
		} 
		return true;
	}
	
	public double getBewertung() {
		return bewertung;
	}

	public void setBewertung(double bewertung) {
		this.bewertung = bewertung;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public double getGewichtung() {
		return gewichtung;
	}

	public void setGewichtung(double gewichtung) {
		this.gewichtung = gewichtung;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}
	
}
