package de.lunqual.rzpro.items.bewertungen;

import java.util.Calendar;

import de.lunqual.rzpro.RzPro;

public class BewertungsAbfrageItem {
	
	public static final int	DATE_NONE 		= 0;
	public static final int	DATE_ERSTELLT	= 1;
	public static final int	DATE_GEAENDERT	= 2;
	
	RzPro			rz;
	int 			id;
	int 			dateMode;
	int 			vonJahr;
	int				vonMonat;
	int				vonTag;
	int 			bisJahr;
	int				bisMonat;
	int				bisTag;	
	String			nummer;
	String			bezeichnung;
	String			losnummer;
	

	public BewertungsAbfrageItem(RzPro rz, int dateMode, int vonJahr, int vonMonat, int vonTag, int bisJahr, int bisMonat, int bisTag, String nummer, String bezeichnung, String losnummer) {
		this.rz = rz;
		this.dateMode = dateMode;
		this.vonJahr = vonJahr;
		this.vonMonat = vonMonat;
		this.vonTag = vonTag;
		this.bisJahr = bisJahr;
		this.bisMonat = bisMonat;
		this.bisTag = bisTag;
		this.nummer = nummer;
		this.bezeichnung = bezeichnung;
		this.losnummer = losnummer;
	}

	public BewertungsAbfrageItem(RzPro rz,int mischung) {
		Calendar now = Calendar.getInstance();
		this.rz = rz;
		this.dateMode = BewertungsAbfrageItem.DATE_NONE;
		this.vonJahr = now.get(Calendar.YEAR);
		this.vonMonat = now.get(Calendar.MONTH);
		this.vonTag = now.get(Calendar.DAY_OF_MONTH);
   		this.bisJahr = now.get(Calendar.YEAR);
		this.bisMonat =now.get(Calendar.MONTH);
		this.bisTag = now.get(Calendar.DAY_OF_MONTH);
		this.nummer = String.valueOf(mischung);
		this.bezeichnung = "";
		this.losnummer = "";
	}
	
	public BewertungsAbfrageItem(RzPro rz) {
		Calendar now = Calendar.getInstance();
		this.rz = rz;
		this.dateMode = rz.getOptionFactory().getOption("mischung.abfrage.mode",BewertungsAbfrageItem.DATE_NONE);
		this.vonJahr = rz.getOptionFactory().getOption("mischung.abfrage.von_jahr",now.get(Calendar.YEAR));
		this.vonMonat = rz.getOptionFactory().getOption("mischung.abfrage.von_monat",now.get(Calendar.MONTH));
		this.vonTag = rz.getOptionFactory().getOption("mischung.abfrage.von_tag",now.get(Calendar.DAY_OF_MONTH));
   		this.bisJahr = rz.getOptionFactory().getOption("mischung.abfrage.bis_jahr",now.get(Calendar.YEAR));
		this.bisMonat = rz.getOptionFactory().getOption("mischung.abfrage.bis_monat",now.get(Calendar.MONTH));
		this.bisTag = rz.getOptionFactory().getOption("mischung.abfrage.bis_tag",now.get(Calendar.DAY_OF_MONTH));
		this.nummer = rz.getOptionFactory().getOption("mischung.abfrage.mischungsnummer");
		this.bezeichnung = rz.getOptionFactory().getOption("mischung.abfrage.mischungsbezeichnung");
		this.losnummer = rz.getOptionFactory().getOption("mischung.abfrage.tank");
	}
	
//	public BewertungsAbfrageItem clone() {
//		return new BewertungsAbfrageItem(
//				rz,
//				dateMode,
//				vonJahr,vonMonat,vonTag,
//				bisJahr,bisMonat,bisTag,
//				nummer,
//				bezeichnung,
//				losnummer
//				);
//	}
//	
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getDateMode() {
		return dateMode;
	}

	public void setDateMode(int dateMode) {
		this.dateMode = dateMode;
	}

	
	public int getVonJahr() {
		return vonJahr;
	}

	public void setVonJahr(int vonJahr) {
		this.vonJahr = vonJahr;
	}

	public int getVonMonat() {
		return vonMonat;
	}

	public void setVonMonat(int vonMonat) {
		this.vonMonat = vonMonat;
	}

	public int getVonTag() {
		return vonTag;
	}

	public void setVonTag(int vonTag) {
		this.vonTag = vonTag;
	}

	public int getBisJahr() {
		return bisJahr;
	}

	public void setBisJahr(int bisJahr) {
		this.bisJahr = bisJahr;
	}

	public int getBisMonat() {
		return bisMonat;
	}

	public void setBisMonat(int bisMonat) {
		this.bisMonat = bisMonat;
	}

	public int getBisTag() {
		return bisTag;
	}

	public void setBisTag(int bisTag) {
		this.bisTag = bisTag;
	}

	public String getMischungNummer() {
		return saveValue(nummer);
	}

	public void setNummer(String mischungNummer) {
		this.nummer = mischungNummer;
	}

	public String getMischungBezeichnung() {
		return saveValue(bezeichnung);
	}

	public void setBezeichnung(String mischungBezeichnung) {
		this.bezeichnung = mischungBezeichnung;
	}

	public String getLosnummer() {
		return saveValue(losnummer);
	}

	public void setLosnummer(String losnummer) {
		this.losnummer = losnummer;
	}

	private String saveValue(String in) {
		return in.replaceAll("\\[+\\]+\\(+\\)+\\'+\"+", "");
				
	}
	
	
}
