package de.lunqual.rzpro.items.bestellung;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.adressen.AdressItem;

public class BestellungsItem {
	RzPro								rz;
	int									id;
	int									rezeptur;
	int									adresse;
	String								bezeichnung;
	String								artikelnummer;
	String								firma;
	int									einheit;
	double								menge;
	double								rest;
	String								comment;
	String								losnummer;
    Date        						erstellt;
    Date        						geaendert;
    Date								erledigt_datum;
    String      						user_1;
    String     							user_2;
    AdressItem							ai;
    boolean								liefertermin;
    Calendar							liefertermin_datum;
    boolean						bestellt;
    String							bestellt_user;

    public BestellungsItem(RzPro rz,int id,
    			int rezeptur,
    			int adresse,
    			String bezeichnung,
    			String artikelnummer,
    			String firma,
    			int einheit,
    			double menge,
    			double rest,
    			String comment,
    			String losnummer,
    			Date erstellt,
    			Date geaendert,
    			Date erledigt_datum,
    			String user_1,
    			String user_2,
    			boolean liefertermin,
    			Calendar liefertermin_datum,
    			boolean bestellt,
    			String bestellt_user
    		) {
    	this.rz=rz;
    	this.id = id;
    	this.rezeptur = rezeptur;
    	this.adresse=adresse;
    	this.bezeichnung=bezeichnung;
    	this.artikelnummer=artikelnummer;
    	this.firma=firma;
    	this.menge=menge;
    	this.einheit=einheit;
    	this.rest=rest;
    	this.comment=comment;
    	this.losnummer=losnummer;
    	this.erstellt=erstellt;
    	this.geaendert=geaendert;
    	this.erledigt_datum=erledigt_datum;
    	this.user_1=user_1;
    	this.user_2=user_2;
    	this.liefertermin = liefertermin;
    	this.liefertermin_datum = liefertermin_datum;
    	if (this.adresse != 0) {
    		this.ai = rz.getDatabase().getAdressen().dbGetAdresse(this.adresse, true);
    	}
    	this.bestellt = bestellt;
    	this.bestellt_user = bestellt_user;
    }

    
    
    public String getBestellt_user() {
		return bestellt_user;
	}



	public void setBestellt_user(String bestellt_user) {
		this.bestellt_user = bestellt_user;
	}



	public boolean isBestellt() {
		return bestellt;
	}



	public void setBestellt(boolean bestellt) {
		this.bestellt = bestellt;
	}



	public boolean isLiefertermin() {
		return liefertermin;
	}



	public void setLiefertermin(boolean liefertermin) {
		this.liefertermin = liefertermin;
	}



	public Calendar getLiefertermin_datum() {
		return liefertermin_datum;
	}



	public void setLiefertermin_datum(Calendar liefertermin_datum) {
		this.liefertermin_datum = liefertermin_datum;
		rz.roundDatum(liefertermin_datum);
	}



	public String getLosnummer() {
		return losnummer;
	}

	public void setLosnummer(String losnummer) {
		this.losnummer = losnummer;
	}

	public String getGeaendertToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(geaendert);
    }
    public String getErstelltToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(erstellt);
    }
    public String getErledigtToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(erledigt_datum);
    }

    public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public int getEinheit() {
		return einheit;
	}

	public void setEinheit(int einheit) {
		this.einheit = einheit;
	}

	public double getMenge() {
		return menge;
	}

	public void setMenge(double menge) {
		this.menge = menge;
	}

	public AdressItem getAdressItem() {
    	return this.ai;
    }

	public RzPro getRz() {
		return rz;
	}

	public void setRz(RzPro rz) {
		this.rz = rz;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}



	public int getRezeptur() {
		return rezeptur;
	}

	public void setRezeptur(int rezeptur) {
		this.rezeptur = rezeptur;
	}

	public int getAdresse() {
		return adresse;
	}

	public void setAdresse(int adresse) {
		this.adresse = adresse;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public String getArtikelnummer() {
		return artikelnummer;
	}

	public void setArtikelnummer(String artikelnummer) {
		this.artikelnummer = artikelnummer;
	}

	public String getFirma() {
		return firma;
	}

	public void setFirma(String firma) {
		this.firma = firma;
	}

	public double getRest() {
		return rest;
	}

	public void setRest(double rest) {
		this.rest = rest;
	}

	public Date getErstellt() {
		return erstellt;
	}

	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}

	public Date getGeaendert() {
		return geaendert;
	}

	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}

	public Date getErledigt_datum() {
		return erledigt_datum;
	}

	public void setErledigt_datum(Date erledigt_datum) {
		this.erledigt_datum = erledigt_datum;
	}

	public String getUser_1() {
		return user_1;
	}

	public void setUser_1(String user_1) {
		this.user_1 = user_1;
	}

	public String getUser_2() {
		return user_2;
	}

	public void setUser_2(String user_2) {
		this.user_2 = user_2;
	}

    public boolean isErledigt() {
    	if (rz.isZero(this.rest)) {
    		return true;
    	}else {
    		return false;
    	}
    }
}

