/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.ausbeute;

/**
 * @author lunqual
 *
 */
public class AusbeuteItem {
	int				id;
	boolean		system;
	String			name;
	double			nichtzucker;
	double			trester_min;
	double			trester_max;
	double			alk_min;
	double			alk_max;

	public AusbeuteItem() {
		id=0;
		system = false;
		name = "";
		nichtzucker = 0.0;
		trester_min=0.0;
		trester_max=0.0;
		alk_min=0.0;
		alk_max=0.0;
	}

	public AusbeuteItem(int id,boolean system,String name,double nichtzucker,double trester_min,double trester_max) {
		this.id=id;
		this.system=system;
		this.name=name;
		this.nichtzucker=nichtzucker;
		this.trester_min=trester_min;
		this.trester_max=trester_max;
		rechnen(0);
	}

	public void rechnen(double oexle) {
		alk_min =  ((oexle/4) -nichtzucker) * 0.56*trester_min;
		alk_max =  ((oexle/4) -nichtzucker) * 0.56*trester_max;
		if(alk_min < 0) {
			alk_min=0;
		}
		if(alk_max < 0) {
			alk_max=0;
		}
	}


	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public double getNichtzucker() {
		return nichtzucker;
	}
	public void setNichtzucker(double nichtzucker) {
		this.nichtzucker = nichtzucker;
	}
	public double getTrester_max() {
		return trester_max;
	}
	public void setTrester_max(double trester_max) {
		this.trester_max = trester_max;
	}
	public double getTrester_min() {
		return trester_min;
	}
	public void setTrester_min(double trester_min) {
		this.trester_min = trester_min;
	}
	public double getAlk_max() {
		return alk_max;
	}
	public double getAlk_min() {
		return alk_min;
	}
	public int getId() {
		return id;
	}
	public boolean isSystem() {
		return system;
	}
}
