package de.lunqual.rzpro.items.auftrag;

import java.util.ArrayList;
import java.util.HashMap;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.options.OptionFactory;
import de.lunqual.rzpro.items.rechnen.*;

public class BedarfsItem {
	
	RzPro									rz;
	ArrayList<AuftragsItem>					auftraege;
	boolean									ok;
	HashMap<Integer,BedarfsRezeptur>		rezepturen;
	HashMap<Integer,BedarfsZutat>			zutatenMap;
	BedarfsZutatenListe						zutaten;
	public BedarfsItem(RzPro rz,ArrayList<AuftragsItem> auftraege) {
		this.rz = rz;
		this.auftraege = auftraege;
		init();
	}
	
	private void init() {
		ok = auftraege.size() > 0;
		if(ok) {
			rezepturen = new HashMap<Integer,BedarfsRezeptur>();
			for(AuftragsItem ai:auftraege) {
				if(rezepturen.containsKey(ai.getRezeptur_id())) {
					rezepturen.get(ai.getRezeptur_id()).addLiter(ai.getLiter());
				} else {
					rezepturen.put(ai.getRezeptur_id(),new BedarfsRezeptur(ai.getRezeptur_id(),ai.getBezeichnung(),ai.getLiter()));
				}
			}
			zutatenMap = new HashMap<Integer,BedarfsZutat>();
			zutaten = new BedarfsZutatenListe();
			rechnen();
			for(BedarfsZutat bz:zutatenMap.values()) {
				zutaten.add(bz);
			}
			zutaten.sortAlpha();
		}
	}

	public boolean isOk() {
		return ok;
	}

	public HashMap<Integer, BedarfsRezeptur> getRezepturen() {
		return rezepturen;
	}
	
	public BedarfsZutatenListe getZutaten() {
		return zutaten;
	}

	public String toHTMLString() {
		String ret = "";
		for(BedarfsRezeptur bi:rezepturen.values()) {
			ret  += rz.getLocale().formatNumber(bi.getLiter(), OptionFactory.NF_ONE) + "&nbsp;" + rz.getLocale().getString("string_liter") + "&nbsp;" + bi.getBezeichnung() + ", ";
		}
		if(ret.endsWith(", ")) {
			ret = ret.substring(0, ret.length()-2);
		}
		return ret;
	}

	public String toPlainString() {
		String ret = "";
		for(BedarfsRezeptur bi:rezepturen.values()) {
			ret  += rz.getLocale().formatNumber(bi.getLiter(), OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + " " + bi.getBezeichnung() + ", ";
		}
		if(ret.endsWith(", ")) {
			ret = ret.substring(0, ret.length()-2);
		}
		return ret;
	}
	
	private void rechnen() {
		for(BedarfsRezeptur br:rezepturen.values()) {
			RechenItem ri = new RechenItem(rz,br.getRezeptur(),null);
			if(ri != null) {
				ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
				ri.rechnen(br.getLiter(),RechenItem.RECHNEN_LITER);
				for(int i = 0;i < ri.getZeilenListe().size();i++) {
					RechenZeile rzl = ri.getZeilenListe().getItem(i);
					if(rzl != null && rzl.isRechnen()) {
						if(zutatenMap.containsKey(rzl.getRezeptur().getID())) {
							BedarfsZutat bz = zutatenMap.get(rzl.getRezeptur().getID());
							bz.addLiter(rzl.getLiter());
							bz.addKg(rzl.getKg());
							bz.addLa(rzl.getLa());
						}else {
							zutatenMap.put(rzl.getRezeptur().getID(),new BedarfsZutat(
									rz,
									rzl.getRezeptur().getID(),
									rzl.getBezeichnung(),
									rzl.getLiter(),
									rzl.getKg(),
									rzl.getLa()));
						}
					}
				}
			}
		}
	}
	
}
