package de.lunqual.rzpro.items.auftrag;

import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

public class Auftragsliste extends ArrayList {

	RzPro								rz;
    
	public Auftragsliste(RzPro rz) {
		super();
		this.rz=rz;
		
	}
	
	public void addItem(AuftragsItem ai) {
		if(rz.isMain()) {
			this.add(ai);
		} else {
			if(ai.getRezeptur_id()!= 0) {
				this.add(ai);
			}
		}
	}
	
	public AuftragsItem getItem(int i) {
		return (AuftragsItem)this.get(i);
	}
	
	public void removeItem(int i) {
		this.remove(i);
	}
	
	public String getListeToString() {
		String ret="";
		for(int i=0;i < this.size();i++) {
			ret += rz.getLocale().formatNumber(this.getItem(i).getLiter(), OptionFactory.NF_ONE) + " " +rz.getLocale().getString("string_liter") + " " + this.getItem(i).getBezeichnung()+", ";
		}
		if(ret.endsWith(", ")) {
			ret=ret.substring(0,ret.length()-2);
		}
		return ret;
	}
	
	public Auftragsliste getAuftraege(long faellig) {
		Auftragsliste ret = new Auftragsliste(rz);
		for(int i=0;i<this.size();i++){
			if(this.getItem(i).getFaellig().getTimeInMillis() == faellig) {
				ret.addItem(this.getItem(i));
			}
		}
		return ret;
	}
	
	public boolean isInList(int id) {
		if (id != 0) {
			for(int i = 0;i < this.size();i++) {
				if(this.getItem(i).getId() == id) {
					return true;
				}
			}
		}
		return false;
	}
}
