package de.lunqual.rzpro.items.auftrag;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAuftrag;

public class AuftragsItem {
	
    private static final String				DATUM_FORMAT			= "EEEE, d. MMMM yyyy HH:mm";
    private static final String				DATUM_FORMAT_FAELLIG	= "EEEE, d. MMMM yyyy";
    private static final String				DATUM_FORMAT_FERTIG	= 	"d. MM yyyy HH:mm";
    
	RzPro				rz;
	int					id;
	double				liter;
	int					rezeptur_id;
	String				bezeichnung;
	Calendar			faellig;
	Calendar			erstellt_datum;
	String				erstellt_user;
	Calendar			geaendert_datum;
	String				geaendert_user;
	Calendar			erledigt_datum;
	String				erledigt_user;
	String				arbeit_user;
	boolean 			erledigt;
	String 				vg;
	String				hg;
	String 				comment;
	boolean				anfrage;
	SimpleDateFormat 	df;
	SimpleDateFormat	dfFaellig;
	SimpleDateFormat 	dfFertig;
	boolean				inarbeit;
	Calendar			inarbeit_datum;
	String				tank;
	String 				aavg;
	String 				aahg;
	boolean				repeat;
	int					repeat_days;
	String				magic;
	int					repStart;
	int					repSpan;
	int					priority;
	String				gruppe;
	boolean				fertig;
	String				fertig_user;
	Calendar			fertig_datum;
	
	public AuftragsItem(RzPro rz,int rezeptur_id,String bezeichnung,double liter) {
		this.rz=rz;
		this.id=0;
		this.rezeptur_id=rezeptur_id;
		this.bezeichnung=bezeichnung;
		this.liter=liter;
		String user=rz.getDatabase().dbGetUser();
		Date now=new Date();
		this.erstellt_user=user;
		this.geaendert_user=user;
		this.erledigt_user=user;
		this.erstellt_datum=Calendar.getInstance();
		this.erstellt_datum.setTime(now);
		this.geaendert_datum=Calendar.getInstance();
		this.geaendert_datum.setTime(now);
		this.erledigt_datum=Calendar.getInstance();
		this.erledigt_datum.setTimeInMillis(0);
		this.inarbeit_datum=Calendar.getInstance();
		this.inarbeit_datum.setTimeInMillis(0);
		this.faellig=Calendar.getInstance();
		this.faellig.setTimeInMillis(this.faellig.getTimeInMillis());
		rz.roundDatum(faellig);
		this.erledigt_user="";
		this.erledigt=false;
		this.arbeit_user="";
		this.comment="";
		if(rz.isMain()) {
			this.anfrage=false;
		}else {
			this.anfrage=true;
		}
		this.inarbeit=false;
		df = new SimpleDateFormat(DATUM_FORMAT);
		dfFaellig = new SimpleDateFormat(DATUM_FORMAT_FAELLIG);
		dfFertig = new SimpleDateFormat(DATUM_FORMAT_FERTIG);
		this.tank="";
		this.aahg = rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelAAHg();
		this.aavg = rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelAAVg();
		this.repeat=false;
		this.repeat_days=1;
		this.magic="";
		this.repStart = DBAuftrag.REP_MODE_ERLEDIGT;
		this.repSpan = DBAuftrag.REP_SPAN_WOCHEN;
		this.priority = 0;
		this.gruppe ="";
		this.fertig_user ="";
		this.fertig_datum=Calendar.getInstance();
		String[] c = rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(this,0);
		this.vg=c[0];
		this.hg=c[1];
		
	}
	
	
	
	public AuftragsItem(RzPro rz,int id,double liter,int rezeptur_id,String bezeichnung,
			long faellig,Date erstellt_datum,String erstellt_user,Date geaendert_datum,
			String geaendert_user,Date erledigt_datum,String erledigt_user,String arbeit_user,
			String comment,boolean erledigt,boolean anfrage,boolean inarbeit,
			Date inarbeit_datum,String tank,
			boolean repeat,
			int	repeat_days,
			String magic,
			int	repStart,
			int repSpan,
			int priority,
			String gruppe,
			boolean fertig,
			String fertig_user,
			Date fertig_datum
			) {
		df = new SimpleDateFormat(DATUM_FORMAT);
		dfFertig = new SimpleDateFormat(DATUM_FORMAT_FERTIG);
		this.rz=rz;
		this.id=id;
		this.rezeptur_id=rezeptur_id;
		this.bezeichnung=bezeichnung;
		this.liter=liter;
		this.faellig=Calendar.getInstance();
		this.faellig.setTimeInMillis(faellig);
		
		this.erstellt_datum=Calendar.getInstance();
		this.erstellt_datum.setTime(erstellt_datum);
		this.erstellt_user=erstellt_user;
		
		this.geaendert_datum=Calendar.getInstance();
		this.geaendert_datum.setTime(geaendert_datum);
		this.geaendert_user=geaendert_user;
		
		this.erledigt_datum=Calendar.getInstance();
		this.erledigt_datum.setTime(erledigt_datum);
		this.erledigt_user=erledigt_user;
		
		this.fertig=fertig;
		this.fertig_user = fertig_user;
		this.fertig_datum=Calendar.getInstance();
		this.fertig_datum.setTime(fertig_datum);
		
		this.inarbeit_datum=Calendar.getInstance();
		this.inarbeit_datum.setTime(inarbeit_datum);
		this.inarbeit = inarbeit;

		this.arbeit_user=arbeit_user;
		this.comment=comment;
		this.erledigt=erledigt;
		this.anfrage=anfrage;
		this.inarbeit=inarbeit;
		df = new SimpleDateFormat(DATUM_FORMAT);
		dfFaellig = new SimpleDateFormat(DATUM_FORMAT_FAELLIG);
		this.tank=tank;
		this.aahg = rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelAAHg();
		this.aavg = rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelAAVg();
		this.repeat=repeat;
		this.repeat_days=repeat_days;
		this.magic=magic;
		this.repStart=repStart;
		this.repSpan=repSpan;
		this.priority = priority;
		this.gruppe = gruppe;
		String[] c = rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(this,0);
		this.vg=c[0];
		this.hg=c[1];
	}
	
	public AuftragsItem duplicate() {
		return new AuftragsItem(
				rz,
				id,
				liter,
				rezeptur_id,
				bezeichnung,
				faellig.getTimeInMillis(),
				erstellt_datum.getTime(),
				erstellt_user,
				geaendert_datum.getTime(),
				geaendert_user,
				erledigt_datum.getTime(),
				erledigt_user,
				arbeit_user,
				comment,
				erledigt,
				anfrage,
				inarbeit,
				inarbeit_datum.getTime(),
				tank,
				repeat,
				repeat_days,
				magic,
				repStart,
				repSpan,
				priority,
				gruppe,
				fertig,
				fertig_user,
				fertig_datum.getTime()
				);
	}
	

	
	
	public boolean isFertig() {
		return fertig;
	}



	public void setFertig(boolean fertig) {
		this.fertig = fertig;
	}



	public String getGruppe() {
		return gruppe;
	}



	public void setGruppe(String gruppe) {
		this.gruppe = gruppe;
	}



	public int getPriority() {
		return priority;
	}

	public String getPriorityString() {
		String ret = "";
		if(priority > 0) {
			for(int i = 0;i < priority;i++) {
				ret += "\u2605";
			}
		}
		return ret;
	}


	public void setPriority(int priority) {
		this.priority = priority;
	}



	public int getRepSpan() {
		return repSpan;
	}



	public void setRepSpan(int repSpan) {
		this.repSpan = repSpan;
	}



	public int getRepStart() {
		return repStart;
	}



	public void setRepStart(int repMode) {
		this.repStart = repMode;
	}



	public boolean isRepeat() {
		return repeat;
	}



	public void setRepeat(boolean repeat) {
		this.repeat = repeat;
	}



	public int getRepeat_value() {
		return repeat_days;
	}



	public void setRepeat_days(int repeat_days) {
		this.repeat_days = repeat_days;
	}



	public String getMagic() {
		return magic;
	}



	public void setMagic(String magic) {
		this.magic = magic;
	}



	public String getTank() {
		return tank;
	}



	public void setTank(String tank) {
		this.tank = tank;
	}



	public boolean isInarbeit() {
		return inarbeit;
	}



	public void setInarbeit(boolean inarbeit) {
		this.inarbeit = inarbeit;
		this.inarbeit_datum.setTimeInMillis(rz.getDatabase().getServerTimestamp().getTime());
	}



	public Calendar getInarbeit_datum() {
		return inarbeit_datum;
	}



	public void setInarbeit_datum(Calendar inarbeit_datum) {
		this.inarbeit_datum = inarbeit_datum;
	}

	public boolean isArbeitsAuftrag() {
		return rezeptur_id==0?true:false;
	}

	public boolean isAnfrage() {
		return anfrage;
	}



	public void setAnfrage(boolean anfrage) {
		if(rz.isMain()) {
			this.anfrage = anfrage;
		}
	}


	public void clearInArbeitDatum() {
		inarbeit_datum.setTimeInMillis(0);
	}
	
	public void clearErledigtDatum(){
		erledigt_datum.setTimeInMillis(0);
	}
	
	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getStrDatum(Calendar c) {
		return df.format(c.getTime());
	}
	
	public String getVg() {
		if(isArbeitsAuftrag() && !isErledigt()) {
			return aavg;
		} else {
			return vg;
		}
	}

	public void setVg(String vg) {
		this.vg = vg;
	}

	public String getHgDark() {
		String ret = hg;
		if(isArbeitsAuftrag() && !isErledigt()) {
			ret = getDarkerColor(aahg);
		}else {
			ret =  getDarkerColor(hg);
		}
		return ret;
	}

	public String getHgLight() {
			return getLighterColor(hg);
	}
	
	public String getDarkerColor(String color) {
		int d = rz.getDatabase().getAuftrag().getAuftragsConfig().getDarker();
		Color c =rz.getOptionFactory().getRGBColorString(color);
		int r = c.getRed();int g = c.getGreen();int b = c.getBlue();
		r = (r>d)?r-d:r;	    			g = (g>d)?g-d:g;	    			b = (b>d)?b-d:b;
		return rz.getOptionFactory().getHexColor(new Color(r,g,b));
	}
	
	public String getLighterColor(String color) {
		int d = rz.getDatabase().getAuftrag().getAuftragsConfig().getDarker();
		Color c =rz.getOptionFactory().getRGBColorString(color);
		int r = c.getRed();int g = c.getGreen();int b = c.getBlue();
		r = (r>d)?r+d:r;	    			g = (g>d)?g+d:g;	    			b = (b>d)?b+d:b;
		return rz.getOptionFactory().getHexColor(new Color(r,g,b));
	}
	
	public String getHg() {
		if(isArbeitsAuftrag() && !isErledigt()) {
			return aahg;
		} else {
			return hg;
		}
	}

	public void setHg(String hg) {
		this.hg = hg;
	}

	public RzPro getRz() {
		return rz;
	}

	public void setRz(RzPro rz) {
		this.rz = rz;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public double getLiter() {
		return liter;
	}

	public void setLiter(double liter) {
		this.liter = liter;
	}

	public int getRezeptur_id() {
		return rezeptur_id;
	}

	public void setRezeptur_id(int rezeptur_id) {
		this.rezeptur_id = rezeptur_id;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public Calendar getFaellig() {
		return faellig;
	}

	public void setFaellig(Calendar faellig) {
		this.faellig = faellig;
	}

	public void setFaellig(long datum) {
		this.faellig = Calendar.getInstance();
		this.faellig.setTimeInMillis(datum);
	}

	
	public Calendar getErstellt_datum() {
		return erstellt_datum;
	}

	public void setErstellt_datum(Calendar erstellt_datum) {
		this.erstellt_datum = erstellt_datum;
	}

	public String getErstellt_user() {
		return erstellt_user;
	}

	public void setErstellt_user(String erstellt_user) {
		this.erstellt_user = erstellt_user;
	}

	public Calendar getGeaendert_datum() {
		return geaendert_datum;
	}

	public void setGeaendert_datum(Calendar geaendert_datum) {
		this.geaendert_datum = geaendert_datum;
	}

	public String getGeaendert_user() {
		return geaendert_user;
	}

	public void setGeaendert_user(String geaendert_user) {
		this.geaendert_user = geaendert_user;
	}

	public Calendar getErledigt_datum() {
		return erledigt_datum;
	}

	public void setErledigt_datum(Calendar erledigt_datum) {
		this.erledigt_datum = erledigt_datum;
	}

	public Calendar getInArbeit_datum() {
		return inarbeit_datum;
	}

	public void setInArbeit_datum(Calendar inarbeit_datum) {
		this.inarbeit_datum = inarbeit_datum;
	}
	
	public String getErledigt_user() {
		return erledigt_user;
	}

	public void setErledigt_user(String erledigt_user) {
		this.erledigt_user = erledigt_user;
	}

	public boolean isEigen() {
		boolean ret=false;
		String user[]=arbeit_user.split(",| ");
		for(String u:user) {
			if(u.trim().equals(rz.getDatabase().dbGetUser())) {
				ret=true;
				break;
			}
		}
		return ret;
	}
	public String getArbeit_user() {
		return arbeit_user;
	}

	public void setArbeit_user(String arbeit_user) {
		this.arbeit_user = arbeit_user;
	}

	public boolean isErledigt() {
		return erledigt;
	}

	public void setErledigt(boolean erledigt) {
		this.erledigt = erledigt;
	}

	public String getInArbeitToString() {
		return df.format(inarbeit_datum.getTime());
	}
	
	public String getErstelltToString() {
		return df.format(erstellt_datum.getTime());
	}
	
	public String getGeaendertToString() {
		return df.format(geaendert_datum.getTime());
	}
	public String getErledigtToString() {
		return df.format(erledigt_datum.getTime());
	}
	public String getFaelligToString() {
		return dfFaellig.format(faellig.getTime());
	}
	public String getFertigToString() {
		return dfFertig.format(fertig_datum.getTime());
	}
	
	public boolean isVisible() {
		return rz.getDatabase().getAuftrag().getAuftragsConfig().isVisible(faellig.getTimeInMillis());
	}



	public String getFertig_user() {
		return fertig_user;
	}



	public void setFertig_user(String fertig_user) {
		this.fertig_user = fertig_user;
	}



	public Calendar getFertig_datum() {
		return fertig_datum;
	}



	public void setFertig_datum(Calendar fertig_datum) {
		this.fertig_datum = fertig_datum;
	}
	
	
}
