package de.lunqual.rzpro.items.auftrag;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;

import de.lunqual.rzpro.RzPro;

public class AuftragConfigItem {
	RzPro rz;
	int	id;
	int darker;
	int level0Value;
	String level0Vg;
	String level0Hg;

	int level1Value;
	String level1Vg;
	String level1Hg;
	
	int level2Value;
	String level2Vg;
	String level2Hg;

	int level3Value;
	String level3Vg;
	String level3Hg;
	
	String levelEvg;
	String levelEhg;
	
	String levelAvg;
	String levelAhg;
	
	
	String levelAAVg;
	String levelAAHg;

	String levelFvg;
	String levelFhg;
	
	boolean saturday;
	String feiertage;
	TagesListe	feiertagsliste;
	TagesListe	vergleichsliste;
	
	public AuftragConfigItem(RzPro rz,int id, 
			int level0Value, String level0Vg,String level0Hg,
			int level1Value, String level1Vg, String level1Hg,
			int level2Value, String level2Vg, String level2Hg,
			int level3Value, String level3Vg, String level3Hg,
			String levelEvg,String levelEhg,
			String levelAvg,String levelAhg,
			String levelAAVg,String levelAAHg,
			String levelFvg,
			String levelFhg,
			int darker
			) {
		this.rz = rz;
		this.id=id;
		this.level0Value = level0Value;
		this.level0Vg = level0Vg;
		this.level0Hg = level0Hg;
		this.level1Value = level1Value;
		this.level1Vg = level1Vg;
		this.level1Hg = level1Hg;
		this.level2Value = level2Value;
		this.level2Vg = level2Vg;
		this.level2Hg = level2Hg;
		this.level3Value = level3Value;
		this.level3Vg = level3Vg;
		this.level3Hg = level3Hg;
		this.levelEhg = levelEhg;
		this.levelEvg = levelEvg;
		this.levelAhg = levelAhg;
		this.levelAvg = levelAvg;
		
		this.levelAAVg = levelAAVg;
		this.levelAAHg = levelAAHg;

		this.levelFvg = levelFvg;
		this.levelFhg = levelFhg;
		
		this.darker = darker;
		this.saturday=rz.getDatabase().getKalender().isSaturday();
		feiertagsliste=rz.getDatabase().getKalender().getFeiertage();
		createVergleichsListe();
	}

	private void createVergleichsListe() {
		Date now=new Date();
		vergleichsliste=new TagesListe(rz,saturday);
		TagesItem ti = new TagesItem(rz,now.getTime(),0);
		//pass 1
		int count=0;
		boolean ende=false;
		TagesItem ti1=new TagesItem(rz,ti.getMillis(),count);
		while(!ende){
			if(!isFeiertag(ti1)) {
				if(count ==0) {
					ti1.setVg(level0Vg);
					ti1.setHg(level0Hg);
				} else if(count >0 && count <= level1Value) {
					ti1.setVg(level1Vg);
					ti1.setHg(level1Hg);					
				} else if(count >level1Value && count <= level2Value) {
					ti1.setVg(level2Vg);
					ti1.setHg(level2Hg);					
				} else if(count >level2Value) {
					ti1.setVg(level3Vg);
					ti1.setHg(level3Hg);					
				}
				ti1.setCount(count);
				vergleichsliste.addItem(ti1.copyItem());
				count++;
				if(count >level3Value || count > 365) {
					ende=true;
				}
			}
			ti1.getCalendar().add(Calendar.DATE, 1);
		}
	}

	public boolean isFeiertag(TagesItem ti) {
		return isFeiertag(ti.getCalendar());
	}	
	
	public boolean isFeiertag(Calendar c) {
		boolean ret=false;
		if(feiertagsliste.isInList(c.getTimeInMillis())) {
			ret=true;
		} else if(c.get(Calendar.DAY_OF_WEEK)==Calendar.SUNDAY) {
			ret=true;
		} else if(c.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY) {
			if(saturday==false) {
				ret = true;
			}else {
				ret = false;
			}
		}
		return ret;
	}
	
	/*
	 * isFeiertag mit LocalDate
	 */
	public boolean isFeiertag(LocalDate c) {
		long millis = c.atStartOfDay(java.time.ZoneId.systemDefault()).toInstant().toEpochMilli();
		boolean ret=false;
		if(feiertagsliste.isInList(millis)) {
			ret=true;
		} else if(c.getDayOfWeek() == DayOfWeek.SUNDAY) {
			ret=true;
		} else if(c.getDayOfWeek() == DayOfWeek.SATURDAY) {
			if(saturday==false) {
				ret = true;
			}else {
				ret = false;
			}
		}
		return ret;
	}
	

	public int getDayDiff(Calendar a,Calendar b) {
		int ret = 0;
		Calendar v = Calendar.getInstance();
		if(a.after(b)) {
			v.setTimeInMillis(b.getTimeInMillis());
			while(a.after(v)) {
				if(!isFeiertag(v))ret -=1;
				v.add(Calendar.DATE, 1);
			}
		}else {
			v.setTimeInMillis(a.getTimeInMillis());
			while(v.before(b)) {
				if(!isFeiertag(v))ret  +=1;
				v.add(Calendar.DATE, 1);
			}
		}
		return ret;
	}
	
    public void goForward(Calendar temp, int tage) {
    	int count=0;
    	while(count < tage) {
    		temp.add(Calendar.DATE,1);
    		if(!rz.getDatabase().getKalender().isFeiertag(temp)) {
    			count++;
    		}
    	}
    }	
    
    
    public LocalDate goForward(LocalDate d,int tage) {
    	int count=0;
    	while(count < tage) {
    		d = d.plusDays(1);
    		if(!isFeiertag(d)) {
    			count++;
    		}
    	}
    	return d;
    }
    
    public LocalDate goBack(LocalDate d,int tage) {
    	int count=0;
    	while(count < tage) {
    		d = d.minusDays(1);
    		if(!isFeiertag(d)) {
    			count++;
    		}
    	}
    	return d;
    }
    
    public LocalDate goBackWeeks(LocalDate d,int weeks) {
    	d = d.minusWeeks(weeks);
    	if (isFeiertag(d)) {
    		d= goBack(d, 1);
    	}
    	return d;
    }
    
    public LocalDate goForwardWeeks(LocalDate d,int weeks) {
    	d = d.plusWeeks(weeks);
    	if (isFeiertag(d)) {
    		d = goForward(d, 1);
    	}
    	return d;
    }
    
    public void move(Calendar temp, int tage) {
    	Calendar today = rz.getToday();
    	int count=0;
    	while(count  < Math.abs(tage)) {
    		temp.add(Calendar.DATE,(tage<0)?-1:1);
    		if(!rz.getDatabase().getKalender().isFeiertag(temp)) {
    			count++;
    		}
    	}
    	if(temp.before(today)) {
    		temp.setTimeInMillis(today.getTimeInMillis());
    	}
    }
    
	public void getValidDate(Calendar c,boolean forward) {
		Calendar limit=rz.getToday();
		limit.add(Calendar.MONTH, -3);
		TagesItem ti = new TagesItem(rz,c.getTimeInMillis(),0);
		while(isFeiertag(ti)) {
			if(forward) {
				c.add(Calendar.DATE,1);
			} else {
				c.add(Calendar.DATE,-1);
			}
			ti = new TagesItem(rz,c.getTimeInMillis(),0);
		}
		if(c.getTimeInMillis()<=limit.getTimeInMillis()) {
			c.setTimeInMillis(limit.getTimeInMillis());
		}
		return;
	}
    
	
	public LocalDate getValidDate(LocalDate c,boolean forward) {
		while(isFeiertag(c) ) {
			if(forward) {
				c = c.plusDays(1);
			} else {
				c= c.minusDays(1);
			}
		}
		return c;
	}
	
	
	public boolean isVisible(long milliseconds) {
		boolean ret=false;
		if(this.vergleichsliste != null && !vergleichsliste.isEmpty()) {
			ret = !(milliseconds > vergleichsliste.getItem(vergleichsliste.size()-1).getCalendar().getTimeInMillis());
		} else {
			ret=true;
		}
		return ret;
	}
	public long getVisibleDate() {
		long ret = 0;
		if(vergleichsliste != null && !vergleichsliste.isEmpty()) {
			ret = vergleichsliste.getItem(vergleichsliste.size()-1).getCalendar().getTimeInMillis();
		}
		return ret;
	}
	
	public String[] getColors(AuftragsItem ai,long millis) {
		String[] ret = {"000000","ffffff","0"};
		if(ai != null) {
			if(ai.isAnfrage()) {
				ret[0] = levelAvg;
				ret[1] = levelAhg;
				ret[2] = rz.getLocale().getString("auftragconfig.label_anfrage").replaceAll("%s",ai.getErstellt_user());
			} else if(ai.isErledigt()) {
				ret[0] = levelEvg;
				ret[1] = levelEhg;
				ret[2] = rz.getLocale().getString("auftragconfig.label_erledigt").trim()
						.replaceAll("%d",ai.getErledigtToString())
						.replaceAll("%s",ai.getErledigt_user());
			} else if(ai.isFertig()){
				ret[0] = levelFvg;
				ret[1] = levelFhg;
				ret[2] = rz.getLocale().getString("auftragconfig.label_fertig").trim()
						.replaceAll("%d",ai.getFertigToString())
						.replaceAll("%s",ai.getFertig_user());
			} else {
				ret = getColors(ai.getFaellig().getTimeInMillis(),ai);
			}
		}else {
			ret = getColors(millis,ai);
		}
		return ret;
	}
	
	public String[] getColors(long millis,AuftragsItem ai) {
		String[] ret = {"000000","ffffff","0"};
		
		if(vergleichsliste != null && !vergleichsliste.isEmpty()) {
			if(millis < vergleichsliste.getItem(0).getCalendar().getTimeInMillis()) {
				//überfällig
				ret[0]=level0Vg;
				ret[1]=level0Hg;
				ret[2]=	rz.getLocale().getString("auftragconfig.label_arbeitstage_min");
			} else 
				if(millis == vergleichsliste.getItem(0).getCalendar().getTimeInMillis()) {
					//überfällig
						ret[0]=level0Vg;
						ret[1]=level0Hg;
					ret[2]=	rz.getLocale().getString("auftragconfig.label_arbeitstage_heute");
				} else 	if(millis > vergleichsliste.getItem(vergleichsliste.size()-1).getCalendar().getTimeInMillis()) {
				// noch lange nicht fällig
					ret[0]=level3Vg;
					ret[1]=level3Hg;
				ret[2]= rz.getLocale().getString("auftragconfig.label_arbeitstage_max").replaceAll("%s", String.valueOf(level3Value));
			} else {
				for(int i=0;i<vergleichsliste.size();i++) {
					if(millis == vergleichsliste.getItem(i).getCalendar().getTimeInMillis()) {
						if(ai != null && ai.isArbeitsAuftrag()) {
							ret[0] = levelAAVg;
							ret[1] = levelAAHg;
						}else {
							ret[0]=vergleichsliste.getItem(i).getVg();
							ret[1]=vergleichsliste.getItem(i).getHg();
						}
						ret[2]= rz.getLocale().getString("auftragconfig.label_arbeitstage").replaceAll("%s",String.valueOf(vergleichsliste.getItem(i).getCount()));
					}
				}
			}
		} else {
			ret[0]=level0Vg;
			ret[1]=level0Hg;
		}
		return ret;
	}
	

	public TagesListe getFeiertagsliste() {
		return feiertagsliste;
	}


	public void setFeiertagsliste(TagesListe feiertagsliste) {
		this.feiertagsliste = feiertagsliste;
		this.createVergleichsListe();
	}


	public RzPro getRz() {
		return rz;
	}

	public void setRz(RzPro rz) {
		this.rz = rz;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getLevel0Value() {
		return level0Value;
	}

	public void setLevel0Value(int level0Value) {
		this.level0Value = level0Value;
	}

	public String getLevel0Vg() {
		return level0Vg;
	}

	public void setLevel0Vg(String level0Vg) {
		this.level0Vg = level0Vg;
	}

	public String getLevel0Hg() {
		return level0Hg;
	}

	public void setLevel0Hg(String level0Hg) {
		this.level0Hg = level0Hg;
	}

	public int getLevel1Value() {
		return level1Value;
	}

	public void setLevel1Value(int level1Value) {
		this.level1Value = level1Value;
	}

	public String getLevel1Vg() {
		return level1Vg;
	}

	public void setLevel1Vg(String level1Vg) {
		this.level1Vg = level1Vg;
	}

	public String getLevel1Hg() {
		return level1Hg;
	}

	public void setLevel1Hg(String level1Hg) {
		this.level1Hg = level1Hg;
	}

	public int getLevel2Value() {
		return level2Value;
	}

	public void setLevel2Value(int level2Value) {
		this.level2Value = level2Value;
	}

	public String getLevel2Vg() {
		return level2Vg;
	}

	public void setLevel2Vg(String level2Vg) {
		this.level2Vg = level2Vg;
	}

	public String getLevel2Hg() {
		return level2Hg;
	}

	public void setLevel2Hg(String level2Hg) {
		this.level2Hg = level2Hg;
	}

	public int getLevel3Value() {
		return level3Value;
	}

	public void setLevel3Value(int level3Value) {
		this.level3Value = level3Value;
	}

	public String getLevel3Vg() {
		return level3Vg;
	}

	public void setLevel3Vg(String level3Vg) {
		this.level3Vg = level3Vg;
	}

	public String getLevel3Hg() {
		return level3Hg;
	}

	public void setLevel3Hg(String level3Hg) {
		this.level3Hg = level3Hg;
	}

	public boolean isSaturday() {
		return saturday;
	}

	public void setSaturday(boolean saturday) {
		this.saturday = saturday;
	}

	public String getLevelEVg() {
		return levelEvg;
	}

	public void setLevelEVg(String levelEvg) {
		this.levelEvg = levelEvg;
	}

	public String getLevelEHg() {
		return levelEhg;
	}

	public void setLevelEHg(String levelEhg) {
		this.levelEhg = levelEhg;
	}

	public String getLevelAVg() {
		return levelAvg;
	}

	public void setLevelAVg(String levelAvg) {
		this.levelAvg = levelAvg;
	}

	public String getLevelAHg() {
		return levelAhg;
	}

	public void setLevelAHg(String levelAhg) {
		this.levelAhg = levelAhg;
	}

	public String getLevelAAVg() {
		return levelAAVg;
	}

	public void setLevelAAVg(String levelAAVg) {
		this.levelAAVg = levelAAVg;
	}

	public String getLevelAAHg() {
		return levelAAHg;
	}

	public void setLevelAAHg(String levelAAHg) {
		this.levelAAHg = levelAAHg;
	}

	public int getDarker() {
		return darker;
	}

	public void setDarker(int darker) {
		this.darker = darker;
	}

	public String getLevelFvg() {
		return levelFvg;
	}

	public void setLevelFvg(String levelFvg) {
		this.levelFvg = levelFvg;
	}

	public String getLevelFhg() {
		return levelFhg;
	}

	public void setLevelFhg(String levelFhg) {
		this.levelFhg = levelFhg;
	}



	
}
