/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.adressen;

// eigene Pakete
import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAdressen;
/**
 *
 * @author  lunqual
 */
public class AdressItem {

	RzPro		rz;
    int         	id;
    String      firma;
    String      nachname;
    String      vorname;
    String      strasse;
    String      plz;
    String      ort;
    String      fon;
    String      mobil;
    String      fax;
    String      mail;
    String      comment;
    Date        erstellt;
    Date        geaendert;
    String      user_1;
    String      user_2;
    String      kdnummer_1;
    String      kdnummer_2;
    int			typ;


    /** Creates a new instance of AdressItem */
    public AdressItem(){

    }
    public AdressItem(RzPro rz,int aID,String aFirma,String aVorname,String aNachname,String aStrasse,String aPLZ, String aOrt,
                      String aFon,String aMobil,String aFax,String aMail, Date aErstellt,Date aGeaendert,
                      String aUser_1,String aUser_2,String aKdnummer_1,String aKdnummer_2,String aComment,int typ) {
    		this.rz = rz;
           id       = aID;
           firma    = aFirma;
           nachname = aNachname;
           vorname  = aVorname;
           strasse  = aStrasse;
           plz      = aPLZ;
           ort      = aOrt;
           fon      = aFon;
           mobil    = aMobil;
           fax      = aFax;
           mail     = aMail;
           erstellt = aErstellt;
           geaendert= aGeaendert;
           user_1   = aUser_1;
           user_2   = aUser_2;
           kdnummer_1= aKdnummer_1;
           kdnummer_2= aKdnummer_2;
           comment  = aComment;
           this.typ=typ;
    }

    public void setID(int aID){id = aID;}
    public void setFirma(String aFirma){firma=aFirma;}
    public void setVorname(String aVorname){vorname=aVorname;}
    public void setNachname(String aNachname){nachname = aNachname;}
    public void setStrasse(String aStrasse){strasse=aStrasse;}
    public void setPLZ(String aPLZ){plz = aPLZ;}
    public void setOrt(String aOrt){ort = aOrt;}
    public void setFon(String aFon){fon = aFon;}
    public void setMobil(String aMobil){mobil = aMobil;}
    public void setFax(String aFax){fax = aFax;}
    public void setMail(String aMail){mail = aMail;}
    public void setErstellt(Date aErstellt){erstellt = aErstellt;}
    public void setGeaendert(Date aGeaendert){geaendert = aGeaendert;}
    public void setUser1(String aUser){user_1 = aUser;}
    public void setUser2(String aUser){user_2 = aUser;}
    public void setKdnummer1(String aKdnummer){kdnummer_1 = aKdnummer;}
    public void setKdnummer2(String aKdnummer){kdnummer_2 = aKdnummer;}
    public void setComment(String aComment){comment = aComment;}

    public int getID(){return id;}
    public String getFirma(){return firma;}
    public String getVorname(){return vorname;}
    public String getNachname(){return nachname;}
    public String getStrasse(){return strasse;}
    public String getPLZ(){return plz;}
    public String getOrt(){return ort;}
    public String getFon(){return fon;}
    public String getMobil(){return mobil;}
    public String getFax(){return fax;}
    public String getMail(){return mail;}
    public Date   getErstellt(){return erstellt;}
    public Date   getGeaendert(){return geaendert;}
    public String getUser1(){return user_1;}
    public String getUser2(){return user_2;}
    public String getKdnummer1(){return kdnummer_1;}
    public String getKdnummer2(){return kdnummer_2;}
    public String getComment(){return comment;}
    @Override
	public String toString(){
    	String ret = firma + ", " + ort + " (" + vorname + " " + nachname + ")";
    	if(typ == DBAdressen.TYP_BEIDE || typ == DBAdressen.TYP_KUNDE) {
    		ret+= "   " + rz.getLocale().getString("adressausgabe.label_kundeKurz");
		}
		if(typ == DBAdressen.TYP_BEIDE || typ == DBAdressen.TYP_LIEFERANT) {
    		ret+="   " + rz.getLocale().getString("adressausgabe.label_lieferantKurz");
		}    	
    	return ret;
    }
    
    public String toHTMLString(){
    	String  ret="<html>";
    	ret +=firma + ", " + ort + " (" + vorname + " " + nachname + ")";
    	if(typ == DBAdressen.TYP_BEIDE || typ == DBAdressen.TYP_KUNDE) {
			ret+=  "&nbsp;<span style=\"background-color:" +DBAdressen.COLOR_KUNDE +"; \">"  + "&nbsp;K&nbsp;</span>";
		}
		if(typ == DBAdressen.TYP_BEIDE || typ == DBAdressen.TYP_LIEFERANT) {
			ret+=  "&nbsp;<span style=\"background-color:#" +DBAdressen.COLOR_LIEFERANT+"; \">"  + "&nbsp;L&nbsp;</span>";    		
		}    	
		ret +="</html>";
		return ret;
    }
    
    public String getGeaendertToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(geaendert);
    }
    public String getErstelltToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(erstellt);
    }
	public int getTyp() {
		return typ;
	}
	public void setTyp(int typ) {
		this.typ = typ;
	}
    
    
}
