/*
 * Created on 27.08.2004
 *
 */
package de.lunqual.rzpro.items.action;

import java.awt.Component;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.log.LogFactory;

/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AuswahlAction extends AbstractAction {

    public static final String			MNEMONIC_MARK = "&";
    RzPro 						rz;
    MessageItem		msg;
    JRzFrame				parentFrame;
    Component[]			parentObjects;
    /** erzeugt eine AuswahlAction
     * @param Rz RzPro-struktur
     * @param parentFrame das parentFrame
     * @param code ActionCode
     * @param desc beschreibung (String für LocaleControl)
     * @param key  Taste
     * @param modifier modifier für den Tastendruck
     *
     */
    public AuswahlAction(RzPro rz,JRzFrame parentFrame,int code,String desc,int key,int modifier) {
		super();
		char mnemonic = '\0';
        this.rz = rz;
        this.parentFrame = parentFrame;
        parentObjects = parentFrame.getComponents();
        msg = new MessageItem(MessageItem.MSG_ACTIONPERFORMED,code,null,parentFrame);
        final String name = rz.getLocale().getString(desc);
        putValue(NAME,name.replaceAll(MNEMONIC_MARK,""));
        if(name.indexOf(MNEMONIC_MARK) != -1) {
            final String n = name.substring(name.indexOf(MNEMONIC_MARK)+1,name.indexOf(MNEMONIC_MARK)+2).toUpperCase();
            mnemonic=n.charAt(0);
        }
        try {
            putValue(SMALL_ICON, new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/" + desc + ".png")));
        } catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"auswahlAction", ":icon /de/lunqual/rzpro/gfx/" + desc + ".png not found !"  );
        }
        if ( key != 0) {
        		putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke(key,modifier, true));
        		putValue(MNEMONIC_KEY,  Integer.valueOf(mnemonic));
        }
		putValue(SHORT_DESCRIPTION, rz.getLocale().getString(desc + ".1"));
    }

    public void actionPerformed(ActionEvent e) {
        	parentFrame.getMessage(msg);
    }


}
