/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.hilfefactory;

import de.lunqual.rzpro.items.hilfe.HilfeFileItem;
import de.lunqual.rzpro.items.hilfe.HilfeFileListe;
import de.lunqual.rzpro.*;
import de.lunqual.rzpro.log.LogFactory;

import java.net.*;
import java.util.*;
import java.io.*;
/**
 * HilfeControl verwaltet Hilfeseiten. Gesucht werden diese als HTML-DATEI
 * im Klassenpfad unter de/lunqual/rzpro/hilfe
 * die eigentlichen Dateien werden dann in einem Ordner gesucht, der wie
 * die Sprache der eingestellten Locale (z.B. "de" oder "fr" benannt ist.
 * Wird kein passender Ordner gefunden, wird im Ordner "default"
 * gesucht.
 * @author  lunqual
 */
public class HilfeFactory {
    static final int    FILE_SIZE = 32768;
    
    public static final String      HILFE_CLASSPATH     = "/de/lunqual/rzpro/hilfe/";
    
    RzPro               rz;
    HilfeFileListe      files;
    String               sprache;
    
    /** Creates a new instance of HilfeControl */
    public HilfeFactory(RzPro r) {
        rz = r;
        files = loadCatalog();
        if(files.size()> 1) {
        	files.sort();
        }
   }
    
    /** l�dt die Dateiliste f�r die Default-Locale oder 
     * Default, wenn die Locale keine Liste hat.
     * Die Dateiliste steht imFile catalog.txt in einem Ordner 
     * der nach dem SprachCode benannt ist
     * Das Format der Datei ist 
     * <dateiname>;<description>
     */
    private HilfeFileListe loadCatalog(){
        URL catalog;
        HilfeFileListe fl = new HilfeFileListe();
        sprache = Locale.getDefault().getLanguage().toLowerCase();
        // erster Versuch: Ordern der Default-Language
        catalog = getClass().getResource(HILFE_CLASSPATH + sprache + "/catalog.txt");
        if(catalog == null){
            // zweiter Versuch: Default-Ordner
            sprache = "default";
            catalog = getClass().getResource(HILFE_CLASSPATH + sprache +"/catalog.txt");         
        }
        String[] c = loadFile(HILFE_CLASSPATH + sprache + "/catalog.txt").split("\\n");
        for (String element : c) {
            if(element.indexOf(";") != -1){
                String zeile[] = element.split(";");
                String pfad = HILFE_CLASSPATH + sprache + "/" + zeile[0];
                URL u = getClass().getResource(pfad);
                fl.add(new HilfeFileItem(zeile[0],zeile[1],u));
            }
        }
        return fl;
    }
    
    /** lädt eine Datei in einen String */
    private String loadFile(String u){
        String out = "";
        byte[] buffer = new byte[FILE_SIZE];
        InputStream in = getClass().getResourceAsStream(u);
        try{
            in.read(buffer,0,FILE_SIZE);
            in.close();
        }
        catch (Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"HilfeControl.loadfile", e.getLocalizedMessage());
        }
        out = new String(buffer);
        return out;
    }
    
    public HilfeFileListe getHilfeListe(){return files;}
}
