/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fonts;

// eigene pakete
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */
public class FontFactory {

    // FontControl
    public static final String      FONT_FILE           = "rzfonts.properties";
    public static final String      DefaultButtonFont   = "Arial";
    public static final int         	DefaultButtonFontSize = 12;
    public static final String      DefaultMenuFont   = "Arial";
    public static final int         	DefaultMenuFontSize = 12;
    public static final String      DefaultListFont   = "Arial";
    public static final int         	DefaultListFontSize = 12;
    public static final String      DefaultTextFont   = "Arial";
    public static final int         	DefaultTextFontSize = 12;
    public static final String      DefaultPrintFont   = "Arial";
    public static final int         	DefaultPrintFontSize = 8;
    public static final String		DefaultTableFont = "Arial";
    public static final int			DefaultTableFontSize = 12;
    public static final String		DefaultAuftragsTableFont = "Arial";
    public static final int			DefaultAuftragsTableFontSize = 12;
    public static final String		DefaultDeckblattFont = "Courier New";
    public static final int			DefaultDeckblattFontSize = 12;

    // Types

    public static final int			BUTTON_FONT 				= 0;
    public static final int			HB_FONT						= 1;
    public static final int			MENU_FONT					= 2;
    public static final int 		LIST_FONT					= 3;
    public static final int			TEXT_FONT					= 4;
    public static final int			ERGEBNIS_FONT				= 5;
    public static final int			TABLE_FONT					= 6;
    public static final int			TABLE_BOLD_FONT				= 7;
    public static final int			AUFTRAGS_TABLE_FONT			= 8;
    public static final int			DECKBLATT_FONT			= 9;

    RzPro           rz;
    String          fontFileName;
    Properties      options;

    Font            ButtonFont;
    Font            MenuFont;
    Font            ListFont;
    Font            TextFont;
    Font            HBFont;
    Font			ErgebnisFont;
    Font            PrintFont;
    Font			TableFont;
    Font			TableBoldFont;
    Font			AuftragsTableFont;
    Font			DeckblattFont;
    
    /** Creates a new instance
     *  of FontControl */
    public FontFactory(RzPro r) {
        rz = r;
        options = new Properties();
        readOptions();
    }
    
    private void setDefaultOptions() {
        if(options.getProperty("buttonfont.name","").equals("")) {
			options.setProperty("buttonfont.name",DefaultButtonFont);
		}
        if(options.getProperty("buttonfont.size","").equals("")) {
			options.setProperty("buttonfont.size",String.valueOf(DefaultButtonFontSize));
		}
        if(options.getProperty("menufont.name","").equals("")) {
			options.setProperty("menufont.name",DefaultButtonFont);
		}
        if(options.getProperty("menufont.size","").equals("")) {
			options.setProperty("menufont.size",String.valueOf(DefaultButtonFontSize));
		}
        if(options.getProperty("listfont.name","").equals("")) {
			options.setProperty("listfont.name",DefaultButtonFont);
		}
        if(options.getProperty("listfont.size","").equals("")) {
			options.setProperty("listfont.size",String.valueOf(DefaultButtonFontSize));
		}
        if(options.getProperty("textfont.name","").equals("")) {
			options.setProperty("textfont.name",DefaultButtonFont);
		}
        if(options.getProperty("textfont.size","").equals("")) {
			options.setProperty("textfont.size",String.valueOf(DefaultButtonFontSize));
		}
        if(options.getProperty("printfont.name","").equals("")) {
			options.setProperty("printfont.name",DefaultButtonFont);
		}
        if(options.getProperty("printfont.size","").equals("")) {
			options.setProperty("printfont.size",String.valueOf(DefaultPrintFontSize));
		}
        if(options.getProperty("hbfont.name","").equals("")) {
			options.setProperty("hbfont.name",DefaultButtonFont);
		}
        if(options.getProperty("hbfont.size","").equals("")) {
			options.setProperty("hbfont.size",String.valueOf(DefaultButtonFontSize));
		}
        if(options.getProperty("ergebnisfont.name","").equals("")) {
			options.setProperty("ergebnisfont.name",DefaultButtonFont);
		}
        if(options.getProperty("ergebnisfont.size","").equals("")) {
			options.setProperty("ergebnisfont.size",String.valueOf(DefaultButtonFontSize));
		}
        if(options.getProperty("tablefont.name","").equals("")) {
			options.setProperty("tablefont.name",DefaultTableFont);
		}
        if(options.getProperty("tablefont.size","").equals("")) {
			options.setProperty("tablefont.size",String.valueOf(DefaultTableFontSize));
		}
        if(options.getProperty("auftragstablefont.name","").equals("")) {
			options.setProperty("auftragstablefont.name",DefaultTableFont);
		}
        if(options.getProperty("auftragstablefont.size","").equals("")) {
			options.setProperty("auftragstablefont.size",String.valueOf(DefaultTableFontSize));
		}
        if(options.getProperty("deckblattfont.size","").equals("")) {
			options.setProperty("deckblattfont.size",String.valueOf(DefaultDeckblattFontSize));
		}
        
        ButtonFont = new Font(options.getProperty("buttonfont.name",DefaultButtonFont),
                     0,
                     Integer.parseInt(options.getProperty("buttonfont.size",String.valueOf(DefaultButtonFontSize))));
        MenuFont = new Font(options.getProperty("menufont.name",DefaultButtonFont),
                     0,
                     Integer.parseInt(options.getProperty("menufont.size",String.valueOf(DefaultButtonFontSize))));
        ListFont = new Font(options.getProperty("listfont.name",DefaultButtonFont),
                     0,
                     Integer.parseInt(options.getProperty("listfont.size",String.valueOf(DefaultButtonFontSize))));
        TextFont = new Font(options.getProperty("textfont.name",DefaultButtonFont),
                     0,
                     Integer.parseInt(options.getProperty("textfont.size",String.valueOf(DefaultButtonFontSize))));
        PrintFont = new Font(options.getProperty("printfont.name",DefaultButtonFont),
                     0,
                     Integer.parseInt(options.getProperty("printfont.size",String.valueOf(DefaultButtonFontSize))));
        HBFont = new Font(options.getProperty("hbfont.name",DefaultButtonFont),
                0,
                Integer.parseInt(options.getProperty("hbfont.size",String.valueOf(DefaultButtonFontSize))));
        ErgebnisFont = new Font(options.getProperty("ergebnisfont.name",DefaultButtonFont),
                0,
                Integer.parseInt(options.getProperty("ergebnisfont.size",String.valueOf(DefaultButtonFontSize))));
        TableFont = new Font(options.getProperty("tablefont.name",DefaultTableFont),
                0,
                Integer.parseInt(options.getProperty("tablefont.size",String.valueOf(DefaultTableFontSize))));
        TableBoldFont = new Font(options.getProperty("tablefont.name",DefaultTableFont),
                Font.BOLD,
                Integer.parseInt(options.getProperty("tablefont.size",String.valueOf(DefaultTableFontSize))));
        AuftragsTableFont = new Font(options.getProperty("auftragstablefont.name",DefaultAuftragsTableFont),
                0,
                Integer.parseInt(options.getProperty("auftragstablefont.size",String.valueOf(DefaultAuftragsTableFontSize))));
        
        DeckblattFont = new Font(options.getProperty("deckblattfont.name",DefaultDeckblattFont),
                0,
                Integer.parseInt(options.getProperty("deckblattfont.size",String.valueOf(DefaultDeckblattFontSize))));
        
    }

    public Properties getFontOptions(){
        return options;
    }
    /**
     * liest die property-Datei ein
     */
    public void readOptions(){
        fontFileName = rz.getOptionFactory().getPropertyFolder() + System.getProperty("file.separator") + rz.getOptionFactory().getOption("fontcontrol.filename");
        if(rz.getDatabase() != null && rz.getDatabase().dbGetUser() != null && !rz.getDatabase().dbGetUser().equals("")) {
        	// Database ist initialisiert und ein User angemeldet. In diesem Falle laden wir eine userbezogene Optionsdatei
            String filename =rz.getOptionFactory().getPropertyFolder() + System.getProperty("file.separator") + rz.getOptionFactory().getOption("fontcontrol.filename") + "."+rz.getDatabase().dbGetUser();
            File test=new File(filename) ;
            if (test.exists()) {
            		fontFileName=filename;
            }
        }
        try {
             final FileInputStream input = new FileInputStream(fontFileName);
             options.clear();
             options.load(input);
             input.close();
        }
		catch (final IOException e ){
	             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "FontControl.readOptions:" ,  e.getLocalizedMessage());
		}
		setDefaultOptions();
    }

    /**
     * schreibt die Properties in die Property-Datei
     */
    public void saveOptions(){
		String[] filenames= {
				rz.getOptionFactory().getPropertyFolder() + System.getProperty("file.separator") + rz.getOptionFactory().getOption("fontcontrol.filename"),
          		rz.getOptionFactory().getPropertyFolder() + System.getProperty("file.separator") +rz.getOptionFactory().getOption("fontcontrol.filename")  + (rz.getDatabase() != null && rz.getDatabase().dbGetUser() != null && !rz.getDatabase().dbGetUser().equals("")?"."+rz.getDatabase().dbGetUser():"")           	 
		};
		try {
				for(String filename:filenames) {
					final FileOutputStream out = new FileOutputStream(filename);
		            options.store(out, "RzPro Fonts");
		            out.close();
				}
		}
		catch (final IOException e ){
             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "FontControl.saveOptions:" ,  e.getLocalizedMessage());
        }
    }

    /**
     * setFont setzt einen gewünschten Font,
     * zeichnet alle Fenster neu
     * @param type Integer
     * @param fontName String
     * @param fontSize int
     * @return true, wenn ein Font gesetzt werden konnte, false wenn nicht
     */
    public boolean setFont(int type,String fontName,int fontSize) {
    	final boolean ret = false;
    	final Font fnt= new Font(fontName, 0,fontSize);
    	if(fnt != null) {
	    	switch(type) {
	    		case BUTTON_FONT :
					options.setProperty("buttonfont.name",fontName);
					options.setProperty("buttonfont.size",String.valueOf(fontSize));
					ButtonFont = new Font(fontName, 0,fontSize);
	    			break;
	    		case HB_FONT :
					options.setProperty("hbfont.name",fontName);
					options.setProperty("hbfont.size",String.valueOf(fontSize));
					HBFont = new Font(fontName, 0,fontSize);
	    			break;
	    		case MENU_FONT :
					options.setProperty("menufont.name",fontName);
					options.setProperty("menufont.size",String.valueOf(fontSize));
					MenuFont = new Font(fontName, 0,fontSize);
	    			break;
	    		case LIST_FONT :
					options.setProperty("listfont.name",fontName);
					options.setProperty("listfont.size",String.valueOf(fontSize));
					ListFont = new Font(fontName, 0,fontSize);
	    			break;
	    		case TEXT_FONT :
					options.setProperty("textfont.name",fontName);
					options.setProperty("textfont.size",String.valueOf(fontSize));
					TextFont = new Font(fontName, 0,fontSize);
	    			break;
	    		case ERGEBNIS_FONT :
					options.setProperty("ergebnisfont.name",fontName);
					options.setProperty("ergebnisfont.size",String.valueOf(fontSize));
					ErgebnisFont = new Font(fontName, 0,fontSize);
	    			break;
	    		case TABLE_FONT :
	    		case TABLE_BOLD_FONT :
					options.setProperty("tablefont.name",fontName);
					options.setProperty("tablefont.size",String.valueOf(fontSize));
					TableFont = new Font(fontName, 0,fontSize);
					options.setProperty("tableboldfont.name",fontName);
					options.setProperty("tableboldfont.size",String.valueOf(fontSize));
					TableBoldFont = new Font(fontName, Font.BOLD,fontSize);
	    			break;
	    		case AUFTRAGS_TABLE_FONT :
					options.setProperty("auftragstablefont.name",fontName);
					options.setProperty("auftragstablefont.size",String.valueOf(fontSize));
					AuftragsTableFont = new Font(fontName, 0,fontSize);
					break;
	    		case DECKBLATT_FONT :
					options.setProperty("deckblattfont.name",fontName);
					options.setProperty("deckblattfont.size",String.valueOf(fontSize));
					DeckblattFont = new Font(fontName, 0,fontSize);
	    			break;
	    		default:
	    			break;
	    	}
        	rz.getFensterFactory().getFensterListe().redrawFrames();
    	} else {
	       	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"fontcontrol.setFont","couldn't set font "+fontName + " " + fontSize);
	    }
    	return ret;
    }
    /**
     * gibt den Tabellen-Font zurück
     */
    public Font getTableFont() {
    	return TableFont;
    }
    public Font getTableBoldFont() {
    	return TableBoldFont;
    }
    public Font getAuftragsTableFont() {
    	return AuftragsTableFont;
    }
    /**
     * gibt den Listen-Font zurück
     */
    public Font getListFont() {
    	return ListFont;
    }
    /**
     * gibt den Menu-Font zurück
     */
    public Font getMenuFont() {
    	return MenuFont;
    }
    /**
     * gibt den Text-Font zurück
     */
    public Font getTextFont() {
    	return TextFont;
    }
    /**
     * gibt den Font für das Herstellbuch zurück
     */
    public Font getHBFont() {
    	return HBFont;
    }
    /**
     * gibt den Font für die Hauptfenster-Detailansicht zurück
     */
    public Font getErgebnisFont() {
    	return ErgebnisFont;
    }
    /**
     * Font getButtonFont() gibt den ButtonFont zur�ck
     */
    public Font getButtonFont(){
        return ButtonFont;
    }
    /**
     * Font getTextPaneFont() gibt den f�r Textpanes zu verwendenden GrundFont
     * zur�ck
     */

    public Font getTextPaneFont(){
        return TextFont;
    }
    public Font getDeckblattFont() {
    	return DeckblattFont;
    }
    /**
     * setzt Fonts f�r alle Komponenten eines Frames
     */
    public void setFrameFonts(JDialog f){
        setComponentFonts(f.getContentPane());
        setMenuBar(f.getJMenuBar());
    }

    public void setFrameFonts(JFrame f){
        setComponentFonts(f.getContentPane());
        setMenuBar(f.getJMenuBar());
    }

    private void setMenuBar(JMenuBar mb){
        if (mb != null){
            for(int i = 0;i < mb.getMenuCount();i++){
                setMenuFont(mb.getMenu(i));
            }
        }
    }

    private void setMenuFont(JMenu m){
   		m.setFont(MenuFont);
        for (int i = 0;i < m.getMenuComponentCount();i++){
            m.getMenuComponent(i).setFont(MenuFont);
            if (m.getMenuComponent(i) instanceof JMenu) {
				setMenuFont((JMenu)m.getMenuComponent(i));
			}
        }
    }

    private void setComponentFonts(Container c){
        for (int i=0;i<c.getComponentCount();i++){
            final Component co = c.getComponent(i);
            if ((co instanceof JPanel) || (co instanceof JTabbedPane) || (co instanceof JScrollPane) || (co instanceof JSplitPane) || ( co instanceof JViewport)){
                setComponentFonts((Container)co);
            }
            else {
                if ((co instanceof JButton) || (co instanceof JRadioButton)) {
					co.setFont(ButtonFont);
				} else {
                    if (co instanceof JList){
                       co.setFont(ListFont);
                    }
                    else {
                        if ((co instanceof JEditorPane) ||  (co instanceof JTabbedPane) || (co instanceof JTextArea) || (co instanceof JPasswordField) || (co instanceof JTextField) || (co instanceof JTextPane)) {
							co.setFont(TextFont);
						} else {
                            co.setFont(ButtonFont);
                        }
                        if (co instanceof JLabel) {
                        	((JLabel)co).setFocusable(false);
                        }
                        if(co instanceof JTable) {
                        	if(co.getName().equals("auswahl.auftragsliste")) {
                                ((JTable)co).setRowHeight(co.getFontMetrics(rz.getFontFactory().getAuftragsTableFont()).getHeight() * 4);
                                co.setFont(rz.getFontFactory().getAuftragsTableFont());
                        	}
                       		co.setFont(TableFont);
                        }
                     }
                }
            }
        }
        if(c != null) {
        	c.repaint();
        }
    }

    /**
     *  eine Combobox mit den vorhandenen Fonts füllen
     */
    public void fillFontCMB(JComboBox cmb,int type) {
    	int defaultFont = -1;
    	cmb.removeAllItems();
    	final GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
    	final String fnt[] = gEnv.getAvailableFontFamilyNames();
    	for(int i=0;i  < fnt.length;i++) {
    		cmb.addItem(fnt[i]);
    		switch(type) {
    			case BUTTON_FONT:
    				if(ButtonFont.getName().equals(fnt[i])) {
    					defaultFont = i;
    				}
    				break;
    			case HB_FONT:
    				if(HBFont.getName().equals(fnt[i])) {
    					defaultFont = i;
    				}
    				break;
    			case MENU_FONT:
    				if(MenuFont.getName().equals(fnt[i])) {
    					defaultFont = i;
    				}
    				break;
    			case LIST_FONT:
    				if(ListFont.getName().equals(fnt[i])) {
    					defaultFont = i;
    				}
    				break;
    			case TEXT_FONT:
    				if(TextFont.getName().equals(fnt[i])) {
    					defaultFont = i;
    				}
    				break;
    			case ERGEBNIS_FONT:
    				if(ErgebnisFont.getName().equals(fnt[i])) {
    					defaultFont = i;
    				}
    				break;
    			case TABLE_FONT:
    				if(TableFont.getName().equals(fnt[i])) {
    					defaultFont = i;
    				}
    				break;
    			case AUFTRAGS_TABLE_FONT:
    				if(AuftragsTableFont.getName().equals(fnt[i])) {
    					defaultFont = i;
    				}
    				break;
    			case DECKBLATT_FONT:
    				if(DeckblattFont.getName().equals(fnt[i])) {
    					defaultFont = i;
    				}
    				break;
    		}
    	}
    	// Voreinstellung markieren
    	if(defaultFont != -1) {
    		cmb.setSelectedIndex(defaultFont);
    	}
    }
}
