/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fensterfactory;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.fenster.FensterItem;
import de.lunqual.rzpro.items.fenster.FensterListe;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  administrator
 */
public class FensterFactory  {
    //const
    public static final String ICON_PATH = "/de/lunqual/rzpro/gfx/0001.png";
    public static final String WINDOW_SEPARATOR = "_";

    //FensterControl
    public static final int         	POSITION_SIZE       							= 1;
    public static final int         	POSITION            							= 2;

    public static final int         	FENSTER_LOGIN      								= 1;
    public static final int         	FENSTER_LOGIN_EINSTELLUNGEN   					= 2;
    public static final int         	FENSTER_AUSWAHL     							= 3;
    public static final int         	FENSTER_ADRESSEN    							= 4;
    public static final int         	FENSTER_ADRESSEINGABE 							= 5;
    public static final int         	FENSTER_NOTIZ       							= 6;
    public static final int         	FENSTER_REPORT      							= 7;
    public static final int         	FENSTER_EINSTELLUNGEN							= 8;
    public static final int         	FENSTER_KALKULATION 							= 9;
    public static final int         	FENSTER_LAGER       							= 10;
    public static final int         	FENSTER_HILFE       							= 11;
    public static final int        		FENSTER_REZEPTUR    							= 12;
    public static final int 			FENSTER_RECHNEN									= 13;
	public static final int 			FENSTER_ADRESSAUSWAHL							= 14;
    public static final int 			FENSTER_STICHWORTAUSWAHL						= 15;
    public static final int				FENSTER_KALKULATION_EINGABE  					= 16;
    public static final int				FENSTER_LAGER_EINGABE							= 17;
    public static final int				FENSTER_STAERKE									= 18;
    public static final int				FENSTER_BEHAELTER								= 19;
    public static final int				FENSTER_CONTAINER_EINGABE						= 20;
    public static final int				FENSTER_LIEFERSCHEIN							= 21;
    public static final int				FENSTER_LIEFERSCHEIN_LISTE						= 22;
    public static final int 			FENSTER_ADRESSAUSWAHL_EINFACH 					= 23;
    public static final int				FENSTER_ETIKETTEN								= 24;
    public static final int				FENSTER_TAFEL									= 25;
    public static final int				FENSTER_ZUGANG									= 26;
    public static final int				FENSTER_ABGANG									= 27;
    public static final int				FENSTER_STATISTIK								= 28;
    public static final int				FENSTER_HERSTELLUNG								= 29;
    public static final int				FENSTER_HERSTELLUNG_EDIT						= 30;
    public static final int				FENSTER_ABGANGCLIENT_AUSWAHL					= 31;
    public static final int				FENSTER_VERLAUF									= 32;
    public static final int				FENSTER_ABOUT									= 33;
    public static final int				FENSTER_LOGGING									= 34;
    public static final int				FENSTER_CLIENT_EINSTELLUNGEN 					= 35;
    public static final int				FENSTER_AUSBEUTE								= 36;
    public static final int				FENSTER_STICHWORT_BEARBEITEN					= 37;
    public static final int				FENSTER_AUSBEUTE_EINGABE						= 38;
    public static final int      	    FENSTER_ZUGANGCLIENT_AUSWAHL            		= 39;
    public static final int         	FENSTER_ST_GRAFIK			            		= 40;
    public static final int           	FENSTER_DEPENDENCY			            		= 41;
    public static final int           	FENSTER_PALETTENLISTE		            		= 42;
    public static final int           	FENSTER_PALETTENEINGABE	            			= 43;
    public static final int           	FENSTER_PALETTENRECHNER	            			= 44;
    public static final int           	FENSTER_ABFRAGE_ERWEITERT        				= 45;
    public static final int           	FENSTER_INVENTURLISTE			        		= 46;
    public static final int           	FENSTER_INVENTUREINGABE		        			= 47;
    public static final int           	FENSTER_INVENTURFENSTER		        			= 48;
    public static final int           	FENSTER_ACIDLISTENFENSTER	        			= 49;
    public static final int           	FENSTER_ACIDEINGABE				        		= 50;
    public static final int           	FENSTER_ACIDRECHNER				       			= 51;
    public static final int			  	FENSTER_DEKLARATIONSLISTE						= 52;
    public static final int			  	FENSTER_DEKLARATIONS_EINGABE					= 53;
    public static final int			  	FENSTER_DEKLARATIONS_AUSWAHL					= 54;
    public static final int			  	FENSTER_AUSSTATTUNG								= 55;
    public static final int				FENSTER_DATENBLATT 								= 56;
    public static final int				FENSTER_BESTELLUNGEN							= 57;
    public static final int				FENSTER_BESTELLUNGSLISTE 						= 58;
    public static final int				FENSTER_LABORWERTLISTE 							= 59;
    public static final int				FENSTER_LABORWERT_BERECHNEN 					= 60;
    public static final int				FENSTER_LABORWERTLISTE_EINGABE 					= 61;
    public static final int				FENSTER_STATISTIK_REZEPTUR 						= 62;
    public static final int				FENSTER_PROBE									= 63;
    public static final int				FENSTER_PROBEN_EINGABE							= 64;
    public static final int				FENSTER_ZUTATENVERZEICHNIS_EINSTELLUNGEN 		= 65;
    public static final int				FENSTER_ZUTATENVERZEICHNIS_EINGABE 				= 66;
    public static final int				FENSTER_ZUTATENVERZEICHNIS 						= 67;
    public static final int				FENSTER_VERBRAUCH								= 68;
    public static final int				FENSTER_GEWICHT									= 69;
    public static final int				FENSTER_LOSNUMMER_VORLAGE						= 70;
    public static final int				FENSTER_KALENDER								= 71;
    public static final int				FENSTER_AUFTRAG									= 72;
    public static final int				FENSTER_CHANGES									= 73;
    public static final int				FENSTER_CHANGESLISTE							= 74;    
    public static final int				FENSTER_MHD										= 75;
    public static final int				FENSTER_TEMPERATURZONEN							= 76;
    public static final int				FENSTER_AUFTRAGSLISTE							= 77;
    public static final int				FENSTER_TERMINEINGABE							= 78;    
    public static final int				FENSTER_DMLISTE									= 79; 
    public static final int				FENSTER_TANKLISTE								= 80;
    public static final int				FENSTER_ORTEINGABE								= 81;
    public static final int				FENSTER_TANKEINGABE								= 82;
    public static final int				FENSTER_TANKAUSWAHL								= 83;    
    public static final int				FENSTER_KONFORM									= 84;    
    public static final int				FENSTER_SORTEN_EINGABE							= 85;
    public static final int				FENSTER_MISCHUNG_EINGABE						= 86;
    public static final int				FENSTER_MISCHUNGSLISTE							= 87;
    public static final int				FENSTER_BEWERTUNGEN_KATEGORIE_EINGABE			= 88;
    public static final int				FENSTER_BEWERTUNGEN_EINGABE						= 89;
    public static final int				FENSTER_BEWERTUNGEN_ANZEIGE						= 90;
    public static final int				FENSTER_BEWERTUNGSLISTE							= 91;  
    public static final int				FENSTER_MISCHUNG								= 92;
    public static final int				FENSTER_TICKETEINGABE							= 93;
    public static final int				FENSTER_STAMMBAUM								= 94;    
    public static final int				FENSTER_VERGLEICH								= 95;
    public static final int				FENSTER_BEDARF									= 96;
    public static final int				FENSTER_TRACE									= 97;
    public static final int				FENSTER_LOSNUMMERLISTE							= 98;
    public static final int				FENSTER_DRUCKFORMULARE							= 99;
    public static final int				FENSTER_MISCHUNG_CHART							= 100;
    public static final int				FENSTER_DOCUMENT_LISTE							= 101;
    public static final int				FENSTER_DOCUMENT_EINGABE						= 102;
    public static final int				FENSTER_REZEPTUR_CONTENT						= 103;
    public static final int				FENSTER_RECHNEN_EDIT_CONTENT					= 104;
    public static final int				FENSTER_KONTRAKTE								= 105;
    public static final int				FENSTER_EDIT_KONTRAKT							= 106;    
    
    RzPro                   	rz;
    FensterListe          	liste;
    Properties            	options;
    String                  	fensterFileName;

    /** Creates a new instance of FensterControl */
    public FensterFactory(RzPro r) {
        rz = r;
        liste = new FensterListe(rz);
        options = new Properties();
        readOptions();
    }

    /**
     * liest die property-Datei ein
     */
    public void readOptions(){
    	//Zuerst eine globale Optionsdatei auswaehlen
    	fensterFileName = rz.getOptionFactory().getPropertyFolder() + System.getProperty("file.separator") +rz.getOptionFactory().getOption("fenstercontrol.filename");
//        if(rz.getDatabase() != null && rz.getDatabase().dbGetUser() != null && !rz.getDatabase().dbGetUser().equals("")) {
//        	// Database ist initialisiert und ein User angemeldet. In diesem Falle laden wir eine userbezogene Optionsdatei
//            String filename = rz.getOptionFactory().getPropertyFolder() + System.getProperty("file.separator") +rz.getOptionFactory().getOption("fenstercontrol.filename") + "."+rz.getDatabase().dbGetUser();
//            File test=new File(filename) ;
//            if (test.exists()) {
//            		fensterFileName=filename;
//            }
//        }
        try {
             final FileInputStream input = new FileInputStream(fensterFileName);
             options.clear();
             options.load(input);
             input.close();
        }
	catch (final IOException e ){
             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "fenstercontrol.readOptions:" ,  e.getLocalizedMessage());
             saveOptions();
		}
    }
    /**
     * schreibt die Properties in die Property-Datei
     */
    public void saveOptions(){
    	String []filenames = {
    			rz.getOptionFactory().getPropertyFolder() + System.getProperty("file.separator") +rz.getOptionFactory().getOption("fenstercontrol.filename"),
           		//rz.getOptionFactory().getPropertyFolder() + System.getProperty("file.separator") +rz.getOptionFactory().getOption("fenstercontrol.filename")  + (rz.getDatabase() != null && rz.getDatabase().dbGetUser() != null && !rz.getDatabase().dbGetUser().equals("")?"."+rz.getDatabase().dbGetUser():"")           	 
    	};
    	try {
    		for(String filename:filenames) {	
		        final FileOutputStream out = new FileOutputStream(filename);
		        options.store(out, "RzPro Fensterpositionen");
		        out.close();
    		}
	}
	catch (final IOException e ){
             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "FensterControl.saveOptions:" ,  e.getLocalizedMessage());
        }
    }

    public int getOption(String OptName,int OptDefault){
        return Integer.parseInt(options.getProperty(OptName,String.valueOf(OptDefault)));
    }

    public String getOption(String OptName,String OptDefault){
    	return options.getProperty(OptName,OptDefault);
     }

    public void setOption(String OptName,int OptValue){
       options.setProperty(OptName, String.valueOf(OptValue));
    }
    public void setOption(String OptName,String OptValue){
        options.setProperty(OptName, OptValue);
     }

    /**
     * gibt die Fensterliste zurück
     * @return Fensterliste
     *
     */
    public FensterListe getFensterListe(){return liste;}

    /**
     * saveLocation speichert die Position des angegebenen Fensters ab
     * @param JRzFrame frame
     */
    public void saveLocation(Window frame){
         final String form = frame.getName();
         final Rectangle element=frame.getBounds();
         setOption(form + ".left",element.x);
         setOption(form + ".top",element.y);
         setOption(form + ".width",element.width);
         setOption(form + ".height",element.height);
         setOption(form + ".visible",(frame.isVisible() ? 1 : 0));
         saveOptions();
    }
    /**
     * setLocation setzt beim das angegebenen Fenster
     * gespeicherte positionen
     * @param JRzFrame frame
     * @param what  POSITION oder POSITION_SIZE
     */
    public void setLocation(Window f, int what){
         final String form = f.getName();
         final Rectangle element=f.getBounds();
         final Toolkit tk = Toolkit.getDefaultToolkit();
         final Dimension screen=tk.getScreenSize();
         if (what == POSITION_SIZE){
            element.width = getOption(form + ".width",f.getWidth());
            element.height = getOption(form + ".height",f.getHeight());
         }
         else {
            element.width = f.getWidth();
            element.height = f.getHeight();
         }
         element.x = getOption(form + ".left",(screen.width-element.width) / 2);
         element.y = getOption(form + ".top",(screen.height-element.height)/2);
         f.setBounds(element);

    }

    public void disposeAllWindows(){
        for(int i = 0;i < liste.size();i++){
            ((FensterItem)liste.get(i)).getFrame().dispose();
        }
    }
}
