package de.lunqual.rzpro.fenster.zutatenverzeichnis;

/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
  * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisItem;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class ZutatenverzeichnisEinstellungen extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel listenPanel;
    			private JLabel lblListe;
    			private JScrollPane scrListe;
    				private JTable tblListe;
    			private JPanel listenButtonPanel;
    				private JPanel listenButtonOben;
    					private JButton btFirst;
    					private JButton btUp;
    					private JButton btDown;
    					private JButton btLast;
    				private JPanel listenButtonUnten;
						private JButton btNeu;
						private JButton btEdit;
						private JButton btDelete;
    	private JPanel buttonPanel;
    		private JButton btSave;
    		private JButton btClose;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "zutatenverzeichnis_einstellungen.action_close";
    public static final int         		ACTION_SAVE_CODE = 1002;
    public static final String      	ACTION_SAVE_TEXT = "zutatenverzeichnis_einstellungen.action_save";

    public static final int         		ACTION_HILFE_CODE = 1006;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_FIRST_CODE = 1008;
    public static final String      	ACTION_FIRST_TEXT = "zutatenverzeichnis_einstellungen.action_first";
    public static final int         		ACTION_LAST_CODE = 1009;
    public static final String      	ACTION_LAST_TEXT = "zutatenverzeichnis_einstellungen.action_last";
    public static final int         		ACTION_UP_CODE = 1010;
    public static final String      	ACTION_UP_TEXT = "zutatenverzeichnis_einstellungen.action_up";
    public static final int         		ACTION_DOWN_CODE = 1011;
    public static final String      	ACTION_DOWN_TEXT = "zutatenverzeichnis_einstellungen.action_down";
    public static final int         		ACTION_NEU_CODE = 1012;
    public static final String      	ACTION_NEU_TEXT = "zutatenverzeichnis_einstellungen.action_neu";
    public static final int         		ACTION_EDIT_CODE = 1013;
    public static final String      	ACTION_EDIT_TEXT = "zutatenverzeichnis_einstellungen.action_edit";
    public static final int         		ACTION_DELETE_CODE = 1014;
    public static final String      	ACTION_DELETE_TEXT = "zutatenverzeichnis_einstellungen.action_delete";

    public static final int				MAX_COLUMN				= 4;
    public static final int				C_STICHWORT				= 0;
    public static final int				C_EINHEIT						= 1;
    public static final int				C_WERT							= 2;
    public static final int				C_BEZEICHNUNG		= 3;

    Timer					   		ergebnisTimer;
    ZutatenverzeichnisListe 			zl;
    DialogItem					dlgItem;

    /** Creates new form AdressenFenster */
    public ZutatenverzeichnisEinstellungen(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
       });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {

        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuFenster=new JMenu();
        	mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());

				listenPanel=new JPanel(new BorderLayout());
					lblListe=new JLabel();
					lblListe.setHorizontalAlignment(SwingConstants.CENTER);
				listenPanel.add(lblListe,BorderLayout.NORTH);
					scrListe = new JScrollPane();
						tblListe = new JTable();
						tblListe.setName("zutatenverzeichnis_einstellungen.spalten");
						tblListe.setColumnSelectionAllowed(false);
		    			tblListe.setRowSelectionAllowed(true);
		    			tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
		                    public void valueChanged(ListSelectionEvent e) {
		        			        if (e.getValueIsAdjusting()) {
										return;
									}
			        			    if(ergebnisTimer.isRunning()) {
			        			            ergebnisTimer.stop();
			        			        }
		        			        ergebnisTimer.start();
		                        }
			    			});
						scrListe.setViewportView(tblListe);
					listenPanel.add(scrListe,BorderLayout.CENTER);
					listenButtonPanel=new JPanel(new BorderLayout());
						listenButtonOben = new JPanel(new GridLayout(1,4));
							btFirst=new JButton();
						listenButtonOben.add(btFirst);
							btUp=new JButton();
						listenButtonOben.add(btUp);
							btDown=new JButton();
						listenButtonOben.add(btDown);
							btLast=new JButton();
						listenButtonOben.add(btLast);
					listenButtonPanel.add(listenButtonOben,BorderLayout.NORTH);
					listenButtonUnten=new JPanel(new GridLayout(1,3));
							btNeu=new JButton();
						listenButtonUnten.add(btNeu);
							btEdit=new JButton();
						listenButtonUnten.add(btEdit);
							btDelete=new JButton();
				    	listenButtonUnten.add(btDelete);
				    listenButtonPanel.add(listenButtonUnten,BorderLayout.SOUTH);
				    listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
			    contentPanel.add(listenPanel,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new GridLayout(1,3));
				btSave=new JButton();
				buttonPanel.add(btSave);
				btClose = new JButton();
				buttonPanel.add(btClose);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
    	    	buttonPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("zutatenverzeichnis.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
	  mnuFenster.setText(rz.getLocale().getString("menu.fenster"));

      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));


      mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
      mnuBearbeiten.add(getAction(ACTION_EDIT_CODE));
      mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_FIRST_CODE));
      mnuBearbeiten.add(getAction(ACTION_UP_CODE));
      mnuBearbeiten.add(getAction(ACTION_DOWN_CODE));
      mnuBearbeiten.add(getAction(ACTION_LAST_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));



      mnuHilfe.add(getAction(ACTION_HILFE_CODE));


      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btSave.setAction(getAction(ACTION_SAVE_CODE));

      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_NEU_CODE));
      tb1.add(getAction(ACTION_EDIT_CODE));
      tb1.add(getAction(ACTION_DELETE_CODE));
      tb1.addSeparator();

      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));


      btNeu.setAction(getAction(ACTION_NEU_CODE));
      btEdit.setAction(getAction(ACTION_EDIT_CODE));
      btDelete.setAction(getAction(ACTION_DELETE_CODE));
      btFirst.setAction(getAction(ACTION_FIRST_CODE));
      btUp.setAction(getAction(ACTION_UP_CODE));
      btDown.setAction(getAction(ACTION_DOWN_CODE));
      btLast.setAction(getAction(ACTION_LAST_CODE));

		getAction(ACTION_EDIT_CODE).setEnabled(false);
		getAction(ACTION_DELETE_CODE).setEnabled(false);
		getAction(ACTION_UP_CODE).setEnabled(false);
		getAction(ACTION_FIRST_CODE).setEnabled(false);
		getAction(ACTION_DOWN_CODE).setEnabled(false);
		getAction(ACTION_LAST_CODE).setEnabled(false);

      lblListe.setText(rz.getLocale().getString("zutatenverzeichnis_eingabe.label_liste"));

      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_NEU_CODE:neuAction();break;
                case ACTION_SAVE_CODE:saveAction();break;
                case ACTION_EDIT_CODE:editAction();break;
                case ACTION_DELETE_CODE:deleteAction();break;
                case ACTION_FIRST_CODE:firstAction();break;
                case ACTION_LAST_CODE:lastAction();break;
                case ACTION_UP_CODE:upAction();break;
                case ACTION_DOWN_CODE:downAction();break;

    			default :
                    break;
               }
        		break;
        	case MessageItem.MSG_ZUTATENVERZEICHNIS_EINGABE_REPLY:
        		if(msg.getData() != null) {
        			final ZutatenverzeichnisItem zi=((ZutatenverzeichnisItem)msg.getData());
       				zl.addItem(zi,zl.size());
        	        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
        	        tblListe.scrollRectToVisible(tblListe.getCellRect(zl.size(), 0,true));
        	        if(zl.size()>0) {
        	        	tblListe.setRowSelectionInterval(zl.size()-1,zl.size()-1);
        	        }
        	       	setActions();
        		}
        		break;
        	case MessageItem.MSG_SHOW_ZUTATENVERZEICHNIS_EINSTELLUNGEN:
        		zl = rz.getDatabase().getZutatenverzeichnis().getListe();
     		    this.settblListenModel(tblListe);
     		    setActions();
        		break;
            default:
                rz.getLogFactory().logMessage(2, "zutatenverzeichnis-einstellungen:", "auswahlAction:" + msg.getMsgCode());
                break;
        }
    }


     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_FIRST_CODE),new AuswahlAction(rz,this,ACTION_FIRST_CODE,ACTION_FIRST_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_LAST_CODE),new AuswahlAction(rz,this,ACTION_LAST_CODE,ACTION_LAST_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_UP_CODE),new AuswahlAction(rz,this,ACTION_UP_CODE,ACTION_UP_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_DOWN_CODE),new AuswahlAction(rz,this,ACTION_DOWN_CODE,ACTION_DOWN_TEXT, 0 ,0));

        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_EDIT_CODE),new AuswahlAction(rz,this,ACTION_EDIT_CODE,ACTION_EDIT_TEXT, KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, 0 ,0));

     }

	private void saveAction() {
		rz.getDatabase().getZutatenverzeichnis().saveVerzeichnis(zl);
		closeWindow();
	}


    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
	        toFront();
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void neuAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUTATENVERZEICHNIS_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_ZUTATENVERZEICHNIS_EINGABE,0,null,this));
    }

    private void editAction() {
    	if (tblListe.getSelectedRow() != -1) {
    		final ZutatenverzeichnisItem zi = zl.getItem(tblListe.getSelectedRow());
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUTATENVERZEICHNIS_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_ZUTATENVERZEICHNIS_EINGABE,0,zi,this));
    	}
    }

    private void deleteAction() {
    	if (tblListe.getSelectedRow() != -1) {
    		zl.remove(tblListe.getSelectedRow());
	        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	        tblListe.scrollRectToVisible(tblListe.getCellRect(zl.size(), 0,true));
	        if (zl.size() > 0) {
	        	tblListe.setRowSelectionInterval(zl.size()-1,zl.size()-1);
	        }
    	}
    }

    private void firstAction() {
    	final int p1=tblListe.getSelectedRow();
    	if(p1 != -1) {
        	final ZutatenverzeichnisItem zi = zl.getItem(p1);
        	zl.remove(p1);
        	zl.addItem(zi, 0);
	        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	        tblListe.scrollRectToVisible(tblListe.getCellRect(zl.size(), 0,true));
	    	if (zl.size() > 0) {
	        	tblListe.setRowSelectionInterval(0,0);
	        }
        }
    }

    private void lastAction() {
    	final int p1=tblListe.getSelectedRow();
    	if(p1 != -1) {
        	final ZutatenverzeichnisItem zi = zl.getItem(p1);
        	zl.remove(p1);
        	zl.addItem(zi, zl.size());
	        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	        tblListe.scrollRectToVisible(tblListe.getCellRect(zl.size(), 0,true));
	    	if (p1-1< zl.size()) {
	        	tblListe.setRowSelectionInterval(zl.size()-1,zl.size()-1);
	        }
        }
    }

    private void downAction() {
    	final int p1=tblListe.getSelectedRow();
    	if((p1 != -1) && (p1 < zl.size()-1)) {
        	final ZutatenverzeichnisItem zi = zl.getItem(p1);
        	zl.remove(p1);
        	zl.addItem(zi, p1+1);
	        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	        tblListe.scrollRectToVisible(tblListe.getCellRect(zl.size(), 0,true));
	    	if (p1+1 < zl.size()) {
	        	tblListe.setRowSelectionInterval(p1+1,p1+1);
	        }
        }
    }

    private void  upAction() {
    	final int p1=tblListe.getSelectedRow();
    	if((p1 != -1) && (p1 > 0)) {
        	final ZutatenverzeichnisItem zi = zl.getItem(p1);
        	zl.remove(p1);
        	zl.addItem(zi, p1-1);
	        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	        tblListe.scrollRectToVisible(tblListe.getCellRect(zl.size(), 0,true));
	    	if (zl.size() > 0) {
	        	tblListe.setRowSelectionInterval(p1-1,p1-1);
	        }
        }
    }

    private void ergebnisTimerEvent() {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
        setActions();
    }

    private void setActions() {
    	if(zl.isEmpty()) {
    		getAction(ACTION_EDIT_CODE).setEnabled(false);
    		getAction(ACTION_DELETE_CODE).setEnabled(false);
    		getAction(ACTION_UP_CODE).setEnabled(false);
    		getAction(ACTION_FIRST_CODE).setEnabled(false);
    		getAction(ACTION_DOWN_CODE).setEnabled(false);
    		getAction(ACTION_LAST_CODE).setEnabled(false);
    	}else {
    		final int p=tblListe.getSelectedRow();
    		if (p != -1) {
        		getAction(ACTION_EDIT_CODE).setEnabled(true);
        		getAction(ACTION_DELETE_CODE).setEnabled(true);
    			if((p==0) && (zl.size()>1)) {
    	    		getAction(ACTION_DOWN_CODE).setEnabled(true);
    	    		getAction(ACTION_LAST_CODE).setEnabled(true);
    	    		getAction(ACTION_UP_CODE).setEnabled(false);
    	    		getAction(ACTION_FIRST_CODE).setEnabled(false);
    			} else if ((p == (zl.size()-1)) && (zl.size()>1)) {
    	    		getAction(ACTION_DOWN_CODE).setEnabled(false);
    	    		getAction(ACTION_LAST_CODE).setEnabled(false);
    	    		getAction(ACTION_UP_CODE).setEnabled(true);
    	    		getAction(ACTION_FIRST_CODE).setEnabled(true);
    			} else {
    	    		getAction(ACTION_DOWN_CODE).setEnabled(true);
    	    		getAction(ACTION_LAST_CODE).setEnabled(true);
    	    		getAction(ACTION_UP_CODE).setEnabled(true);
    	    		getAction(ACTION_FIRST_CODE).setEnabled(true);
    			}
    		}
    	}
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"zutatenverzeichnis_einstellungen.html",this));
    }



    private void settblListenModel(JTable t) {
	    final listenColumnModel rcm = new listenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("zutatenverzeichnis_einstellungen.tableheader_stichwort"));
    		tc.setModelIndex(C_STICHWORT);
    		tc.setCellRenderer(sr);
    	rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("zutatenverzeichnis_einstellungen.tableheader_einheit"));
	    	tc.setModelIndex(C_EINHEIT);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("zutatenverzeichnis_einstellungen.tableheader_wert"));
			tc.setModelIndex(C_WERT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("zutatenverzeichnis_einstellungen.tableheader_bezeichnung"));
			tc.setModelIndex(C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblListe.setModel(new ListenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class listenColumnModel extends DefaultTableColumnModel{
	    public listenColumnModel() {
	        super();
	    }

	}

	private  class ListenTableModel extends AbstractTableModel    {

        SimpleDateFormat df;

        public ListenTableModel() {
            df = new SimpleDateFormat("dd.MM.yyyy");
        }

	   public int getColumnCount() {
	       	return MAX_COLUMN;
        }
        public int getRowCount() {
        	if(zl != null) {
                return zl.size();
        	} else {
        		return 0;
        	}
        }

        public ZutatenverzeichnisItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (zl != null)) {
        		return zl.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (zl != null)) {
                ret = getContent(zl.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(ZutatenverzeichnisItem zi,int aColumn,int row) {
            Object ret = null;
            if(zi != null) {
	            switch(aColumn){
	            	case C_STICHWORT:
	            		ret = (zi.getStichwort()==null)?"":  zi.getStichwort().getName();
	            		break;
	            	case C_EINHEIT :
	            	    ret = rz.getDatabase().getEinheiten().getGrundeinheit(zi.getEinheit()).getName();
	            	    break;
	            	case C_BEZEICHNUNG:
	            	    ret = zi.getBezeichnung();
	            	    break;
	            	case C_WERT:
	            	    ret = rz.getLocale().formatNumber( zi.getWert(),OptionFactory.NF_NORMAL);
	            	    break;
	            }
            }
            return ret;
        }
	}


	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
	            Object value, boolean isSelected, boolean hasFocus, int row,
	            int column)
	    {
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
	    }
	}


	public void columnAdded(TableColumnModelEvent e) {

	}
	public void columnMarginChanged(ChangeEvent e) {

	}
	public void columnMoved(TableColumnModelEvent e) {

	}
	public void columnRemoved(TableColumnModelEvent e) {

	}
	public void columnSelectionChanged(ListSelectionEvent e) {
}



}
