/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.temperaturzonenfenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikFenster;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.temperaturzone.rezepturZonenItem;
import de.lunqual.rzpro.items.temperaturzone.rezepturZonenListe;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class TemperaturzonenFenster extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuBearbeiten;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel sortPanel;
    			private JPanel sortButtonPanel;
					private ButtonGroup sortGroup;
						private JRadioButton btSortZone;
						private JRadioButton btSortRezeptur;
				JCheckBox chkReverse;
    		private JPanel txtPanel;
				private JScrollPane scrText;
					private JTable tblZonen;
			private JButton btRefresh;
    	private JPanel buttonPanel;
    		private JButton btClose;
			private JComboBox cmbFormulare;
			private JButton btDrucken;

    public static final int         ACTION_CLOSE_CODE = 1001;
    public static final String     ACTION_CLOSE_TEXT = "hilfe.action_close";
    public static final int         ACTION_DRUCKEN_CODE = 1002;
    public static final String     ACTION_DRUCKEN_TEXT = "hilfe.action_drucken";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_REFRESH_CODE = 1004;
    public static final String     ACTION_REFRESH_TEXT = "temperaturzonen.action_refresh";
    
    private static final int			MAX_COLUMN=6;
    private static final int			C_BEZEICHNUNG=0;
    private static final int			C_ARTIKELNUMMER=1;
    private static final int			C_TEMPERATUR_MIN=2;
    private static final int			C_TEMPERATUR_MAX=3;
    private static final int			C_TEMPERATUR_SCHNITT=4;
    private static final int			C_TEMPERATUR_ZONE=5;    
    
    rezepturZonenListe				liste;
    String							rezepturen = "";
	JRzFrame						parent;
	
    /** Creates new form HilfeFenster */
    public TemperaturzonenFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }


    @Override
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new BorderLayout());
				txtPanel=new JPanel(new BorderLayout());
					sortPanel = new JPanel(new BorderLayout());
						sortButtonPanel=new JPanel(new BorderLayout());
							sortGroup=new ButtonGroup();
								btSortZone=new JRadioButton();
	    			             btSortZone.addActionListener(new java.awt.event.ActionListener() {
		    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    			                    refreshAction();
		    			                	}
		    			            	});
								sortGroup.add(btSortZone);
								sortButtonPanel.add(btSortZone,BorderLayout.NORTH);
								btSortRezeptur = new JRadioButton();
								btSortRezeptur.addActionListener(new java.awt.event.ActionListener() {
	    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    			                    refreshAction();
	    			                	}
	    			            	});
								sortGroup.add(btSortRezeptur);
								sortButtonPanel.add(btSortRezeptur,BorderLayout.SOUTH);
								btSortZone.setSelected(true);
							sortPanel.setBorder(BorderFactory.createEtchedBorder());
						sortPanel.add(sortButtonPanel,BorderLayout.NORTH);
						chkReverse = new JCheckBox();
						chkReverse.addActionListener(new java.awt.event.ActionListener() {
			                public void actionPerformed(java.awt.event.ActionEvent evt) {
			                    refreshAction();
			                	}
			            	});
						sortPanel.add(chkReverse,BorderLayout.SOUTH);
					contentPanel.add(sortPanel,BorderLayout.NORTH);
					scrText = new JScrollPane();
						tblZonen = new JTable();
						tblZonen.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
						tblZonen.setName("temperaturzonenfenster.spalten");
		    			tblZonen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		    			tblZonen.setColumnSelectionAllowed(true);
		    			tblZonen.setRowSelectionAllowed(true);
		    			tblZonen.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
		    			tblZonen.setShowGrid(true);
		    			tblZonen.addMouseListener(new MouseAdapter(){
						     public void mouseClicked(MouseEvent e){
						    	  listeClickedAction();
						      }
						} );
						scrText.setViewportView(tblZonen);
				txtPanel.add(scrText,BorderLayout.CENTER);
					btRefresh=new JButton();
					txtPanel.add(btRefresh,BorderLayout.SOUTH);
				contentPanel.add(txtPanel,BorderLayout.CENTER);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				cmbFormulare=new JComboBox();
				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_TEMPERATURZONEN);
	    	    cmbFormulare.addActionListener(new ActionListener() {
		        	public void actionPerformed(ActionEvent evt) {
		        		if(cmbFormulare.getSelectedIndex() != -1) {
		        			rz.getOptionFactory().setOption("report.tzone",((ReportItem)cmbFormulare.getSelectedItem()).getID());
		        		}
		        	}
	            });
				buttonPanel.add(cmbFormulare,BorderLayout.CENTER);
				btDrucken=new JButton();
				buttonPanel.add(btDrucken,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);


    }
    @Override
	public void setGUIComponents() {

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));

      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.add(getAction(ACTION_DRUCKEN_CODE));

      btSortZone.setText(rz.getLocale().getString("temperaturzonen.sort_zone"));
      btSortRezeptur.setText(rz.getLocale().getString("temperaturzonen.sort_rezeptur"));
      chkReverse.setText(rz.getLocale().getString("temperaturzonen.sort_reverse"));
      
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;

    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT,KeyEvent.VK_F5 ,0));

    }


    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED :
        	    switch(msg.getCode()) {
	              	case ACTION_CLOSE_CODE:closeWindow();break;
	              	case ACTION_DRUCKEN_CODE:druckenAction();break;
	              	case ACTION_HIDE_CODE:hideAction();break;
	              	case ACTION_REFRESH_CODE:refreshAction();break;
        	    }
             break;
            case MessageItem.MSG_SHOW_TEMPERATURZONEN:
            	rezepturen = (String)msg.getData();
     		    settblZonenModel(tblZonen);
            	parent=msg.getOrigin();
            	refreshAction();
            	break;
            default:
                break;
        }
    }

    @Override
	public void closeWindow() {
       rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

   
    
    @Override
	public void openWindow() {
        setVisible(true);
        toFront();
        this.tblZonen.requestFocus();
    }

   private void refreshAction() {
	   liste = rz.getDatabase().getTemperatur().getListeRezeptur(rezepturen); 
	   if(chkReverse.isSelected()) {
		   if(this.btSortZone.isSelected()) {
			   liste.sortZoneReverse();
		   }else {
			   liste.sortRezepturReverse();
		   }
	   }else {
		   if(this.btSortZone.isSelected()) {
			   liste.sortZone();
		   }else {
			   liste.sortRezeptur();
		   }
	   }
       ((AbstractTableModel)tblZonen.getModel()).fireTableDataChanged();
	   if(parent != null) {
			parent.getMessage( new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,0,null,this));
	   }
   }

   
   private void listeClickedAction() {
	   rezepturZonenItem rzi ;
	   if(tblZonen.getSelectedRow()!= -1) {
		   rzi=liste.getItem(tblZonen.getSelectedRow());
		   if(rzi != null) {
			   AbfrageItem abfrage = new AbfrageItem();
			   switch(tblZonen.getSelectedColumn()) {
				   case C_BEZEICHNUNG:
			    		abfrage.setMuster(rzi.getBezeichnung());
			    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
			    		abfrage.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
			    		abfrage.setAdressListe(new StichwortListe());
			    		abfrage.setStichwortListe(new StichwortListe());
			    		try {
			    			parent.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, rzi.getRezeptur_id(), abfrage,this));
			    			this.toBack();
			    			parent.toFront();
			    		}catch (Exception e) {}
					   	break;
				   case C_ARTIKELNUMMER:
			    		abfrage.setMuster(rzi.getBezeichnung());
			    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
			    		abfrage.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
			    		abfrage.setAdressListe(new StichwortListe());
			    		abfrage.setStichwortListe(new StichwortListe());
			    		ErgebnisListe liste=rz.getDatabase().getErgebnis().dbGetErgebnisListe(abfrage);
			    		if(!liste.isEmpty()) {
				    		try {
				                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(MessageItem.MSG_SHOW_STATISTIK_BESTAND,StatistikFenster.NO_FILTER,liste.getItem(0),this));
				    		}catch (Exception e1) {}
			    		}
					   break;
			   }
		   }
	   }
   }
   
   
   
   private void settblZonenModel(JTable t) {
	    final MhdColumnModel rcm = new MhdColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("temperaturzonen.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("temperaturzonen.tableheader_artikelnummer"));
	    	tc.setModelIndex(C_ARTIKELNUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("temperaturzonen.tableheader_temperatur_min"));
	    	tc.setModelIndex(C_TEMPERATUR_MIN);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
		tc = new TableColumn();
		    	tc.setHeaderValue(rz.getLocale().getString("temperaturzonen.tableheader_temperatur_max"));
		    	tc.setModelIndex(C_TEMPERATUR_MAX);
		    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("temperaturzonen.tableheader_temperatur_schnitt"));
			tc.setModelIndex(C_TEMPERATUR_SCHNITT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("temperaturzonen.tableheader_zone"));
			tc.setModelIndex(C_TEMPERATUR_ZONE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
       rcm.addColumnModelListener(this);
       tblZonen.setModel(new mhdTableModel());
       tblZonen.setColumnModel(rcm);
       tblZonen.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
       tblZonen.getTableHeader().setReorderingAllowed(false);
	}

	private class MhdColumnModel extends DefaultTableColumnModel{
	    public MhdColumnModel() {
	        super();
	    }

	}

	private  class mhdTableModel extends AbstractTableModel    {

	        public mhdTableModel() {
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(liste != null) {
	                return liste.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public rezepturZonenItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (liste != null)) {
	        		return liste.getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (liste != null)) {
	                ret = getContent(liste.getItem(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        private Object getContent(rezepturZonenItem rzi,int aColumn,int row) {
	            Object ret = null;
	            if(rzi != null) {
		            switch(aColumn){
		            	 case C_BEZEICHNUNG:
		            	     ret = rzi.getBezeichnung();
		            	     break;
		            	 case C_ARTIKELNUMMER:
		            		 ret=rzi.getArtikelnummer();
		            		 break;
		            	 case C_TEMPERATUR_MIN:
		            		 ret=String.valueOf(rzi.getTempVon()) + " °C";
		            		 break;
		            	 case C_TEMPERATUR_MAX:
		            		 ret=String.valueOf(rzi.getTempBis()) + " °C";
		            		 break;
		            	 case C_TEMPERATUR_SCHNITT:
		            		 ret=String.valueOf(rzi.getTEmperaturDurchschnitt()) + " °C";
		            		 break;
		            	 case C_TEMPERATUR_ZONE:
		            		 ret=rzi.getZi().getBezeichnung();
		            		 break;
		            }
	            }
	            return ret;
		}	
	}
	
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon leer,abfrage,bestand;
		
	    StringRenderer() {
	        super();
	        setOpaque(true);
            leer = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/temperaturzonenfenster.icon_leer.png"));
            abfrage = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/temperaturzonenfenster.icon_abfrage.png"));
            bestand = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/temperaturzonenfenster.icon_bestand.png"));
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    	{
		    	rezepturZonenItem rzi = null;
		    	if((row != -1) && (liste != null)) {
		    	   rzi = liste.getItem(row);
		    	   setBackground(rz.getOptionFactory().getRGBColorString(rzi.getZi().getHgS()));
		    	   setForeground(rz.getOptionFactory().getRGBColorString(rzi.getZi().getVgS()));
		    	}
	    		if(isSelected) {
	    			setFont(rz.getFontFactory().getTableBoldFont());
	    		}else {
	    			setFont(rz.getFontFactory().getTableFont());
	    		}
	    		setIcon(leer);
	       		switch(column) {
	    			case C_BEZEICHNUNG:
	    				setIcon(abfrage);
	    				break;
	    			case C_ARTIKELNUMMER:
	    				setIcon(bestand);
	    				break;
	    			
	    		}
	    		setText((String)value);
		        return this;
        	}
		}
   
   
    private void druckenAction(){
    	if(liste != null && !liste.isEmpty()) {
    		rz.getReportFactory().temperaturZonenReport(liste, this);
    	}
    }

     private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }


	public void columnAdded(TableColumnModelEvent arg0) {
	}


	public void columnMarginChanged(ChangeEvent arg0) {
	}


	public void columnMoved(TableColumnModelEvent arg0) {
	}


	public void columnRemoved(TableColumnModelEvent arg0) {
	}


	public void columnSelectionChanged(ListSelectionEvent arg0) {
	}



}
