/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.tankfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.buchung.TankLastBelegung;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.ortItem;
import de.lunqual.rzpro.items.tank.ortListe;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class TanklistenFenster extends JRzFrame  implements TableColumnModelListener,Printable {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JSplitPane spl1;
    			private JPanel ortePanel;
    				private JPanel orteListenPanel;
    					private JLabel lblOrte;
    					private JScrollPane scrOrte;
    						private JList lstOrte;
    					private JLabel lblOrtComment;
    				private JPanel orteButtonPanel;
    					private JPanel lagerZoomPanel;
    						private JLabel lblZoom;
    						private JSpinner spZoom;
    					private JPanel lagerAnzeigenPanel;
    						private JCheckBox chkLagerAnzeige;
    						private JCheckBox chkBemerkungenAnzeige;
    					private JPanel orteButtonPanelSucheRezeptur;
    						private JButton btSucheRezeptur;
    					private JPanel sucheTankPanel;
    						private JLabel lblSucheTank;
    						private JSelectedTextField txtSucheTank;
    						private JButton btTankSuchen;
	    				private JPanel sucheLosnummerPanel;
    						private JLabel lblSucheLosnummer;
    						private JSelectedTextField txtSucheLosnummer;
    						private JButton btLosnummerSuchen;
	    				private JPanel sucheSortePanel;
    						private JLabel lblSucheSorte;
    						private JSelectedTextField txtSucheSorte;
    						private JButton btSorteSuchen;
    					private JPanel listendruckPanel;
    						private JPanel listenDruckTitelPanel;
    							private JLabel lblListendruck;
    						private JPanel radioPanel;
	    						private ButtonGroup listenGroup;
		    						private JRadioButton btListeBelegt;
		    						private JRadioButton btListeAlle;
    						private JComboBox cmbListendruck;
    						private JPanel listendruckButtonPanel;
    							private JCheckBox chkDuplex;
    							private JButton btListenDruck;
    							private JButton btListenVorschau;
    					private JPanel orteButtonPanelUnten;
	    					private JButton btOrtNeu;
	    					private JButton btOrtEdit;
	    					private JButton btOrtDelete;
	    					private JButton btOrtRefresh;
    			private JSplitPane spl2;
    				private JPanel tanklistenPanel;
							private JLabel lblTankBelegung;
    					private JScrollPane scrTanks;
    						private JTable tblTanks;
    					private JPanel tankButtonPanel;
		    					private JButton btTankNeu;
		    					private JButton btTankEdit;
		    					private JButton btTankDelete;
		    					private JButton btTankRefresh;
		    					private JButton btTankPlace;
    				private JPanel anzeigePanel;
    					private JScrollPane scrAnzeige;
    						private TanklagerPanel lagerPanel;
    					private JPanel druckPanel;
    						private JButton btDrucken;
    						private JLabel lblAnzeige;
    						private JPanel lastBelegungPanel;
    							private JPanel lastBelegungButtonPanel;
    								private JLabel lblLastBelegung;
    								private JSelectedTextField txtLastBelegungSuche;
    								private JButton btLastBelegung;
    							private JScrollPane scrLastBelegung;
    								private JEditorPane txtLastBelegung;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      		ACTION_CLOSE_TEXT = "tanklistenfenster.action_close";
    public static final int				 	ACTION_HILFE_CODE = 1002;
    public static final String      		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1008;
    public static final String      		ACTION_REFRESH_TEXT = "tanklistenfenster.action_refresh";
    
    
    public static final int         		ACTION_NEU_ORT_CODE = 1009;
    public static final String      		ACTION_NEU_ORT_TEXT = "tanklistenfenster.action_neu_ort";
    public static final int         		ACTION_EDIT_ORT_CODE = 1010;
    public static final String      		ACTION_EDIT_ORT_TEXT = "tanklistenfenster.action_edit_ort";
    public static final int         		ACTION_REFRESH_ORT_CODE = 1011;
    public static final String      		ACTION_REFRESH_ORT_TEXT = "tanklistenfenster.action_refresh_ort";
    public static final int         		ACTION_DELETE_ORT_CODE = 1012;
    public static final String      		ACTION_DELETE_ORT_TEXT = "tanklistenfenster.action_delete_ort";
    
    public static final int         		ACTION_NEU_TANK_CODE = 1013;
    public static final String      		ACTION_NEU_TANK_TEXT = "tanklistenfenster.action_neu_tank";
    public static final int         		ACTION_EDIT_TANK_CODE = 1014;
    public static final String      		ACTION_EDIT_TANK_TEXT = "tanklistenfenster.action_edit_tank";
    public static final int         		ACTION_REFRESH_TANK_CODE = 1015;
    public static final String      		ACTION_REFRESH_TANK_TEXT = "tanklistenfenster.action_refresh_tank";
    public static final int         		ACTION_DELETE_TANK_CODE = 1016;
    public static final String      		ACTION_DELETE_TANK_TEXT = "tanklistenfenster.action_delete_tank";
    public static final int         		ACTION_PRINT_PLAN_CODE = 1017;
    public static final String      		ACTION_PRINT_PLAN_TEXT = "tanklistenfenster.action_drucken";
    public static final int         		ACTION_PLACE_CODE = 1018;
    public static final String      		ACTION_PLACE_TEXT = "tanklistenfenster.cursor-kreuz";
    
    public static final int         		ACTION_SUCHEN_TANK_CODE = 1019;
    public static final String      		ACTION_SUCHEN_TANK_TEXT = "tanklistenfenster.action_suchen";
    
    public static final int         		ACTION_SUCHE_REZEPTUR_CODE = 1020;
    public static final String      		ACTION_SUCHE_REZEPTUR_TEXT = "tanklistenfenster.action_suche_rezeptur";

    public static final int         		ACTION_AUFTRAG_CODE = 1021;
    public static final String      		ACTION_AUFTRAG_TEXT = "tanklistenfenster.action_auftrag_neu";
    public static final int         		ACTION_SUCHEN_LOSNUMMER_CODE = 1022;
    public static final String      		ACTION_SUCHEN_LOSNUMMER_TEXT = "tanklistenfenster.action_suchen_losnummer";
    public static final int         		ACTION_SUCHEN_SORTE_CODE = 1023;
    public static final String      		ACTION_SUCHEN_SORTE_TEXT = "tanklistenfenster.action_suchen_sorte";
    public static final int         		ACTION_LISTEN_VORSCHAU_CODE = 1024;
    public static final String      		ACTION_LISTEN_VORSCHAU_TEXT = "tanklistenfenster.action_listenvorschau";
    public static final int         		ACTION_LISTEN_DRUCK_CODE = 1025;
    public static final String      		ACTION_LISTEN_DRUCK_TEXT = "tanklistenfenster.action_listendruck";
    public static final int         		ACTION_MISCHUNG_NEU_CODE = 1026;
    public static final String      		ACTION_MISCHUNG_NEU_TEXT = "tanklistenfenster.action_mischung_neu";
    public static final int         		ACTION_LAYOUT_V_CODE = 1027;
    public static final String      		ACTION_LAYOUT_V_TEXT = "tanklistenfenster.layout_v";
    public static final int         		ACTION_LAYOUT_H_CODE = 1028;
    public static final String      		ACTION_LAYOUT_H_TEXT = "tanklistenfenster.layout_h";
    
	public static final int ACTION_CHART_CODE = 1029;
	public static final String ACTION_CHART_TEXT = "tanklistenfenster.action_chart";
    
    public static final int 			MAX_COLUMN = 8;
    public static final int				C_NUMMER=0;
    public static final int				C_INHALT=1;
    public static final int				C_RESTLITER=2;
    public static final int				C_LAGER = 3;
    public static final int				C_LITER=6;
    public static final int				C_COMMENT=7;
    public static final int				C_PX=8;
    public static final int				C_PY=4;
    public static final int				C_PR=5;


    ArrayList<ortItem>					orte;
    ArrayList<tankItem>					tanks;
    Image								image;
    JRzFrame							origin;
    boolean								placeMode;
    tankItem							anzeige;
    boolean								lagerAnzeige = false;
    boolean								bemerkungenAnzeige = false;
    boolean								startup = true;
    
    /** Creates new form AdressenFenster */
    public TanklistenFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        placeMode = false;
        anzeige = new tankItem(rz,"0");
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				spl1=new JSplitPane();
					spl1.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
					spl1.setDividerSize(6);
					ortePanel = new JPanel(new BorderLayout());
						lblOrte = new JLabel();
							lblOrte.setHorizontalAlignment(SwingConstants.CENTER);
						ortePanel.add(lblOrte, BorderLayout.NORTH);
						scrOrte = new JScrollPane();	
							lstOrte = new JList();
							 lstOrte.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
						            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
						            	if(evt.getValueIsAdjusting()) {
											return;
										}
						            	refreshTanklisteAction(0);
						            }
						        });
							 lstOrte.setCellRenderer(new ortListenRenderer(rz));
							scrOrte.setViewportView(lstOrte);
						ortePanel.add(scrOrte,BorderLayout.CENTER);
						orteButtonPanel = new JPanel();
							orteButtonPanel.setLayout(new BoxLayout(orteButtonPanel,BoxLayout.PAGE_AXIS));
							
								lagerZoomPanel = new JPanel(new BorderLayout()) ;
								lagerZoomPanel.setBorder(BorderFactory.createEtchedBorder());
									lblZoom = new JLabel();
									lblZoom.setHorizontalAlignment(SwingConstants.TRAILING);
									lagerZoomPanel.add(lblZoom,BorderLayout.WEST);
									spZoom = new JSpinner();
									try {
										spZoom.setValue(rz.getOptionFactory().getOption("tanklager-auswahl.zoom",TanklagerPanel.DEFAULT_SCALING));
									}catch (Exception e) {
										spZoom.setValue(TanklagerPanel.DEFAULT_SCALING);
									}
									spZoom.addChangeListener(new javax.swing.event.ChangeListener() {
										public void stateChanged(javax.swing.event.ChangeEvent evt) {
											zoomChanged();
				    	            	}
									});
									lagerZoomPanel.add(spZoom,BorderLayout.CENTER);
							    orteButtonPanel.add(lagerZoomPanel);
								lagerAnzeigenPanel = new JPanel(new BorderLayout());
									chkLagerAnzeige = new JCheckBox();
										lagerAnzeige = rz.getOptionFactory().getOption("tanklistenfenster.lager_anzeige",0)==0?false:true;
										chkLagerAnzeige.setSelected(lagerAnzeige);
										chkLagerAnzeige.addActionListener(new ActionListener() {
					        	        	public void actionPerformed(ActionEvent evt) {
					        	            	rz.getOptionFactory().setOption("tanklistenfenster.lager_anzeige", chkLagerAnzeige.isSelected()?1:0);
					        	            	rz.getOptionFactory().saveOptions();
					        	            	lagerPanel.setPaintLager(chkLagerAnzeige.isSelected());
					        	            	lagerPanel.repaint();
					        	        	}
						        	    });
										
									lagerAnzeigenPanel.add(chkLagerAnzeige,BorderLayout.NORTH);
									
									chkBemerkungenAnzeige = new JCheckBox();
									bemerkungenAnzeige = rz.getOptionFactory().getOption("tanklistenfenster.bemerkungen_anzeige",0)==0?false:true;
									chkBemerkungenAnzeige.setSelected(bemerkungenAnzeige);
									chkBemerkungenAnzeige.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	            	rz.getOptionFactory().setOption("tanklistenfenster.bemerkungen_anzeige", chkBemerkungenAnzeige.isSelected()?1:0);
				        	            	rz.getOptionFactory().saveOptions();
				        	            	lagerPanel.setPaintBemerkungen(chkBemerkungenAnzeige.isSelected());
				        	            	lagerPanel.repaint();
				        	        	}
					        	    });
									
									lagerAnzeigenPanel.add(chkBemerkungenAnzeige,BorderLayout.SOUTH);
									
								orteButtonPanel.add(lagerAnzeigenPanel);
								orteButtonPanelSucheRezeptur = new JPanel(new BorderLayout());
									btSucheRezeptur = new JButton();
									orteButtonPanelSucheRezeptur.add(btSucheRezeptur,BorderLayout.CENTER);
								orteButtonPanel.add(orteButtonPanelSucheRezeptur,BorderLayout.NORTH);
									sucheTankPanel = new JPanel(new BorderLayout());
										sucheTankPanel.setBorder(BorderFactory.createEtchedBorder());
										lblSucheTank = new JLabel();
											lblSucheTank.setHorizontalAlignment(SwingConstants.CENTER);
										sucheTankPanel.add(lblSucheTank,BorderLayout.NORTH);
										txtSucheTank = new JSelectedTextField();
										txtSucheTank.addKeyListener(new java.awt.event.KeyAdapter() {
								            public void keyReleased(java.awt.event.KeyEvent evt) {
								                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
								                    	tankSuchenAction();
								                    }
								            }
								        });
										sucheTankPanel.add(txtSucheTank,BorderLayout.CENTER);
										btTankSuchen = new JButton();
										sucheTankPanel.add(btTankSuchen,BorderLayout.EAST);
									orteButtonPanel.add(sucheTankPanel);
									
										sucheLosnummerPanel = new JPanel(new BorderLayout());
										sucheLosnummerPanel.setBorder(BorderFactory.createEtchedBorder());
										lblSucheLosnummer = new JLabel();
											lblSucheLosnummer.setHorizontalAlignment(SwingConstants.CENTER);
										sucheLosnummerPanel.add(lblSucheLosnummer,BorderLayout.NORTH);
										txtSucheLosnummer = new JSelectedTextField();
										txtSucheLosnummer.addKeyListener(new java.awt.event.KeyAdapter() {
								            public void keyReleased(java.awt.event.KeyEvent evt) {
								                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
								                    	losnummerSuchenAction();
								                    }
								            }
								        });
										sucheLosnummerPanel.add(txtSucheLosnummer,BorderLayout.CENTER);
										btLosnummerSuchen = new JButton();
										sucheLosnummerPanel.add(btLosnummerSuchen,BorderLayout.EAST);
									orteButtonPanel.add(sucheLosnummerPanel);
									
										sucheSortePanel = new JPanel(new BorderLayout());
										sucheSortePanel.setBorder(BorderFactory.createEtchedBorder());
										lblSucheSorte = new JLabel();
											lblSucheSorte.setHorizontalAlignment(SwingConstants.CENTER);
										sucheSortePanel.add(lblSucheSorte,BorderLayout.NORTH);
										txtSucheSorte = new JSelectedTextField();
										txtSucheSorte.addKeyListener(new java.awt.event.KeyAdapter() {
								            public void keyReleased(java.awt.event.KeyEvent evt) {
								                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
								                    	sorteSuchenAction();
								                    }
								            }
								        });
										sucheSortePanel.add(txtSucheSorte,BorderLayout.CENTER);
										btSorteSuchen = new JButton();
										sucheSortePanel.add(btSorteSuchen,BorderLayout.EAST);
									orteButtonPanel.add(sucheSortePanel);
									
									listendruckPanel = new JPanel();
										listendruckPanel.setLayout(new BoxLayout(listendruckPanel,BoxLayout.PAGE_AXIS));
										listendruckPanel.setBorder(BorderFactory.createEtchedBorder());
										listenDruckTitelPanel = new JPanel(new BorderLayout());
											lblListendruck = new JLabel();
												lblListendruck.setHorizontalAlignment(SwingConstants.CENTER);
											listenDruckTitelPanel.add(lblListendruck,BorderLayout.NORTH);
										listendruckPanel.add(listenDruckTitelPanel);
										radioPanel = new JPanel(new BorderLayout());
											radioPanel.setBorder(BorderFactory.createLoweredBevelBorder());
											listenGroup = new ButtonGroup();
												btListeBelegt = new JRadioButton();
												listenGroup.add(btListeBelegt);
												radioPanel.add(btListeBelegt,BorderLayout.NORTH);
												btListeAlle = new JRadioButton();
												listenGroup.add(btListeAlle);
												radioPanel.add(btListeAlle,BorderLayout.SOUTH);
												btListeBelegt.setSelected(true);
										listendruckPanel.add(radioPanel);
										cmbListendruck = new JComboBox();
											rz.getDatabase().getReport().dbGetReportListeCombo(cmbListendruck,ReportFactory.REPORT_TYPE_TANKBELEGUNG);
											 cmbListendruck.addActionListener(new ActionListener() {
													public void actionPerformed(ActionEvent evt) {
							        	        		if(cmbListendruck.getSelectedIndex() != -1) {
							        	        			rz.getOptionFactory().setOption("report.tankbelegung",((ReportItem)cmbListendruck.getSelectedItem()).getID());
							        	        		}
							        	        	}
								                });
										listendruckPanel.add(cmbListendruck);
										listendruckButtonPanel = new JPanel(new GridLayout(2,2));
											chkDuplex= new JCheckBox();
											chkDuplex.setSelected((rz.getOptionFactory().getOption("tankliste.duplex",0) == 1?true:false));
											chkDuplex.addActionListener(new ActionListener() {
									        	public void actionPerformed(ActionEvent evt) {
									        		rz.getOptionFactory().setOption("tankliste.duplex", chkDuplex.isSelected()?1:0);
									        		rz.getOptionFactory().saveOptions();
									        	}
								    	    });
											listendruckButtonPanel.add(chkDuplex);
		    								btListenDruck = new JButton();
		    								listendruckButtonPanel.add(btListenDruck);
		    								btListenVorschau = new JButton();
		    								listendruckButtonPanel.add(btListenVorschau);
		    							listendruckPanel.add(listendruckButtonPanel);
										
		    						orteButtonPanel.add(listendruckPanel);
		    							
							orteButtonPanelUnten = new JPanel(new GridLayout(2,2));
								btOrtNeu = new JButton();
								orteButtonPanelUnten.add(btOrtNeu);
								btOrtEdit = new JButton();
								orteButtonPanelUnten.add(btOrtEdit);
								btOrtDelete = new JButton();
								orteButtonPanelUnten.add(btOrtDelete);
								btOrtRefresh = new JButton();
								orteButtonPanelUnten.add(btOrtRefresh);
								orteButtonPanel.add(orteButtonPanelUnten, BorderLayout.SOUTH);
							ortePanel.add(orteButtonPanel,BorderLayout.SOUTH);
					spl2 = new JSplitPane();

						tanklistenPanel = new JPanel(new BorderLayout());
							scrTanks = new JScrollPane();
								tblTanks  = new JTable();
					 	        tblTanks.addMouseListener(new MouseAdapter() {
									public void mousePressed(MouseEvent e) {
					 	                if(e.getClickCount() !=1) {
					 	                }
					 	            }
								public void mouseReleased(MouseEvent e) {
									int row = tblTanks.getSelectedRow();
									int column = tblTanks.getSelectedColumn();
									if (row != -1 && column != -1) {
										if (column == C_INHALT) {
											inhaltsAnzeige(row,column);
									}
		        			        tblTanksSelectionChanged();
						 	       }
					 	        }});
					 	        tblTanks.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
				    			tblTanks.setName("tanklistenfenster.tanks");
					    		tblTanks.setShowGrid(true);
				    			tblTanks.setGridColor(Color.BLACK);
								scrTanks.setViewportView(tblTanks);
							tanklistenPanel.add(scrTanks,BorderLayout.CENTER);
								tankButtonPanel = new JPanel(new GridLayout(3,2));
									btTankNeu = new JButton();
									tankButtonPanel.add(btTankNeu);
									btTankEdit = new JButton();
									tankButtonPanel.add(btTankEdit);
									btTankDelete = new JButton();
									tankButtonPanel.add(btTankDelete);
									btTankPlace = new JButton();
									tankButtonPanel.add(btTankPlace);
									btTankRefresh = new JButton();
									tankButtonPanel.add(btTankRefresh);
							tanklistenPanel.add(tankButtonPanel,BorderLayout.SOUTH);
						anzeigePanel = new JPanel(new BorderLayout());
							scrAnzeige = new JScrollPane();
								scrAnzeige.getVerticalScrollBar().setUnitIncrement(32);
								scrAnzeige.getHorizontalScrollBar().setUnitIncrement(32);
								lagerPanel = new TanklagerPanel(rz);
								lagerPanel.setZoom(rz.getOptionFactory().getOption("tanklager.zoom",(int) TanklagerPanel.DEFAULT_SCALING));
								lagerPanel.addMouseListener(new MouseAdapter() {
									public void mouseReleased(MouseEvent e) {
						            	if (e.getClickCount() == 1) {
						            		lagerPanelMouseClicked(e);
						            		if(e.isMetaDown()) {
						            			showPopup(e);
						            		}else {
						            			tankItem ti = lagerPanel.getTankAt(e.getPoint(),true,false);
												if(ti != null) {
													getLastBelegung(ti);
												}
											}
							 	        }
									}
									private void showPopup(MouseEvent e) {
										tankItem ti = lagerPanel.getTankAt(e.getPoint(),true,false);
										if(ti != null) {
											auftragEingebenAction(ti);
										}
									}
						        });
								lagerPanel.addMouseMotionListener(new MouseMotionListener() {
									public void mouseMoved(MouseEvent e) {
										tankItem ti = lagerPanel.getTankAt(e.getPoint(),true,false);
										if(ti !=null) {
												if(!ti.getNummer().equals(anzeige.getNummer())) {
													anzeige = ti.clones();
													lblAnzeige.setText(lagerPanel.getLabelTipText(e));
												}
										}
									}
									public void mouseDragged(MouseEvent e) {
									}
								}
							);
							scrAnzeige.setViewportView(lagerPanel);
							druckPanel = new JPanel(new BorderLayout());
								btDrucken = new JButton();
								druckPanel.add(btDrucken,BorderLayout.WEST);
								lblAnzeige = new JLabel();
									lblAnzeige.setBorder(BorderFactory.createEtchedBorder());
								druckPanel.add(lblAnzeige,BorderLayout.EAST);
								lastBelegungPanel = new JPanel(new BorderLayout());
									lastBelegungButtonPanel = new JPanel(new BorderLayout());
										lblLastBelegung = new JLabel();
											lblLastBelegung.setHorizontalAlignment(SwingConstants.LEADING);
										lastBelegungButtonPanel.add(lblLastBelegung,BorderLayout.WEST);
										txtLastBelegungSuche = new JSelectedTextField();
										txtLastBelegungSuche.addKeyListener(new java.awt.event.KeyAdapter() {
								            public void keyReleased(java.awt.event.KeyEvent evt) {
								                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
								                    	if(!txtLastBelegungSuche.getText().trim().equals("")) {
								                    		tankItem ti = new tankItem(rz,txtLastBelegungSuche.getText().trim());
								                    		getLastBelegung(ti);
								                    	}
								                    }
								            }
								        });
										lastBelegungButtonPanel.add(txtLastBelegungSuche,BorderLayout.CENTER);
										btLastBelegung = new JButton();
										btLastBelegung.addActionListener(new ActionListener() {
											public void actionPerformed(ActionEvent evt) {
												if(!txtLastBelegungSuche.getText().trim().equals("")) {
						                    		tankItem ti = new tankItem(rz,txtLastBelegungSuche.getText().trim());
						                    		getLastBelegung(ti);
						                    	}
					        	        	}
						                });
										lastBelegungButtonPanel.add(btLastBelegung,BorderLayout.EAST);
									lastBelegungPanel.add(lastBelegungButtonPanel,BorderLayout.NORTH);
									scrLastBelegung = new JScrollPane();
										txtLastBelegung = new JEditorPane();
										txtLastBelegung.setContentType("text/html");
										txtLastBelegung.setEditable(false);
										txtLastBelegung.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
								            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
								                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
									                	ergebnisLinkAction(txtLastBelegung);
								                	}
									            }
									        });
										scrLastBelegung.setViewportView(txtLastBelegung);
									lastBelegungPanel.add(scrLastBelegung,BorderLayout.CENTER);
								
									if(rz.getDatabase().getProperties().getProperty("global_tankliste_show_history").getP_value().equals("1")){
										druckPanel.add(lastBelegungPanel,BorderLayout.CENTER);
									}
									anzeigePanel.add(druckPanel,BorderLayout.SOUTH);
						anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
						spl2.setLeftComponent(tanklistenPanel);
						spl2.setRightComponent(anzeigePanel);
						setLayout(rz.getOptionFactory().getOption("tanklager.layout", OptionFactory.DEFAULT_TANKLAGER_LAYOUT));
						
				spl1.setLeftComponent(ortePanel);
				spl1.setRightComponent(spl2);
			contentPanel.add(spl1,BorderLayout.CENTER);

			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				buttonPanel.setBorder(BorderFactory.createEtchedBorder());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    		setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    		startup = false;
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("tanklistenfenster.titel") +"  " + rz.getLocale().getString("tankliste.gesamtkapazitaet").replaceAll("%n", rz.getLocale().formatNumber(getGesamtKapazitaet(), OptionFactory.NF_ONE)));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
	  mnuDatei.addSeparator();
	  mnuDatei.add(getAction(ACTION_CHART_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));

      mnuBearbeiten.add(getAction(ACTION_AUFTRAG_CODE));
      
      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btOrtNeu.setAction(getAction(ACTION_NEU_ORT_CODE));
      btOrtEdit.setAction(getAction(ACTION_EDIT_ORT_CODE));
      btOrtDelete.setAction(getAction(ACTION_DELETE_ORT_CODE));
      btOrtRefresh.setAction(getAction(ACTION_REFRESH_ORT_CODE));
      
      btTankNeu.setAction(getAction(ACTION_NEU_TANK_CODE));
      btTankEdit.setAction(getAction(ACTION_EDIT_TANK_CODE));
      btTankDelete.setAction(getAction(ACTION_DELETE_TANK_CODE));
      btTankRefresh.setAction(getAction(ACTION_REFRESH_TANK_CODE));
      btTankPlace.setAction(getAction(ACTION_PLACE_CODE));
      btTankSuchen.setAction(getAction(ACTION_SUCHEN_TANK_CODE));
      btLosnummerSuchen.setAction(getAction(ACTION_SUCHEN_LOSNUMMER_CODE));
      btSorteSuchen.setAction(getAction(ACTION_SUCHEN_SORTE_CODE));
      btSucheRezeptur.setAction(getAction(ACTION_SUCHE_REZEPTUR_CODE));
      
      btLastBelegung.setText(rz.getLocale().getString("tanklistenfenster.lastbelegung_suche"));
      Icon suchIcon = new ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/tanklistenfenster.icon_suchen.png"));	
      btLastBelegung.setIcon(suchIcon);
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_PRINT_PLAN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_AUFTRAG_CODE));
	  tb1.addSeparator();
	  tb1.add(getAction(ACTION_CHART_CODE));
      tb1.addSeparator();
     // tb1.add(getAction(ACTION_MISCHUNG_NEU_CODE));
      tb1.add(getAction(ACTION_LAYOUT_H_CODE));
      tb1.add(getAction(ACTION_LAYOUT_V_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));

      btDrucken.setAction(getAction(ACTION_PRINT_PLAN_CODE));
      btListenDruck.setAction(getAction(ACTION_LISTEN_DRUCK_CODE));
      btListenVorschau.setAction(getAction(ACTION_LISTEN_VORSCHAU_CODE));
      
      getAction(ACTION_AUFTRAG_CODE).setEnabled(false);
      getAction(ACTION_MISCHUNG_NEU_CODE).setEnabled(false);
      
      lblOrte.setText(rz.getLocale().getString("tanklistenfenster.label_orte"));
      lblSucheTank.setText(rz.getLocale().getString("tanklistenfenster.label_suche_tank"));
      lblSucheLosnummer.setText(rz.getLocale().getString("tanklistenfenster.label_suche_losnummer"));
      lblSucheSorte.setText(rz.getLocale().getString("tanklistenfenster.label_suche_sorte"));
      lblListendruck.setText(rz.getLocale().getString("tanklistenfenster.label_listendruck"));
      btListeBelegt.setText(rz.getLocale().getString("tanklistenfenster.listendruck_belegt"));
      btListeAlle.setText(rz.getLocale().getString("tanklistenfenster.listendruck_alle"));
      chkLagerAnzeige.setText(rz.getLocale().getString("tanklistenfenster.label_lager_anzeigen"));
      chkBemerkungenAnzeige.setText(rz.getLocale().getString("tanklistenfenster.label_bemerkungen_anzeigen"));
      lblZoom.setText(rz.getLocale().getString("tanklistenfenster.label_zoom"));
      lblLastBelegung.setText(rz.getLocale().getString("tanklistenfenster.label_belegung").replaceAll("%t", "").replaceAll("%d",String.valueOf(rz.getOptionFactory().getInt("tankliste.belegung.last.count"))));
      chkDuplex.setText(rz.getLocale().getString("tankliste.duplex"));
      
      
//      lagerAnzeige = rz.getOptionFactory().getOption("tanklistenfenster.lager_anzeige",0) == 0?false:true;
//      chkLagerAnzeige.setSelected(lagerAnzeige);
      settblTanksModel(tblTanks);
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      setDividerLocations();
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_REFRESH_ORT_CODE:
                case ACTION_REFRESH_CODE:refreshAction(0);break;
                case ACTION_REFRESH_TANK_CODE:refreshTanklisteAction(0);break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_EDIT_ORT_CODE: editOrtAction();break;
                case ACTION_NEU_ORT_CODE:neuOrtAction();break;
                
                case ACTION_EDIT_TANK_CODE: editTankAction();break;
                case ACTION_NEU_TANK_CODE:neuTankAction();break;
                case ACTION_DELETE_TANK_CODE:deleteTankAction();break;
                case ACTION_DELETE_ORT_CODE:deleteOrtAction();break;
                case ACTION_PRINT_PLAN_CODE:printPlanAction();break;
                case ACTION_PLACE_CODE:togglePlaceMode();break;
                
                case ACTION_SUCHEN_TANK_CODE:tankSuchenAction();break;
                case ACTION_SUCHEN_LOSNUMMER_CODE:losnummerSuchenAction();break;
                case ACTION_SUCHEN_SORTE_CODE:sorteSuchenAction();break;
                case ACTION_SUCHE_REZEPTUR_CODE:sucheRezepturAction();break;
                
                case ACTION_LISTEN_DRUCK_CODE:listendruckAction(false);break;
                case ACTION_LISTEN_VORSCHAU_CODE:listendruckAction(true);break;
                case ACTION_LAYOUT_V_CODE:setLayout(0);break;
                case ACTION_LAYOUT_H_CODE:setLayout(1);break;
                case ACTION_CHART_CODE:chartAction();break;
                case ACTION_AUFTRAG_CODE:
                	if(tblTanks.getSelectedRow() != -1) {
                		auftragEingebenAction(tanks.get(tblTanks.getSelectedRow()));
                	}
                	break;
                case ACTION_MISCHUNG_NEU_CODE:
                	if(tblTanks.getSelectedRow() != -1) {
                		tankItem ti = tanks.get(tblTanks.getSelectedRow());
                		if(ti != null) {
                			if(!ti.isMischung()&&ti.isEmpty()) {
                				mischungNeuAction(ti);
                			}
                		}
                	}
                	break;
                default :
                    break;
               }
        		break;
        	case MessageItem.MSG_REFRESH_AUSGABE:
    			refreshTanklisteAction(0);
        		break;
        	case MessageItem.MSG_TANKEINGABE_REPLY:
    			refreshTanklisteAction(msg.getCode());
        		break;
        	case MessageItem.MSG_ORTEINGABE_REPLY:
    			refreshAction(msg.getCode());
        		break;
        	case MessageItem.MSG_SHOW_TANKLISTE:
        		origin = msg.getOrigin();
        	   	if(msg.getData() instanceof String) {  
        	   		String tank = (String)msg.getData();
        	   		if(tank != null && !tank.equals("")) {
        	   			this.txtSucheTank.setText(tank.trim());
        	   			tankSuchenAction();
        	   		}
        	   	} else {
            	   	refreshAction(rz.getOptionFactory().getOption("tanklistenfenster.selected",0));
        	   	}
                break;
            default:
                break;
        }
    }

    private void zoomChanged() {
    	int value = ((Integer)spZoom.getValue()).intValue();
    	if(value < 10) {
     		value = 10;
     	} else if(value > 100) {
     		value = 100;
     	}
     	spZoom.setValue(value);
    	lagerPanel.setZoom(value);
    	rz.getOptionFactory().setOption("tanklager.zoom", value);
    	rz.getOptionFactory().saveOptions();
    	lagerPanel.validate();
    	lagerPanel.repaint();
    }
    
    private void saveDividerLocations(){
    	rz.getOptionFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getOptionFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getOptionFactory().setOption(this.getName() + ".spl2", this.spl2.getDividerLocation());
        rz.getOptionFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getOptionFactory().getOption(this.getName() + ".spl1",this.getWidth()/3));
        spl2.setDividerLocation(rz.getOptionFactory().getOption(this.getName() + ".spl2",this.getHeight()/2));
    }
    

     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_ORT_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_ORT_CODE,ACTION_REFRESH_ORT_TEXT, KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_NEU_ORT_CODE),new AuswahlAction(rz,this,ACTION_NEU_ORT_CODE,ACTION_NEU_ORT_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_EDIT_ORT_CODE),new AuswahlAction(rz,this,ACTION_EDIT_ORT_CODE,ACTION_EDIT_ORT_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_ORT_CODE),new AuswahlAction(rz,this,ACTION_DELETE_ORT_CODE,ACTION_DELETE_ORT_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_TANK_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_TANK_CODE,ACTION_REFRESH_TANK_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_NEU_TANK_CODE),new AuswahlAction(rz,this,ACTION_NEU_TANK_CODE,ACTION_NEU_TANK_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_EDIT_TANK_CODE),new AuswahlAction(rz,this,ACTION_EDIT_TANK_CODE,ACTION_EDIT_TANK_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_TANK_CODE),new AuswahlAction(rz,this,ACTION_DELETE_TANK_CODE,ACTION_DELETE_TANK_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_PRINT_PLAN_CODE),new AuswahlAction(rz,this,ACTION_PRINT_PLAN_CODE,ACTION_PRINT_PLAN_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_PLACE_CODE),new AuswahlAction(rz,this,ACTION_PLACE_CODE,ACTION_PLACE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_TANK_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_TANK_CODE,ACTION_SUCHEN_TANK_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SUCHE_REZEPTUR_CODE),new AuswahlAction(rz,this,ACTION_SUCHE_REZEPTUR_CODE,ACTION_SUCHE_REZEPTUR_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_AUFTRAG_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAG_CODE,ACTION_AUFTRAG_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_LOSNUMMER_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_LOSNUMMER_CODE,ACTION_SUCHEN_LOSNUMMER_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_SORTE_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_SORTE_CODE,ACTION_SUCHEN_SORTE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_LISTEN_DRUCK_CODE),new AuswahlAction(rz,this,ACTION_LISTEN_DRUCK_CODE,ACTION_LISTEN_DRUCK_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_LISTEN_VORSCHAU_CODE),new AuswahlAction(rz,this,ACTION_LISTEN_VORSCHAU_CODE,ACTION_LISTEN_VORSCHAU_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_MISCHUNG_NEU_CODE),new AuswahlAction(rz,this,ACTION_MISCHUNG_NEU_CODE,ACTION_MISCHUNG_NEU_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_LAYOUT_V_CODE),new AuswahlAction(rz,this,ACTION_LAYOUT_V_CODE,ACTION_LAYOUT_V_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_LAYOUT_H_CODE),new AuswahlAction(rz,this,ACTION_LAYOUT_H_CODE,ACTION_LAYOUT_H_TEXT, 0 ,0));
		actionList.put(String.valueOf(ACTION_CHART_CODE),new AuswahlAction(rz,this,ACTION_CHART_CODE,ACTION_CHART_TEXT, 0,0));
     }

     private void setLayout(int layout) {
    	 rz.getOptionFactory().setOption("tanklager.layout", layout);
    	 rz.getOptionFactory().saveOptions();
    	 spl1.remove(spl2);
    	 if(layout == 0){
				spl2.setOrientation(JSplitPane.VERTICAL_SPLIT);
				spl2.setDividerSize(6);
				spl2.remove(anzeigePanel);
				spl2.remove(tanklistenPanel);
				spl2.setLeftComponent(tanklistenPanel);
				spl2.setRightComponent(anzeigePanel);
			    getAction(ACTION_LAYOUT_H_CODE).setEnabled(true);
			    getAction(ACTION_LAYOUT_V_CODE).setEnabled(false);
			} else {
				spl2.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
				spl2.setDividerSize(6);
				spl2.remove(anzeigePanel);
				spl2.remove(tanklistenPanel);
				spl2.setLeftComponent(anzeigePanel);
				spl2.setRightComponent(tanklistenPanel);
			    getAction(ACTION_LAYOUT_H_CODE).setEnabled(false);
			    getAction(ACTION_LAYOUT_V_CODE).setEnabled(true);
			}
    	 spl2.validate();
    	 spl2.repaint();
    	 spl1.setRightComponent(spl2);
    	 if(layout == 0) {
			spl2.setDividerLocation((spl2.getHeight()/5));
    	 }else {
			spl2.setDividerLocation(((spl2.getWidth()/5)*4));
    	 }
     }
     
     private void chartAction() {
    		if(tblTanks.getSelectedRow() != -1) {
        		tankItem ti = tanks.get(tblTanks.getSelectedRow());
        		if(ti != null) {
        			if(ti.isMischung()) {
        				MischungsItem mi =  rz.getDatabase().getMischungen().getMischung(ti.getInhaltsListe().getMischungsNummer());
        				if(mi != null) {
        					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG_CHART,false,new MessageItem(MessageItem.MSG_SHOW_MISCHUNG_CHART,0,mi,this));
        				}
        			}
        		}
        	}
     }
     
     private void ergebnisLinkAction(JEditorPane txt) {
		 final Document d = txt.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txt.viewToModel( txt.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
		 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
		 			if(ziel.startsWith("l:")) {
		 				String[] p = ziel.split(":");
                 		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^"+p[2].replaceAll(" ", ".")+"$",this));
		 			} else if (ziel.startsWith("r:")){
		 				String[] p = ziel.split(":");
		 				final AbfrageItem ai = new AbfrageItem();
						ai.setID(0);
						ai.setAdressListe(new StichwortListe());
						ai.setStichwortListe(new StichwortListe());
						ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
						ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" + p[1] + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
						try {
							rz.setWaitCursor(this);
							JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
							frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this)); 
							rz.setFreeCursor(this);
						} catch (final Exception e1) {}
		 			} else if(ziel.startsWith("m:")) {
		 				String[] p = ziel.split(":");
		 				int nummer = 0;
		 				try {
		 					nummer = Integer.parseInt(p[2]);
		 				}catch(Exception e1) {};
		 				
		 				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNG,nummer,null,this));
		 			}
		 		}
		 	}
		 }
     }
		 				
     private void getLastBelegung(tankItem ti) {
    	 SimpleDateFormat df=new SimpleDateFormat("dd.MM yyyy");
    	 String belegung = "";
    	 lblLastBelegung.setText(rz.getLocale().getString("tanklistenfenster.label_belegung").replaceAll("%t", "").replaceAll("%d",String.valueOf(rz.getOptionFactory().getInt("tankliste.belegung.last.count"))));
    	 ArrayList<TankLastBelegung> last = new ArrayList<TankLastBelegung>();
    	 if(ti != null  &&  !ti.getNummer().trim().equals("")) {
    		 txtLastBelegungSuche.setText(ti.getNummer().trim());
    	   	 lblLastBelegung.setText(rz.getLocale().getString("tanklistenfenster.label_belegung").replaceAll("%t", ti.getNummer()).replaceAll("%d",String.valueOf(rz.getOptionFactory().getInt("tankliste.belegung.last.count"))));
    		 last = rz.getDatabase().getBuchungen().getTankLastBelegung(ti, rz.getOptionFactory().getInt("tankliste.belegung.last.count"));
    		 if(last.size() > 0) {
    			 for(int i = 0;i < last.size();i++) {
    				 TankLastBelegung t = last.get(i);
    				 if(ti.isMischung()) {
	    				 belegung += rz.getLocale().getString("tanklistenfenster.belegung_zeile_mischung") 
	    						 .replaceAll("%d",df.format(t.getDatum()))
	    						 .replaceAll("%b", t.getBezeichnung())  
	    						 .replaceAll("%n", getLink("m",0,t.getLosnummer())) +"<br>";
    				 } else {
	    				 belegung += rz.getLocale().getString("tanklistenfenster.belegung_zeile_tank") 
	    						 .replaceAll("%d",df.format(t.getDatum()))
	    						 .replaceAll("%b", getLink("r",t.getRezepturID(),t.getBezeichnung()))
	    						 .replaceAll("%l",rz.getLocale().formatNumber(t.getLiter(), OptionFactory.NF_ONE)) 
	    						 .replaceAll("%n", getLink("l",t.getRezepturID(),t.getLosnummer())) +"<br>";
	    			 }
    			 }
    		 }
    	 }
    	 txtLastBelegung.setText("<html><head></head><body><center><table>"+belegung.trim() +"</table></center></body></html>");
     }
     
     private String getLink(String prefix,int key,String in) {
    	 String ret = "<a href=\"" + prefix + ":" + String.valueOf(key) + ":" +in + "\">"+ in + "</a>";
    	 return ret;
     }
     
     private void listendruckAction(boolean vorschau) {
    	 if(lagerPanel.getTankListe() != null && !lagerPanel.getTankListe().isEmpty()) {
    		 rz.getReportFactory().tankBelegungsReport(lagerPanel.getTankListe(), vorschau, btListeAlle.isSelected(),chkLagerAnzeige.isSelected(), this,chkDuplex.isSelected());
    	 }
     }
     
     private void mischungNeuAction(tankItem ti) {
    	 if(ti != null) {
    		 rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_MISCHUNG_EINGABE_TANK,0,ti,this));
    	 }
     }
     
     private void auftragEingebenAction(tankItem ti) {
    	 if(ti != null){
	    	 double menge = 0;
	    	 int rezeptur = getRezeptur(ti);
	    	 String bezeichnung = "";
	    	 if(rezeptur != 0) {
	    		 try {
	    			 RezepturItem ri = rz.getDatabase().getRezeptur().dbGetRezeptur(rezeptur, true);
	    			 bezeichnung = ri.getTitel();
	    		 }catch(Exception e) {}
	    	 }
	    	 menge = ti.getLiter() - ti.getRestLiter();
	    	 AuftragsItem ai=new AuftragsItem(rz,rezeptur,bezeichnung,menge);
	    	 ai.setTank(ti.getNummer());
	    	 rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG, false, new MessageItem(MessageItem.MSG_EDIT_AUFTRAG,0,ai,this));
    	 }
     }
     
    private int getRezeptur(tankItem ti) {
    	if(rz.isZero(ti.getRestLiter())){
    		//in den rezepturen schauen
    		return rz.getDatabase().getRezeptur().getRezepturFromTank(ti.getNummer());
    	} else {
    		//in den buchungen schauen
    		return ti.getInhaltID();
    	}
    }
     
    private void tankSuchenAction() {
    	ArrayList<tankItem>liste = rz.getDatabase().getTank().getTankListeFromTankPattern(txtSucheTank.getText().trim());
   		anzeigenAction(liste);
    }

    
   private void losnummerSuchenAction() {
	   if(!txtSucheLosnummer.getText().trim().equals("")) {
		   String suche="";
		   String[] input = txtSucheLosnummer.getText().trim().split(" |,|;");
		   for(String in:input) {
			   String s = rz.getDatabase().getTank().getTankFromLosnummer(in.trim());
			   if(!s.equals("")) {
				   suche += s+ ",";
			   }
		   }
		   if(suche.endsWith(","))suche = suche.substring(0, suche.length()-1);
		   ArrayList<tankItem>liste = rz.getDatabase().getTank().getTankListeFromTankPattern(suche);
		   anzeigenAction(liste);
	   }
   }
   
   
  private void sorteSuchenAction() {
	  if(!txtSucheSorte.getText().trim().equals("")) {
		   String suche="";
		   String[] input = txtSucheSorte.getText().trim().split(" |,|;");
		   for(String in:input) {
			   String s = rz.getDatabase().getTank().getTankFromSorte(in.trim());
			   if(!s.equals("")) {
				   suche += s+ ",";
			   }
		   }
		   if(suche.endsWith(","))suche = suche.substring(0, suche.length()-1);
		   ArrayList<tankItem>liste = rz.getDatabase().getTank().getTankListeFromTankPattern(suche);
		   anzeigenAction(liste);
	   }
  }
    
    
    private void sucheRezepturAction() {
    	if(lstOrte.getSelectedIndex()!= -1) {
    		tanks=rz.getDatabase().getTank().getTanks(((ortItem)lstOrte.getSelectedValue()).getId());
    		if(tanks.size()>0) {
    			String suche = "";
    			for(tankItem ti:tanks) {
    				suche += ti.getInhaltsListe().getIDs() + ",";
    			}
				suche = suche.replaceAll(",+",",");
    			if(suche.endsWith(","))suche = suche.substring(0, suche.length()-1);
    			if(suche.startsWith(","))suche = suche.substring(1, suche.length());
    			if(!suche.equals("")) {
    				final AbfrageItem ai = new AbfrageItem();
    				ai.setID(0);
					ai.setAdressListe(new StichwortListe());
					ai.setStichwortListe(new StichwortListe());
					ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
					ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" + suche + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
					try {
						rz.setWaitCursor(this);
						JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
						frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this)); 
						rz.setFreeCursor(this);
					} catch (final Exception e) {}
    			}
    		}
    	}
    }
    @Override
	public void openWindow(){
        if(!isVisible()) {
			lagerPanel.setPaintLager(lagerAnzeige);
			lagerPanel.setPaintBemerkungen(bemerkungenAnzeige);
			setVisible(true);
		  	getGesamtKapazitaet();
		}
        toFront();
    }

    public double getGesamtKapazitaet() {
		double ret = 0;
		ortListe orte = rz.getDatabase().getTank().getAlleTanksUndOrte();
		for(ortItem oi:orte) {
			for( tankItem ti:oi.getTanks()) {
				ret += ti.getLiter();
			}
		}
		return ret;
	}
    @Override
	public void closeWindow(){
    	rz.getOptionFactory().setOption("tanklistenfenster.lager_anzeige", chkLagerAnzeige.isSelected()?1:0);
    	rz.getOptionFactory().setOption("tanklistenfenster.bemerkungen_anzeige", chkBemerkungenAnzeige.isSelected()?1:0);
    	rz.getOptionFactory().saveOptions();
    	saveDividerLocations();
    	if(lstOrte.getSelectedIndex()!= -1) {
    		try {
    			rz.getOptionFactory().setOption("tanklistenfenster.selected", ((ortItem)lstOrte.getSelectedValue()).getId());
    			rz.getOptionFactory().saveOptions();
    		}catch (Exception e) {}
    	}
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void tblTanksSelectionChanged() {
    	if(tblTanks.getSelectedRow() != -1) {
    		lagerPanel.tanklisteChanged(String.valueOf(tanks.get(tblTanks.getSelectedRow()).getId()));
    		lagerPanel.repaint();
    	}
    	setActions();
    }
    
    private void inhaltsAnzeige(int row,int column) {
    	if(tanks != null) {
			try {
				final AbfrageItem ai = new AbfrageItem();
				tankItem ti = tanks.get(row);
				if(ti.isMischung()) {
				    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNG,ti.getInhaltsListe().getMischungsNummer(),null,this));
				} else {
					if(!ti.getInhaltsListe().getIDs().equals("")) {
							ai.setID(0);
							ai.setAdressListe(new StichwortListe());
							ai.setStichwortListe(new StichwortListe());
							ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
							ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + "  rezeptliste.id in (" + ti.getInhaltsListe().getIDs() + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
						}
						try {
							rz.setWaitCursor(this);
							JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
							frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this));
							rz.setFreeCursor(this);
						} catch (final Exception e) {
						}
				}
			} catch(Exception e1) {}
    	}
    }
    
    private void anzeigenAction(ArrayList<tankItem> liste) {
    	tankItem ti = null; 
    	orte = rz.getDatabase().getTank().getOrte();
    	lstOrte.setListData(orte.toArray());
    	if(orte.size()>0) {
			lstOrte.setSelectedIndex(0);
    		if(liste != null && liste.size()>0) {
    			for(tankItem item:liste) {
    				if(item != null && item.getId()!= 0 && rz.getDatabase().getTank().tankExists(item)) {
    					ti=item;
    					break;
    				}
    			}
    			if(ti != null) {
   				for(int i = 0; i< orte.size();i++) {
    					ortItem oi = orte.get(i);
    					if(oi.getId()==ti.getOrt()) {
    						lagerPanel.setOrt(oi);
    						lstOrte.setSelectedIndex(i);
    						lagerPanel.tanklisteChanged(liste);
    						break;
    					}
    				}
    			}
    		} 
    	}
    	if(lstOrte.getSelectedIndex()!=-1) {
            lagerPanel.setOrt((ortItem)lstOrte.getSelectedValue());
            tanks = lagerPanel.getTankListe();
            ((AbstractTableModel)tblTanks.getModel()).fireTableDataChanged();
            lagerPanel.repaint();
    	}
    	rz.getDatabase().getTank().selectOrte(orte, liste);
    }

    
    private void togglePlaceMode() {
    	if(placeMode) {
    		placeMode = false;
    		setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    	} else {
    		placeMode = true;
    		setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
    	}
    }
    
    /**
     * Actions enable/disable
     *
     */
    private void setActions() {
    	getAction(ACTION_NEU_ORT_CODE).setEnabled(true);
    	getAction(ACTION_REFRESH_ORT_CODE).setEnabled(true);
    	getAction(ACTION_DELETE_ORT_CODE).setEnabled(false);
    	getAction(ACTION_EDIT_ORT_CODE).setEnabled(false);
    	getAction(ACTION_NEU_TANK_CODE).setEnabled(false);
    	getAction(ACTION_REFRESH_TANK_CODE).setEnabled(false);
    	getAction(ACTION_DELETE_TANK_CODE).setEnabled(false);
    	getAction(ACTION_EDIT_TANK_CODE).setEnabled(false);
    	getAction(ACTION_PLACE_CODE).setEnabled(false);
    	getAction(ACTION_SUCHE_REZEPTUR_CODE).setEnabled(false);
    	getAction(ACTION_AUFTRAG_CODE).setEnabled(false);
    	getAction(ACTION_MISCHUNG_NEU_CODE).setEnabled(false);
    	getAction(ACTION_CHART_CODE).setEnabled(false);
    	
    	if(tblTanks.getSelectedRow() != -1) {
    		tankItem ti = tanks.get(tblTanks.getSelectedRow());
    		if(ti != null) {
    			if(!ti.isMischung()) {
    	        	getAction(ACTION_AUFTRAG_CODE).setEnabled(true);
    	        	if(ti.isEmpty()) {
    	        		getAction(ACTION_MISCHUNG_NEU_CODE).setEnabled(true);
    	        	}
    			}else {
    		    	getAction(ACTION_CHART_CODE).setEnabled(true);
    			}
    		}
    	}
    	if(lstOrte.getSelectedIndex()!= -1) {
    		ortItem oi =(ortItem)lstOrte.getSelectedValue();
    		if(rz.getDatabase().getTank().ortIsDeleteable(oi)) {
    			getAction(ACTION_DELETE_ORT_CODE).setEnabled(true);
    		}
        	getAction(ACTION_EDIT_ORT_CODE).setEnabled(true);
        	getAction(ACTION_NEU_TANK_CODE).setEnabled(true);
        	getAction(ACTION_REFRESH_TANK_CODE).setEnabled(true);
        	getAction(ACTION_SUCHE_REZEPTUR_CODE).setEnabled(true);
        	if(tblTanks.getSelectedRow() != -1) {
        		getAction(ACTION_DELETE_TANK_CODE).setEnabled(true);
        		getAction(ACTION_EDIT_TANK_CODE).setEnabled(true);
            	getAction(ACTION_PLACE_CODE).setEnabled(true);
            	getAction(ACTION_SUCHE_REZEPTUR_CODE).setEnabled(true);
        	}
    	}
    }

    private void lagerPanelMouseClicked(MouseEvent evt) {
    	if(placeMode) {
    		tankItem ti = tanks.get(tblTanks.getSelectedRow());
    		if(ti != null) {
    			double scaleX;

    			//scaleX = (double)(lagerPanel.getWidth())/1000.0;
    			scaleX = ((double)(lagerPanel.getWidth())/1000.0) * (lagerPanel.getZoom()/100);
    			double rad = (double)(ti.getPr()/2) * scaleX;
    			ti.setPx((int)((double)((evt.getX()-rad)  / (scaleX))));
    			ti.setPy((int)((double)((evt.getY()-rad)  / (scaleX))));
    			rz.getDatabase().getTank().saveTank(ti);
    			int sel = tblTanks.getSelectedRow();
                ((AbstractTableModel)tblTanks.getModel()).fireTableDataChanged();
    			if(lstOrte.getSelectedIndex() != -1) {
    				lagerPanel.setOrt((ortItem)lstOrte.getSelectedValue());
    				lagerPanel.repaint();
    			}
    			togglePlaceMode();
    			tblTanks.getSelectionModel().setSelectionInterval(sel,sel);
    	        tblTanks.scrollRectToVisible(tblTanks.getCellRect(sel, 0,true));
    		}
    	} else 
    	{
	    	if(tanks!= null && !tanks.isEmpty()) {
	    		tankItem ti = lagerPanel.getTankAt(evt.getPoint(),true,false);
	    		if(ti != null) {
	    			lagerPanel.tanklisteChanged(String.valueOf(ti.getId()));
	    			lagerPanel.repaint();
	    			if(ti.getId() != 0) {
	                	for(int i=0;i<tanks.size();i++) {
	                		if(tanks.get(i).getId() == ti.getId()) {
	    	        			tblTanks.getSelectionModel().setSelectionInterval(i,i);
	    	        	        tblTanks.scrollRectToVisible(tblTanks.getCellRect(i, 0,true));
	    	        	        setActions();
	                			break;
	                		}
	                	}
	                }
	    		}
	    	}
    	}
    }
    
    private void refreshTanklisteAction(int id) {
    	if(lstOrte.getSelectedIndex()!= -1) {
            lagerPanel.setOrt((ortItem)lstOrte.getSelectedValue());
            tanks = lagerPanel.getTankListe();
            ((AbstractTableModel)tblTanks.getModel()).fireTableDataChanged();
            lagerPanel.repaint();
            if(id != 0) {
            	for(int i=0;i<tanks.size();i++) {
            		if(tanks.get(i).getId() == id) {
	        			tblTanks.getSelectionModel().setSelectionInterval(i,i);
	        	        tblTanks.scrollRectToVisible(tblTanks.getCellRect(i, 0,true));
            			break;
            		}
            	}
            }
            setActions();
    	}
    }

    private void printPlanAction() {
    	 final PrinterJob job = PrinterJob.getPrinterJob();
         job.setPrintable(this);
         final PageFormat pf=new PageFormat();
         pf.setOrientation(PageFormat.LANDSCAPE);
         if(job.printDialog()){
         try{
             job.print();
             }
         catch(final PrinterException pe){
                 rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "Tanklistenfenster.druckenAction:" ,  pe.getLocalizedMessage());
             }
         }
    }
    
    /**
     * Liste neu einlesen
     */
    private void refreshAction(int id) {

    	orte = rz.getDatabase().getTank().getOrte();
    	lstOrte.setListData(orte.toArray());
    	if(orte.size()>0) {
    		if(id != 0) {
    			for(int i=0;i <lstOrte.getModel().getSize();i++) {
    				if(((ortItem)lstOrte.getModel().getElementAt(i)).getId()==id) {
    					lstOrte.setSelectedIndex(i);
    					break;
    				}
    			}
    		} else {
    			lstOrte.setSelectedIndex(0);
    		}
    	}
    	if(lstOrte.getSelectedIndex()!=-1) {
            tanks = lagerPanel.getTankListe();
            ((AbstractTableModel)tblTanks.getModel()).fireTableDataChanged();
        	lagerPanel.setPaintLager(chkLagerAnzeige.isSelected());
            lagerPanel.repaint();
    	}
    	setActions();
    }

    private void deleteOrtAction() {
    	if(lstOrte.getSelectedIndex() != -1) {
    		ortItem ort = (ortItem)lstOrte.getSelectedValue();
    		if(ort != null) {
    			if(rz.getDatabase().getTank().ortIsDeleteable(ort)) {
	                final DialogItem di = new DialogItem(
	                        DialogControl.FRAGE_DIALOG,
	                        "",
	                        0.0,
	                        rz.getLocale().getString("ort.question_delete"),
	                        rz.getLocale().getString("ort.question_delete"),
	                        rz.getLocale().getString("ort.question_delete_1").replaceAll("%s",ort.getBezeichnung()),
	                        "frage.png",
	                        rz.getLocale().getString("string_ja"),
	                        rz.getLocale().getString("string_nein"),
	                        this
	                );
	                rz.getDialogFactory().getDialog(di);
	
	                if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	                	rz.getDatabase().getTank().deleteOrt(ort);
	                	refreshAction(0);
	                }
    			}
    		}
    	}
    }
    
    private void deleteTankAction() {
    	if(tblTanks.getSelectedRow() != -1) {
    		tankItem ti = tanks.get(tblTanks.getSelectedRow());
    		if(ti != null) {
                final DialogItem di = new DialogItem(
                        DialogControl.FRAGE_DIALOG,
                        "",
                        0.0,
                        rz.getLocale().getString("tank.question_delete"),
                        rz.getLocale().getString("tank.question_delete"),
                        rz.getLocale().getString("tank.question_delete_1").replaceAll("%s",ti.getNummer()),
                        "frage.png",
                        rz.getLocale().getString("string_ja"),
                        rz.getLocale().getString("string_nein"),
                        this
                );
                rz.getDialogFactory().getDialog(di);

                if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
                	rz.getDatabase().getTank().deleteTank(ti);
                	refreshTanklisteAction(0);
                }
    		}
    	}
    }
    
    private void neuTankAction() {
    	ortItem ort = null;
    	if(orte.size() > 0) {
    		ort = (ortItem)lstOrte.getSelectedValue();
    		if(ort != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKEINGABE,true,new MessageItem(MessageItem.MSG_SHOW_TANKEINGABE,ort.getId(),null,this));
    		}
    	}
    }
    
    private void editTankAction() {
    	if(tblTanks.getSelectedRow() != -1) {
    		tankItem ti = tanks.get(tblTanks.getSelectedRow());
    		if(ti != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKEINGABE,true,new MessageItem(MessageItem.MSG_SHOW_TANKEINGABE,0,ti,this));
    		}
    	}
    }
    
    
    
    private void neuOrtAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ORTEINGABE,true,new MessageItem(MessageItem.MSG_SHOW_ORTEINGABE,0,null,this));
    }
    
    private void editOrtAction() {
    	if(orte.size()>0) {
    		ortItem oi = (ortItem)lstOrte.getSelectedValue();
    		if(oi != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ORTEINGABE,true,new MessageItem(MessageItem.MSG_SHOW_ORTEINGABE,oi.getId(),oi,this));
    		}
    	}
    }
    
    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"tankliste.html",this));
    }

    
    private void settblTanksModel(final JTable t) {
	    final tanksColumnModel rcm = new tanksColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final NumericRenderer nr = new NumericRenderer(); 
	    TableColumn tc;
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("tanklistenfenster.tableheader_nummer"));
			tc.setModelIndex(C_NUMMER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
		
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("tanklistenfenster.tableheader_inhalt"));
			tc.setModelIndex(C_INHALT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);

	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("tanklistenfenster.tableheader_restliter"));
			tc.setModelIndex(C_RESTLITER);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
		
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("tanklistenfenster.tableheader_lager"));
			tc.setModelIndex(C_LAGER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
		
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("tanklistenfenster.tableheader_liter"));
	    	tc.setModelIndex(C_LITER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("tanklistenfenster.tableheader_comment"));
			tc.setModelIndex(C_COMMENT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("tanklistenfenster.tableheader_px"));
			tc.setModelIndex(C_PX);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("tanklistenfenster.tableheader_py"));
			tc.setModelIndex(C_PY);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("tanklistenfenster.tableheader_pr"));
			tc.setModelIndex(C_PR);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);

	    
        rcm.addColumnModelListener(this);
        t.setModel(new auftragslisteTableModel());
        t.setColumnModel(rcm);
        t.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        t.getTableHeader().setReorderingAllowed(false);
        t.setFont(rz.getFontFactory().getAuftragsTableFont());
        rz.setPreferredRowHeights(t);
        TableModelListener l = new TableModelListener() {
			public void tableChanged(TableModelEvent e) {
		         SwingUtilities.invokeLater(new Runnable() {
		              public void run() {
		                  rz.setPreferredRowHeights(t);
		              }
		         });
			}
	     }; 
		 t.getModel().addTableModelListener(l);
	}
    
	private class tanksColumnModel extends DefaultTableColumnModel{
	    public tanksColumnModel() {
	        super();
	    }
	}
	
	
	private  class auftragslisteTableModel extends AbstractTableModel    {

    	
        SimpleDateFormat df;
        
        public auftragslisteTableModel() {
        	super();
        }

	   public int getColumnCount() {
	       	return  MAX_COLUMN;
        }
        public int getRowCount() {
        	if(tanks != null) {
                return tanks.size();
        	} else {
        		return 0;
        	}
        }

        public tankItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (tanks != null)) {
        		return tanks.get(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (tanks != null)) {
                ret = getContent(tanks.get(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        public boolean isCellEditable(int row, int col){
        	boolean ret = false;
	        	switch(col) {
	        		case C_PX:
	        		case C_PY:
	        		case C_PR: ret=true;
	        			break;
	        		default: break;
    		}
        	return ret;
        }

        public void setValueAt(Object value, int row, int col) {
        	if(tanks != null && ! tanks.isEmpty()) {
        		final tankItem ti = tanks.get(row);
        		if (ti != null) {
        			switch(col ) {
        				case C_PX:ti.setPx(Integer.parseInt((String)value));
        					break;
        				case C_PY:ti.setPy(Integer.parseInt((String)value));
    						break;
        				case C_PR:ti.setPr(Integer.parseInt((String)value));
    						break;
        			}
        			rz.getDatabase().getTank().saveTank(ti);
        			if(lstOrte.getSelectedIndex() != -1) {
        				lagerPanel.setOrt((ortItem)lstOrte.getSelectedValue());
        				lagerPanel.repaint();
        			}
        			lagerPanel.tanklisteChanged(String.valueOf(ti.getId()));
        			lagerPanel.repaint();
        			
	        	}
        	}
        }
        
        private Object getContent(tankItem ti,int aColumn,int row) {
            Object ret = null;
            if(ti != null) {
	            switch(aColumn){
	            	 case C_NUMMER:
	            		 	ret=ti.getNummer();
	            			break;
	            	 case C_COMMENT:
	            		 	ret = ti.getComment();
	            	     	break;
	            	 case C_LITER:
	            		 	if(ti.isStellplatz()) {
	            		 		ret = rz.getLocale().getString("tanklistenfenster.table_stellplatz");
	            		 	}else if (ti.isMischung()){
	            		 		
	            		 	} else {
	            		 		ret  = rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE);
	            		 	}
		            	 	break;
	            	 case C_PX:
	            		 	ret = ti.getPx();
	            	     	break;
	            	 case C_PY:
	            		 	ret = ti.getPy();
	            	     	break;
	            	 case C_PR:
	            		 	ret = ti.getPr();
	            	     	break;
	            	 case C_INHALT:
	            		 if(ti.isStellplatz()) {
	            			 ret = ti.getInhaltsListe().getInhaltBezeichnung().trim().equals("")?"":"<html><font color=\"blue\">" + ti.getInhaltsListe().getInhaltBezeichnung().replaceAll("\\n", "<br>") + "</font> </html>";
	            		 } else  if(ti.isMischung()){
	            			 ret = ti.getInhaltsListe().getInhaltBezeichnung().trim().equals("")?"":"<html><font color=\"green\">" + ti.getInhaltsListe().getInhaltBezeichnung().replaceAll("\\n", "<br>") + "</font></html>";
	            		 } else {
	            			 ret = ti.getInhaltsListe().getInhaltBezeichnung().trim().equals("")?"":"<html><font color=\"blue\">" + ti.getInhaltsListe().getInhaltBezeichnung().replaceAll("\\n", "<br>") + "</font> (" + ti.getPercentFull()+" %)</html>";
	            		 }
	            		 break;
	            	 case C_LAGER:
	            		 if(ti.isStellplatz()) {
	            			 ret = ti.getInhaltsListe().getInhaltBezeichnung().trim().equals("")?"":"<html>" + ti.getInhaltsListe().getInhaltLager()+ "</html>";
	            		 } else  if(ti.isMischung()){
	            			 ret = ti.getInhaltsListe().getInhaltBezeichnung().trim().equals("")?"":"<html>" + ti.getInhaltsListe().getInhaltLager()+ "</html>";
	            		 } else {
	            			 ret = ti.getInhaltsListe().getInhaltBezeichnung().trim().equals("")?"":"<html>" + ti.getInhaltsListe().getInhaltLager()+ "</html>";
	            		 }
	            		 break;
	            	 case C_RESTLITER:
	            		 if(ti.isMischung()) {
            				 ret  = rz.getLocale().formatNumber(ti.getRestKg(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");
	            		 } else {
		            		 if(!ti.getInhaltsListe().isEmpty()) {
			            		 if(ti.isStellplatz()) {
			            			 ret  = rz.getLocale().formatNumber(ti.getRestLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter")+" (" +rz.getLocale().formatNumber(ti.getRestKg(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_kg") +")" ;
			            		 } else {
		            				 ret  = rz.getLocale().formatNumber(ti.getRestLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter");
			            		 }
		            		 } else {
		            			 ret = "";
		            		 }
	            		 }
         		 		break;
	            }
            }
            return ret;
        }
	}

	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(null);
	    	setFont(rz.getFontFactory().getAuftragsTableFont());
	    	if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
	    	if(value != null) {
	    		setText(value.toString());
	    	}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
	
	
	private class StringRenderer extends DefaultTableCellRenderer {
		
		Icon statusIcon;
		
	    StringRenderer() {
	        super();
	        setOpaque(true);
	    	statusIcon = new  javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/tanklagerpanel.icon_mischung.png"));	
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(null);
	    	tankItem ti = tanks.get(row);
	    	if(ti != null) {
	    		if(ti.isMischung() && (column == C_NUMMER || column == C_INHALT)) {
	    			setIcon(statusIcon);
	    		}
	    	}
	    	setFont(rz.getFontFactory().getAuftragsTableFont());
	    	if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
    		setText((String)value);
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
    
	public void columnAdded(TableColumnModelEvent e) {
	}
	public void columnRemoved(TableColumnModelEvent e) {
	}
	public void columnMoved(TableColumnModelEvent e) {
	}
	public void columnMarginChanged(ChangeEvent e) {
	}
	public void columnSelectionChanged(ListSelectionEvent e) {
	}

	
	public int print (java.awt.Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
		if(pageIndex != 0){
            return Printable.NO_SUCH_PAGE;
        }
        else {
            final Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(),
                          pageFormat.getImageableY());
            final int cw = lagerPanel.getWidth();
            final int ch = lagerPanel.getHeight();
            final double pw = pageFormat.getImageableWidth();
            final double ph = pageFormat.getImageableHeight();
            if ((cw > pw) || (ch > ph)) {
                final double scaleX = pw / cw;
                final double scaleY = ph / ch;
                final double scale = scaleX < scaleY ? scaleX : scaleY;
                g2d.scale(scale, scale);
            }
        lagerPanel.printAll(g2d);
        return Printable.PAGE_EXISTS;
        }
	}

	
}
