package de.lunqual.rzpro.fenster.tankfenster;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.swing.ImageIcon;
import javax.swing.JPanel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.auftrag.Auftragsliste;
import de.lunqual.rzpro.items.tank.ortItem;
import de.lunqual.rzpro.items.tank.ortListe;
import de.lunqual.rzpro.items.tank.tankInhaltsItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.items.tank.tankLagerItem;
import de.lunqual.rzpro.options.OptionFactory;

public class TanklagerPanel  extends JPanel {

	RzPro										rz;
	Color										background;
	Color										linie;
	Color										tank;
	Color										tank_selected;
	Color										text;
	Color										empty;
	Color										fill;
	Color										fastLeer;
	Color										meldeBestand;
	Color										mischung_leer;
	Color										mischung_voll;
	double										width;
	double										height;
	double										factor;
	Font										panelFont;
	ArrayList<Integer>							selected;
	ortItem										oi;
	ArrayList<tankItem>							tanks;
    AffineTransform 							atOriginal;
    ImageIcon									auftragsIcon;
    ImageIcon									anfrageIcon;
    ImageIcon									mischungsIcon;
    ortListe									orteListe;
    boolean										paintLager = false;
    boolean										paintBemerkungen = false;
	
	public static final int						SCALE_WIDTH = 1000;
	public static final int						SCALE_HEIGHT= 1000;
	private static final int					FASTLEER=5;
	public static final int						DEFAULT_SCALING=100;
	
	int											offsetX = 0;
	int											offsetY = 0;
	double										scaling = DEFAULT_SCALING;
	SimpleDateFormat						df;
	
	public TanklagerPanel(RzPro rz){
		super();
		this.rz=rz;
		init();
	}

	/*
	 * ein PAnel. dass nur die Auswahl anzeigen soll
	 * ohne Updatemöglichkeit
	 */
	public TanklagerPanel(RzPro rz,boolean auswahl) {
		super();
		this.rz = rz;
		init();
		orteListe = rz.getDatabase().getTank().getAlleTanksUndOrte();
	}
	
	private void init() {
		df = new SimpleDateFormat("EEEE, dd. MMMM yyyy H:mm");
		background = Color.WHITE;
		linie = Color.BLACK;
		tank = Color.WHITE;
		tank_selected = Color.CYAN;
		text = Color.BLACK;
		empty = new Color(255,200,200);
		fill = new Color(200,255,200);
		fastLeer = rz.getOptionFactory().getRGBColor("tanklagerpanel.color_fastleer");
		meldeBestand = new Color(255,255,200);
		mischung_leer = new Color(255,168,0);
		mischung_voll = new Color(200,255,200);
		selected = new ArrayList<Integer>();
		auftragsIcon = new  javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auftrag.png"));
		anfrageIcon = new  javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/anfrage.png"));
		mischungsIcon = new  javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/tanklagerpanel.icon_mischung.png"));
		this.setToolTipText("");
		orteListe = new ortListe(rz);
		setZoom(rz.getOptionFactory().getOption("tanklager.zoom",OptionFactory.DEFAULT_TANKLAGER_ZOOM));
		   if(rz.getDatabase().getProperties().getProperty("tanklager.mode.fix").getP_value().equals("1")) {
				this.setPreferredSize(new Dimension(rz.getOptionFactory().getOption("tanklager.preferred.width", OptionFactory.TANKLAGER_PREFERRED_WIDTH),rz.getOptionFactory().getOption("tanklager.preferred.height", OptionFactory.TANKLAGER_PREFERRED_HEIGHT)));   
		   }
	
	}
	
	public void setZoom(int zoom) {
		scaling = zoom;
	}
	public double getZoom() {
		return scaling;
	}
	
	public void setPaintBemerkungen(boolean b) {
		paintBemerkungen = b;
	}
	
	public void setPaintLager(boolean b) {
		paintLager = b;
		orteListe = rz.getDatabase().getTank().getAlleTanksUndOrte();
		setOrtID(oi);
	}
	
	public ArrayList<tankItem> getTankListe(){
		return tanks;
	}
	
	public ortListe getOrtListe() {
		return orteListe;
	}
	
	public void setOrtID(ortItem oi) {
		try {
			this.oi = orteListe.getOrt(oi.getId());
			this.tanks = this.oi.getTanks();
		}catch(Exception e) {}
	}
	
	public void setOrt(ortItem oi) {
		this.oi = oi;
		this.tanks = rz.getDatabase().getTank().getTanks(oi.getId());
	}
	
	public void tanklisteChanged(ArrayList<tankItem> liste) {
		selected.clear();
		for(tankItem item:liste) {
			try {
				selected.add(item.getId());
			}catch (Exception e) {}
		}
	}
	
	public void tanklisteChanged(String in) {
		selected.clear();
		String input[] = in.split("\\s|,|;|:|-");
		for(String item:input) {
			try {
				selected.add(Integer.parseInt(item));
			}catch (Exception e) {}
		}
	}
	
	private boolean isSelected(int id) {
		for(Integer item:selected) {
			if(item == id) {
				return true;
			}
		}
		return false;
	}
	
	private void getValues() {
		width = this.getWidth();
		height = this.getHeight();
		factor = width / (SCALE_WIDTH*1/(scaling/100));
	}
	
	public tankItem getTankAt(Point pt,boolean markup,boolean selectMischung) {
		tankItem ret = null;
		getValues();
		for(tankItem ti:tanks) {
			float rechts =(ti.getPx() * (float)factor) + offsetX;
			float oben = (ti.getPy() * (float)factor) + offsetY;
			float rad = ti.getPr() * (float)factor;
			if(pt.getX() >= rechts && pt.getX() <=( rechts + rad) && pt.getY() >=oben && pt.getY() <= (oben + rad)) {
				ret = ti;
				break;
			}
		}
		if(markup) {
			return ret;
		} else {
			if(selectMischung) {
				return (ret.isMischung() || (!ret.isMischung() && rz.isZero(ret.getRestLiter())))?ret:null;
			}else {
				return ret.isMischung()?null:ret;
			}
		}
	}
	
	public double getKapazitaet() {
		double ret = 0;
		for(tankItem ti:tanks) {
			ret += ti.getLiter();
		}
		return ret;
	}
	
	
	public void paint(Graphics g) {
		super.paint(g);
		getValues();
		g.setColor(background);
		panelFont = new Font("arial",Font.PLAIN,12);
		g.setFont(panelFont);
		g.fillRect(0,0,this.getWidth(),this.getHeight());
		paintLines(g);
		paintTanks(g);
	}
	
	private void paintLines(Graphics g) {
		String[] start;
		String[] ziel;
		Graphics2D ga = (Graphics2D)g;
		ga.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		atOriginal= ga.getTransform();
		if(oi != null) {
			g.setColor(linie);
			ga.setStroke(new BasicStroke(1));
			Font f = new Font("arial",Font.BOLD,14);
			g.setFont(f);
			String[] shape = oi.getShape().split(":|\\n");
				for(String line:shape) {
					try 	{
						line = line.trim();
						if(line.length()>0) {
							String[] group = line.split("-");
							String befehl=group[0].trim();
							if(befehl.equals("fs")) {
								int size = (int)(Integer.parseInt(group[1]));
								f = new Font("arial",Font.BOLD,size);
								ga.setFont(f);
							} else if(befehl.equals("l")) {
								start = group[1].split(",");
								ziel = group[2].split(",");
								int s1 = (int)(Integer.parseInt(start[0]) * factor) + offsetX;
								int s2 = (int)(Integer.parseInt(start[1]) * factor) + offsetY;
								int s3 = (int)(Integer.parseInt(ziel[0]) * factor) + offsetX;
								int s4 = (int)(Integer.parseInt(ziel[1]) * factor) + offsetY;
								ga.drawLine(s1, s2, s3, s4);
							}else if(befehl.equals("t")) {
								start = group[1].split(",");
								int s1 = (int)(Integer.parseInt(start[0]) * factor) + offsetX;
								int s2 = (int)(Integer.parseInt(start[1]) * factor) + offsetY;
								String str = group[2].replaceAll("%d",df.format(new Date())).replaceAll("%k", rz.getLocale().formatNumber(getKapazitaet(), OptionFactory.NF_ONE));
								ga.drawString(str,s1,s2);
							}else if(befehl.equals("#")) {
							}else if(befehl.equals("s")) {
								int s1 = (int)(Integer.parseInt(group[1]));
								ga.setStroke(new BasicStroke(s1));
							}else if(befehl.equals("f")) {
								Color c = rz.getOptionFactory().getRGBColorString(group[1]);
								if (c != null) {
									g.setColor(c);
								}
							}else if(befehl.equals("r")) {
								start = group[1].split(",");
								ziel = group[2].split(",");
								int s1 = (int)(Integer.parseInt(start[0]) * factor) + offsetX;
								int s2 = (int)(Integer.parseInt(start[1]) * factor) + offsetY;
								int s3 = (int)(Integer.parseInt(ziel[0]) * factor);
								int s4 = (int)(Integer.parseInt(ziel[1]) * factor);
								ga.drawRect(s1, s2, s3, s4);
							}else if(befehl.equals("R")) {
								start = group[1].split(",");
								ziel = group[2].split(",");
								int s1 = (int)(Integer.parseInt(start[0]) * factor) + offsetX;
								int s2 = (int)(Integer.parseInt(start[1]) * factor) + offsetY;
								int s3 = (int)(Integer.parseInt(ziel[0]) * factor);
								int s4 = (int)(Integer.parseInt(ziel[1]) * factor);
								ga.fillRect(s1, s2, s3, s4);
							} else if(befehl.equals("d")) {
								int winkel = (int)(Integer.parseInt(group[1]));
								AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(winkel));
								ga.setFont((ga.getFont()).deriveFont(at));
								start = group[1].split(",");
								ziel = group[2].split(",");
								int s1 = (int)(Integer.parseInt(start[0]) * factor) + offsetX;
								int s2 = (int)(Integer.parseInt(start[1]) * factor) + offsetY;
								int s3 = (int)(Integer.parseInt(ziel[0]) * factor);
								int s4 = (int)(Integer.parseInt(ziel[1]) * factor);
								Shape circle = new Ellipse2D.Float(s1,s2,s3,s4);
								ga.draw(circle);
							}else if(befehl.equals("c")) {
								start = group[1].split(",");
								ziel = group[2].split(",");
								int s1 = (int)(Integer.parseInt(start[0]) * factor) + offsetX;
								int s2 = (int)(Integer.parseInt(start[1]) * factor) + offsetY;
								int s3 = (int)(Integer.parseInt(ziel[0]) * factor);
								int s4 = (int)(Integer.parseInt(ziel[1]) * factor);
								Shape circle = new Ellipse2D.Float(s1,s2,s3,s4);
								ga.draw(circle);
							} 	else if(befehl.equals("C")) {
								start = group[1].split(",");
								ziel = group[2].split(",");
								int s1 = (int)(Integer.parseInt(start[0]) * factor) + offsetX;
								int s2 = (int)(Integer.parseInt(start[1]) * factor) + offsetY;
								int s3 = (int)(Integer.parseInt(ziel[0]) * factor);
								int s4 = (int)(Integer.parseInt(ziel[1]) * factor);
								Shape circle = new Ellipse2D.Float(s1,s2,s3,s4);
								ga.fill(circle);
							}else if(befehl.equals("U")) {
								start = group[1].split(",");
								int s1 = (int)(Integer.parseInt(start[0]) * factor);
								int s2 = (int)(Integer.parseInt(start[1]) * factor);
								offsetX = (int)(s1);
								offsetY = (int)(s2);
							}else if(befehl.equals("p") || befehl.equals("P")) {
								String values[] = line.split("-");
								if(values.length>1) {
									Polygon p = new Polygon();
									for(int i = 1;i < values.length;i++) {
										try {
											String v[] = values[i].split(",");
											if(v.length == 2) {
												p.addPoint(  (int)(offsetX + Integer.parseInt(v[0]) * factor),(int)(offsetY+Integer.parseInt(v[1])*factor));
											}
										}catch(Exception e) {}
									}
									if(befehl.equals("p")) {
										ga.drawPolygon(p);
									} else {
										ga.fillPolygon(p);
									}
								}
							}else if(befehl.equals("rp") || befehl.equals("RP")) {
								String values[] = line.substring(3).split("/");
								if(values.length>1) {
									Polygon p = new Polygon();
									int lastX = -10000;
									int lastY = -10000;
									for(int i = 0;i < values.length;i++) {
										try {
											String v[] = values[i].split(",");
											if(v.length == 2) {
												if(lastX == -10000 && lastY == -10000) {
													// erster Punkt
													lastX = (int)(offsetX + Integer.parseInt(v[0]) * factor);
													lastY = (int)(offsetY + Integer.parseInt(v[1]) * factor);
													p.addPoint(lastX ,lastY);
												} else {
													lastX += (int)(offsetX + Integer.parseInt(v[0]) * factor);
													lastY += (int)(offsetY + Integer.parseInt(v[1]) * factor);
													p.addPoint(lastX ,lastY);
												}
											}
										}catch(Exception e) {}
									}
									if(befehl.equals("rp")) {
										ga.drawPolygon(p);
									} else {
										ga.fillPolygon(p);
									}
								}
							}else if(befehl.equals("i")) {
								start = group[1].split(",");
								if(start.length == 3) {
									int s1 = (int)(Integer.parseInt(start[0]) * factor) + offsetX;
									int s2 = (int)(Integer.parseInt(start[1]) * factor) + offsetY;
									int width = (int)(Integer.parseInt(start[2]) * factor);
									ga.drawImage(rz.getDatabase().getIcons().getIcon(group[2],width).getImage(),s1,s2,this);
								}
							} else if (befehl.equals("sc")) {
								//scaling = (double)(Double.parseDouble(group[1]));
								scaling = Integer.parseInt(group[1]);
								if (scaling < 10 || scaling > 200) {
									scaling = DEFAULT_SCALING;
								}
								getValues();
							} 
						}
					} catch(final Exception e) {
				}
			}
		}
		if(atOriginal != null) {
			ga.setTransform(atOriginal);
		}
	}
	
	private void paintTanks(Graphics g) {
		Graphics2D ga = (Graphics2D)g;
		ga.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		ga.setStroke(new BasicStroke(1));
		Font f = new Font("arial",Font.PLAIN,12);
		ga.setFont(f);
		g.setColor(linie);

		if(tanks !=null && !tanks.isEmpty()) {
			for(tankItem ti:tanks) {
				if(ti.getPx() != 0 && ti.getPy() != 0) {
					if(ti.isStellplatz()) {
						paintStellplatz(ti,g);
					}else  if(ti.isMischung()){
						paintMischung(ti,g);
					}else {
						paintCircle(ti,g);
					}
				}
			}
		}
	}
	
	private void drawPercent(tankItem ti,Shape circle_inner,Graphics g,float rechts,float oben,float rad,Color fillcolor) {
		double start = 90;
		double extend = -(ti.getPercentFull()*360)/100;
		Area pie =new Area((Shape) new Arc2D.Double(rechts, oben, rad, rad, start, extend, Arc2D.PIE));
		g.setColor(background);
	    ((Graphics2D) g).fill(circle_inner);
	    g.setColor(fillcolor);
        ((Graphics2D) g).fill(pie);
        g.setColor(linie);
        ((Graphics2D) g).draw(pie);
	}
	
	private void paintMischung(tankItem ti,Graphics g) {
		Graphics2D ga = (Graphics2D)g;
		float rechts =((ti.getPx() * (float)factor))+offsetX;
		float oben = ((ti.getPy() * (float)factor))+offsetY;
		float rad = ti.getPr() * (float)factor;
		Shape circle = new Ellipse2D.Float(rechts,oben,rad,rad);
		Shape circle_inner = new Ellipse2D.Float(rechts+2,oben+2,rad-4,rad-4);
		ga.setColor(linie);
		ga.draw(circle);
		if(rz.isZero(ti.getRestLiter())) {
			if(isSelected(ti.getId())) {
				ga.setColor(tank_selected);
			}else {
				ga.setColor(mischung_leer);
			}
		}	else {
			ga.setColor(mischung_voll);
		}
		ga.fill(circle_inner);
		ga.setColor(linie);
		//nummer
		Rectangle2D r = g.getFontMetrics().getStringBounds(ti.getNummer(),g);
		float x = rechts + rad/2 - (float)(r.getWidth()/2) + 4;
		float y = oben + rad/2 -  (float)(r.getHeight());
		ga.drawString(ti.getNummer(), x,y);
		ga.drawImage(mischungsIcon.getImage() ,(int)(rechts),(int)(oben +rad/2 - mischungsIcon.getIconHeight()/2),this);
		String liter = rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE) + rz.getLocale().getString("string_liter");
		r = g.getFontMetrics().getStringBounds(liter,g);
		x = rechts + rad/2 - (float)(r.getWidth()/2);
		y = oben +rad/2 + (float)(r.getHeight() + 2);
		ga.drawString(liter, x,y);
		paintBemerkungen(g,ti,rechts,oben,rad);
		paintLagerMischung(g,ti,rechts,oben+(rad/6),rad);
	}
	
	private void paintStellplatz(tankItem ti,Graphics g) {
		Graphics2D ga = (Graphics2D)g;
		int rechts =(int)(( ti.getPx() * (float)factor)) + offsetX;
		int oben = (int)((ti.getPy() * (float)factor)) + offsetY;
		int rad = (int)(ti.getPr()  * (float)factor);
		if(isSelected(ti.getId())) {
			ga.setColor(tank_selected);
		} else {
			if(ti.isMischung()) {
				ga.setColor(mischung_leer);
			} else {
				if(rz.isZero(ti.getRestLiter())){
					ga.setColor(empty);
				} else {
					ga.setColor(fill);
				}
			}
		}
		ga.fillRoundRect(rechts, oben, rad, rad,10,10);
		paintLager(g,ti,rechts,oben,rad);
		ga.setColor(linie);
		ga.drawRoundRect(rechts, oben, rad, rad,10,10);
		Rectangle2D r = g.getFontMetrics().getStringBounds(ti.getNummer(),g);
		float x = rechts + rad/2 - (float)(r.getWidth()/2);
		float y = oben + rad -  (float)(r.getHeight());
		ga.setColor(linie);
		ga.drawString(ti.getNummer(), x,y);
		if(ti.isMischung()) {
			ga.drawImage(mischungsIcon.getImage() ,(int)(rechts),(int)(oben +rad/2 - mischungsIcon.getIconHeight()/2),this);
		}
	}
	
	private void paintCircle(tankItem ti,Graphics g) {
		Graphics2D ga = (Graphics2D)g;
		float rechts =(ti.getPx() * (float)factor)+ offsetX;
		float oben = (ti.getPy() * (float)factor) + offsetY;
		float rad = ti.getPr() * (float)factor;
		Shape circle = new Ellipse2D.Float(rechts,oben,rad,rad);
		Shape circle_inner = new Ellipse2D.Float(rechts+2,oben+2,rad-4,rad-4);
		ga.setColor(linie);
		ga.draw(circle);
		if(rz.isZero(ti.getRestLiter())) {
			if(isSelected(ti.getId())) {
				ga.setColor(tank_selected);
			}else {
				ga.setColor(empty);
			}
			ga.fill(circle_inner);
		}	else {
			ga.fill(circle_inner);
			if(isSelected(ti.getId())) {
				drawPercent(ti,circle_inner,g,rechts,oben,rad,tank_selected);
			}else {
				Color fillColor = fill;
				if(ti.isMeldebestand()) {
					fillColor = meldeBestand;
				}
				if(ti.getPercentFull() <=FASTLEER) {
					fillColor = fastLeer;
				} 
				drawPercent(ti,circle_inner,g,rechts,oben,rad,fillColor);
			}
		}
		paintLager(g,ti,rechts,oben,rad);
		ga.setColor(linie);
		//nummer
		Rectangle2D r = g.getFontMetrics().getStringBounds(ti.getNummer(),g);
		float x = rechts + rad/2 - (float)(r.getWidth()/2);
		float y = oben + rad/2 -  (float)(r.getHeight());
		ga.drawString(ti.getNummer(), x,y);
		//größe
		String liter = rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE) + rz.getLocale().getString("string_liter");
		r = g.getFontMetrics().getStringBounds(liter,g);
		x = rechts + rad/2 - (float)(r.getWidth()/2);
		y = oben +rad/2 + (float)(r.getHeight() + 2);
		ga.drawString(liter, x,y);
		//Auftrag
		String auftrag = getAuftraege(ti);
		if(auftrag != null && !auftrag.equals("")) {
			if(auftrag.contains("anfrage.png")) {
				ga.drawImage(anfrageIcon.getImage() ,(int)(rechts+12),(int)(oben +rad/2 - anfrageIcon.getIconHeight()/2),this);
			} 
			if(auftrag.contains("auftrag.png")) {
				ga.drawImage(auftragsIcon.getImage() ,(int)(rechts),(int)(oben +rad/2 - auftragsIcon.getIconHeight()/2),this);
			}
		}
		paintBemerkungen(g,ti,rechts,oben,rad);
	}
	
	private void paintBemerkungen(Graphics g,tankItem ti,float rechts,float oben,float rad) {
		if(paintBemerkungen) {
			Graphics2D ga = (Graphics2D)g;
			Font alt = ga.getFont();
			Font f = new Font("arial",Font.PLAIN,rz.getOptionFactory().getInt("tanklagerpanel.bemerkungen_fontsize"));
			ga.setFont(f);
			Rectangle2D r = g.getFontMetrics().getStringBounds(ti.getComment(),g);
			float x = rechts + rad/2 - (float)(r.getWidth()/2);
			float y = oben + rad/2;// -  (float)(r.getHeight());
			ga.drawString(ti.getComment(), x,y);
			ga.setFont(alt);
		}
	}
	
	private void paintLager(Graphics g,tankItem ti,float rechts,float oben,float rad) {
		if(paintLager) {
			Graphics2D ga = (Graphics2D)g;
			HashMap<String,tankLagerItem> map = ti.getInhaltsListe().getTankLagerListe();
			int lager = map.size();
			if(lager > 0) {
				int breite = (int)rad /(lager*2);
				int hoehe = (int)rad/6;
				float x = rechts + rad/2 - (float)((lager*breite)/2);
				for (Entry<String, tankLagerItem> entry : map.entrySet()) {
					float y = oben + ((rad/3) * 2);
					ga.setColor(rz.getOptionFactory().getRGBColorString(((tankLagerItem)entry.getValue()).getHg()));
					ga.fillRect((int)x, (int)y, breite, hoehe);
					ga.setColor(Color.BLACK);
					ga.drawRect((int)x, (int)y, breite, hoehe);
					x += breite;
					
				}
			}
		}
	}
	
	private void paintLagerMischung(Graphics g,tankItem ti,float rechts,float oben,float rad) {
		if(paintLager) {
			Graphics2D ga = (Graphics2D)g;
			HashMap<String,tankLagerItem> map = ti.getInhaltsListe().getTankLagerListe();
			int lager = map.size();
			if(lager > 0) {
				int breite = (int)rad /(lager*2);
				int hoehe = (int)rad/6;
				float x = rechts + rad/2 - (float)((lager*breite)/2);
				for (Entry<String, tankLagerItem> entry : map.entrySet()) {
					float y = oben + ((rad/3) * 2);
					ga.setColor(rz.getOptionFactory().getRGBColorString(((tankLagerItem)entry.getValue()).getHg()));
					ga.fillRect((int)x, (int)y, breite, hoehe);
					ga.setColor(Color.BLACK);
					ga.drawRect((int)x, (int)y, breite, hoehe);
					x += breite;
					
				}
			}
		}
	}
	
    @Override
    public String getToolTipText(MouseEvent event) {
    	String ret = null;
        Point p = new Point(event.getX(), event.getY());
        tankItem ti = getTankAt(p,true,true);
        if(ti!=null) {
        	ret = getToolTipTextHeader(ti,true);
        	String a =getAuftraege(ti);
        	if(a!= null && !a.equals(""))ret += a;
        }
        return ret == null?null:"<html>"+ret+"</html>";
    }
   
     public String getLabelTipText(MouseEvent event){
     	String ret = "";
        Point p = new Point(event.getX(), event.getY());
        tankItem ti = getTankAt(p,true,true);
        if(ti != null) {
        	ret = getToolTipTextHeader(ti,false);
        }
        return ret == null?null:"<html>"+ret+"</html>";
     }
     
     
    private String getToolTipTextHeader(tankItem ti,boolean liste) {
    	String ret = "";
		if(ti!=null) {
	    	if(ti.isMischung()) {
	      		ret= rz.getLocale().getString("tanklagerpanel.tooltip_mischung")
	        			.replaceAll("%i",String.valueOf(ti.getInhaltsListe().getMischungsNummer()))
	        			.replaceAll("%s", ti.getInhaltsListe().getInhaltBezeichnung())
	        			.replaceAll("%l", rz.getLocale().formatNumber(ti.getRestKg(), OptionFactory.NF_ONE))
	        			.replaceAll("\\n","<br>");
	      	} else {
	        	if(ti.isStellplatz()) {
	        		String p = getAlleStellplaetze(ti);
		        	ret= liste ? 
		        			rz.getLocale().getString("tanklagerpanel.tooltip_stellplatz")
		        			.replaceAll("%n",ti.getNummer())
		        			.replaceAll("%i", ti.getInhaltsListe().getInhaltBezeichnung()).replaceAll("\\n","<br>")
		        			.replaceAll("%r",rz.getLocale().formatNumber(ti.getRestLiter(),OptionFactory.NF_ONE))
		        			.replaceAll("%k",rz.getLocale().formatNumber(ti.getRestKg(),OptionFactory.NF_ONE))
		        			.replaceAll("%p", p)
		        			:
			        		rz.getLocale().getString("tanklagerpanel.tooltip_stellplatz")
			        		.replaceAll("%n",ti.getNummer())
			        		//.replaceAll("%i",  rz.getLocale().getString("tanklagerpanel.mehrere"))
		        			.replaceAll("%i", ti.getInhaltsListe().getInhaltBezeichnung()).replaceAll("\\n","<br>")
			        		.replaceAll("%r",rz.getLocale().formatNumber(ti.getRestLiter(),OptionFactory.NF_ONE))
			        		.replaceAll("%k",rz.getLocale().formatNumber(ti.getRestKg(),OptionFactory.NF_ONE))
			        		.replaceAll("%p", p)
		        			;
	        	}else {
		        	if(ti.getInhaltsListe().size() > 1) {
			        	ret=  liste ? 
			        			rz.getLocale().getString("tanklagerpanel.multi_tooltip")
			        			.replaceAll("%n",ti.getNummer())
			        			.replaceAll("%l",rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE))
			        			.replaceAll("%i", ti.getInhaltsListe().getInhaltBezeichnung()).replaceAll("\\n","<br>")
			        			.replaceAll("%p",String.valueOf(ti.getPercentFull()))
			        			.replaceAll("%r",rz.getLocale().formatNumber(ti.getRestLiter(),OptionFactory.NF_ONE))
			        			:
				        		rz.getLocale().getString("tanklagerpanel.multi_tooltip")
				        		.replaceAll("%n",ti.getNummer())
				        		.replaceAll("%l",rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE))
				        		.replaceAll("%i", rz.getLocale().getString("tanklagerpanel.mehrere"))
				        		.replaceAll("%p",String.valueOf(ti.getPercentFull()))
				        		.replaceAll("%r",rz.getLocale().formatNumber(ti.getRestLiter(),OptionFactory.NF_ONE))   			
			        			;
		        	}else {
			        	ret= (rz.getLocale().getString("tanklagerpanel.tooltip")
			        			.replaceAll("%n",ti.getNummer())
			        			.replaceAll("%l",rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE))
			        			.replaceAll("%i", ti.getInhaltsListe().getInhaltBezeichnung()).replaceAll("\\n","<br>")
			        			.replaceAll("%p",String.valueOf(ti.getPercentFull()))
			        			.replaceAll("%r",rz.getLocale().formatNumber(ti.getRestLiter(),OptionFactory.NF_ONE))
			        			);
		        	}
	        	}
	      	}
		}
    	return ret ;
    }
    
    private String getAlleStellplaetze(tankItem ti) {
    	String ret = "";
    	HashMap<String, String> map = new HashMap<String,String>();
    	for(tankInhaltsItem i:ti.getInhaltsListe()) {
    		String r = rz.getDatabase().getBuchungen().getBestandTanks(i.getRezeptur_id(),rz.getLocale().getString("ausgabe.tank"),rz.getOptionFactory().getOption("dbbuchung.tank_sb"),rz.getOptionFactory().getOption("dbbuchung.tank_se")).getTankString(); 
    		String[] liste = r.split("[ ,.-]");
    		for(String eintrag:liste) {
    			if(!map.containsKey(eintrag.trim())) {
    				if(rz.getDatabase().getTank().tankExists(eintrag.trim())) {
    					map.put(eintrag.trim(), i.getBezeichnung());
    				}
    			}
    		}
    	}
    	map.remove(ti.getNummer().trim());
    	for(Map.Entry<String,String> m:map.entrySet()) {
    		if(!m.getKey().trim().isEmpty()){
    			ret += m.getValue()+ ":" + m.getKey() +"<br>";
    		}
    	}
    	return ret;
    }
    
    
    private String getAuftraege(tankItem ti) {
    	String ret = "";
    	Auftragsliste liste = new Auftragsliste(rz);
    	if(ti != null  && liste != null) {
	    	if(!ti.getInhaltsListe().getIDs().equals("")){
	    		String ids[] = ti.getInhaltsListe().getIDs().split(",");
	    		for(String id:ids) {
	    			try {
	    				if(Integer.valueOf(id) != 0) {
	        				Auftragsliste al2 = rz.getDatabase().getAuftrag().getAuftragsListe(Integer.valueOf(id)) ;
	        				if(al2 !=null && !al2.isEmpty()) {
	        					for(int j=0;j<al2.size();j++) {
	        						AuftragsItem ai = al2.getItem(j);
	        						if(!liste.isInList(ai.getId())) {
	        							liste.add(ai);
	        						}
	        					}
	        				}
	    				}
	       			}catch(Exception e) {};
	    		}
    		}
    	}
    	Auftragsliste al = rz.getDatabase().getAuftrag().getAuftragTank(ti.getNummer());
    	if(al!= null && al.size()>0) {
    		for(int i=0;i < al.size();i++) {
    			AuftragsItem ai = al.getItem(i);
    			if(ai !=null) {
					if(!liste.isInList(ai.getId())) {
						liste.addItem(ai);
					}
				}
        	}
    	}
    
    	
    	if(!liste.isEmpty()) {
    		for(int i=0;i<liste.size();i++) {
    			AuftragsItem ai = liste.getItem(i);
    			if(ai.isAnfrage()) {
	    			ret +="<br><img src=\"" + getClass().getResource("/de/lunqual/rzpro/gfx/anfrage.png").toString() + "\" border=\"0\">&nbsp;";
	    			ret += rz.getLocale().getString("tanklagerpanel.anfrage")
	    					.replaceAll("%l",rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_ONE))
	    					.replaceAll("%n", ai.getBezeichnung())
	    					.replaceAll("%s",ai.getFaelligToString())
	    					.replaceAll("%u", ai.getErstellt_user());
    			}else {
	    			ret +="<br><img src=\"" + getClass().getResource("/de/lunqual/rzpro/gfx/auftrag.png").toString() + "\" border=\"0\">&nbsp;";
	    			ret += rz.getLocale().getString("tanklagerpanel.auftrag")
	    					.replaceAll("%l",rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_ONE))
	    					.replaceAll("%n", ai.getBezeichnung())
	    					.replaceAll("%s",ai.getFaelligToString());
	    		}
    		}
    	}
    	return  ret.equals("")?null:ret;
    }

	   
}
