/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.tankfenster;


import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.BuchungsDialog;
import de.lunqual.rzpro.fenster.dialoge.EingabeDialog;
import de.lunqual.rzpro.fenster.dialoge.ErledigenDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.tank.ortItem;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
/**
 *
 * @author  lunqual
 */
public class TankAuswahlFenster extends JRzFrame {

    //GUI-Variablen
    private JMenuBar mb;
    private JPanel mainPanel;
    	private JMenu mnuDatei;
    	private JMenu mnuHilfe;
    	private JPanel contentPanel;
    		private JSplitPane spl1;
	    		private JPanel lagerZoomPanel;
	    			private JLabel lblZoom;
	    			private JSpinner spZoom;
    			private JPanel ortePanel;
    				private JList lstOrte;
   				private JPanel anzeigePanel;
   					private JScrollPane scrAnzeige;
   						private TanklagerPanel lagerPanel;
   					private JPanel infoPanel;
						private JLabel lblInfo;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      		ACTION_CLOSE_TEXT = "tanklistenfenster.action_close";
    public static final int					ACTION_HILFE_CODE = 1002;
    public static final String      		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      		ACTION_HIDE_TEXT = "action_hide";

    
    ArrayList<ortItem>						orte;
    ArrayList<tankItem>					tanks;
    
    ArrayList<tankItem>					selectedTanks;
    
    JRzFrame										parent;
    BuchungsDialog							parentDialog;
    EingabeDialog								parentEingabe;
    ErledigenDialog								parentErledigen;
    
    boolean											selectMischungen = false;
    tankItem										anzeige;
    
    
    /** Creates new form AdressenFenster */
    public TankAuswahlFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        anzeige = new tankItem(rz,"0");
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			contentPanel = new JPanel(new BorderLayout());
				spl1=new JSplitPane();
					spl1.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
					spl1.setDividerSize(6);
					ortePanel = new JPanel(new BorderLayout());
						lstOrte = new JList();
						 lstOrte.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					            	if(evt.getValueIsAdjusting()) {
										return;
									}
					            	refreshTanklisteAction(0);
					            }
					        });
						lstOrte.setCellRenderer(new ortListenRenderer(rz));
						ortePanel.add(lstOrte,BorderLayout.CENTER);
						lagerZoomPanel = new JPanel(new BorderLayout()) ;
						lagerZoomPanel.setBorder(BorderFactory.createEtchedBorder());
							lblZoom = new JLabel();
							lblZoom.setHorizontalAlignment(SwingConstants.TRAILING);
							lagerZoomPanel.add(lblZoom,BorderLayout.WEST);
							spZoom = new JSpinner();
							try {
								spZoom.setValue(rz.getOptionFactory().getOption("tanklager-auswahl.zoom",TanklagerPanel.DEFAULT_SCALING));
							}catch (Exception e) {
								spZoom.setValue(TanklagerPanel.DEFAULT_SCALING);
							}
							spZoom.addChangeListener(new javax.swing.event.ChangeListener() {
								public void stateChanged(javax.swing.event.ChangeEvent evt) {
									zoomChanged();
		    	            	}
							});
							lagerZoomPanel.add(spZoom,BorderLayout.CENTER);
							ortePanel.add(lagerZoomPanel,BorderLayout.NORTH);
						
					anzeigePanel = new JPanel(new BorderLayout());
						scrAnzeige = new JScrollPane();
						scrAnzeige = new JScrollPane();
							scrAnzeige.getVerticalScrollBar().setUnitIncrement(32);
							scrAnzeige.getHorizontalScrollBar().setUnitIncrement(32);
							lagerPanel = new TanklagerPanel(rz,true);
							lagerPanel.setZoom(rz.getOptionFactory().getOption("tanklager-auswahl.zoom",(int) TanklagerPanel.DEFAULT_SCALING));
							lagerPanel.addMouseListener(new MouseAdapter() {
					            @Override
								public void mouseClicked(MouseEvent evt) {
					            	if (evt.getClickCount() == 1) {
					            		lagerPanelMouseClicked(evt);
					            	}
					            }
					        });
							lagerPanel.addMouseMotionListener(new MouseMotionListener() {
								public void mouseMoved(MouseEvent e) {
									tankItem ti = lagerPanel.getTankAt(e.getPoint(),true,false);
									if(ti !=null) {
											if(!ti.getNummer().equals(anzeige.getNummer())) {
												anzeige = ti.clones();
												lblInfo.setText(lagerPanel.getLabelTipText(e));
											}
									}
								}
								public void mouseDragged(MouseEvent e) {
								}
							}
						);
						scrAnzeige.setViewportView(lagerPanel);
					anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
					infoPanel=new JPanel(new BorderLayout()) ;
						lblInfo = new JLabel();
							infoPanel.add(lblInfo,BorderLayout.CENTER);
					anzeigePanel.add(infoPanel,BorderLayout.SOUTH);
				spl1.setLeftComponent(ortePanel);
				spl1.setRightComponent(anzeigePanel);
			contentPanel.add(spl1,BorderLayout.CENTER);

			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				buttonPanel.setBorder(BorderFactory.createEtchedBorder());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("tankauswahlfenster.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      lblZoom.setText(rz.getLocale().getString("tanklistenfenster.label_zoom"));

      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      setPreferredSize(new Dimension(300,300));
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      setDividerLocations();
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                
                default :
                    break;
               }
        		break;
        	case MessageItem.MSG_SHOW_TANKAUSWAHL_MISCHUNG:
        		selectMischungen=true;
        	case MessageItem.MSG_SHOW_TANKAUSWAHL:
        		tankAuswahlItem tai = (tankAuswahlItem)msg.getData();
        		if(tai != null) {
            		selectedTanks = tai.getListe();
        			if(tai.getOriginFrame() != null) {
        				parent = tai.getOriginFrame();
        				parentDialog = null;
        				parentEingabe = null;
        				parentErledigen = null;
        			} else if(tai.getOriginDialog() != null){
        				parent=null;
        				parentDialog = tai.getOriginDialog();
        				parentEingabe = null;
        				parentErledigen = null;
        			}  else if(tai.getOriginalEingabe() != null) {
        				parent = null;
        				parentDialog = null;
        				parentEingabe = tai.getOriginalEingabe();
        				parentErledigen = null;
        			} else if(tai.getOriginalErledigen() != null) {
        				parent = null;
        				parentDialog=null;
        				parentEingabe = null;
        				parentErledigen = tai.getOriginalErledigen();
        			}
        		}
        		if(selectedTanks != null && selectedTanks.size()>0) {
        			refreshAction(selectedTanks);
        		}else {
        			refreshAction(null);
        		}
                break;
            default:
                break;
        }
    }

    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getWidth()/4));
    }
    

     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
     }



     private void zoomChanged() {
    	int value = ((Integer)spZoom.getValue()).intValue();
     	if(value < 10) {
     		value = 10;
     	} else if(value > 100) {
     		value = 100;
     	}
     	spZoom.setValue(value);
     	lagerPanel.setZoom(value);
     	rz.getOptionFactory().setOption("tanklager-auswahl.zoom", value);
     	rz.getOptionFactory().saveOptions();
     	lagerPanel.validate();
     	lagerPanel.repaint();
     }

    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
    }

    @Override
	public void closeWindow(){
    	saveDividerLocations();
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

      
   private void lagerPanelMouseClicked(MouseEvent evt) {
    	if(tanks!= null && !tanks.isEmpty()) {
    		tankItem ti = lagerPanel.getTankAt(evt.getPoint(),false,selectMischungen);
    		if(ti != null) {
    			try {
	    			if(parentDialog != null) {
	    				parentDialog.setTankItem(ti.clones());
	    			}else if (parent != null) {
	    				parent.getMessage(new MessageItem(MessageItem.MSG_TANKLISTE_REPLY,0, ti.clones(),this));
	    			} else if (parentEingabe != null) {
	    				parentEingabe.addTank(ti.getNummer());
	    			} else if (parentErledigen != null) {
	    				parentErledigen.setTankNummer(ti.getNummer());
	    			}
	    			
    			}catch(Exception e) {
    				
    			}
    			closeWindow();
    		}
    	}
    }

   private void refreshTanklisteAction(int id) {
   	if(lstOrte.getSelectedIndex()!= -1) {
           lagerPanel.setOrtID((ortItem)lstOrte.getSelectedValue());
           tanks=lagerPanel.getTankListe();
           zoomChanged();
           lagerPanel.repaint();
           rz.getOptionFactory().setOption("tankauswahlfenster.selected_ort",lstOrte.getSelectedIndex());
   		}
   }
   
    /**
     * Liste neu einlesen
     */
    private void refreshAction(ArrayList<tankItem> liste) {
    	tankItem ti = null; 
    	orte = lagerPanel.getOrtListe();
    	lstOrte.setListData(orte.toArray());
    	if(orte.size()>0) {
    		try {
    			lstOrte.setSelectedIndex(rz.getOptionFactory().getOption("tankauswahlfenster.selected_ort",0));
    		}catch(Exception e) {
    			lstOrte.setSelectedIndex(0);
    		}
    		if(liste != null && liste.size()>0) {
    			for(tankItem item:liste) {
    				if(item != null && item.getId()!= 0 && rz.getDatabase().getTank().tankExists(item)) {
    					ti=item;
    					break;
    				}
    			}
    			if(ti != null) {
    				for(int i = 0; i< orte.size();i++) {
    					ortItem oi = orte.get(i);
    					if(oi.getId()==ti.getOrt()) {
    						lagerPanel.setOrtID(oi);
    						lstOrte.setSelectedIndex(i);
    						lagerPanel.tanklisteChanged(liste);
    						break;
    					}
    				}
    			}
    		} 
    	}
    	if(lstOrte.getSelectedIndex()!=-1) {
            lagerPanel.setOrtID((ortItem)lstOrte.getSelectedValue());
            tanks=lagerPanel.getTankListe();
            lagerPanel.repaint();
    	}
    	if(orte != null && liste != null) {
    		rz.getDatabase().getTank().selectOrteAuswahl(orte,liste);
    	}
    }


    
    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"tankliste.html",this));
    }

}
