/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.fenster.staerkefenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.database.DBRezeptur;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.BuchungsDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.acid.AcidAnzeigeItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.buchung.herstellungReturnItem;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.rechnen.RechenZeile;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.tafel.TafelItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class Staerke extends JRzFrame implements TableColumnModelListener{

    private JMenuBar	mb;
	private JMenu mnuDatei;
	private JMenu mnuBearbeiten;
	private JMenu mnuExtras;
	private JMenu mnuFenster;
	private JMenu mnuHilfe;
	private JPopupMenu mnuContext;
	private JPopupMenu mnuBuchen;
	private JPanel mainPanel;
		private JPanel contentPanel;
			private JPanel tbPanel;
				private JToolBar tb1;
			private JPanel centerPanel;
				private JPanel zutatenPanel;
					private JButton btZutat1;
					private JLabel lblZutat1;
					private JSelectedTextField txtZutat1;
					private JNumberField txtStaerke1;
					private JLabel	lblVolProz1;
					private JButton btAdd;
					private JComboBox cmbZutat2;
					private JSelectedTextField txtZutat2;
					private JNumberField txtStaerke2;
					private JLabel	lblVolProz2;
					private JLabel	lblVolProz3;
				private JPanel anzeigePanel;
					private JPanel tablePanel;
						private JScrollPane scrTable;
							private JTable tblRezeptur;
					private JPanel summenPanel;
						private JLabel lblSummeTitel;
						private JPanel summeLeftPanel;
							private JLabel lblSummeLiterTitel;
							private JLabel lblSummeLiter;
							private JLabel lblSummeKgTitel;
							private JLabel lblSummeKg;
							private JLabel lblSummeLATitel;
							private JLabel lblSummeLA;
						private JPanel summeRightPanel;
							private JLabel lblLitergewichtTitel;
							private JLabel lblLitergewicht;
							private JLabel lblLitergewichtEinheit;
							private JLabel lblExtraktProzentTitel;
							private JLabel lblExtraktProzent;
							private JLabel lblExtraktProzentEinheit;
							private JLabel lblExtraktGrammTitel;
							private JLabel lblExtraktGramm;
							private JLabel lblExtraktGrammEinheit;
							private JLabel lblAcidTitel;
							private JLabel lblAcid;
							private JLabel lblAcidEinheit;
				private JPanel ergebnisPanel;
					private JLabel lblGesucht;
					private JNumberField txtGesucht;
					private JComboBox cmbMode;
					private JNumberField txtGesuchtStaerke;
					private JLabel lblProzentVol;

			private JPanel buttonPanel;
				private JLabel lblFormulare;
				private JComboBox cmbFormulare;
				private JButton btPrint;
				private JButton btVerbuchen;
				private JButton btHilfe;
				private JButton btCancel;


    public static final int		MAX_COLUMN 							= 23;
    public static final int		ZEILE_RECHNEN 						= 1;
    public static final int		ZEILE_KOMMENTAR 					= 2;
    public static final int		ZEILE_LEER								= 3;
    public static final int		ZEILE_SUMME 							= 4;

    public static final int		C_MENGE 									= 0;
    public static final int		C_EINHEIT 								= 1;
    public static final int		C_TITEL 									= 2;
    public static final int		C_STAERKE 								= 3;
    public static final int		C_LITER	 									= 4;
    public static final int		C_KG 										= 5;
    public static final int 		C_LA 											= 6;
    public static final int		C_ARTIKEL									= 7;
    public static final int		C_LOSNUMMER							= 8;
    public static final int	    C_BESTAND 								= 9;
    public static final int		C_MELDEBESTAND 						= 10;
    public static final int		C_EXTRAKTFREI							= 11;
    public static final int		C_EXTRAKT									= 12;
    public static final int		C_TROCKENMASSE						= 13;
    public static final int		C_ACID										= 14;
    public static final int		C_ACIDCONTENT							= 15;
    public static final int		C_GRUNDPREIS							= 16;
    public static final int		C_PREIS										= 17;
    public static final int		C_EXTRAKTFREI_LITER					= 18;
    public static final int		C_EXTRAKTFREI_STAERKE				= 19;
    public static final int		C_EXTRAKTFREI_LITERGEWICHT	= 20;
    public static final int		C_EXTRAKTFREI_GEWICHT			= 21;
    public static final int		C_BRENNWERT_ALKOHOL 			= 22;
    public static final int		C_BRENNWERT_ALKOHOLFREI 		= 23;


    public static final int 			MODE_LITER_ENDMENGE			=	0;
    public static final int 			MODE_LITER_AUSGANGSMENGE	=	1;
    public static final int 			MODE_KG_ENDMENGE				=	2;
    public static final int 			MODE_KG_AUSGANGSMENGE		=	3;
    public static final int 			MODE_LA_ENDMENGE					=	4;
    public static final int 			MODE_LA_AUSGANGSMENGE		=	5;

	public static final int 			ACTION_SCHLIESSEN_CODE = 1000;
	public static final String 		ACTION_SCHLIESSEN_TEXT = "staerke.action_close";
	public static final int         	ACTION_HILFE_CODE  = 1001;
    public static final String     	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         	ACTION_HIDE_CODE  = 1002;
    public static final String     	ACTION_HIDE_TEXT = "action_hide";
	public static final int 			ACTION_PRINT_CODE = 1005;
	public static final String 		ACTION_PRINT_TEXT = "staerke.action_print";
	public static final int 			ACTION_ADD_CODE = 1006;
	public static final String 		ACTION_ADD_TEXT = "staerke.action_add";
	public static final int 			ACTION_ZUTAT1_CODE = 1007;
	public static final String 		ACTION_ZUTAT1_TEXT = "staerke.action_zutat1";
    public static final int         ACTION_TAFEL_CODE  = 1008;
    public static final String     ACTION_TAFEL_TEXT = "staerke.action_tafel";
    public static final int         ACTION_EINSTELLUNGEN_CODE  = 1009;
    public static final String     ACTION_EINSTELLUNGEN_TEXT = "staerke.action_einstellungen";
    public static final int 	ACTION_BUCHEN_CODE = 1010;
    public static final String	ACTION_BUCHEN_TEXT = "staerke.action_buchen";
    public static final int 	ACTION_VERSANDBUCHUNG_CODE = 1011;
    public static final String	ACTION_VERSANDBUCHUNG_TEXT = "staerke.action_versandbuchung";
    public static final int 	ACTION_HERSTELLBUCHUNG_CODE = 1012;
    public static final String	ACTION_HERSTELLBUCHUNG_TEXT = "staerke.action_herstellbuchung";
    public static final int 	ACTION_LOSNUMMER_CODE = 1013;
    public static final String	ACTION_LOSNUMMER_TEXT = "staerke.action_losnummer";
    public static final int         ACTION_ACIDRECHNER_CODE = 1014;
    public static final String     ACTION_ACIDRECHNER_TEXT = "staerke.action_acidrechner";

	ErgebnisItem		ei;
	MessageItem	 	mi;
    RezepturItem		zutat1;
    RezepturItem		zutat2;
    RezepturItem		extraktZutat;
	int					mode;
	RechenItem		ri;
	CurrencyItem    	waehrung;
	boolean				setup=false;
    DialogItem         dlgItem;
	ZutatenDialog		zd;
	BuchungsDialog		bd;
	BewertungsItem		bwi;

    public Staerke(RzPro r,String name,Object extendedData) {
    	super(r,name,extendedData);
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
	    mi = new MessageItem(MessageItem.MSG_NULL,0,null,this);
	    mode = 1;
		createActions();
		createGUIComponents();
		setGUIComponents();
		getMessage((MessageItem)extendedData);
    }



    public void createActions() {
		actionList.put(String.valueOf(ACTION_HIDE_CODE), new AuswahlAction(rz,this, ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5, KeyEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_SCHLIESSEN_CODE), new AuswahlAction(rz,this, ACTION_SCHLIESSEN_CODE,ACTION_SCHLIESSEN_TEXT, KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_HILFE_CODE), new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1, 0));
		actionList.put(String.valueOf(ACTION_PRINT_CODE), new AuswahlAction(rz,this,ACTION_PRINT_CODE,ACTION_PRINT_TEXT, KeyEvent.VK_D, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADD_CODE), new AuswahlAction(rz,this,ACTION_ADD_CODE,ACTION_ADD_TEXT, KeyEvent.VK_PLUS, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ZUTAT1_CODE), new AuswahlAction(rz,this,ACTION_ZUTAT1_CODE,ACTION_ZUTAT1_TEXT, KeyEvent.VK_Z, KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_TAFEL_CODE),new AuswahlAction(rz,this,ACTION_TAFEL_CODE,ACTION_TAFEL_TEXT, KeyEvent.VK_F12,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_EINSTELLUNGEN_CODE),new AuswahlAction(rz,this,ACTION_EINSTELLUNGEN_CODE,ACTION_EINSTELLUNGEN_TEXT,KeyEvent.VK_F12 ,0));
		actionList.put(String.valueOf(ACTION_BUCHEN_CODE), new AuswahlAction(rz,this,ACTION_BUCHEN_CODE,ACTION_BUCHEN_TEXT, KeyEvent.VK_B, KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_VERSANDBUCHUNG_CODE),new AuswahlAction(rz,this,ACTION_VERSANDBUCHUNG_CODE,ACTION_VERSANDBUCHUNG_TEXT, KeyEvent.VK_H,KeyEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_HERSTELLBUCHUNG_CODE), new AuswahlAction(rz,this,ACTION_HERSTELLBUCHUNG_CODE,ACTION_HERSTELLBUCHUNG_TEXT, KeyEvent.VK_V, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_LOSNUMMER_CODE), new AuswahlAction(rz,this,ACTION_LOSNUMMER_CODE,ACTION_LOSNUMMER_TEXT, KeyEvent.VK_L, KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ACIDRECHNER_CODE),new AuswahlAction(rz,this,ACTION_ACIDRECHNER_CODE,ACTION_ACIDRECHNER_TEXT, 0,0));

    }
    public void createGUIComponents() {
        final GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(0,0,0,0);
    	mb = new javax.swing.JMenuBar();
    	mnuDatei = new javax.swing.JMenu();
    	mnuBearbeiten = new JMenu();
    	mnuExtras = new JMenu();
    	mnuFenster= new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuExtras);
    	mb.add(mnuFenster);
    	mb.add(mnuHilfe);
        setJMenuBar(mb);
        mnuContext = new JPopupMenu();
        mnuBuchen = new JPopupMenu();
        contentPanel = new JPanel(new BorderLayout());
		//Toolbar
		tb1 = new javax.swing.JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//Panels & buttons...
			tbPanel = new JPanel(new BorderLayout());
			tbPanel.add(tb1,BorderLayout.CENTER);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
		centerPanel = new JPanel(new BorderLayout());
			zutatenPanel = new JPanel(new GridBagLayout());
				btZutat1 = new JButton();
					c.gridx = 0;c.gridy = 0;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				zutatenPanel.add(btZutat1,c);
				lblZutat1 = new JLabel();
				c.gridx = 1;c.gridy = 0;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				zutatenPanel.add(lblZutat1);
				txtZutat1 = new JSelectedTextField();
		        txtZutat1.addKeyListener(new java.awt.event.KeyAdapter() {
		            public void keyReleased(java.awt.event.KeyEvent evt) {
		            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		            		rechnen();
		            	}
		            }
		        });
					c.gridx = 3;c.gridy = 0;c.gridwidth=2;c.gridheight=1;c.weightx=1;
				zutatenPanel.add(txtZutat1,c);
				txtStaerke1 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,99.999999);
		        txtStaerke1.addKeyListener(new java.awt.event.KeyAdapter() {
		            public void keyReleased(java.awt.event.KeyEvent evt) {
		            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		            	    rechnen();
		            	}
		            }
		        });
		        txtStaerke1.setColumns(5);
					c.gridx = 6;c.gridy = 0;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				zutatenPanel.add(txtStaerke1,c);
                lblVolProz1 = new JLabel();
                	lblVolProz1.setHorizontalAlignment(SwingConstants.LEADING);
					c.gridx = 7;c.gridy = 0;c.gridwidth=2;c.gridheight=1;c.weightx=0;
                zutatenPanel.add(lblVolProz1,c);
                btAdd=new JButton();
					c.gridx = 0;c.gridy = 1;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				zutatenPanel.add(btAdd,c);
				cmbZutat2 = new JComboBox();
	        	    cmbZutat2.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        			zutat2Action();
	    	        	    	rechnen();
		    	        	}
		            });
					c.gridx = 1;c.gridy = 1;c.gridwidth=2;c.gridheight=1;c.weightx=0;
				zutatenPanel.add(cmbZutat2,c);
				txtZutat2 = new JSelectedTextField();
		        txtZutat2.addKeyListener(new java.awt.event.KeyAdapter() {
		            public void keyReleased(java.awt.event.KeyEvent evt) {
		            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		            		rechnen();
		            	}
		            }
		        });
					c.gridx = 3;c.gridy = 1;c.gridwidth=2;c.gridheight=1;c.weightx=1;
				zutatenPanel.add(txtZutat2,c);
				txtStaerke2 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,99.999999);
		        txtStaerke2.addKeyListener(new java.awt.event.KeyAdapter() {
		            public void keyReleased(java.awt.event.KeyEvent evt) {
		            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		            	    rechnen();
		            	}
		            }
		        });
					txtStaerke2.setColumns(5);
					c.gridx = 6;c.gridy = 1;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				zutatenPanel.add(txtStaerke2,c);
	            lblVolProz2 = new JLabel();
	            	lblVolProz2.setHorizontalAlignment(SwingConstants.LEADING);
					c.gridx = 7;c.gridy = 1;c.gridwidth=2;c.gridheight=1;c.weightx=0;
	            zutatenPanel.add(lblVolProz2,c);
	            lblVolProz3 = new JLabel();
	            	lblVolProz2.setHorizontalAlignment(SwingConstants.LEADING);
					c.gridx = 7;c.gridy = 1;c.gridwidth=2;c.gridheight=1;c.weightx=0;
	            zutatenPanel.add(lblVolProz3,c);

			centerPanel.add(zutatenPanel,BorderLayout.NORTH);
			anzeigePanel = new JPanel(new BorderLayout());
				tablePanel = new JPanel(new BorderLayout()) ;
					scrTable = new JScrollPane();
						tblRezeptur=new JTable();
						tblRezeptur.setName("staerkefenster.spalten");
		    			tblRezeptur.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
		                    public void valueChanged(ListSelectionEvent e) {
		        			        if (!e.getValueIsAdjusting()) {
										return;
									}
		        			        selectionChanged();
		                        }
			    			});
			 	        tblRezeptur.addMouseListener(new MouseAdapter() {
			 	            public void mousePressed(MouseEvent e) {
			 	                if(e.getClickCount() == 2) {
			 	                   rechnenAction();
			 	                } else {
			 	                	maybeShowPopup(e);
			 	                }
			 	            }
				 	       public void mouseReleased(MouseEvent e) {
				 	           maybeShowPopup(e);
				 	       }

				 	       private void maybeShowPopup(MouseEvent e) {
				 	           if (e.isPopupTrigger()) {
				 	               mnuContext.show(e.getComponent(),
				 	                          e.getX(), e.getY());
				 	           		}
				 	       		}
			 	        });
						scrTable.setViewportView(tblRezeptur);
					tablePanel.add(scrTable,BorderLayout.CENTER);
				anzeigePanel.add(tablePanel,BorderLayout.CENTER);
				summenPanel=new JPanel(new BorderLayout());
					lblSummeTitel = new JLabel();
						lblSummeTitel.setHorizontalAlignment(SwingConstants.CENTER);
					summenPanel.add(lblSummeTitel,BorderLayout.NORTH);
					summeLeftPanel = new JPanel(new GridLayout(3,2));
						lblSummeLiterTitel = new JLabel();
							lblSummeLiterTitel.setHorizontalAlignment(SwingConstants.TRAILING);
							summeLeftPanel.add(lblSummeLiterTitel);
							lblSummeLiter = new JLabel();
								lblSummeLiter.setHorizontalAlignment(SwingConstants.LEADING);
								summeLeftPanel.add(lblSummeLiter);
							lblSummeKgTitel = new JLabel();
								lblSummeKgTitel.setHorizontalAlignment(SwingConstants.TRAILING);
							summeLeftPanel.add(lblSummeKgTitel);
							lblSummeKg = new JLabel();
								lblSummeKg.setHorizontalAlignment(SwingConstants.LEADING);
							summeLeftPanel.add(lblSummeKg);

							lblSummeLATitel = new JLabel();
								lblSummeLATitel.setHorizontalAlignment(SwingConstants.TRAILING);
							summeLeftPanel.add(lblSummeLATitel);
							lblSummeLA = new JLabel();
								lblSummeLA.setHorizontalAlignment(SwingConstants.LEADING);
								summeLeftPanel.add(lblSummeLA);

					summenPanel.add(summeLeftPanel,BorderLayout.WEST);
					summeRightPanel = new JPanel(new GridLayout(4,3));
						lblLitergewichtTitel=new JLabel();
							lblLitergewichtTitel.setHorizontalAlignment(SwingConstants.TRAILING);
						summeRightPanel.add(lblLitergewichtTitel);
						lblLitergewicht=new JLabel();
							lblLitergewicht.setHorizontalAlignment(SwingConstants.TRAILING);
					    summeRightPanel.add(lblLitergewicht);
					    lblLitergewichtEinheit=new JLabel();
					    	lblLitergewichtEinheit.setHorizontalAlignment(SwingConstants.LEADING);
					    summeRightPanel.add(lblLitergewichtEinheit);

						lblExtraktProzentTitel=new JLabel();
						lblExtraktProzentTitel.setHorizontalAlignment(SwingConstants.TRAILING);
						summeRightPanel.add(lblExtraktProzentTitel);
						lblExtraktProzent=new JLabel();
							lblExtraktProzent.setHorizontalAlignment(SwingConstants.TRAILING);
					    summeRightPanel.add(lblExtraktProzent);
					    lblExtraktProzentEinheit=new JLabel();
					    	lblExtraktProzentEinheit.setHorizontalAlignment(SwingConstants.LEADING);
					    summeRightPanel.add(lblExtraktProzentEinheit);

						lblExtraktGrammTitel=new JLabel();
						lblExtraktGrammTitel.setHorizontalAlignment(SwingConstants.TRAILING);
						summeRightPanel.add(lblExtraktGrammTitel);
						lblExtraktGramm=new JLabel();
							lblExtraktGramm.setHorizontalAlignment(SwingConstants.TRAILING);
					    summeRightPanel.add(lblExtraktGramm);
					    lblExtraktGrammEinheit=new JLabel();
					    	lblExtraktGrammEinheit.setHorizontalAlignment(SwingConstants.LEADING);
					    summeRightPanel.add(lblExtraktGrammEinheit);

						lblAcidTitel=new JLabel();
						lblAcidTitel.setHorizontalAlignment(SwingConstants.TRAILING);
						summeRightPanel.add(lblAcidTitel);
						lblAcid=new JLabel();
						lblAcid.setHorizontalAlignment(SwingConstants.TRAILING);
						summeRightPanel.add(lblAcid);
						lblAcidEinheit=new JLabel();
				    	lblAcidEinheit.setHorizontalAlignment(SwingConstants.LEADING);
				    	summeRightPanel.add(lblAcidEinheit);


					summenPanel.add(summeRightPanel,BorderLayout.EAST);
					summenPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
			    anzeigePanel.add(summenPanel,BorderLayout.SOUTH);
	        centerPanel.add(anzeigePanel,BorderLayout.CENTER);
			ergebnisPanel=new JPanel(new FlowLayout());
				lblGesucht=new JLabel();
				ergebnisPanel.add(lblGesucht);
				txtGesucht = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
				txtGesucht.setColumns(16);
		        txtGesucht.addKeyListener(new java.awt.event.KeyAdapter() {
			            public void keyReleased(java.awt.event.KeyEvent evt) {
			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
			            	    rechnen();
			            	}
			            }
			        });
				ergebnisPanel.add(txtGesucht);
				cmbMode = new JComboBox();
					cmbMode.addItem(rz.getLocale().getString("staerke.mode_0"));
					cmbMode.addItem(rz.getLocale().getString("staerke.mode_1"));
					cmbMode.addItem(rz.getLocale().getString("staerke.mode_2"));
					cmbMode.addItem(rz.getLocale().getString("staerke.mode_3"));
					cmbMode.addItem(rz.getLocale().getString("staerke.mode_4"));
					cmbMode.addItem(rz.getLocale().getString("staerke.mode_5"));
	        	    cmbMode.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        	    rechnen();
		    	        	}
		            });
					ergebnisPanel.add(cmbMode);
				txtGesuchtStaerke =  new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,99.9999999);
		        txtGesuchtStaerke.addKeyListener(new java.awt.event.KeyAdapter() {
		            public void keyReleased(java.awt.event.KeyEvent evt) {
		            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		            	    rechnen();
		            	}
		            }
		        });
					txtGesuchtStaerke.setColumns(6);
				ergebnisPanel.add(txtGesuchtStaerke);
				lblProzentVol = new JLabel();
				ergebnisPanel.add(lblProzentVol);
			centerPanel.add(ergebnisPanel,BorderLayout.SOUTH);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
 		buttonPanel = new JPanel(new GridBagLayout());
		buttonPanel.setBorder(BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
		c.weightx = 1;c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(5,5,5,5);
		btCancel = new JButton();
			c.gridx=0;c.gridy=0;c.gridheight=1;c.gridwidth = 1;
		buttonPanel.add(btCancel,c);
		lblFormulare = new JLabel();
			lblFormulare.setHorizontalAlignment(SwingConstants.TRAILING);
			c.gridx=1;c.gridy=0;c.gridheight=1;c.gridwidth = 1;
		buttonPanel.add(lblFormulare,c);
		cmbFormulare = new JComboBox();
			rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_STAERKE);
    	    cmbFormulare.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		if(cmbFormulare.getSelectedIndex() != -1) {
	        			rz.getOptionFactory().setOption("report.staerke",((ReportItem)cmbFormulare.getSelectedItem()).getID());
	        		}
	        	}
            });
			c.gridx=2;c.gridy=0;c.gridheight=1;c.gridwidth = 1;
    	    buttonPanel.add(cmbFormulare,c);
		btPrint = new JButton();
			c.gridx=3;c.gridy=0;c.gridheight=1;c.gridwidth = 1;
			buttonPanel.add(btPrint,c);
		btVerbuchen = new JButton();
			c.gridx=4;c.gridy=0;c.gridheight=1;c.gridwidth = 1;
			buttonPanel.add(btVerbuchen,c);
		btHilfe = new JButton();
			c.gridx=5;c.gridy=0;c.gridheight=1;c.gridwidth = 1;
			btHilfe.setAction(getAction(ACTION_HILFE_CODE));
			buttonPanel.add(btHilfe,c);


		contentPanel.add(buttonPanel,BorderLayout.SOUTH);
		mainPanel = new JPanel(new BorderLayout());
		mainPanel.add(contentPanel,BorderLayout.CENTER);

		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
    }

    public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("staerke.titel"));

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
		mnuDatei.add(getAction(ACTION_PRINT_CODE));
		mnuDatei.add(getAction(ACTION_ADD_CODE));
		mnuDatei.addSeparator();
		mnuDatei.add(getAction(ACTION_SCHLIESSEN_CODE));
		mnuBearbeiten.add(getAction(ACTION_LOSNUMMER_CODE));
		mnuExtras.add(getAction(ACTION_HIDE_CODE));
		mnuFenster.add(getAction(ACTION_ACIDRECHNER_CODE));
		mnuFenster.add(getAction(ACTION_TAFEL_CODE));
		mnuFenster.add(getAction(ACTION_EINSTELLUNGEN_CODE));
		mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		mnuContext.add(getAction(ACTION_TAFEL_CODE));
		mnuContext.addSeparator();
		mnuContext.add(getAction(ACTION_EINSTELLUNGEN_CODE));
		mnuContext.addSeparator();
		mnuContext.add(getAction(ACTION_HILFE_CODE));

		getAction(ACTION_BUCHEN_CODE).setEnabled(false);
		getAction(ACTION_HERSTELLBUCHUNG_CODE).setEnabled(false);
		getAction(ACTION_VERSANDBUCHUNG_CODE).setEnabled(false);
		mnuBuchen.add(getAction(ACTION_HERSTELLBUCHUNG_CODE));
		mnuBuchen.add(getAction(ACTION_VERSANDBUCHUNG_CODE));

		tb1.add(getAction(ACTION_SCHLIESSEN_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ADD_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_PRINT_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HERSTELLBUCHUNG_CODE));
		tb1.add(getAction(ACTION_VERSANDBUCHUNG_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ACIDRECHNER_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_EINSTELLUNGEN_CODE));
		tb1.add(getAction(ACTION_TAFEL_CODE));
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_LOSNUMMER_CODE));

		lblVolProz1.setText(rz.getLocale().getString("string_prozentvol"));
		lblVolProz2.setText(rz.getLocale().getString("string_prozentvol"));
		lblVolProz3.setText(rz.getLocale().getString("string_prozentvol"));

		lblGesucht.setText(rz.getLocale().getString("staerke.label_gesucht"));
		lblProzentVol.setText(rz.getLocale().getString("string_prozentvol"));

	    lblFormulare.setText(rz.getLocale().getString("staerke.label_druckformular"));
	    lblSummeTitel.setText(rz.getLocale().getString("staerke.label_summe"));

	    lblSummeLiterTitel.setText(rz.getLocale().getString("staerke.label_summe_liter"));
	    lblSummeKgTitel.setText(rz.getLocale().getString("staerke.label_summe_kg"));
	    lblSummeLATitel.setText(rz.getLocale().getString("staerke.label_summe_la"));

	    lblLitergewichtTitel.setText(rz.getLocale().getString("staerke.label_litergewicht_titel"));
	    lblExtraktProzentTitel.setText(rz.getLocale().getString("staerke.label_extraktprozent_titel"));
	    lblExtraktGrammTitel.setText(rz.getLocale().getString("staerke.label_extraktgramm_titel"));
	    lblAcidTitel.setText(rz.getLocale().getString("staerke.label_acid_titel"));

	    lblExtraktProzentEinheit.setText(rz.getLocale().getString("staerke.label_extraktprozent_einheit").replaceAll("%s",rz.getLocale().getString("string_prozentmas")));
	    lblExtraktGrammEinheit.setText(rz.getLocale().getString("staerke.label_extraktgramm_einheit").replaceAll("%s", rz.getDatabase().getEinheiten().dbGetGramm100mlString()));
	    lblLitergewichtEinheit.setText(rz.getLocale().getString("staerke.label_litergewicht_einheit").replaceAll("%s", rz.getDatabase().getEinheiten().dbGetLitergewichtString()));
	    lblAcidEinheit.setText(rz.getLocale().getString("staerke.label_acid_einheit"));

	    btCancel.setAction(getAction(ACTION_SCHLIESSEN_CODE));
	    btPrint.setAction(getAction(ACTION_PRINT_CODE));
	    btHilfe.setAction(getAction(ACTION_HILFE_CODE));
	    btAdd.setAction(getAction(ACTION_ADD_CODE));
	    btZutat1.setAction(getAction(ACTION_ZUTAT1_CODE));
		btVerbuchen.setAction(getAction(ACTION_BUCHEN_CODE));

		setResizable(true);
		rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);
    }

    public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
	    	case MessageItem.MSG_ACTIONPERFORMED:
	            switch(msg.getCode()){
	            case ACTION_HILFE_CODE: hilfeAction();break;
	            case ACTION_HIDE_CODE:hideAction();break;
	            case ACTION_SCHLIESSEN_CODE:closeWindow();break;
	            case ACTION_PRINT_CODE:printRezepturAction();break;
	            case ACTION_ADD_CODE:	addAction();break;
	            case ACTION_ZUTAT1_CODE:zutat1Action();break;
	            case ACTION_EINSTELLUNGEN_CODE:einstellungenAction();break;
	            case ACTION_TAFEL_CODE:tafelAction();break;
	            case ACTION_HERSTELLBUCHUNG_CODE: verbuchen(DBBuchung.BUCHUNG_HERSTELLUNG);break;
	            case ACTION_VERSANDBUCHUNG_CODE: verbuchen(DBBuchung.BUCHUNG_VERSAND);break;
	            case ACTION_LOSNUMMER_CODE:losnummerAction();break;
		        case ACTION_ACIDRECHNER_CODE:acidRechnerAction();break;
	            case ACTION_BUCHEN_CODE:
		               mnuBuchen.show(btVerbuchen,10,10);
	                break;
            }
	    	break;
	      case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
    	 		zutatenDialogReply((ZutatenSuchItem)msg.getData());
    	 		break;
    	  case MessageItem.MSG_STAERKE:
              	ei = (ErgebnisItem)msg.getData();
   				setTitle(rz.getLocale().getString("staerke.titel") + " " + ei.getName());
   				mode = msg.getCode();
   				waehrung = rz.getDatabase().getCurrency().dbGetCurrency(rz.getOptionFactory().getOption("kalkulation.currency",1),true);
   				setValues();
   				if(zutat1 != null) {
	   				setup=true;
	   				setTblRezepturModel(tblRezeptur);
	   				getRechenItem(zutat1.getID());
	   	     		rechnen();
   				}
   				break;
    	  case MessageItem.MSG_REPLY_BUCHUNGSDIALOG:
    		  bwi = (BewertungsItem)msg.getData();
    		  verbuchen2();
    		  break;
    	}
    }

    private void anzeige() {
		if(ri.isBuchungsWarnung()) {
			getAction(ACTION_BUCHEN_CODE).setEnabled(false);
			getAction(ACTION_HERSTELLBUCHUNG_CODE).setEnabled(false);
			getAction(ACTION_VERSANDBUCHUNG_CODE).setEnabled(false);
		} else  {
			getAction(ACTION_BUCHEN_CODE).setEnabled(true);
			getAction(ACTION_HERSTELLBUCHUNG_CODE).setEnabled(true);
			getAction(ACTION_VERSANDBUCHUNG_CODE).setEnabled(true);
		}
    	lblSummeLiter.setText(rz.getLocale().formatNumber(ri.getGesamtLiter(),OptionFactory.NF_NORMAL));
    	lblSummeKg.setText( rz.getLocale().formatNumber(ri.getGesamtKg(),OptionFactory.NF_NORMAL));
        lblSummeLA.setText(rz.getLocale().formatNumber(ri.getGesamtLA(),OptionFactory.NF_NORMAL));
        lblLitergewicht.setText( rz.getLocale().formatNumber(ri.getGesamtLitergewicht(),OptionFactory.NF_LITERGEWICHT));
        lblExtraktGramm.setText(rz.getLocale().formatNumber(ri.getGesamtExtrakt(),OptionFactory.NF_NORMAL));
        lblExtraktProzent.setText(rz.getLocale().formatNumber(ri.getExtraktMassenProzent(),OptionFactory.NF_NORMAL));
        lblAcid.setText(rz.getLocale().formatNumber(ri.getGesamtAcid(),OptionFactory.NF_NORMAL));
    }


    /** holt ein RechenItem und passt es auf die Bedürfnisse einer Aufstärkrechnung an
     *
     * @param id
     */
    private void getRechenItem(int id) {
			ri = new RechenItem(rz,zutat1.getID(),(AbstractTableModel)tblRezeptur.getModel());
			ri.setWaehrung(waehrung);
    }

	private void losnummerAction() {
	    int i;
	    for(i = 0;i < ri.getZeilenListe().size();i++) {
	        final RechenZeile zl = ri.getZeilenListe().getItem(i);
	        if(zl.isRechnen() && (zl.getRezeptur().getID() != 0)) {
	            zl.getRezeptur().setLosnummer(rz.getDatabase().getBuchungen().getLosNummerListe(DBBuchung.REIHE_FIFO, zl.getRezeptur().getID(), zl.getLiter(), rz.getDatabase().getEinheiten().getLiterItem()).toString());
	        }
	    }
	    ((AbstractTableModel)tblRezeptur.getModel()).fireTableDataChanged();
	}

    private void rechnen() {
        if((ri != null) && (zutat1 != null) && (zutat2 != null) && setup) {
			ri.getZeilenListe().clear(); // die gesamte Zeilenliste wechhaun !
			ri.setSternZeile(-1); //das ist eine Mischungsrechnung
			//jetzt 2 Zeilen hinzufügen;
			ri.getZeilenListe().addItem("1 1 " + rz.getDatabase().getEinheiten().getEinheit("1").getID() + " [[" + String.valueOf(zutat1.getID()) + "]]\n" );
			ri.getZeilenListe().addItem("1 1 " + rz.getDatabase().getEinheiten().getEinheit("1").getID() + " [[" + String.valueOf(zutat2.getID()) + "]]\n" );
       	    // da das eine Mischungsrechnung ist, noch die Verschnittwasserzeile hinzufügen
			ri.getZeilenListe().addItem("1 0 " + rz.getDatabase().getEinheiten().getEinheit("1").getID()+ " [[" + DBRezeptur.REZEPTURWASSER + "]]");
       	    // und dann noch die SummenZeile
			ri.getZeilenListe().addItem("3 leer");
			ri.getZeilenListe().addItem("4 summe");
			ri.getZeilenListe().getItem(0).setBezeichnung(txtZutat1.getText());
			ri.getZeilenListe().getItem(1).setBezeichnung(txtZutat2.getText());
			ri.setFaktor(1);
			//double liter1=0.0,liter2=0.0;
			if(ri.getZeilenListe().getItem(1).getRezeptur().getID() == 0) {
				ri.getZeilenListe().getItem(1).setBezeichnung(rz.getLocale().getString("database.verschnittwasser"));
			}
			getLiter(/*liter1,liter2,*/txtStaerke1.getValue(),txtStaerke2.getValue(),txtGesucht.getValue(),cmbMode.getSelectedIndex());
			ri.getSumme();
	 		ri.setWasserP(0.0);
			if(rz.isZero(Math.abs(txtStaerke1.getValue() - txtGesuchtStaerke.getValue()))|| rz.isZero(Math.abs(txtStaerke2.getValue() - txtGesuchtStaerke.getValue())) ){
				ri.getZeilenListe().getItem(2).setOriginalMenge(0);
				ri.getZeilenListe().getItem(2).rechnen(1,waehrung);
				((AbstractTableModel)tblRezeptur.getModel()).fireTableDataChanged();
			}
 			anzeige();
        }
    }
    /** ermittelt die notwendigen Liter
     *
     * @param liter1
     */
    private void getLiter(/*double liter1,double liter2,*/double staerke1,double staerke2,double gesucht,int mode) {
    	double liter1=0;double liter2=0;
        final double staerke = txtGesuchtStaerke.getValue();

        if((staerke < Math.min(staerke1, staerke2)) || (staerke > Math.max(staerke1, staerke2))){
    		liter1=0.0;liter2=0.0;
            }  else {
            	ri.getZeilenListe().getItem(0).setStaerke(staerke1);
            	ri.getZeilenListe().getItem(1).setStaerke(staerke2);
 		        final double f1 = Math.abs(staerke  - staerke2);
 		        final double f2 = Math.abs(staerke - staerke1);
 		        double f = f1+f2;
 		        if(rz.isZero(f)) {
					f=1;
				}
 		        switch(mode) {
 		        	case MODE_LITER_ENDMENGE :
 		        	    liter1 = (gesucht/f) * f1;
 		        	    liter2 = (gesucht/f) * f2;
 		        	    break;
 		        	 case MODE_LITER_AUSGANGSMENGE:
 		        	     liter1=gesucht;
 		        	     liter2=(gesucht * f2)/f1;
 		        	     break;
 		        	 case MODE_KG_ENDMENGE :
 		        	    final double gl = gesucht* (1/ ri.getGesamtLitergewicht());
  		        	    liter1 = (gl/f) * f1;
 		        	    liter2 = (gl/f) * f2;

 		        	 	break;
 		        	 case MODE_KG_AUSGANGSMENGE :
 		        	     liter1=gesucht*(1/ri.getZeilenListe().getItem(0).getLitergewicht());
 		        	     liter2=(liter1*f2)/f1;
 		        	     break;
 		        	 case MODE_LA_AUSGANGSMENGE:
  		        	    if(staerke1 != 0) {
  	 		        	     liter1=(gesucht*100)/staerke1;
  	 		        	     liter2=(liter1*f2)/f1;
 		        	    }
  		        	    break;
 		        	 case MODE_LA_ENDMENGE:
 		        	    if(staerke != 0) {
 		        	        liter1 = (((gesucht*100)/staerke)/f) * f1;
 		        	        liter2 = (((gesucht*100)/staerke)/f) * f2;
 		        	    }
 		        	    break;
 		        }
            }
			ri.getZeilenListe().getItem(0).setOriginalMenge(liter1);
			ri.getZeilenListe().getItem(1).setOriginalMenge(liter2);
    }
    /** die Combobox mit den Rezepturen füllen
     */
    private void setValues() {
        RezepturItem r1;
        r1=rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),false);
        if(r1 != null) {
	        if(r1.getVerweis() != 0) {
	            zutat1=rz.getDatabase().getRezeptur().dbGetRezeptur(r1.getVerweis(),true);
	            zutat1.setTitel(r1.getTitel());
	            zutat1.setAdressListe(r1.getAdressListe());
	            zutat1.setStichwortListe(r1.getStichwortListe());
	        } else {
	            zutat1 = r1;
	        }
	        if(zutat1!=null) {
	            rz.getDatabase().getRezeptur().setAlkoholCmb(cmbZutat2,rz.getOptionFactory().getOption("einstellungen.staerkeliste"),zutat1);
	            lblZutat1.setText(zutat1.getTitel());
	            txtZutat1.setText(zutat1.getTitel());
	            txtStaerke1.setValue(zutat1.getStaerke());
	    		txtGesucht.setValue(100);
	    		txtGesuchtStaerke.setValue(zutat1.getStaerke());
	        }
	        if(cmbZutat2.getModel().getSize() > 0) {
	            if(mode ==0) {
	                cmbZutat2.setSelectedIndex(0);
	            }else {
	                cmbZutat2.setSelectedIndex(cmbZutat2.getModel().getSize()-1);
	            }
	            zutat2 = (RezepturItem)cmbZutat2.getSelectedItem();
	            if(zutat2 != null) {
	            	txtStaerke2.setValue(zutat2.getStaerke());
	            }
	        }
        }
    }

    private void zutat1Action(){
        setValues();
    }
    /** angeklickte Rezeptur ausrechnen
     */
    private void rechnenAction() {
        if(tblRezeptur.getSelectedRow() != -1) {
            final RechenZeile z = ((RechenTableModel)tblRezeptur.getModel()).getZeileAt(tblRezeptur.getSelectedRow());
        	if(z != null) {
        	    if(z.isRechnen()) {
        	        if(z.getRezeptur().getID() >0) {
                        final ErgebnisItem ei1 = new ErgebnisItem(
                        		rz,
                        		z.getRezeptur().getID(),
                        		RzPro.TYP_ID_REZEPT,
        						z.getRezeptur().getTitel(),z.getLitergewicht(),z.getAcid(),z.getRezeptur().getGeaendert(),	z.getRezeptur().getStichwortListe().toString(),z.getRezeptur().getAdressListe().toString(),0,0,0.0,false,z.getRezeptur().getBasiseinheit(),z.getStaerke(),"","",20,20,false,false);
                        ei1.setLiter(z.getLiter());
                		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_RECHNEN,false,new MessageItem(MessageItem.MSG_RECHNEN,0,ei1,this));
        	        }
        	    }
        	}
        }
    }
    /** eine Zutat zur Liste hinzufügen
     */
    private void addAction() {
		int x, y;
        x = (int)(btAdd.getLocationOnScreen().getX());
        y = (int)(btAdd.getLocationOnScreen().getY());
        if(zd != null) {
        	zd.dispose();
        	zd = null;
        }
		final ZutatenDialog zd = new ZutatenDialog(this, rz, x, y,"",ZutatenDialog.MODE_ALKOHOLHALTIG);
		zd.setVisible(true);
    }

	private void zutatenDialogReply(ZutatenSuchItem zi) {
		if(zi != null) {
			cmbZutat2.addItem(rz.getDatabase().getRezeptur().dbGetRezeptur(zi.getID(),true));
		    for(int i=0;i < cmbZutat2.getModel().getSize();i++) {
		        if(((RezepturItem)cmbZutat2.getModel().getElementAt(i)).getID() == zi.getID()) {
		            cmbZutat2.setSelectedIndex(i);
		            break;
		        }
		    }
		}
		if(zd != null) {
			zd.dispose();
			zd = null;
		}
	}

    private void zutat2Action() {
        if(cmbZutat2.getSelectedIndex() != -1) {
            txtZutat2.setText(((RezepturItem)cmbZutat2.getSelectedItem()).getTitel());
            txtStaerke2.setValue(((RezepturItem)cmbZutat2.getSelectedItem()).getStaerke());
            zutat2 = (RezepturItem)cmbZutat2.getSelectedItem();
        }
    }


	/** rezeptur ausdrucken
	 */
	private void printRezepturAction() {
	    losnummerAction();
		rz.getReportFactory().staerkeReport(ri,this);
	}

	private void verbuchen(int typ) {
		if(bd != null) {
			bd.dispose();
			bd=null;
		}
		bd = new BuchungsDialog(rz,this);
		bd.setModal(false);
		ri.getRezeptur().setStaerke(ri.getStaerke());
		ri.getRezeptur().setLitergewicht(ri.getGesamtLitergewicht());
		ri.getRezeptur().setTitel(txtZutat1.getText().trim());
		bd.setBezeichnung(txtZutat1.getText().trim());
		bd.setRezepturID(ri.getRezeptur().getID());
		bd.setSchwundsatz(ri.getRezeptur().getSchwundsatz());
		bd.setMenge(ri.getGesamtLiter());
		bd.setTyp(typ);
		bd.setTank(ri.getRezeptur().getTank());
		bd.setRProbe(ri.getRezeptur().isRProbe());
		bd.setBewertung(ri.getRezeptur().isBewertung());
		bd.showDialog();
	}
	
	private void verbuchen2() {
		if(bd.getCode() == BuchungsDialog.DIALOG_OK) {
			herstellungReturnItem ok = rz.getDatabase().getBuchungen().herstellungBuchenTransaction(ri,bd.getTyp(),bd.getSchwundsatz(),bd.getEndmenge(),!bd.getFilterschichten().equals("")? "["+rz.getLocale().getString("buchungsdialog.label_filterschichten") + bd.getFilterschichten() + "]" + bd.getBemerkungen():bd.getBemerkungen(),bd.getTank(),bd.isRProbe());
			if(bwi != null) {
				bwi.setLosnummer(ok.getLosnummer());
				rz.getDatabase().getBewertungen().saveBewertungFromHerstellung(bwi);
			}
			//final boolean ok = rz.getDatabase().getBuchungen().herstellungBuchenTransaction(ri,bd.getTyp(),bd.getSchwundsatz(),bd.getEndmenge(),bd.getBemerkungen(),bd.getTank());
            if((rz.getOptionFactory().getOption("confirm.buchung",OptionFactory.CONFIRM_ZUGANG) == 1) && (ok.isRet())) {
                dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("buchung.speichern"));
                dlgItem.setTitel(rz.getLocale().getString("buchung.speichern"));
                dlgItem.setMessage(rz.getLocale().getString("buchung.speichern_message")
                        .replaceAll("%l", rz.getLocale().formatNumber(ri.getGesamtLiter(), OptionFactory.NF_NORMAL))
                        .replaceAll("%s", ri.getBezeichnung()));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
                rz.getDialogFactory().getDialog(dlgItem);
            }
        	rz.getFensterFactory().getFensterListe().propagateBestand(this,ri.getRezepturIDS());
		}
		if(bd != null) {
			bd.dispose();
			bd = null;
		}
	}


	/** das Fenster öffnen
	 */
	public void openWindow() {
		if(zutat1 != null) {
		    if(!isVisible()) {
				setVisible(true);
			}
			toFront();
			txtGesucht.requestFocus();
		} else {
			rz.getFensterFactory().getFensterListe().disposeFrame(this);
		}
	}

	public void closeWindow() {
		if(zd != null) {
			zd.dispose();
			zd = null;
		}
	    rz.getFensterFactory().getFensterListe().disposeFrame(this);
	}


	private void einstellungenAction() {
	       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_EINSTELLUNGEN,true,new MessageItem(MessageItem.MSG_SHOW_EINSTELLUNGEN,0,null,this));
	}

	/**
	 * Säurerechner anzeigen
	 */
	private void acidRechnerAction() {
		AcidAnzeigeItem ai = null;
		if(tblRezeptur.getSelectedRow() != -1) {
			final RechenZeile z = ((RechenTableModel)tblRezeptur.getModel()).getZeileAt(tblRezeptur.getSelectedRow());
			ai = new AcidAnzeigeItem(z.getBezeichnung(),z.getLitergewicht(),z.getAcid());
		} else {
			ai = new AcidAnzeigeItem(this.ri.getRezeptur().getTitel(),ri.getGesamtLitergewicht(),ri.getGesamtAcid());
		}
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ACIDRECHNER,false,new MessageItem(MessageItem.MSG_SHOW_ACIDRECHNER,0,ai,this));
	}

	private void tafelAction() {
		TafelItem ti = null;
		if(txtGesucht.hasFocus() || txtGesuchtStaerke.hasFocus() || txtStaerke1.hasFocus() ||
				txtStaerke2.hasFocus() || txtZutat1.hasFocus() || txtZutat2.hasFocus()) {
			ti=new TafelItem(rz,txtGesuchtStaerke.getValue(),txtGesucht.getValue());
		} else if(tblRezeptur.getSelectedRow() != -1 ) {
            final RechenZeile z = ((RechenTableModel)tblRezeptur.getModel()).getZeileAt(tblRezeptur.getSelectedRow());
        	if(z != null) {
        	    if(z.isRechnen()) {
        			ti=new TafelItem(rz,z.getStaerke(),z.getLiter());
        	    	} else {
        				ti=new TafelItem(rz,txtGesuchtStaerke.getValue(),txtGesucht.getValue());
        	    	}
        	    }
		} else  {
			ti=new TafelItem(rz,txtGesuchtStaerke.getValue(),txtGesucht.getValue());
		}
		if(ti != null) {
			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TAFEL,false,new MessageItem(MessageItem.MSG_SHOW_TAFEL,0,ti,this));
		}
	}

	private void selectionChanged() {

	}
	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"staerke.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

	public void columnAdded(TableColumnModelEvent e) {
	}
	public void columnMarginChanged(ChangeEvent e) {
	}
	public void columnMoved(TableColumnModelEvent e) {
	}
	public void columnRemoved(TableColumnModelEvent e) {
	}
	public void columnSelectionChanged(ListSelectionEvent e) {
	}

	private void setTblRezepturModel(JTable t) {
	    final RechenColumnModel rcm = new RechenColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
    	tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_menge"));
    	tc.setModelIndex(C_MENGE);
    	tc.setCellRenderer(nr);
    rcm.addColumn(tc);
    	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_einheit"));
		tc.setCellRenderer(sr);
		tc.setModelIndex(C_EINHEIT);
    rcm.addColumn(tc);
	tc = new TableColumn();
    	tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_titel"));
    	tc.setModelIndex(C_TITEL);
    	tc.setCellRenderer(sr);
    rcm.addColumn(tc);
	tc = new TableColumn();
    	tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_staerke"));
    	tc.setModelIndex(C_STAERKE);
    	tc.setCellRenderer(nr);
    rcm.addColumn(tc);
	tc = new TableColumn();
    	tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_liter"));
    	tc.setModelIndex(C_LITER);
    	tc.setCellRenderer(nr);
    rcm.addColumn(tc);
	tc = new TableColumn();
    	tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_kg"));
    	tc.setModelIndex(C_KG);
    	tc.setCellRenderer(nr);
    rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_la"));
		tc.setModelIndex(C_LA);
    	tc.setCellRenderer(nr);
    rcm.addColumn(tc);
   	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_artikel"));
		tc.setModelIndex(C_ARTIKEL);
    	tc.setCellRenderer(sr);
    rcm.addColumn(tc);
   	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_losnummer"));
		tc.setModelIndex(C_LOSNUMMER);
    	tc.setCellRenderer(sr);
    rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_bestand"));
		tc.setModelIndex(C_BESTAND);
		tc.setCellRenderer(sr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_meldebestand"));
		tc.setModelIndex(C_MELDEBESTAND);
		tc.setCellRenderer(sr);
    rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_extraktfrei"));
		tc.setModelIndex(C_EXTRAKTFREI);
		tc.setCellRenderer(sr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_trockensubstanz"));
		tc.setModelIndex(C_EXTRAKT);
		tc.setCellRenderer(sr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_trockenmasse"));
		tc.setModelIndex(C_TROCKENMASSE);
		tc.setCellRenderer(sr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_acid"));
		tc.setModelIndex(C_ACID);
		tc.setCellRenderer(nr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_acidcontent"));
		tc.setModelIndex(C_ACIDCONTENT);
		tc.setCellRenderer(nr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_grundpreis"));
		tc.setModelIndex(C_GRUNDPREIS);
		tc.setCellRenderer(sr);
    rcm.addColumn(tc);
		tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_preis"));
		tc.setModelIndex(C_PREIS);
		tc.setCellRenderer(sr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_extraktfrei_liter"));
		tc.setModelIndex(C_EXTRAKTFREI_LITER);
		tc.setCellRenderer(sr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_extraktfrei_staerke"));
		tc.setModelIndex(C_EXTRAKTFREI_STAERKE);
		tc.setCellRenderer(sr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_extraktfrei_litergewicht"));
		tc.setModelIndex(C_EXTRAKTFREI_LITERGEWICHT);
		tc.setCellRenderer(sr);
	rcm.addColumn(tc);
		tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_extraktfrei_gewicht"));
		tc.setModelIndex(C_EXTRAKTFREI_GEWICHT);
		tc.setCellRenderer(sr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_brennwert_alkohol"));
		tc.setModelIndex(C_BRENNWERT_ALKOHOL);
		tc.setCellRenderer(nr);
	rcm.addColumn(tc);
	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("rechnen.tableheader_brennwert_alkoholfrei"));
		tc.setModelIndex(C_BRENNWERT_ALKOHOLFREI);
		tc.setCellRenderer(nr);
	rcm.addColumn(tc);

        rcm.addColumnModelListener(this);
        tblRezeptur.setModel(new RechenTableModel());
        tblRezeptur.setColumnModel(rcm);
        tblRezeptur.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblRezeptur.setCellSelectionEnabled(true);
        tblRezeptur.getTableHeader().setReorderingAllowed(false);
	}

	private class RechenColumnModel extends DefaultTableColumnModel{
	    public RechenColumnModel() {
	        super();
	    }

	}

	private  class RechenTableModel extends AbstractTableModel    {


		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(ri != null) {
	                return ri.getZeilenListe().size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public RechenZeile getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (ri != null)) {
	        		return ri.getZeilenListe().getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            final RechenZeile z = ri.getZeilenListe().getItem(rowIndex);
	            switch(z.getTyp()) {
	            	case ZEILE_RECHNEN:
	            	    ret = getContent(z,columnIndex);
	            	    break;
	            	case ZEILE_KOMMENTAR:
	            	    if(columnIndex == C_TITEL) {
	            	        ret = z.getBezeichnung();
	            	    } else {
	            	        ret =null;
	            	    }
	            	    break;
	            	case ZEILE_LEER:
	            	    ret = null;
	            	    break;
	            	case ZEILE_SUMME:
	            	    ret = getSumme(columnIndex);
	            	    break;

	            }
	            return ret;
	        }

	        private Object getContent(RechenZeile z,int aColumn) {
	            Object ret = null;
	            String r = "";
	            switch(aColumn) {
	            	case C_MENGE: ret = rz.getLocale().formatNumber(z.getMenge(),OptionFactory.NF_NORMAL); break;
	            	case C_EINHEIT: ret = z.getEinheit().getName();break;
	            	case C_TITEL: ret = z.getBezeichnung();break;
	            	case C_STAERKE: ret = rz.getLocale().formatNumber(z.getStaerke(),OptionFactory.NF_NORMAL);break;
	            	case C_LITER: ret = rz.getLocale().formatNumber(z.getLiter(),OptionFactory.NF_NORMAL);break;
	            	case C_KG: ret = rz.getLocale().formatNumber(z.getKg(),OptionFactory.NF_NORMAL);break;
	            	case C_LA: ret = rz.getLocale().formatNumber(z.getLa(),OptionFactory.NF_NORMAL);break;
	            	case C_ARTIKEL: ret = z.getRezeptur().getArtikelnummer();break;
	            	case C_LOSNUMMER: ret=z.getRezeptur().getLosnummer();break;
	            	case C_BESTAND:
	            		r = rz.getLocale().formatNumber(z.getRezeptur().getBestand(),OptionFactory.NF_NORMAL);
					 	r += " ";
					 	r += rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(z.getRezeptur().getBestandseinheit())).getName();
					 	ret = (Object)r;
					break;
	            	case C_MELDEBESTAND:
	            		r = rz.getLocale().formatNumber(z.getRezeptur().getMeldebestand(),OptionFactory.NF_NORMAL);
					 	r += " ";
					 	r += rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(z.getRezeptur().getBestandseinheit())).getName();
					 	ret = (Object)r;
					 	break;
	            	case C_EXTRAKTFREI: ret = z.getRezeptur().getExtraktfrei()==true ? rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein");
	            	    break;
	            	case C_EXTRAKT : ret = z.getRezeptur().getExtraktfrei() ==true ? " " : rz.getLocale().formatNumber(z.getExtrakt(),OptionFactory.NF_NORMAL);
	            		break;
	            	case C_TROCKENMASSE : ret = z.getRezeptur().getExtraktfrei() ==true ? " " : rz.getLocale().formatNumber(z.getTrockenmasse(),OptionFactory.NF_NORMAL);
            			break;
	            	case C_ACID : ret = rz.getLocale().formatNumber(z.getAcid(),OptionFactory.NF_NORMAL); break;
	            	case C_ACIDCONTENT : ret = rz.getLocale().formatNumber(z.getAcidContent(),OptionFactory.NF_NORMAL); break;
	            	case C_EXTRAKTFREI_LITER:ret =rz.getLocale().formatNumber(z.getExtraktfreiLiter(),OptionFactory.NF_NORMAL) ;
                        break;
                    case C_EXTRAKTFREI_STAERKE:ret =rz.getLocale().formatNumber(z.getExtraktfreiStaerke(),OptionFactory.NF_STAERKE) ;
                    	break;
                    case C_EXTRAKTFREI_LITERGEWICHT:ret = rz.getLocale().formatNumber(z.getExtraktfreiLitergewicht(),OptionFactory.NF_LITERGEWICHT) ;
                    	break;
                    case C_EXTRAKTFREI_GEWICHT:ret = rz.getLocale().formatNumber(z.getExtraktfreiKg(),OptionFactory.NF_NORMAL) ;
                    	break;
                    case C_GRUNDPREIS:ret =z.getGrundPreis();
                    	break;
                    case C_PREIS: ret = rz.getLocale().formatNumber(z.getKalkulationBetrag(),OptionFactory.NF_NORMAL);
                    	break;
	            }
	            return ret;
	        }
	        private Object getSumme(int aColumn) {
	            Object ret = null;
	            switch(aColumn) {
	            	case C_LITER: ret = rz.getLocale().formatNumber(ri.getSummeLiter(),OptionFactory.NF_NORMAL);break;
	            	case C_KG: ret = rz.getLocale().formatNumber(ri.getSummeKg(),OptionFactory.NF_NORMAL);break;
	            	case C_LA: ret =rz.getLocale().formatNumber(ri.getSummeLA(),OptionFactory.NF_NORMAL);break;
                    case C_EXTRAKTFREI_GEWICHT:ret = rz.getLocale().formatNumber(ri.getSummeExtraktfreiKg(),OptionFactory.NF_NORMAL) ;break;
                    case C_EXTRAKTFREI_LITER:ret =rz.getLocale().formatNumber(ri.getSummeExtraktfreiLiter(),OptionFactory.NF_NORMAL) ;break;
                    case C_ACIDCONTENT:ret =rz.getLocale().formatNumber(ri.getSummeAcid(),OptionFactory.NF_NORMAL) ;break;
                    case C_TROCKENMASSE : ret = ri.getRezeptur().getExtraktfrei() ==true ? " " : rz.getLocale().formatNumber(ri.getSummeTrockenMasse(),OptionFactory.NF_NORMAL);break;
                    case C_PREIS: ret = rz.getLocale().formatNumber(ri.getSummeKalkulation(),OptionFactory.NF_NORMAL);break;
	            }
	            return ret;
	        }
		}

	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	if(row != -1) {
	    		final RechenZeile z = ri.getZeilenListe().getItem(row);
		        if(isSelected) {
		            setBackground(Color.CYAN);
		        } else {
		            setBackground(z.getFarbe());
		        }
	    	}

	        if(value != null) {
	           if(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_NORMAL) != 0 ) {
	               setText(value.toString());
	           } else {
				setText("");
			}
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	if(row != -1) {
	    		final RechenZeile z = ri.getZeilenListe().getItem(row);
		        if(isSelected) {
		            setBackground(Color.CYAN);
		        } else {
		            setBackground(z.getFarbe());
		        }
	    	}

	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}



}

