package de.lunqual.rzpro.fenster.rzDatePicker;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.time.DayOfWeek;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.DateChangeListener;
import com.github.lgooddatepicker.optionalusertools.DateVetoPolicy;
import com.github.lgooddatepicker.zinternaltools.DateChangeEvent;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JIntegerField;

public class RzAuftragDatePicker extends JPanel{

	
	private static final int				BUTTON_UP 			= 1;
	private static final int				BUTTON_DOWN 		= 2;
	private static final int				BUTTON_UP_WEEKS		= 3;
	private static final int				BUTTON_DOWN_WEEKS 	= 4;
	RzPro 										rz;
	JPanel										pickerPanel;
	JPanel										buttonPanel;
		JButton									btUp;
		JButton									btDown;
		JButton									btWUp;
		JButton									btWDown;
	JPanel										dateButtonPanel;
		JButton									btHeute;
		JButton									bt1Tag;
		JButton									bt2Tag;
		JButton									bt3Tag;
		JButton									btDieseWoche;
		JButton									btNaechsteWoche;
		JButton									bt1Woche;
		JButton									bt2Wochen;
		JButton									bt3Wochen;
		JButton									bt4Wochen;
		JLabel									lblKW;
		JIntegerField							txtKW;
		
	private static final int					BT_HEUTE = 1;
	private static final int					BT_1TAG = 2;
	private static final int					BT_2TAG = 3;
	private static final int					BT_3TAG = 4;
	private static final int					BT_DIESE_WOCHE = 5;
	private static final int					BT_NAECHSTE_WOCHE = 6;
	private static final int					BT_1WOCHE = 7;
	private static final int					BT_2WOCHEN = 8;
	private static final int					BT_3WOCHEN = 9;
	private static final int					BT_4WOCHEN = 10;	

	private static final int					FORWARD = 1;
	private static final int					BACKWARD = 2;	
		
	ImageIcon								icon;
	 List<pickerCalendarListener> 	listeners; 
	DatePicker								picker;
	 DatePickerSettings 				settings; 

	public RzAuftragDatePicker(RzPro rz) {
		this.rz = rz;
		initComponent();
		picker.setDate(LocalDate.now());
	}

	public RzAuftragDatePicker(RzPro rz,Calendar datum) {
		super();
		this.rz = rz;
		initComponent();
		setStartDate(datum);
	}

	public Calendar getDate() {
		return getSelectedDate();
	}
	
	public void setStartDate(Calendar datum) {
		if(datum == null) {
			LocalDate d = rz.getDatabase().getAuftrag().getAuftragsConfig().goForward(LocalDate.now(),0);
			picker.setDate(d);
		} else {
			picker.setDate(Calendar2local(datum));
		}
	  	settings.setVetoPolicy(new VetoPolicy(rz));
	}
	
	private void initComponent() {
		listeners = new ArrayList<pickerCalendarListener>();
		this.setLayout(new BorderLayout());
		this.setBorder(BorderFactory.createEtchedBorder());
		pickerPanel = new JPanel(new BorderLayout());
		
		/*
		 * Date Picker
		 */
		icon = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rzdatepicker_icon.png"));
		
		 settings = new DatePickerSettings();
	        	settings.setFormatForDatesCommonEra(rz.getOptionFactory().getOption("rzsimpledatepicker.format"));
	        	settings.setWeekNumbersDisplayed(true, true);
		picker = new DatePicker(settings);	
        	JButton datePickerButton = picker.getComponentToggleCalendarButton();
        	datePickerButton.setText("");
        	datePickerButton.setIcon(icon);
        	picker.addDateChangeListener(new DateChangeListener() {

			@Override
				public void dateChanged(DateChangeEvent event) {
					dateNew( );
			}});
        
		/*
		 * Panels
		 */
		pickerPanel.add(picker,BorderLayout.CENTER);
		buttonPanel = new JPanel(new GridLayout(1,2));
			btWDown = new JButton();
			btWDown.setText("--");
			btWDown.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		dateButton(BUTTON_DOWN_WEEKS);
	        	}
		    });
		buttonPanel.add(btWDown);
			btDown = new JButton();
				btDown.setText("-");
				btDown.addActionListener(new ActionListener() {
    	        	public void actionPerformed(ActionEvent evt) {
    	        		dateButton(BUTTON_DOWN);
    	        	}
        	    });
			buttonPanel.add(btDown);
			btUp = new JButton();
			btUp.setText("+");
			btUp.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		dateButton(BUTTON_UP);
	        	}
		    });
		buttonPanel.add(btUp);

		btWUp = new JButton();
			btWUp.setText("++");
			btWUp.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		dateButton(BUTTON_UP_WEEKS);
	        	}
		    });
		buttonPanel.add(btWUp);		
		pickerPanel.add(buttonPanel,BorderLayout.WEST);
		this.add(pickerPanel,BorderLayout.NORTH);
		
		dateButtonPanel = new JPanel(new GridLayout(3,4));
			btHeute = new JButton();
			btHeute.setText(rz.getLocale().getString("picker.auftrag.button.heute"));
			btHeute.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_HEUTE);
	        	}
    	    });
			dateButtonPanel.add(btHeute);
			
			bt1Tag  = new JButton(); 
			bt1Tag.setText(rz.getLocale().getString("picker.auftrag.button.1tag"));
			bt1Tag.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_1TAG);
	        	}
    	    });
			dateButtonPanel.add(bt1Tag);
			
			bt2Tag  = new JButton(); 
			bt2Tag.setText(rz.getLocale().getString("picker.auftrag.button.2tag"));
			bt2Tag.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_2TAG);
	        	}
    	    });
			dateButtonPanel.add(bt2Tag);
			
			bt3Tag  = new JButton();
			bt3Tag.setText(rz.getLocale().getString("picker.auftrag.button.3tag"));
			bt3Tag.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_3TAG);
	        	}
    	    });
			dateButtonPanel.add(bt3Tag);
			
			btDieseWoche  = new JButton();
			btDieseWoche.setText(rz.getLocale().getString("picker.auftrag.button.diese_woche"));
			btDieseWoche.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_DIESE_WOCHE);
	        	}
    	    });
			dateButtonPanel.add(btDieseWoche);
			
			btNaechsteWoche  = new JButton(); 
			btNaechsteWoche.setText(rz.getLocale().getString("picker.auftrag.button.naechste_woche"));
			btNaechsteWoche.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_NAECHSTE_WOCHE);
	        	}
    	    });
			dateButtonPanel.add(btNaechsteWoche);
			
			bt1Woche  = new JButton();
			bt1Woche.setText(rz.getLocale().getString("picker.auftrag.button.1woche"));
			bt1Woche.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_1WOCHE);
	        	}
    	    });
			dateButtonPanel.add(bt1Woche);
			
			bt2Wochen = new JButton();
			bt2Wochen.setText(rz.getLocale().getString("picker.auftrag.button.2wochen"));
			bt2Wochen.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_2WOCHEN);
	        	}
    	    });
			dateButtonPanel.add(bt2Wochen);
			
			bt3Wochen = new JButton();
			bt3Wochen.setText(rz.getLocale().getString("picker.auftrag.button.3wochen"));
			bt3Wochen.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_3WOCHEN);
	        	}
    	    });
			dateButtonPanel.add(bt3Wochen);
			
			bt4Wochen = new JButton();
			bt4Wochen.setText(rz.getLocale().getString("picker.auftrag.button.4wochen"));
			bt4Wochen.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(BT_4WOCHEN);
	        	}
    	    });
			dateButtonPanel.add(bt4Wochen);
			
			lblKW = new JLabel();
			lblKW.setText(rz.getLocale().getString("picker.auftrag.label.kw"));
			lblKW.setHorizontalAlignment(SwingConstants.TRAILING);
			dateButtonPanel.add(lblKW);
			
			txtKW = new JIntegerField(1,1,53);
			txtKW.addKeyListener(new java.awt.event.KeyAdapter() {
	            public void keyReleased(java.awt.event.KeyEvent evt) {
	            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	            	    setWeekNumber(txtKW.getValue());
	            	}
	            }
	        });
			dateButtonPanel.add(txtKW);
			
			add(dateButtonPanel,BorderLayout.CENTER);
			pickerPanel.setBorder(BorderFactory.createEtchedBorder());
			dateButtonPanel.setBorder(BorderFactory.createEtchedBorder());
			
	}
	
	
	private void buttonPressed(int which) {
		LocalDate neu =LocalDate.now();
		switch(which) {
			case BT_HEUTE :
				neu = rz.getDatabase().getAuftrag().getAuftragsConfig().goForward(neu, 0);
				break;
			case BT_1TAG :
				neu = rz.getDatabase().getAuftrag().getAuftragsConfig().goForward(neu, 1);
				break;
			case BT_2TAG :
				neu = rz.getDatabase().getAuftrag().getAuftragsConfig().goForward(neu, 2);
				break;
			case BT_3TAG :
				neu = rz.getDatabase().getAuftrag().getAuftragsConfig().goForward(neu, 3);
				break;
			case BT_DIESE_WOCHE :
				neu = neu.plusDays(DayOfWeek.SUNDAY.getValue() - neu.getDayOfWeek().getValue() );
    			neu = rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(neu,false);
				break;   
			case BT_NAECHSTE_WOCHE :
				neu = neu.plusDays(7 + DayOfWeek.SUNDAY.getValue() - neu.getDayOfWeek().getValue() );
    			neu = rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(neu,false);
				break;
			case BT_1WOCHE :
				neu = neu.plusDays(7);
    			neu = rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(neu,false);
				break;        
			case BT_2WOCHEN :
				neu = neu.plusDays(14);
    			neu = rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(neu,false);
				break;       
			case BT_3WOCHEN :
				neu = neu.plusDays(21);
    			neu = rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(neu,false);
				break;       
			case BT_4WOCHEN :
				neu = neu.plusDays(28);
    			neu = rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(neu,false);
				break;	  
		}
		picker.setDate(neu);
	}
	
	private void setWeekNumber(int value) {
		picker.setDate( LocalDate.of(picker.getDate().getYear(), picker.getDate().getMonth(), picker.getDate().getDayOfMonth()).with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, value).with(ChronoField.DAY_OF_WEEK, DayOfWeek.MONDAY.getValue()));
	}
	
	
	private void dateButton(int direction) {
		try {
			switch (direction) {
				case BUTTON_UP:
					picker.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().goForward(picker.getDate(), 1));
					break;
				case BUTTON_DOWN:
					picker.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().goBack(picker.getDate(), 1));
					break;
				case BUTTON_DOWN_WEEKS:
					picker.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().goBackWeeks(picker.getDate(), 1));
					break;
				case BUTTON_UP_WEEKS:
					picker.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().goForwardWeeks(picker.getDate(), 1));
					break;

			}
		}
		catch(NullPointerException n) {}
	}
	
	private void dateNew() {
		picker.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(picker.getDate(),true));
        for (pickerCalendarListener hl : listeners) {
            hl.calendarChanged(getSelectedDate());
        }
		TemporalField woy = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear(); 
		int weekNumber = picker.getDate().get(woy);
		txtKW.setValue(weekNumber);
	}
	
	
	private LocalDate Calendar2local(Calendar datum) {
		return  datum.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
	}
	
	private Calendar getSelectedDate(){
		Calendar c = Calendar.getInstance();
		try {
			LocalDateTime time = picker.getDate().atStartOfDay();
			c.clear();
			c.set(Calendar.YEAR, time.getYear());
			c.set(Calendar.MONTH, time.getMonthValue()-1);
			c.set(Calendar.DAY_OF_MONTH,time.getDayOfMonth());
			c.set(Calendar.HOUR, time.getHour());
			c.set(Calendar.MINUTE, time.getMinute());
			c.set(Calendar.SECOND, time.getSecond());
		}catch(NullPointerException n) {
			
		}
		return c;
	}

	 public void addListener(pickerCalendarListener toAdd) {
	        listeners.add(toAdd);
	    }
}

class VetoPolicy implements DateVetoPolicy {
    RzPro rz;
    VetoPolicy(RzPro rz) {
    	this.rz = rz;
    }
    public boolean isDateAllowed(LocalDate date) {
    	return rz.getDatabase().getAuftrag().getAuftragsConfig().isFeiertag(date)?false:true;
    }
}

