/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.rezepturfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.CSVExport;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.items.rezeptur.ChangesFilterListe;
import de.lunqual.rzpro.items.rezeptur.ChangesItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class Changes extends JRzFrame  implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
		private JPanel toolbarPanel;
			private JToolBar tb1;
    	private JPanel contentPanel;
	    	private JPanel auswahlPanel;
	    		private JPanel auswahlButtonPanel;
		    		private ButtonGroup auswahlGroup;
		    			private JRadioButton btAuswahlRelevante;
		    			private JRadioButton btAuswahlAlle;
		    		private JPanel filterPanel;
		    			private JButton btSetFilterButton;
		    			private JLabel lblFilterliste;
	    		private JButton btRefresh;
	    	private JPanel anzeigePanel;
	    		private JScrollPane scrAnzeige;
	    			private JTable tblAnzeige;
    	private JPanel buttonPanel;
    		private JButton btHilfe;
    		private JComboBox cmbFormulare;
    		private JButton btDrucken;
    		private JButton btVorschau;
    		private JButton btCsvFile;
    		private JButton btCsvCopy;
    		private JButton btClose;


    		
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      		ACTION_CLOSE_TEXT = "changes.action_close";
    public static final int         		ACTION_HILFE_CODE = 1003;
    public static final String      		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1004;
    public static final String      		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1005;
    public static final String      		ACTION_REFRESH_TEXT = "changes.action_refresh";
    public static final int         		ACTION_PRINT_CODE = 1006;
    public static final String      		ACTION_PRINT_TEXT = "changes.action_print";
    public static final int         		ACTION_VORSCHAU_CODE = 1007;
    public static final String      		ACTION_VORSCHAU_TEXT = "changes.action_vorschau";
    public static final int         		ACTION_FILTER_CODE = 1008;
    public static final String      		ACTION_FILTER_TEXT = "changes.action_filter";
    public static final int         		ACTION_CSV_FILE_CODE = 1009;
    public static final String      		ACTION_CSV_FILE_TEXT = "csv.export_file";
    public static final int         		ACTION_CSV_COPY_CODE = 1010;
    public static final String      		ACTION_CSV_COPY_TEXT = "csv.export_copy";
    

    public static final int				MAX_COLUMNS = 9;
    public static final int				C_STATUS = 0;
    public static final	int				C_DATUM = 1;
    public static final int 				C_UHRZEIT = 2;
    public static final int				C_USER = 3;
    public static final int				C_REZEPTUR = 4;
    public static final int				C_STICHWORTE = 5;
    public static final int				C_FELD = 6;
    public static final int				C_ALT = 7;
    public static final int				C_NEU = 8;
    

    int											rezeptur_id=-1;
    ArrayList<ChangesItem>						liste=null;
    int											mode=RzPro.TYP_ID_REZEPT;
    
    ChangesFilterListe						filterliste;
    changesFilterAuswahl					filterAuswahl;
    
    /** Creates new form AusstattungsFenster */
    public Changes(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        filterliste = new ChangesFilterListe(r,true);
        String filter = rz.getOptionFactory().getOption("changesfenster.filterliste");
        if(filter.trim().equals("")) {
        	filterliste.setCheckForAll(true);
        } else {
        	filterliste.setCheckForAll(false);
        	String s[] = filter.split(",");
        	for(int i=0;i < s.length;i++){
        		try {
        			int n = Integer.parseInt(s[i].trim());
        			filterliste.getItem(n).setChecked(true);
        		}catch(Exception e) {}
        	}
        }
        setFilterLabel();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
	    		auswahlPanel = new JPanel(new BorderLayout());
	    			auswahlButtonPanel = new JPanel(new BorderLayout());
			    		auswahlGroup = new ButtonGroup();
		    				btAuswahlRelevante = new JRadioButton();
		    					btAuswahlRelevante.setSelected(true);
		    			    btAuswahlAlle =  new JRadioButton();
		    			    auswahlGroup.add(btAuswahlRelevante);
		    			    auswahlGroup.add(btAuswahlAlle);
		    			    btAuswahlRelevante.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		refreshAction();
		        	        	}
			        	    });
		    			    btAuswahlAlle.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		refreshAction();
		        	        	}
			        	    });
		    			auswahlButtonPanel.add(btAuswahlRelevante,BorderLayout.NORTH);
		    			auswahlButtonPanel.add(btAuswahlAlle,BorderLayout.SOUTH);
		    		auswahlPanel.add(auswahlButtonPanel,BorderLayout.NORTH);	  
	    			filterPanel = new JPanel(new BorderLayout());
	    				btSetFilterButton = new JButton();
	    				filterPanel.add(btSetFilterButton,BorderLayout.WEST);
	    				lblFilterliste = new JLabel();
	    				filterPanel.add(lblFilterliste,BorderLayout.CENTER);
	    			auswahlPanel.add(filterPanel,BorderLayout.CENTER);
		    		btRefresh = new JButton();
	    		auswahlPanel.add(btRefresh,BorderLayout.SOUTH);
	    		contentPanel.add(auswahlPanel,BorderLayout.NORTH);
		    		anzeigePanel= new JPanel(new BorderLayout());
		    			scrAnzeige=new JScrollPane();
		    			tblAnzeige = new JTable();
    						tblAnzeige.setName("changes.spalten");
	    			        tblAnzeige.setShowGrid(true);
	    					tblAnzeige.setGridColor(Color.GRAY);
    						scrAnzeige.setViewportView(tblAnzeige);
		    		anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
	    		contentPanel.add(anzeigePanel,BorderLayout.CENTER);
			
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new GridLayout(1,7));

				btClose = new JButton();
				buttonPanel.add(btClose);
				cmbFormulare = new JComboBox();
		    	rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_CHANGES);
        	    cmbFormulare.addActionListener(new ActionListener() {
    	        	public void actionPerformed(ActionEvent evt) {
    	        		if(cmbFormulare.getSelectedIndex() != -1) {
    	        			rz.getOptionFactory().setOption("report.changes",((ReportItem)cmbFormulare.getSelectedItem()).getID());
    	        		}
    	        	}
                });
				buttonPanel.add(cmbFormulare);
				btDrucken=new JButton();
				buttonPanel.add(btDrucken);
				btVorschau=new JButton();
				buttonPanel.add(btVorschau);
				btCsvFile = new JButton();
				buttonPanel.add(btCsvFile);
				btCsvCopy = new JButton();
				buttonPanel.add(btCsvCopy);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);



			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("changes.fenster.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_PRINT_CODE));
      mnuDatei.add(getAction(ACTION_VORSCHAU_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CSV_FILE_CODE));
      mnuDatei.add(getAction(ACTION_CSV_COPY_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
      btDrucken.setAction(getAction(ACTION_PRINT_CODE));
      btVorschau.setAction(getAction(ACTION_VORSCHAU_CODE));
      btSetFilterButton.setAction(getAction(ACTION_FILTER_CODE));
      btCsvFile.setAction(getAction(ACTION_CSV_FILE_CODE));
      btCsvCopy.setAction(getAction(ACTION_CSV_COPY_CODE));
      btAuswahlRelevante.setText(rz.getLocale().getString("changes.label_relevante"));
      btAuswahlAlle.setText(rz.getLocale().getString("changes.label_alle"));
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_PRINT_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_CSV_COPY_CODE));
      tb1.add(getAction(ACTION_CSV_FILE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      settblAnzeigeModel(tblAnzeige);
      
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }


    
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_REFRESH_CODE:refreshAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_PRINT_CODE:printAction(false);break;
                case ACTION_VORSCHAU_CODE:printAction(true);break;
                case ACTION_FILTER_CODE:filterAction();break;
                case ACTION_CSV_FILE_CODE:csvFileExportAction();break;
                case ACTION_CSV_COPY_CODE:csvCopyExportAction();break;
                default :
                    break;
               }
        		break;
            case MessageItem.MSG_SHOW_CHANGES_AUSSTATTUNG:
            	mode = RzPro.TYP_ID_NOTIZ;
         	   	rezeptur_id=msg.getCode();
				this.btAuswahlAlle.setEnabled(false);
				this.btAuswahlRelevante.setEnabled(false);
         	    refreshAction();
         	    break;
            case MessageItem.MSG_SHOW_CHANGES_NOTIZ:
            	mode = RzPro.TYP_ID_NOTIZ;
         	   	rezeptur_id=msg.getCode();
				this.btAuswahlAlle.setEnabled(false);
				this.btAuswahlRelevante.setEnabled(false);
         	    refreshAction();
         	    break;
           case MessageItem.MSG_SHOW_CHANGES:
        	   mode=RzPro.TYP_ID_REZEPT;
        	   rezeptur_id=msg.getCode();
        	   refreshAction();
        	   break;
        	   
           case MessageItem.MSG_CHANGESFILTER_DIALOG_REPLY:
        	   if(msg.getData() != null) {
       			ChangesFilterListe reply = (ChangesFilterListe)msg.getData();
       			checkFilterliste(reply);
       			saveFilterListe();
       			refreshAction();
       		}
        	   break;
            default:
                break;
        }
    }


     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_PRINT_CODE),new AuswahlAction(rz,this,ACTION_PRINT_CODE,ACTION_PRINT_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_VORSCHAU_CODE),new AuswahlAction(rz,this,ACTION_VORSCHAU_CODE,ACTION_VORSCHAU_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_FILTER_CODE),new AuswahlAction(rz,this,ACTION_FILTER_CODE,ACTION_FILTER_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_CSV_FILE_CODE),new AuswahlAction(rz,this,ACTION_CSV_FILE_CODE,ACTION_CSV_FILE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_CSV_COPY_CODE),new AuswahlAction(rz,this,ACTION_CSV_COPY_CODE,ACTION_CSV_COPY_TEXT, 0 ,0));
     }

     private void csvFileExportAction() {
    	 rz.getCSVExport().AenderungenCSV(liste, CSVExport.EXPORT_FILE);
    	 
     }
     
     private void csvCopyExportAction () {
    	 rz.getCSVExport().AenderungenCSV(liste, CSVExport.EXPORT_COPY);
     }
     
     private void saveFilterListe() {
    	 String filter = "";
    	 for(int i=0;i < filterliste.size();i++) {
    		 if(filterliste.getItem(i).isChecked()) {
    			 filter += i + ",";
    		 }
    	 }
    	 if(filter.endsWith(",")) {
    		 filter = filter.substring(0,filter.length()-1);
    	 }
    	 rz.getOptionFactory().setOption("changesfenster.filterliste", filter);
    	 rz.getOptionFactory().saveOptions();
     }
     
     private void checkFilterliste(ChangesFilterListe reply) {
    	 for(int i = 0;i < reply.size();i++) {
    		 String r = reply.getItem(i).getBezeichnung().trim();
        	 for(int j=0;j<filterliste.size();j++) {
        		 if(reply.getItem(i).isChecked()) {
        			String s = filterliste.getItem(j).getBezeichnung().trim();
        			if(r.equals(s)) {
        				filterliste.getItem(i).setChecked(true);
        				break;
        			}
        			
        		 }
        	 }
    	 }
    	 setFilterLabel();
     }
     
     private void setFilterLabel() {
    	 lblFilterliste.setText("");
    	 String s = "";
    	 for (int i=0;i< filterliste.size();i++) {
    		 if(filterliste.getItem(i).isChecked()) {
    			 s += filterliste.getItem(i).getBezeichnung() + " ";
    		 }
    	 }
    	 lblFilterliste.setText("<html>" + s + "</html>");
     }
     
     private void filterAction() {
 			int x, y;
    		x = (int) (btSetFilterButton.getLocationOnScreen().getX() );
    		y = (int) (btSetFilterButton.getLocationOnScreen().getY() );
    		if(filterAuswahl != null) {
    			filterAuswahl.dispose();
    			filterAuswahl= null;
    		}
    		filterAuswahl = new changesFilterAuswahl(this, rz, x, y,filterliste);
    		filterAuswahl.setVisible(true);
    	}
     
     private void printAction(boolean vorschau) {
    	 if(liste != null && !liste.isEmpty()) {
    		 rz.getReportFactory().changesReport(liste,vorschau,this);
    	 }
     }
     
     private void refreshAction() {
    	 rz.setWaitCursor(this);
    	 liste=null;
    	 ArrayList<ChangesItem> liste1;
    	 if(rezeptur_id > 0) {
    		switch(mode) {
    			case RzPro.TYP_ID_REZEPT:
			    	liste1 = rz.getDatabase().getChanges().getChanges(rezeptur_id,btAuswahlRelevante.isSelected()?true:false);
			    	liste = new ArrayList<ChangesItem>();
			    	for(int i = 0;i < liste1.size();i++) {
			    		if(outputAllowed(liste1.get(i))) {
			    			liste.add(liste1.get(i));
			    		}
			    	}
		    	break;
    			case RzPro.TYP_ID_NOTIZ:
    			case RzPro.TYP_ID_AUSSTATTUNG:
			    	liste1 = rz.getDatabase().getChanges().getChanges(rezeptur_id,false);
			    	liste = new ArrayList<ChangesItem>();
			    	for(int i = 0;i < liste1.size();i++) {
			    		if(outputAllowed(liste1.get(i))) {
			    			liste.add(liste1.get(i));
			    		}
			    	}
    				break;
    		}
    	 }
         ((AbstractTableModel)tblAnzeige.getModel()).fireTableDataChanged();
         rz.setFreeCursor(this);
     }
     
     private boolean outputAllowed(ChangesItem ci) {
    	boolean ret = false;
    	String s = ci.getBezeichnung().trim();
    	for(int i = 0;i < filterliste.size();i++) {
    		if(filterliste.getItem(i).isChecked() && filterliste.getItem(i).getBezeichnung().trim().equals(s)) {
    			return true;
    		}
    	}
    	return ret;
     }
     
    @Override
	public void openWindow(){
    	if(liste != null) {
	        if(!isVisible()) {
				setVisible(true);
			}
        toFront();
        btClose.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


  

    /**
     * Die Daten aus der Struktur ins GUI übernehmen
     *
     */
    private void fromItem(AusstattungsItem as) {

    }
    /**
     * Die Daten aus dem GUI in die Struktur übertragen
     *
     */
    private void toItem(AusstattungsItem as) {

    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"changes.html",this));
    }

    
    private void settblAnzeigeModel(final JTable t) {
	    final ausgabeColumnModel rcm = new ausgabeColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("changesliste.tableheader_c_status"));
	    	tc.setModelIndex(C_STATUS);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("changesliste.tableheader_c_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("changesliste.tableheader_c_uhrzeit"));
	    	tc.setModelIndex(C_UHRZEIT);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("changesliste.tableheader_c_user"));
	    	tc.setModelIndex(C_USER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("changesliste.tableheader_c_rezeptur"));
	    	tc.setModelIndex(C_REZEPTUR);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("changesliste.tableheader_c_stichworte"));
	    	tc.setModelIndex(C_STICHWORTE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("changesliste.tableheader_c_feld"));
	    	tc.setModelIndex(C_FELD);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("changesliste.tableheader_c_alt"));
	    	tc.setModelIndex(C_ALT);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("changesliste.tableheader_c_neu"));
	    	tc.setModelIndex(C_NEU);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    
	    
        rcm.addColumnModelListener(this);
        tblAnzeige.setModel(new ausgabeTableModel());
        tblAnzeige.setColumnModel(rcm);
        tblAnzeige.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblAnzeige.getTableHeader().setReorderingAllowed(false);
        rz.setPreferredRowHeights(t);
        TableModelListener l = new TableModelListener() {
			public void tableChanged(TableModelEvent e) {
		         SwingUtilities.invokeLater(new Runnable() {
		              public void run() {
		                  rz.setPreferredRowHeights(t);
		              }
		         });
			}
	     }; 
		 t.getModel().addTableModelListener(l);
	}
    
	private class ausgabeColumnModel extends DefaultTableColumnModel{
	    public ausgabeColumnModel() {
	        super();
	    }
	}
    
	private  class ausgabeTableModel extends AbstractTableModel    {

    	Icon						relevant;
    	Icon						nicht_relevant;
    	
        SimpleDateFormat dfDatum;
        SimpleDateFormat dfZeit;

        public ausgabeTableModel() {
        	try {
        		relevant = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/ausgabe.icon_relevant.png"));
        		nicht_relevant = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/ausgabe.icon_irrelevant.png"));
        	}catch (Exception e) {
        	}
            dfDatum = new SimpleDateFormat("EEEE dd. MMMM yyyy");
            dfZeit = new SimpleDateFormat("HH:mm");
        }

	   public int getColumnCount() {
	       	return MAX_COLUMNS;
        }
        public int getRowCount() {
        	if(liste != null) {
                return liste.size();
        	} else {
        		return 0;
        	}
        }

        public ChangesItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (liste != null)) {
        		return liste.get(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (liste != null)) {
                ret = getContent(liste.get(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(ChangesItem ci,int aColumn,int row) {
            Object ret = null;
            if(ci != null) {
	            switch(aColumn){
	            	case C_DATUM:
	            		ret = dfDatum.format(ci.getErstellt());
	            		if(row > 0) {
	            			if(dfDatum.format(liste.get(row-1).getErstellt()).equals(dfDatum.format(ci.getErstellt()))){
	            				ret =  ":" + ret; 
	            			} 
	            		}
	            		break;
	            	case C_UHRZEIT:
	            		ret = dfZeit.format(ci.getErstellt());
	            		if(row > 0) {
	            			if(dfZeit.format(liste.get(row-1).getErstellt()).equals(dfZeit.format(ci.getErstellt()))){
	            				ret = ":" + ret;
	            			}
	            		}
	            		break;
	            	case C_STATUS:
	            		ret = ci.isRelevant()?relevant:nicht_relevant;
	            		break;
	            	case C_USER:
	            		ret = ci.getUser();
	            		break;
	            	case C_REZEPTUR:
	            		ret = ci.getRezeptur();
	            		break;
	            	case C_STICHWORTE:
	            		ret = ci.getStichworte().toHTMLBarString();
	            		break;
	            	case C_FELD:
	            		ret = ci.getBezeichnung();
	            		break;
	            	case C_ALT:
	            		ret = ci.getAltHTML();
	            		break;
	            	case C_NEU:
	            		ret = ci.getNeuHTML();
	            		break;
	            }
            }
            return ret;
        }
	}

	
	
	private class IconRenderer extends DefaultTableCellRenderer {
		Color light;
		
	    IconRenderer() {
	        super();
	        light = new Color(240,240,240);
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,Object value, boolean isSelected, boolean hasFocus, int row,int column)
	    {
	        if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
            }else {
            	if(row % 2 == 0) {
            		setBackground(light);
            	}else{
            		setBackground(Color.WHITE);
            	}
            }
	        setText("");
	        setIcon((Icon)value);
	    return this;
	    }
	}
	
	private class StringRenderer extends DefaultTableCellRenderer {
		Color light;
	    StringRenderer() {
	        super();
	        light = new Color(240,240,240);
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,Object value, boolean isSelected, boolean hasFocus, int row,int column)
	    {
	    	
    		setToolTipText(null);
	    	String prefix = "<html>";
	    	String postfix = "</html>";
	    	if(column == C_ALT) {
	    		prefix += "<font color=\"red\">";
	    		postfix += "</font>";
	    		  setToolTipText(prefix + (String)value + postfix);
	    	} else if( column == C_NEU) {
	    		prefix += "<font color=\"green\">";
	    		postfix += "</font>";	 
	    		  setToolTipText(prefix + (String)value + postfix);
	    	} else if(column == C_UHRZEIT) {
	    		prefix += "<b><font color=\"blue\">";
	    		postfix += "</font></b>";
	    		if(((String)value).startsWith(":")) {
		    		setToolTipText(((String)value).substring(1,((String)value).length()));
	    			value ="";
	    		}
	    	}else if(column == C_DATUM) {
	    		prefix += "<b>";
	    		postfix += "</b>";
	    		if(((String)value).startsWith(":")) {
		    		setToolTipText(((String)value).substring(1,((String)value).length()));
	    			value ="";
	    		}
	    	}
	        if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
            }else {
            	if(row % 2 == 0) {
            		setBackground(light);
            	}else{
            		setBackground(Color.WHITE);
            	}
            }
    		setText(prefix + (String)value + postfix);
	    return this;
	    }
	}
	
	
	@Override
	public void columnAdded(TableColumnModelEvent e) {	}

	@Override
	public void columnMarginChanged(ChangeEvent e) {	}

	@Override
	public void columnMoved(TableColumnModelEvent e) {	}

	@Override
	public void columnRemoved(TableColumnModelEvent e) {	}

	@Override
	public void columnSelectionChanged(ListSelectionEvent e) {	}


}
