	package de.lunqual.rzpro.fenster.rechenfenster;
	import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics2D;
	import java.awt.GridLayout;
	import java.awt.event.ComponentEvent;
	import java.awt.event.ComponentListener;
	import java.awt.event.InputEvent;
	import java.awt.event.KeyEvent;
	import java.awt.print.PageFormat;
	import java.awt.print.Printable;
	import java.awt.print.PrinterException;
	import java.awt.print.PrinterJob;

	import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
	import javax.swing.JLabel;
	import javax.swing.JMenu;
	import javax.swing.JMenuBar;
	import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;	
	import javax.swing.JToolBar;
	import javax.swing.SwingConstants;

	import de.lunqual.rzpro.RzPro;
	import de.lunqual.rzpro.fenster.JRzFrame;
	import de.lunqual.rzpro.fensterfactory.FensterFactory;
	import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rechnen.RechenChartListe;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.log.LogFactory;
	/**
	 *
	 * @author  lunqual
	 */
	public class rezepturContentFenster extends JRzFrame implements Printable{

	    //GUI-Variablen
	    private JToolBar tb1;
	    private JMenuBar mb;
	    private JMenu mnuDatei;
	    private JMenu mnuHilfe;
	      private  JPanel contentPanel;
	      	private JPanel tbPanel;
	      	private JPanel centerPanel;
	      		private JPanel radioPanel;
	      			private JLabel lblTitel;
	      			private JPanel radioButtonPanel;
		      			private ButtonGroup contentGroup;
							private JRadioButton btContentLiter;
							private JRadioButton btContentKg;
							private JRadioButton btContentLA;
							private JRadioButton btContentKosten;
							private JRadioButton btContentKostenSteuer;
	      		private JPanel chartContentPanel;
		      		private JScrollPane scrListe;
		      			private RechenChartPanel chartPanel;
	  		private JPanel buttonPanel;
	  	    	private JButton btClose;
	  	    	private JPanel rightPanel;
	  	    		private JButton btDrucken;
	  	    		private JButton btHilfe;

	    public static final int         		ACTION_CLOSE_CODE = 1001;
	    public static final String     		ACTION_CLOSE_TEXT = "rezepturcontent.action_close";
	    public static final int         		ACTION_HILFE_CODE = 1003;
	    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
	    public static final int         		ACTION_HIDE_CODE = 1004;
	    public static final String    		ACTION_HIDE_TEXT = "action_hide";
	    public static final int         		ACTION_DRUCKEN_CODE = 1005;
	    public static final String    		ACTION_DRUCKEN_TEXT = "rezepturcontent.action_print";

	    
	    int	rezeptur=0;
    	RechenChartListe liste = null;
    	CurrencyItem			cur;
	    
	    /** Creates new form AdressenFenster */
	    public rezepturContentFenster(RzPro r, String name, Object extendedData) {
	        super(r,name,extendedData);
	        createActions();
	        createGUIComponents();
	        setGUIComponents();
	        getMessage((MessageItem)extendedData);
	    }

	    @Override
		public void createGUIComponents() {
	    	// Menü
	    	mb = new JMenuBar();
	    	mnuDatei = new JMenu();
	    	mnuHilfe = new JMenu();
	    	mb.add(mnuDatei);
	    	mb.add(mnuHilfe);
	    	setJMenuBar(mb);
			//Toolbar
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			//ToolbarPanel
			//contentPanel
			contentPanel = new JPanel(new BorderLayout());
				tbPanel = new JPanel(new BorderLayout());
					tbPanel.add(tb1,BorderLayout.NORTH);
			contentPanel.add(tbPanel,BorderLayout.NORTH);
				centerPanel = new JPanel(new BorderLayout());
				
					radioPanel = new JPanel(new BorderLayout());
					lblTitel = new JLabel();
						lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
						lblTitel.setBorder(BorderFactory.createEtchedBorder());
					radioPanel.add(lblTitel,BorderLayout.NORTH);
					radioButtonPanel = new JPanel(new GridLayout(1,5));
						radioButtonPanel.setBorder( BorderFactory.createEtchedBorder());
						contentGroup = new ButtonGroup();
							btContentLiter = new JRadioButton();
							contentGroup.add(btContentLiter);
							btContentKg = new JRadioButton();
							contentGroup.add(btContentKg);
							btContentLA = new JRadioButton();
							contentGroup.add(btContentLA);
							btContentKosten = new JRadioButton();
							contentGroup.add(btContentKosten);
							btContentKostenSteuer = new JRadioButton();
							contentGroup.add(btContentKostenSteuer);
							btContentLiter.addActionListener(new java.awt.event.ActionListener() {
    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
    			                	rz.getOptionFactory().setOption("rechenChartMode", 0);
    			                	rz.getOptionFactory().saveOptions();
    			                    auswahlAction();
    			                	}
    			            	});
							btContentKg.addActionListener(new java.awt.event.ActionListener() {
    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
    			                	rz.getOptionFactory().setOption("rechenChartMode", 1);
    			                	rz.getOptionFactory().saveOptions();
    			                    auswahlAction();
    			                	}
    			            	});
							btContentLA.addActionListener(new java.awt.event.ActionListener() {
    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
    			                	rz.getOptionFactory().setOption("rechenChartMode", 2);
    			                	rz.getOptionFactory().saveOptions();
    			                    auswahlAction();
    			                	}
    			            	});
							btContentKosten.addActionListener(new java.awt.event.ActionListener() {
    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
    			                	rz.getOptionFactory().setOption("rechenChartMode", 3);
    			                	rz.getOptionFactory().saveOptions();
    			                    auswahlAction();
    			                	}
    			            	});
							btContentKostenSteuer.addActionListener(new java.awt.event.ActionListener() {
    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
    			                	rz.getOptionFactory().setOption("rechenChartMode", 4);
    			                	rz.getOptionFactory().saveOptions();
    			                    auswahlAction();
    			                	}
    			            	});
							
							radioButtonPanel.add(btContentLiter);
							radioButtonPanel.add(btContentKg);
							radioButtonPanel.add(btContentLA);
							radioButtonPanel.add(btContentKosten);
							radioButtonPanel.add(btContentKostenSteuer);
							int active = rz.getOptionFactory().getOption("rechenChartMode", 0);
							switch(active) {
								case 0: btContentLiter.setSelected(true);break;
								case 1: btContentKg.setSelected(true);break;
								case 2: btContentLA.setSelected(true);break;
								case 3: btContentKosten.setSelected(true);break;
								case 4: btContentKostenSteuer.setSelected(true);break;
							}
					radioPanel.add(radioButtonPanel,BorderLayout.SOUTH);
				centerPanel.add(radioPanel,BorderLayout.NORTH);
				
				
					scrListe = new JScrollPane();
						chartPanel=new RechenChartPanel(rz);
						chartPanel.setBackground(Color.WHITE);
						scrListe.setBorder(BorderFactory.createEtchedBorder());
						scrListe.setViewportView(chartPanel);
					centerPanel.add(scrListe,BorderLayout.CENTER);

					
					contentPanel.add(centerPanel,BorderLayout.CENTER);
				 buttonPanel=new JPanel(new BorderLayout());
					btClose = new JButton();
						buttonPanel.add(btClose,BorderLayout.WEST);
					rightPanel=new JPanel(new GridLayout(1,3));
						btDrucken = new JButton();
						rightPanel.add(btDrucken);
						btHilfe = new JButton();
						rightPanel.add(btHilfe,BorderLayout.EAST);
				buttonPanel.add(rightPanel,BorderLayout.EAST);
			contentPanel.add(buttonPanel,BorderLayout.SOUTH);

			addComponentListener(new ComponentListener() {
			    public void componentResized(ComponentEvent componentEvent) {
			    		refreshAction();
			    }

				@Override
				public void componentMoved(ComponentEvent e) {
					
				}

				@Override
				public void componentShown(ComponentEvent e) {
					
				}

				@Override
				public void componentHidden(ComponentEvent e) {
					
				}
			});
			//Panels ans Fenster hängen;
			this.getContentPane().setLayout(new BorderLayout());

			this.getContentPane().add(contentPanel, BorderLayout.CENTER);
	    }


	    @Override
		public void setGUIComponents() {
	        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("rezepturcontent.titel"));

			mnuDatei.setText(rz.getLocale().getString("menu.datei"));
			mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

			mnuDatei.addSeparator();
			mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
			mnuDatei.addSeparator();
	        mnuDatei.add(getAction(ACTION_CLOSE_CODE));

	        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

			tb1.add(getAction(ACTION_CLOSE_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_HIDE_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_HILFE_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_DRUCKEN_CODE));

			btHilfe.setAction(getAction(ACTION_HILFE_CODE));
			btClose.setAction(getAction(ACTION_CLOSE_CODE));
			btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
			
			btContentLiter.setText(rz.getLocale().getString("rezepturcontent.txtliter"));
			btContentKg.setText(rz.getLocale().getString("rezepturcontent.txtkg"));
			btContentLA.setText(rz.getLocale().getString("rezepturcontent.txtla"));
			btContentKosten.setText(rz.getLocale().getString("rezepturcontent.txtkosten"));
			btContentKostenSteuer.setText(rz.getLocale().getString("rezepturcontent.txtkostensteuer"));
			
			setResizable(true);
	        rz.getFontFactory().setFrameFonts(this);
	        pack();
	        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
	    }

	    @Override
		public void getMessage(MessageItem msg) {
	        switch(msg.getMsgCode()) {
	    	case MessageItem.MSG_ACTIONPERFORMED:
	            switch(msg.getCode()){
			          case ACTION_HILFE_CODE: hilfeAction();break;
			          case ACTION_HIDE_CODE:hideAction();break;
			          case ACTION_CLOSE_CODE:closeWindow();break;
			          case ACTION_DRUCKEN_CODE:
			        	  druckenAction();
			        	  refreshAction();
			        	  break;
			          default :
			              break;
	           }
	    		break;
	         case MessageItem.MSG_SHOW_REZEPTUR_CONTENT_RI:
	        	 rezeptur = msg.getCode();
	        	 RechenItem ri = (RechenItem)msg.getData();
	        	 if(ri != null) {
	        		 liste = new RechenChartListe(rz, ri);
	        	 }
	        	 if(liste.isAlkoholfrei()) {
	    	    		btContentLA.setEnabled(false);
	    	    		btContentLiter.setSelected(true);
	    	    	} else {
	    	    		btContentLA.setEnabled(true);
	    	    	}
	        	 break;
	         case MessageItem.MSG_SHOW_REZEPTUR_CONTENT:
	        	 rezeptur = msg.getCode();
	        	 cur= (CurrencyItem)msg.getData();
	        	 if(rezeptur != 0) {
	        		 liste = new RechenChartListe(rz,rezeptur,cur);
	     	    	if(liste.isAlkoholfrei()) {
	    	    		btContentLA.setEnabled(false);
	    	    		btContentLiter.setSelected(true);
	    	    	} else {
	    	    		btContentLA.setEnabled(true);
	    	    	}
	        	 }
	 	         break;
	        default:
	            break;
	        }

	    }

	    private void auswahlAction () {
	    	lblTitel.setText("<html><b>" + liste.getName() + "</b></html>");
	    	if(btContentLiter.isSelected()) {
	    		liste.rechnen(RzPro.EINHEIT_LITER);
	    	} else if (btContentKg.isSelected()) {
	    		liste.rechnen(RzPro.EINHEIT_KG);
	    	} else if (btContentLA.isSelected()){
	    		liste.rechnen(RzPro.EINHEIT_LA);
	    	} else if(btContentKostenSteuer.isSelected()){
	    		liste.rechnen(RzPro.EINHEIT_KOSTEN_STEUER);
	    	} else {
	    		liste.rechnen(RzPro.EINHEIT_KOSTEN);
	    	}
	    	refreshAction();
	    }
	    
	    private void refreshAction() {
	    	if(liste != null) {
	    		chartPanel.setData(liste);
	    		chartPanel.repaint();
	    	}
	    }
	    
	   
	    @Override
		public void createActions(){
	        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
	        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
	        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_ESCAPE,0));
	        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_D,InputEvent.CTRL_DOWN_MASK));
	    }

	    @Override
		public void openWindow(){
	    	if(rezeptur != 0) {
	            setVisible(true);
	            toFront();
	            auswahlAction();
	    	}
	    }

	    @Override
		public void closeWindow(){
	        rz.getFensterFactory().getFensterListe().disposeFrame(this);
	    }

	    //Extras-Menü
	    private void hideAction(){
	        rz.getFensterFactory().getFensterListe().sperren(this);
	    }

	    //hilfe
	    private void hilfeAction(){
	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"mischungchartfenster.html",this));
	    }

	    private void druckenAction(){
	        final PrinterJob job = PrinterJob.getPrinterJob();
	        job.setPrintable(this);
	        final PageFormat pf=new PageFormat();
	        pf.setOrientation(PageFormat.LANDSCAPE);
	        if(job.printDialog()){
	        try{
	            job.print();
	            }
	        catch(final PrinterException pe){
	                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "rezepturChartFenster.druckenAction:" ,  pe.getLocalizedMessage());
	            }
	         refreshAction();
	        }
	    }
	    public int print(java.awt.Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
	        if(pageIndex != 0){
	            return Printable.NO_SUCH_PAGE;
	        }
	        else {
	            final Graphics2D g2d = (Graphics2D)graphics;
	            g2d.translate(pageFormat.getImageableX(),
	                          pageFormat.getImageableY());
	            final int cw = 	chartPanel.getWidth();
	            final int ch = chartPanel.getHeight();
	            final double pw = pageFormat.getImageableWidth();
	            final double ph = pageFormat.getImageableHeight();
	            if ((cw > pw) || (ch > ph)) {
	                final double scaleX = pw / cw;
	                final double scaleY = ph / ch;
	                final double scale = scaleX < scaleY ? scaleX : scaleY;
	                g2d.scale(scale, scale);
	            }
	        chartPanel.printAll(g2d);
	        return Printable.PAGE_EXISTS;
	        }
	    }

	}


