/*
 * Created on 07.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.fenster.rechenfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class RechenZahlenDialog extends JDialog {
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;
    	private JPanel leftPanel;
    			private JLabel lblIcon;
    		private JPanel rightPanel;
    			private JLabel lblMessage;
    				private JPanel eingabePanel;
    					private JNumberField txtEingabe;
    					private JButton btBestand;
    	private JPanel buttonPanel;
    		private JButton btAlles;
    		private JButton btZeile;
    		private JButton btCancel;

    public static final int         	DIALOG_CANCEL     	= 0;
    public static final int			DIALOG_ALLES			= 1;
    public static final int			DIALOG_ZEILE			= 2;

    RzPro				rz;

    int				numberFormat;
    double			minValue;
    double 			maxValue;
    double 			value;
    double			bestandValue;
    String			einheit;
    String			bezeichnung;
    int				code;
    JFrame 			parent;
    boolean			zeilenberechnung;

    public RechenZahlenDialog(RzPro r,JFrame parent) {
    	super(parent,true);
        rz = r;
        zeilenberechnung=true;
        minValue = 0.0;
        maxValue = Double.POSITIVE_INFINITY;
        value = 0.0;
        code = DIALOG_CANCEL;
        numberFormat = OptionFactory.NF_NORMAL;
        this.parent = parent;
        createGUIComponents();
        setGUIComponents();
    }


    private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        contentPanel = new JPanel(new BorderLayout());
	        lblTitel = new JLabel();
	    	lblTitel.setForeground(Color.WHITE);
	    	lblTitel.setBackground(Color.BLUE);
	    	lblTitel.setOpaque(true);
	        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
	        contentPanel.add(lblTitel,BorderLayout.NORTH);
	        	leftPanel = new JPanel(new BorderLayout());
	        		lblIcon = new JLabel();
	        			lblIcon.setHorizontalAlignment(SwingConstants.CENTER);
	        			lblIcon.setVerticalAlignment(SwingConstants.CENTER);
	        		leftPanel.add(lblIcon,BorderLayout.WEST);
	        	rightPanel = new JPanel(new BorderLayout());
	        	    lblMessage = new JLabel();
	        	    	lblMessage.setHorizontalAlignment(SwingConstants.CENTER);
	        	    rightPanel.add(lblMessage,BorderLayout.NORTH);
	        	    	eingabePanel = new JPanel(new BorderLayout());
			        		txtEingabe= new JNumberField(rz.getLocale().getNumberFormat(numberFormat),value,minValue,maxValue);
				 	        txtEingabe.addKeyListener(new java.awt.event.KeyAdapter() {
				 	            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				 	                switch(evt.getKeyCode())  {
				 	                    case KeyEvent.VK_ENTER :
					 	                	code = DIALOG_ALLES;
					 	                	setVisible(false);
					 	                	break;
					 	                case KeyEvent.VK_ESCAPE:
					 	                	code = DIALOG_CANCEL;
					 	                	setVisible(false);
					 	                	break;
				 	                	}
				 	            	}
				 	        	});
				 	        eingabePanel.add(txtEingabe,BorderLayout.CENTER);
				 	     btBestand = new JButton();
				       	     btBestand.addActionListener(new ActionListener() {
			       	            public void actionPerformed(ActionEvent evt) {
			       	            	txtEingabe.setValue(bestandValue);
			       	            	}
			       	        	});
				 	     	eingabePanel.add(btBestand,BorderLayout.EAST);
	        	rightPanel.add(eingabePanel,BorderLayout.SOUTH);

	        	contentPanel.add(leftPanel,BorderLayout.WEST);
	        	contentPanel.add(rightPanel,BorderLayout.CENTER);
	        	buttonPanel = new JPanel(new GridBagLayout());
	    			final GridBagConstraints c = new GridBagConstraints();
	    			c.weightx = 1;c.fill = GridBagConstraints.BOTH;
	    			c.insets = new Insets(5,5,5,5);
	        		btAlles = new JButton();
	        	     btAlles.addActionListener(new ActionListener() {
	        	            public void actionPerformed(ActionEvent evt) {
	        	            		code = DIALOG_ALLES;
	        	                	setVisible(false);
	        	            	}
	        	        	});
	        	        btAlles.addKeyListener(new java.awt.event.KeyAdapter() {
	        	            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
	            	            		code = DIALOG_CANCEL;
	            	            		setVisible(false);
	        	                	}
	        	            	}
	        	        	});
	        		c.gridx=0;c.gridy=0;c.gridwidth=1;c.gridheight=1;
	        		buttonPanel.add(btAlles,c);

	        		btZeile = new JButton();
		       	     btZeile.addActionListener(new ActionListener() {
		       	            public void actionPerformed(ActionEvent evt) {
		       	                	code = DIALOG_ZEILE;
		       	                	value = txtEingabe.getValue();
		       	                	setVisible(false);
		       	            	}
		       	        	});
		       	        btZeile.addKeyListener(new java.awt.event.KeyAdapter() {
		       	            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
		       	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
		       	                	    code = DIALOG_CANCEL;
		       	                	    setVisible(false);
		       	                	}
		       	            	}
	       	        	});
		    			c.gridx=1;c.gridy=0;c.gridwidth=1;c.gridheight=1;
	        		buttonPanel.add(btZeile,c);
	        		btCancel = new JButton();
		       	    btCancel.addActionListener(new ActionListener() {
		 	            public void actionPerformed(ActionEvent evt) {
		 	            		code = DIALOG_CANCEL;
	 	                		setVisible(false);
		 	            	}
		 	        	});
		 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	                	code =DIALOG_CANCEL;
		 	                	setVisible(false);
		 	            	}
		 	        	});
	    			c.gridx=2;c.gridy=0;c.gridwidth=1;c.gridheight=1;
		 	        buttonPanel.add(btCancel,c);
		 	   contentPanel.add(buttonPanel,BorderLayout.SOUTH);
		 	   contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
         getContentPane().add(contentPanel,BorderLayout.CENTER);
        setResizable(false);
    }

    private void setGUIComponents() {
    	this.setUndecorated(true);
        setTitle(rz.getLocale().getString("rechnen.zahlendialog"));
        lblTitel.setText(getTitle());
        lblIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/frage.png" )));
        btAlles.setText(rz.getLocale().getString("rechenzahlendialog.alles"));
        btZeile.setText(rz.getLocale().getString("rechenzahlendialog.zeile"));
        btCancel.setText(rz.getLocale().getString("string_abbrechen"));
        rz.getFontFactory().setFrameFonts(this);
    }

    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
    	code = DIALOG_CANCEL;
        txtEingabe.setValue(value);
        lblMessage.setText(rz.getLocale().getString("rechenzahlendialog.message")
                    	.replaceAll("%z",bezeichnung)
                    	.replaceAll("%s",rz.getLocale().formatNumber(value,OptionFactory.NF_NORMAL))
                    	.replaceAll("%mode",einheit));
        if(!rz.isZero(bestandValue)) {
        	btBestand.setEnabled(true);
        	btBestand.setText(rz.getLocale().getString("rechenzahlendialog.bestand")
        				.replaceAll("%b",rz.getLocale().formatNumber(bestandValue,OptionFactory.NF_NORMAL))
						.replaceAll("%e",einheit));
        } else {
        	btBestand.setText(rz.getLocale().getString("rechenzahlendialog.kein_bestand"));
        	btBestand.setEnabled(false);
        }
        if(zeilenberechnung) {
        	btZeile.setEnabled(true);
        }else {
        	btZeile.setEnabled(false);
        }
        pack();
        this.setLocationRelativeTo(parent);
        setVisible(true);
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        txtEingabe.requestFocus();
    }

	public int getCode() {
		return code;
	}
	public double getValue() {
		return txtEingabe.getValue();
	}

	public void setBestandValue(double bestandValue) {
		this.bestandValue = bestandValue;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public void setEinheit(String einheit) {
		this.einheit = einheit;
	}

	public void setValue(double value) {
		this.value = value;
		txtEingabe.setValue(value);
	}


	public void setZeilenberechnung(boolean zeilenberechnung) {
		this.zeilenberechnung = zeilenberechnung;
	}
}