/*
 * Created on 07.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.fenster.rechenfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.items.rezeptur.ChangesListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class RechenStaerkeDialog extends JDialog {
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;
    	private JPanel leftPanel;
    			private JLabel lblIcon;
    		private JPanel rightPanel;
    			private JLabel lblMessage;
    				private JPanel eingabePanel;
    					private JNumberField txtEingabe;
    					private JButton btSave;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btCancel;

    public static final int         	DIALOG_CANCEL     	= 0;
    public static final int			DIALOG_OK				= 1;

    RzPro				rz;

    int				numberFormat;
    double			minValue;
    double 			maxValue;
    double 			value;
    String			bezeichnung;
    int				code;
    JFrame 			parent;
    int				key;

    public RechenStaerkeDialog(RzPro r,JFrame parent) {
    	super(parent,true);
        rz = r;
        minValue = 0.0;
        maxValue = 99.9999999;
        value = 0.0;
        code = DIALOG_CANCEL;
        numberFormat = OptionFactory.NF_STAERKE;
        this.parent = parent;
        createGUIComponents();
        setGUIComponents();
    }


    private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        contentPanel = new JPanel(new BorderLayout());
	        lblTitel = new JLabel();
	    	lblTitel.setForeground(Color.WHITE);
	    	lblTitel.setBackground(Color.BLUE);
	    	lblTitel.setOpaque(true);
	        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
	            contentPanel.add(lblTitel,BorderLayout.NORTH);
	        	leftPanel = new JPanel(new BorderLayout());
	        		lblIcon = new JLabel();
	        			lblIcon.setHorizontalAlignment(SwingConstants.CENTER);
	        			lblIcon.setVerticalAlignment(SwingConstants.CENTER);
	        		leftPanel.add(lblIcon,BorderLayout.WEST);
	        	rightPanel = new JPanel(new BorderLayout());
	        	    lblMessage = new JLabel();
	        	    	lblMessage.setHorizontalAlignment(SwingConstants.CENTER);
	        	    rightPanel.add(lblMessage,BorderLayout.NORTH);
	        	    	eingabePanel = new JPanel(new BorderLayout());
			        		txtEingabe= new JNumberField(rz.getLocale().getNumberFormat(numberFormat),value,minValue,maxValue);
				 	        txtEingabe.addKeyListener(new java.awt.event.KeyAdapter() {
				 	            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				 	                switch(evt.getKeyCode())  {
				 	                    case KeyEvent.VK_ENTER :
					 	                	code = DIALOG_OK;
					 	                	setVisible(false);
					 	                	break;
					 	                case KeyEvent.VK_ESCAPE:
					 	                	code = DIALOG_CANCEL;
					 	                	setVisible(false);
					 	                	break;
				 	                	}
				 	            	}
				 	        	});
				 	        eingabePanel.add(txtEingabe,BorderLayout.CENTER);
				 	     btSave = new JButton();
				       	     btSave.addActionListener(new ActionListener() {
			       	            public void actionPerformed(ActionEvent evt) {
			       	            		if(key != 0) {
			       	            			ChangesListe liste = new ChangesListe(rz,key);
			       	            		    rz.getDatabase().getRezeptur().updateStaerke(key,txtEingabe.getValue());
			       	            		    liste.commit();
			       	            		    code = DIALOG_OK;
			       	            		    setVisible(false);
			       	            		}
			       	            	}
			       	        	});
				 	     	eingabePanel.add(btSave,BorderLayout.EAST);
	        	rightPanel.add(eingabePanel,BorderLayout.SOUTH);

	        	contentPanel.add(leftPanel,BorderLayout.WEST);
	        	contentPanel.add(rightPanel,BorderLayout.CENTER);
	        	buttonPanel = new JPanel(new GridBagLayout());
	    			final GridBagConstraints c = new GridBagConstraints();
	    			c.weightx = 1;c.fill = GridBagConstraints.BOTH;
	    			c.insets = new Insets(5,5,5,5);
	    			c.gridx=0;c.gridy=0;c.gridwidth=1;c.gridheight=1;
	        		btOK = new JButton();
	        	     btOK.addActionListener(new ActionListener() {
	        	            public void actionPerformed(ActionEvent evt) {
	        	            		code = DIALOG_OK;
	        	                	setVisible(false);
	        	            	}
	        	        	});
	        	        btOK.addKeyListener(new java.awt.event.KeyAdapter() {
	        	            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
	            	            		code = DIALOG_CANCEL;
	            	            		setVisible(false);
	        	                	}
	        	            	}
	        	        	});
	        		buttonPanel.add(btOK,c);
	        		btCancel = new JButton();
		       	     btCancel.addActionListener(new ActionListener() {
		 	            public void actionPerformed(ActionEvent evt) {
		 	            		code = DIALOG_CANCEL;
	 	                		setVisible(false);
		 	            	}
		 	        	});
		 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	                	code =DIALOG_CANCEL;
		 	                	setVisible(false);
		 	            	}
		 	        	});
	    			c.gridx=1;c.gridy=0;c.gridwidth=1;c.gridheight=1;
	        		buttonPanel.add(btCancel,c);
              contentPanel.add(buttonPanel,BorderLayout.SOUTH);
              contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
              getContentPane().add(contentPanel,BorderLayout.CENTER);
        setResizable(false);
    }

    private void setGUIComponents() {
    	this.setUndecorated(true);
        setTitle(rz.getLocale().getString("rechnen.staerkedialog"));
        lblTitel.setText(getTitle());
        lblIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/frage.png" )));
        btSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rechenstaerkedialog.speichern.png" )));
        btSave.setText(rz.getLocale().getString("rechenstaerkedialog.speichern"));
        btOK.setText(rz.getLocale().getString("string_ok"));
        btCancel.setText(rz.getLocale().getString("string_abbrechen"));
        rz.getFontFactory().setFrameFonts(this);
    }

    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
    	code = DIALOG_CANCEL;
        txtEingabe.setValue(value);
        lblMessage.setText(rz.getLocale().getString("rechenstaerkedialog.message")
                    	.replaceAll("%z",bezeichnung)
                    	.replaceAll("%s",rz.getLocale().formatNumber(value,OptionFactory.NF_STAERKE)));

        pack();
        this.setLocationRelativeTo(parent);
        setVisible(true);
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        txtEingabe.requestFocus();
    }

	public int getCode() {
		return code;
	}
	public double getValue() {
		return txtEingabe.getValue();
	}


	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public void setValue(double value) {
		this.value = value;
		txtEingabe.setValue(value);
	}

    public int getKey() {
        return key;
    }
    public void setKey(int key) {
        this.key = key;
    }
}