/*
 * Created on 07.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.fenster.rechenfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import de.lunqual.rzpro.RzPro;


/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class RechenExtraktDialog extends JDialog {
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;
    	private JPanel centerPanel;
    		private JLabel lblMessage;
    		private JScrollPane scrListe;
    			private JList lstKomponenten;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btCancel;

    public static final int         	DIALOG_CANCEL     	= 0;
    public static final int			DIALOG_OK				= 1;

    RzPro			rz;

    ArrayList		komponenten;
    int				selected;
    int				code;
    JFrame 			parent;
    int				what = Rechenfenster.RECALC_EXTRAKT;


    public RechenExtraktDialog(RzPro r,JFrame parent,int what) {
    	super(parent,true);
        rz = r;
        this.what = what;
        code = DIALOG_CANCEL;
        this.parent = parent;
        createGUIComponents();
        setGUIComponents(what);
    }


    private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        contentPanel = new JPanel(new BorderLayout());
	        lblTitel = new JLabel();
	    	lblTitel.setForeground(Color.WHITE);
	    	lblTitel.setBackground(Color.BLUE);
	    	lblTitel.setOpaque(true);
	        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
	        contentPanel.add(lblTitel,BorderLayout.NORTH);
	        	centerPanel = new JPanel(new BorderLayout());
	        		lblMessage = new JLabel();
	        			lblMessage.setHorizontalAlignment(SwingConstants.CENTER);
	        		centerPanel.add(lblMessage,BorderLayout.NORTH);
	        		scrListe = new JScrollPane();
	        			lstKomponenten = new JList();
	        	        lstKomponenten.addKeyListener(new java.awt.event.KeyAdapter() {
	        	            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
	            	            		code = DIALOG_CANCEL;
	            	            		selected = -1;
	            	            		setVisible(false);
	        	                	}
	        	                	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	            	            		code = DIALOG_OK;
	            	            		selected = lstKomponenten.getSelectedIndex();
	            	            		setVisible(false);
	        	                	}
	        	            	}
	        	        	});
	        				lstKomponenten.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	        			scrListe.setViewportView(lstKomponenten);
	        		centerPanel.add(scrListe,BorderLayout.CENTER);
	        		centerPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
	        	contentPanel.add(centerPanel,BorderLayout.CENTER);
	        	buttonPanel = new JPanel(new GridBagLayout());
	    			final GridBagConstraints c = new GridBagConstraints();
	    			c.weightx = 1;c.fill = GridBagConstraints.BOTH;
	    			c.insets = new Insets(5,5,5,5);
	        		btOK = new JButton();
	        	     btOK.addActionListener(new ActionListener() {
	        	            public void actionPerformed(ActionEvent evt) {
	        	            		code = DIALOG_OK;
	        	            		selected = lstKomponenten.getSelectedIndex();
	        	                	setVisible(false);
	        	            	}
	        	        	});
	        	        btOK.addKeyListener(new java.awt.event.KeyAdapter() {
	        	            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
	            	            		code = DIALOG_CANCEL;
	            	            		selected = -1;
	            	            		setVisible(false);
	        	                	}
	        	            	}
	        	        	});
	        		c.gridx=0;c.gridy=0;c.gridwidth=1;c.gridheight=1;
	        		buttonPanel.add(btOK,c);

	        		btCancel = new JButton();
		       	    btCancel.addActionListener(new ActionListener() {
		 	            public void actionPerformed(ActionEvent evt) {
		 	            		code = DIALOG_CANCEL;
		 	            		selected = -1;
	 	                		setVisible(false);
		 	            	}
		 	        	});
		 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	                	code =DIALOG_CANCEL;
		 	                	selected = -1;
		 	                	setVisible(false);
		 	            	}
		 	        	});
	    			c.gridx=2;c.gridy=0;c.gridwidth=1;c.gridheight=1;
		 	        buttonPanel.add(btCancel,c);
		 	   contentPanel.add(buttonPanel,BorderLayout.SOUTH);
		 	   contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
         getContentPane().add(contentPanel,BorderLayout.CENTER);
        setResizable(false);
    }

    private void setGUIComponents(int what) {
    	this.setUndecorated(true);
    	switch (what) {
    		case Rechenfenster.RECALC_EXTRAKT:
    	        setTitle(rz.getLocale().getString("rechnen.extraktdialog"));
    	        lblTitel.setText(getTitle());
    	        lblMessage.setText(rz.getLocale().getString("rechenextraktdialog.message"))	;
    			break;
    		case Rechenfenster.RECALC_ACID:
    	        setTitle(rz.getLocale().getString("rechnen.aciddialog"));
    	        lblTitel.setText(getTitle());
    	        lblMessage.setText(rz.getLocale().getString("rechenaciddialog.message"));
    			break;
    	}
;
        btOK.setText(rz.getLocale().getString("string_ok"));
        btCancel.setText(rz.getLocale().getString("string_abbrechen"));
        rz.getFontFactory().setFrameFonts(this);
        pack();
        this.setLocationRelativeTo(parent);
    }

    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
    	code = DIALOG_CANCEL;
    	lstKomponenten.setListData(komponenten.toArray());
    	selected = -1;
        setVisible(true);
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        if(lstKomponenten.getModel().getSize() > 0) {
            lstKomponenten.setSelectedIndex(0);
        }
        lstKomponenten.requestFocus();
    }

	public int getCode() {
		return code;
	}

    public void setKomponenten(ArrayList komponenten) {
        this.komponenten = komponenten;
    }

    public int getSelected() {
        return selected;
    }
}