package de.lunqual.rzpro.fenster.rechenfenster;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import javax.swing.JPanel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rechnen.RechenChartItem;
import de.lunqual.rzpro.items.rechnen.RechenChartListe;
import de.lunqual.rzpro.options.OptionFactory;


public class RechenChartPanel extends JPanel {
	
	private static final int					C_MAX = 30;
	private static final int					C_DIFF=200;
	
	RzPro					rz;
	int						centerX;
	int						centerY;
	int						durchmesser;
	Color[] 				colors;
	Color					black,white,grey,red;
	RechenChartListe	items;
	int						fontsize=14;
	double					limit ;
	
	public RechenChartPanel(RzPro rz) {
		super();
		this.rz = rz;
		setColors();
	}
	
	

	public void setColors() {
		black = new Color(0,0,0);
		white = new Color(255,255,255);
		grey = new Color(125,125,125);
		red = new Color(255,0,0);
		colors= new Color[rz.getOptionFactory().getOption("mischung.chart.max.colors",OptionFactory.MISCHUNG_CHART_MAX_COLORS)];
		for(int i=0;i<rz.getOptionFactory().getOption("mischung.chart.max.colors",OptionFactory.MISCHUNG_CHART_MAX_COLORS);i++) {
			colors[i] = rz.getOptionFactory().getRGBColor("mischung.chart.color_" + String.valueOf(i) );
		}
	}
	
	
	public void setData(RechenChartListe rci) {
		this.items = rci;
		if(items != null) {
			durchmesser = this.getHeight() - this.getHeight()/10;
			centerX=10;
			centerY=10;
		} 
	}
	
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		g.setColor(Color.white);
		g.fillRect(0,0,this.getWidth(),this.getHeight());
		if(items != null && !items.isEmpty()) {
			drawItems(g);
		}
	}

	private void drawItems(Graphics g) {
		Graphics2D ga = (Graphics2D)g;
		ga.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		Font f = rz.getFontFactory().getTableFont();
		fontsize = f.getSize();
		double start = 90.0;
		int startTextY = fontsize*2;
		int startTextX = durchmesser + (fontsize * 2);

		for (int i=0;i<items.size();i++) {
			RechenChartItem entry =items.get(i);
			double extend = -(360*entry.getValue())/100;
			if (i==0) {
				ga.setFont(rz.getFontFactory().getTableBoldFont());
				if(items.getMode() == RzPro.EINHEIT_KOSTEN && items.isPreisWarnung()) {
			        ga.setColor(red);
					ga.drawString(rz.getLocale().getString("rechnen.error_zutatenpreise_fehlen") ,(int)(startTextX + (fontsize* 2)),(int)(startTextY + fontsize));
					startTextY += (int)(f.getSize()*3);
				}
				if(items.getMode() == RzPro.EINHEIT_KOSTEN && rz.isZero(rz.getOptionFactory().getDouble("kalkulation.wasserpreis_preis"))) {
			        ga.setColor(red);
					ga.drawString(rz.getLocale().getString("rechnen.error_kein_wasserpreis") ,(int)(startTextX + (fontsize * 2)),(int)(startTextY + fontsize));
					startTextY += (int)(f.getSize()*3);
				}
		        ga.setColor(black);
				ga.drawString(rz.getLocale().getString("rezepturcontent.chart_header").replaceAll("%n",items.getName()).replaceAll("%m", items.getModeString()) ,(int)(startTextX + (fontsize*2)),(int)(startTextY + fontsize));
				startTextY += (int)(f.getSize()*3);
			}
			ga.setColor( colors[i % colors.length]);
			ga.setFont(f);
			Area pie =new Area((Shape) new Arc2D.Double(centerX,centerY,durchmesser,durchmesser, start, extend, Arc2D.PIE));
	        ga.fill(pie);
	        ga.setColor(black);
	        if(i < items.size()-1) {
	        	ga.draw(pie);
	        }
			start+=extend;
			if(!rz.isZero(entry.getValue())){
				ga.setColor( colors[i % colors.length]);
				ga.fillRect(startTextX, startTextY-fontsize, fontsize, fontsize*2);
				ga.setColor(black);
				ga.drawRect(startTextX, startTextY-fontsize, fontsize, fontsize*2);
				String str = entry.getString() ;
				ga.drawString(str, (int)(startTextX + (fontsize*2)),(int)startTextY);
				startTextY += (int)(f.getSize()*3);
			}
		}	
		drawOutline(ga);
	}

	

	  
	private void drawOutline(Graphics2D ga) {
		ga.setColor(black);
		ga.setStroke(new BasicStroke(2));
		Shape circle = new Ellipse2D.Float(centerX,centerY,durchmesser,durchmesser);
		ga.draw(circle);
	}
}
