/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
  * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.probenfenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.rzDatePicker.PickerDualDateListener;
import de.lunqual.rzpro.fenster.rzDatePicker.RzDualDatePicker;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.laborwerte.LaborwertListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.proben.ProbenItem;
import de.lunqual.rzpro.items.proben.ProbenListe;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class ProbenFenster extends JRzFrame implements TableColumnModelListener {
    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel suchePanel;
	    		private JPanel auswahlPanel;
					private JPanel selectPanel;
						private JCheckBox chkDatum;
					private JPanel datumPanel;
						private JPanel boxPanel;
							private JPanel pickerPanel;
								private RzDualDatePicker picker;
							
		      		    private JPanel datenPanel;
		      		    	private JPanel benutzerPanel;
		      		    		private JCheckBox chkBezeichnung;
		      		    		private JSelectedTextField txtBezeichnung;
			      		    private JPanel probenNummerPanel;
			      		    	private JCheckBox chkProbenNummer;
			      		    	private JSelectedTextField txtProbenNummer;
		      		    	private JPanel losnummerPanel;
		      		    		private JCheckBox chkLosnummer;
		      		    		private JSelectedTextField txtLosnummer;
		      		    	private JPanel adressenPanel;
		      		    		private JPanel adrCheckPanel;
		      		    			private JCheckBox chkAdressen;
		      		    		private JPanel adrDatenPanel;
		      		    			private JButton btAdressen;
		      		    			private JLabel lblAdressen;
		      		    			private JButton btAdressenLoeschen;
		  				
		  				    private JPanel refreshPanel;
		  				    	private JButton btRefresh;
    		private JSplitPane splErgebnis;
    				private JPanel leftPanel;
    					private JScrollPane scrListe;
    						private JTable tblListe;
    					private JPanel leftButtonPanel;
    						private JButton btBearbeiten;
    						private JButton btLoeschen;
    						private JButton btEntsorgen;
    						private JButton btEtikett;
    						private JComboBox cmbProbenListe;
    						private JButton btProbenListeDrucken;
    				private JPanel rightPanel;
    					private JPanel anzeigePanel;
    						private JScrollPane scrAnzeige;
    							private JEditorPane txtAnzeige;
    						private JPanel anzeigeButtonPanel;
    							private JComboBox cmbFormulare;
    							private JButton btDrucken;
    							private JCheckBox chkDuplex;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "probenfenster.action_close";
    public static final int         		ACTION_NEU_CODE = 1002;
    public static final String      	ACTION_NEU_TEXT = "probenfenster.action_neu";
    public static final int         		ACTION_BEARBEITEN_CODE = 1003;
    public static final String      	ACTION_BEARBEITEN_TEXT = "probenfenster.action_edit";
    public static final int         		ACTION_LOESCHEN_CODE = 1004;
    public static final String      	ACTION_DELETE_TEXT = "probenfenster.action_delete";
    public static final int         		ACTION_HILFE_CODE = 1006;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1008;
    public static final String      	ACTION_REFRESH_TEXT = "probenfenster.action_refresh";
    public static final int         		ACTION_ADRESSE_SUCHEN_CODE = 1009;
    public static final String      	ACTION_ADRESSE_SUCHEN_TEXT = "probenfenster.action_adresse_suchen";
    public static final int         		ACTION_ADRESSE_LOESCHEN_CODE = 1010;
    public static final String      	ACTION_ADRESSE_LOESCHEN_TEXT = "probenfenster.action_adresse_loeschen";
    public static final int         		ACTION_ETIKETT_CODE = 1011;
    public static final String      	ACTION_ETIKETT_TEXT = "probenfenster.action_etikett";
    public static final int         		ACTION_DRUCKEN_CODE = 1012;
    public static final String      	ACTION_DRUCKEN_TEXT = "probenfenster.action_drucken";
    public static final int         		ACTION_HERSTELLBUCH_CODE = 1013;
    public static final String    		ACTION_HERSTELLBUCH_TEXT = "probenfenster.action_herstellbuch";
    public static final int         		ACTION_ENTSORGEN_CODE = 1014;
    public static final String    		ACTION_ENTSORGEN_TEXT = "probenfenster.action_entsorgen";
    public static final int         		ACTION_PROBENLISTE_CODE = 1015;
    public static final String    		ACTION_PROBENLISTE_TEXT = "probenfenster.action_probenliste";
    public static final int         		ACTION_NICHT_ENTSORGEN_CODE = 1016;
    public static final String    		ACTION_NICHT_ENTSORGEN_TEXT = "probenfenster.action_nicht_entsorgen";
    
    public static final String 			CALENDAR_FORMAT		=	"d. MMMMMM yyyy";

    public static final int				DATE_HEUTE 					= 0;
    public static final int				DATE_GESTERN 			= 1;
    public static final int				DATE_DIESE_WOCHE 	= 2;
    public static final int				DATE_LETZTE_WOCHE 	= 3;
    public static final int				DATE_DIESEN_MONAT 	= 4;
    public static final int				DATE_LETZTEN_MONAT	= 5;
    public static final int				DATE_DIESES_JAHR 		= 6;
    public static final int				DATE_LETZTES_JAHR		= 7;
    public static final int				DATE_2_WOCHEN			= 8;
    public static final int				DATE_4_WOCHEN			= 9;

    public static final int				MAX_COLUMN				= 4;
    public static final int				C_NUMMER 					= 0;
    public static final int				C_DATUM						= 1;
    public static final int				C_BEZEICHNUNG			= 2;
    public static final int				C_LOSNUMMER				= 3;


    LaborwertListe				liste;
    DialogItem					dlgItem;
    boolean						startup =true;
    ProbenListe					proben = null;
    Timer					   		ergebnisTimer;
    int								editID=-1;

    StichwortListe			adressen;

    /** Creates new form AdressenFenster */
    public ProbenFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        adressen = new StichwortListe();
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuFenster=new JMenu();
        	mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				suchePanel = new JPanel(new BorderLayout());
					auswahlPanel = new JPanel(new BorderLayout());
					selectPanel = new JPanel(new BorderLayout());

		        	    chkDatum = new JCheckBox();
		        	    chkDatum.addActionListener(new ActionListener() {
		    	        	public void actionPerformed(ActionEvent evt) {
		    	        	    datumSelection();
		    	        	    refreshAction();
		    	        	}
		        	    });
		        	    selectPanel.add(chkDatum,BorderLayout.SOUTH);

					auswahlPanel.add(selectPanel,BorderLayout.NORTH);
		    	    datumPanel = new JPanel(new BorderLayout());
		    	    	boxPanel = new JPanel(new GridLayout(1,2));
		    	    		pickerPanel = new JPanel(new BorderLayout());
		    	    			picker = new RzDualDatePicker(rz,null,null);
		    	    				picker.addListener(new PickerDualDateListener() {

										@Override
										public void dateChanged(Date datum1, Date datum2) {
											refreshAction();
											
										}
		    	    					
		    	    				});
		    	    			pickerPanel.add(picker,BorderLayout.CENTER);
		        	    	boxPanel.add(pickerPanel);
		    	    	datumPanel.add(boxPanel,BorderLayout.CENTER);
		    	  
		        	    auswahlPanel.add(datumPanel,BorderLayout.WEST);
		        	    	datenPanel = new JPanel();
		        				datenPanel.setLayout(new BoxLayout(datenPanel, BoxLayout.PAGE_AXIS));
		        	    		benutzerPanel = new JPanel(new BorderLayout());
		        	    			chkBezeichnung = new JCheckBox();
		        	    			chkBezeichnung.setSelected(false);
					        	    chkBezeichnung.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        	    if(!startup) {
				        	        	    	try {
				        	        	    		txtBezeichnung.setEnabled(chkBezeichnung.isSelected()?true:false);
				        	        	    		if (chkBezeichnung.isSelected()) {
														txtBezeichnung.requestFocus();
													}
				        	        	    	}catch (final Exception e) {}
				        	        	    	refreshAction();
				        	        	    }
				        	        	}
					        	    });
		        	    			benutzerPanel.add(chkBezeichnung,BorderLayout.WEST);
		        	    			txtBezeichnung = new JSelectedTextField();
		        	    				txtBezeichnung.setColumns(10);
		        	    				txtBezeichnung.setEnabled(false);
		        	    	            txtBezeichnung.addKeyListener(new java.awt.event.KeyAdapter() {
		        	    	                public void keyReleased(java.awt.event.KeyEvent evt) {
		        	    	                    if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
		        	    	                    	refreshAction();
		        	    	                    }
		        	    	                }
		        	    	            });
		        	    			benutzerPanel.add(txtBezeichnung,BorderLayout.CENTER);
				        	datenPanel.add(benutzerPanel);

			        		probenNummerPanel=new JPanel(new BorderLayout());
			        			chkProbenNummer = new JCheckBox();
				        	    chkProbenNummer.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        	    if(!startup) {
			        	        	    	try {
			        	        	    		txtProbenNummer.setEnabled(chkProbenNummer.isSelected()?true:false);
			        	        	    		if (chkProbenNummer.isSelected()) {
													txtProbenNummer.requestFocus();
												}
			        	        	    	}catch (final Exception e) {}
			        	        	    	refreshAction();
			        	        	    }
			        	        	}
				        	    });
	        	    			probenNummerPanel.add(chkProbenNummer,BorderLayout.WEST);
	        	    			txtProbenNummer  = new JSelectedTextField();
	        	    				txtProbenNummer.setColumns(10);
	        	    				txtProbenNummer.setEnabled(false);
	        	    	            txtProbenNummer.addKeyListener(new java.awt.event.KeyAdapter() {
	        	    	                public void keyReleased(java.awt.event.KeyEvent evt) {
	        	    	                    if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
	        	    	                    	refreshAction();
	        	    	                    }
	        	    	                }
	        	    	            });
	        	    	            probenNummerPanel.add(txtProbenNummer,BorderLayout.CENTER);
				        		datenPanel.add(probenNummerPanel);
		        	    		losnummerPanel=new JPanel(new BorderLayout());
		        	    			chkLosnummer = new JCheckBox();
		        	    			chkLosnummer.setSelected(false);
					        	    chkLosnummer.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        	    if(!startup) {
				        	        	    	try {
				        	        	    		txtLosnummer.setEnabled(chkLosnummer.isSelected()?true:false);
				        	        	    		if (chkLosnummer.isSelected()) {
														txtLosnummer.requestFocus();
													}
				        	        	    	}catch (final Exception e) {}
				        	        	    	refreshAction();
				        	        	    }
				        	        	}
					        	    });
		        	    			losnummerPanel.add(chkLosnummer,BorderLayout.WEST);
		        	    			txtLosnummer = new JSelectedTextField();
		        	    				txtLosnummer.setColumns(10);
		        	    				txtLosnummer.setEnabled(false);
		        	    				txtLosnummer.addKeyListener(new java.awt.event.KeyAdapter() {
		        	    	                public void keyReleased(java.awt.event.KeyEvent evt) {
		        	    	                    if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
		        	    	                    	refreshAction();
		        	    	                    }
		        	    	                }
		        	    	            });
		        	    			losnummerPanel.add(txtLosnummer,BorderLayout.CENTER);
				        	    datenPanel.add(losnummerPanel);
		        	    			adressenPanel=new JPanel(new BorderLayout());
		        	    				adrCheckPanel = new JPanel(new BorderLayout());
		        	    					chkAdressen=new JCheckBox();
							        	    chkAdressen.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        	    if(!startup) {
						        	        	    	try {
						        	        	    		if(chkAdressen.isSelected()) {
							        	        	    		getAction(ACTION_ADRESSE_SUCHEN_CODE).setEnabled(true);
							        	        	    		getAction(ACTION_ADRESSE_LOESCHEN_CODE).setEnabled(true);
						        	        	    		} else {
							        	        	    		getAction(ACTION_ADRESSE_SUCHEN_CODE).setEnabled(false);
							        	        	    		getAction(ACTION_ADRESSE_LOESCHEN_CODE).setEnabled(false);
						        	        	    		}

						        	        	    	}catch (final Exception e) {}
						        	        	    	refreshAction();
						        	        	    }
						        	        	}
							        	    });

		        	    					adrCheckPanel.add(chkAdressen,BorderLayout.WEST);
		        	    				adressenPanel.add(adrCheckPanel,BorderLayout.WEST);
		        	    				adrDatenPanel=new JPanel(new BorderLayout());
				      		    			btAdressen=new JButton();
				      		    			adrDatenPanel.add(btAdressen,BorderLayout.WEST);
				      		    			lblAdressen=new JLabel();
				      		    			adrDatenPanel.add(lblAdressen,BorderLayout.CENTER);
				      		    			btAdressenLoeschen= new JButton();
				      		    			adrDatenPanel.add(btAdressenLoeschen,BorderLayout.EAST);

				      		    		adressenPanel.add(adrDatenPanel,BorderLayout.CENTER);
		        	    				adressenPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		        	    		datenPanel.add(adressenPanel);
		        	    		refreshPanel=new JPanel(new BorderLayout());
		        	    			btRefresh= new JButton();
		        	    		refreshPanel.add(btRefresh,BorderLayout.WEST);
		        	    	datenPanel.add(refreshPanel);
		    	    	auswahlPanel.add(datenPanel,BorderLayout.SOUTH);
		    	    	auswahlPanel.setBorder(BorderFactory.createRaisedBevelBorder());
					suchePanel.add(auswahlPanel,BorderLayout.NORTH);

					splErgebnis = new JSplitPane();
						leftPanel = new JPanel(new BorderLayout());
							scrListe = new JScrollPane();
								tblListe = new JTable();
								tblListe.setName("probenfenster.spalten");
				    			tblListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
				    			tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			                    public void valueChanged(ListSelectionEvent e) {
			        			        if (e.getValueIsAdjusting()) {
											return;
										}
				        			    if(ergebnisTimer.isRunning()) {
				        			            ergebnisTimer.stop();
				        			        }
			        			        ergebnisTimer.start();
			                        }
				    			});
				    			tblListe.setColumnSelectionAllowed(false);
				    			tblListe.setRowSelectionAllowed(true);
								scrListe.setViewportView(tblListe);
							leftPanel.add(scrListe,BorderLayout.CENTER);

						leftButtonPanel=new JPanel(new GridLayout(4,2));
							btBearbeiten = new JButton();
							leftButtonPanel.add(btBearbeiten);
							btLoeschen= new JButton();
							leftButtonPanel.add(btLoeschen);
							btEntsorgen = new JButton();
							leftButtonPanel.add(btEntsorgen);
							btEtikett = new JButton();
							leftButtonPanel.add(btEtikett);
							cmbProbenListe=new JComboBox();
					    	rz.getDatabase().getReport().dbGetReportListeCombo(cmbProbenListe,ReportFactory.REPORT_TYPE_PROBENLISTE);
			        	    cmbProbenListe.addActionListener(new ActionListener() {
			    	        	public void actionPerformed(ActionEvent evt) {
			    	        		if(cmbProbenListe.getSelectedIndex() != -1) {
			    	        			rz.getOptionFactory().setOption("report.probenliste",((ReportItem)cmbProbenListe.getSelectedItem()).getID());
			    	        		}
			    	        	}
			                });
							leftButtonPanel.add(cmbProbenListe);
							btProbenListeDrucken =new JButton();
							leftButtonPanel.add(btProbenListeDrucken);
							chkDuplex = new JCheckBox();
					    	chkDuplex.setSelected((rz.getOptionFactory().getOption("proben.duplex",0) == 1?true:false));
							chkDuplex.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		rz.getOptionFactory().setOption("proben.duplex", chkDuplex.isSelected()?1:0);
		        	        		rz.getOptionFactory().saveOptions();
		        	        	}
			        	    });
							leftButtonPanel.add(chkDuplex);
						leftPanel.add(leftButtonPanel,BorderLayout.SOUTH);
					splErgebnis.setLeftComponent(leftPanel);
					rightPanel=new JPanel(new BorderLayout());
					anzeigePanel=new JPanel(new BorderLayout());
					scrAnzeige = new JScrollPane();
						txtAnzeige = new JEditorPane();
						txtAnzeige.setContentType("text/html");
						 txtAnzeige.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
					            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
					                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
						                	ergebnisLinkAction(txtAnzeige);
					                	}
						            }
						        });
						txtAnzeige.setEditable(false);
						scrAnzeige.setViewportView(txtAnzeige);
					    anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
					    rightPanel.add(anzeigePanel,BorderLayout.CENTER);
					    anzeigeButtonPanel = new JPanel(new GridLayout(1,2));
					    	cmbFormulare = new JComboBox();
					    	rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_PROBE);
			        	    cmbFormulare.addActionListener(new ActionListener() {
			    	        	public void actionPerformed(ActionEvent evt) {
			    	        		if(cmbFormulare.getSelectedIndex() != -1) {
			    	        			rz.getOptionFactory().setOption("report.proben",((ReportItem)cmbFormulare.getSelectedItem()).getID());
			    	        		}
			    	        	}
			                });
					    	anzeigeButtonPanel.add(cmbFormulare);
					    	btDrucken=new JButton();
					    	anzeigeButtonPanel.add(btDrucken);
					    	
					    rightPanel.add(anzeigeButtonPanel,BorderLayout.SOUTH);
					splErgebnis.setRightComponent(rightPanel);
				contentPanel.add(splErgebnis,BorderLayout.CENTER);
				contentPanel.add(suchePanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe,BorderLayout.EAST);
    	    	buttonPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("probenfenster.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
	  mnuFenster.setText(rz.getLocale().getString("menu.fenster"));

      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
      mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
      mnuBearbeiten.add(getAction(ACTION_ENTSORGEN_CODE));
      mnuBearbeiten.add(getAction(ACTION_NICHT_ENTSORGEN_CODE));
      mnuBearbeiten.add(getAction(ACTION_LOESCHEN_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_PROBENLISTE_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_ETIKETT_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuFenster.add(getAction(ACTION_HERSTELLBUCH_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));


      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));

      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));

    
	  btAdressen.setAction(getAction(ACTION_ADRESSE_SUCHEN_CODE));
	  btAdressenLoeschen.setAction(getAction(ACTION_ADRESSE_LOESCHEN_CODE));
      btBearbeiten.setAction(getAction(ACTION_BEARBEITEN_CODE));
      btEntsorgen.setAction(getAction(ACTION_ENTSORGEN_CODE));
      btLoeschen.setAction(getAction(ACTION_LOESCHEN_CODE));
      btEtikett.setAction(getAction(ACTION_ETIKETT_CODE));
	  btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
	  btProbenListeDrucken.setAction(getAction(ACTION_PROBENLISTE_CODE));

	  chkDatum.setText(rz.getLocale().getString("probenfenster.label_select_datum"));
	  chkBezeichnung.setText(rz.getLocale().getString("probenfenster.label_bezeichnung"));
	  chkLosnummer.setText(rz.getLocale().getString("probenfenster.label_losnummer"));
	  chkAdressen.setText(rz.getLocale().getString("probenfenster.label_adressen"));
	  chkProbenNummer.setText(rz.getLocale().getString("probenfenster.label_probennummer"));
	  chkDuplex.setText(rz.getLocale().getString("proben.duplex"));

      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_BEARBEITEN_CODE));
      tb1.add(getAction(ACTION_LOESCHEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_ETIKETT_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_DRUCKEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HERSTELLBUCH_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));


	  getAction(ACTION_LOESCHEN_CODE).setEnabled(false);
	  getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
	  getAction(ACTION_ADRESSE_SUCHEN_CODE).setEnabled(false);
	  getAction(ACTION_ADRESSE_LOESCHEN_CODE).setEnabled(false);
	  getAction(ACTION_ETIKETT_CODE).setEnabled(false);
	  getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
	  getAction(ACTION_HERSTELLBUCH_CODE).setEnabled(false);
	  getAction(ACTION_ENTSORGEN_CODE).setEnabled(false);
	  getAction(ACTION_PROBENLISTE_CODE).setEnabled(false);
	  getAction(ACTION_NICHT_ENTSORGEN_CODE).setEnabled(false);
	  
	  chkDatum.setSelected(true);
      setResizable(true);
      setDividerLocations();
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      setDividerLocations();
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_LOESCHEN_CODE:deleteAction();break;
                case ACTION_NEU_CODE:neuAction();break;
                case ACTION_BEARBEITEN_CODE:editAction();break;
                case ACTION_REFRESH_CODE:refreshAction();break;
    			case ACTION_ADRESSE_SUCHEN_CODE :adresseSuchenAction();break;
    			case ACTION_ADRESSE_LOESCHEN_CODE :adresseLoeschenAction();break;
    			case ACTION_ETIKETT_CODE :etikettAction();break;
    			case ACTION_DRUCKEN_CODE :druckenAction();break;
    			case ACTION_HERSTELLBUCH_CODE:herstellbuchAction();break;
    			case ACTION_NICHT_ENTSORGEN_CODE:
    			case ACTION_ENTSORGEN_CODE:entsorgenAction();break;
    			case ACTION_PROBENLISTE_CODE:probenListeAction();break;
    			default :
                    break;
               }
        		break;
        	case MessageItem.MSG_PROBEN_EDIT_REPLY:
     		   this.settblListenModel(tblListe);
         	   setDatum(DATE_HEUTE);
        		refreshAction();
        		if(editID != -1) {
	                for(int i=0;i <proben.size();i++) {
	                	if(proben.getItem(i).getId()==editID) {
	                        tblListe.scrollRectToVisible(tblListe.getCellRect(i, 0,true));
	                    	tblListe.setRowSelectionInterval(i,i);
	                		break;
	                	}
	                }
	                editID=-1;
                }
        		break;
            case MessageItem.MSG_ADRESSLISTE_REPLY:
            	adressen=((StichwortListe)msg.getData()).copyList();
            	lblAdressen.setText("<html>" + adressen.toHTMLString()+ "</html>");
            	refreshAction();
	      		break;
           case MessageItem.MSG_SHOW_PROBENFENSTER:
    		   this.settblListenModel(tblListe);
         	   setDatum(DATE_HEUTE);
         	   startup=false;
       		   refreshAction();
         	   break;
           case MessageItem.MSG_SHOW_PROBENFENSTER_PROBENNUMMER:
        	   final String probennummer = (String)msg.getData();
    		   this.settblListenModel(tblListe);
         	   setDatum(DATE_HEUTE);
         	   chkProbenNummer.setSelected(true);
         	   chkLosnummer.setSelected(false);
         	   chkBezeichnung.setSelected(false);
         	   chkDatum.setSelected(false);
         	   chkAdressen.setSelected(false);
         	   txtProbenNummer.setText(probennummer);
         	   startup=false;
       		   refreshAction();
       		   break;
           case MessageItem.MSG_SHOW_PROBENFENSTER_ADRESSE:
        	   final AdressItem ai = ((AdressItem)msg.getData());
    		   this.settblListenModel(tblListe);
         	   setDatum(DATE_HEUTE);
         	   chkLosnummer.setSelected(false);
         	   chkBezeichnung.setSelected(false);
         	   chkDatum.setSelected(false);
         	   chkAdressen.setSelected(true);
         	   adressen.clear();
         	   adressen.addItem(new StichwortItem(ai.getID(),ai.getFirma(),"",""));
         	   lblAdressen.setText("<html>"+adressen.toHTMLString()+"</html>");
         	   startup=false;
       		   refreshAction();
       		   break;
            default:
                rz.getLogFactory().logMessage(2, "probenfenster:", "auswahlAction:" + msg.getMsgCode());
                break;
        }
    }


     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT, KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_LOESCHEN_CODE,ACTION_DELETE_TEXT,KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_ADRESSE_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSE_SUCHEN_CODE,ACTION_ADRESSE_SUCHEN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ADRESSE_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSE_LOESCHEN_CODE,ACTION_ADRESSE_LOESCHEN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ETIKETT_CODE),new AuswahlAction(rz,this,ACTION_ETIKETT_CODE,ACTION_ETIKETT_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_HERSTELLBUCH_CODE),new AuswahlAction(rz,this,ACTION_HERSTELLBUCH_CODE,ACTION_HERSTELLBUCH_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ENTSORGEN_CODE),new AuswahlAction(rz,this,ACTION_ENTSORGEN_CODE,ACTION_ENTSORGEN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_PROBENLISTE_CODE),new AuswahlAction(rz,this,ACTION_PROBENLISTE_CODE,ACTION_PROBENLISTE_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_NICHT_ENTSORGEN_CODE),new AuswahlAction(rz,this,ACTION_NICHT_ENTSORGEN_CODE,ACTION_NICHT_ENTSORGEN_TEXT,0 ,0));
     }

     /**
      * im Detail-Textfeld wurde eine Rezeptur oder eine Adressliste angeklicke
      * @param link
      */
     private void ergebnisLinkAction(JEditorPane txt) {
     			 final Document d = txt.getDocument();
     			 final HTMLDocument hd = (HTMLDocument)d;
     			 final int pos = txt.viewToModel( txt.getMousePosition() );
     			 if ( pos >= 0 ) {
     			 	final Element e = hd.getCharacterElement(pos);
     			 	if (e != null) {
     			 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
     			 		if(se != null) {
     			 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
     			 			if(ziel.indexOf("^")!= -1) {
     			 				// Adressliste
     			 		        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEN,true,new MessageItem(MessageItem.MSG_SHOW_ADRESSE,0,ziel,this));
     			 			}
     			 		}
     			 	}
     			 }
     }



	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splErgebnis", this.splErgebnis.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        splErgebnis.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splErgebnis",this.getWidth()/2));
    }


    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
	        toFront();
    }

    @Override
	public void closeWindow(){
    	saveDividerLocations();
    	saveDividerLocations();
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

	private void herstellbuchAction() {
		if(tblListe.getSelectedRow() != -1) {
			final String losnummer = "^" + proben.getItem(tblListe.getSelectedRow()).getLosnummer()+"$";
	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HERSTELLUNG,true,new MessageItem(MessageItem.MSG_SHOW_HERSTELLUNG,0,losnummer,this));
		}
	}

	/** den Dialog mit der Adressenliste anzeigen
	 *
	 *
	 */
	private void adresseSuchenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setAdressListe(adressen.copyList());
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL,true,	new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST,0,ai,this));
	}

	private void adresseLoeschenAction() {
		adressen.clear();
		lblAdressen.setText("");
		refreshAction();
	}


	private void druckenAction() {
        if(tblListe.getSelectedRow() != -1) {
        	final ProbenItem pi = proben.getItem(tblListe.getSelectedRow());
	       	if(pi != null) {
            	 rz.getReportFactory().probenReport(pi.getId(),this);
	       	}
        }
	}

	private void probenListeAction() {
		if (proben != null && !proben.isEmpty()) {
			rz.getReportFactory().probenListenReport(proben,this,chkDuplex.isSelected());
		}
	}
	
	private void entsorgenAction() {
        if(tblListe.getSelectedRow() != -1) {
        	final ProbenItem pi = proben.getItem(tblListe.getSelectedRow());
	       	if(pi != null) {
            	if(pi.isDeleted()) {
            		
            		DialogItem di=null;
            		di = new DialogItem(
	                        DialogControl.FRAGE_DIALOG,
	                        "",
	                        0.0,
	                        rz.getLocale().getString("probenfenster.question_entsorgen"),
	                        rz.getLocale().getString("probenfenster.question_entsorgen"),
	                        rz.getLocale().getString("probenfenster.question_entsorgen_1")
	                        	.replaceAll("%n",String.valueOf(pi.getId()))
	                        	.replaceAll("%s", pi.getBezeichnung()),
	                        "frage.png",
	                        rz.getLocale().getString("string_ja"),
	                        rz.getLocale().getString("string_nein"),
	                        this
	                );
	                rz.getDialogFactory().getDialog(di);

	                if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	            		pi.setDeleted(false);
	                	rz.getDatabase().getProben().probeEntsorgen(pi);
	               }
            	}else {
            		pi.setDeleted(true);
                	rz.getDatabase().getProben().probeEntsorgen(pi);
            	}
            	rz.getAusgabeFactory().probenAusgabe(txtAnzeige, pi);
                ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
                for(int i=0;i <proben.size();i++) {
                	if(proben.getItem(i).getId()==pi.getId()) {
                        tblListe.scrollRectToVisible(tblListe.getCellRect(i, 0,true));
                    	tblListe.setRowSelectionInterval(i,i);
                		break;
                	}
                }
	       	}
        }
	}
	

	private void etikettAction() {
        if(tblListe.getSelectedRow() != -1) {
        	final ProbenItem pi = proben.getItem(tblListe.getSelectedRow());
	       	if(pi != null) {
	        	final EtikettenListe ei = new EtikettenListe();
	        	ei.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));

				final EtikettenItem eti = new EtikettenItem(rz);
				eti.setZeile(0,rz.getLocale().getString("probenfenster.etikett_zeile_0").replaceAll("%n", String.valueOf(pi.getId())));//rz.getLocale().formatNumber(pi.getId(),OptionFactory.NF_ONE)));
				eti.setZeile(1,pi.getBezeichnung());
				eti.setZeile(2,pi.getErstelltToString());
				eti.setZeile(3,pi.getLosnummer());
				eti.setZeile(4,pi.getAdressListe().toVerboseString());
				eti.setLosnummer(pi.getLosnummer());
				eti.setImage(ei.getBogen().getImage());
				ei.addItem(eti);

	        	if(ei.size() != 0) {
	                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,(Object)ei,null));
	        	}
        	}
        }
	}

    /**
     * Neu einlesen
     */
    private void refreshAction() {
	    rz.setWaitCursor(this);
    	if(!chkDatum.isSelected() && !chkBezeichnung.isSelected() && !chkLosnummer.isSelected() && !chkAdressen.isSelected() && !chkProbenNummer.isSelected()) {
    		// alles holen
    		proben = rz.getDatabase().getProben().getProbenListeAll();
    		} else {
	    		// auswahl
	    	    Date dVon=null;
	    	    Date dBis =null;
	    	    final String bezeichnung=chkBezeichnung.isSelected()?txtBezeichnung.getText().trim():"";
	    	    final String losnummer=chkLosnummer.isSelected()?txtLosnummer.getText().trim():"";
	    	    final String probenNummer = chkProbenNummer.isSelected()?txtProbenNummer.getText().trim():"";
	   	        if(chkDatum.isSelected()) {
	   	        	dVon = picker.getDate1();
	    	        dBis = picker.getDate2();
	    	     }
	    		proben = rz.getDatabase().getProben().getProbenListeSelect(bezeichnung,losnummer,dVon,dBis,adressen,probenNummer);
    		}
        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
       	if (proben != null && proben.size() !=0) {
       		try {
	            tblListe.scrollRectToVisible(tblListe.getCellRect(proben.size()-1, 0,true));
	           	tblListe.setRowSelectionInterval(proben.size()-1,proben.size()-1);
       		}catch (Exception e) {}
        }
        rz.setFreeCursor(this);
		ergebnisTimerEvent();
    }
    /**
     * neu anlegen
     */
    private void neuAction() {
    }
    /**
     * ändern
     */
    private void editAction() {
        if(tblListe.getSelectedRow() != -1) {
 	        final ProbenItem pi = proben.getItem(tblListe.getSelectedRow());
 	        	if (pi != null){
 	        		editID=pi.getId();
 	        	  		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBEN_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_PROBENEINGABE_PROBE,pi.getId(),null,this));
 	        		}
 	        	}
    }

    /**
     * löschen
     */
    private void deleteAction() {
    	if(!txtBezeichnung.isFocusOwner() && !txtLosnummer.isFocusOwner()) {
	    	 DialogItem di = null;
	         if(tblListe.getSelectedRow() != -1) {
	 	        final ProbenItem pi = proben.getItem(tblListe.getSelectedRow());
	 	        	if (pi != null){
	 	                di = new DialogItem(
	                        DialogControl.FRAGE_DIALOG,
	                        "",
	                        0.0,
	                        rz.getLocale().getString("probenfenster.question_delete"),
	                        rz.getLocale().getString("probenfenster.question_delete"),
	                        rz.getLocale().getString("probenfenster.question_delete_1")
	                        	.replaceAll("%n",rz.getLocale().formatNumber(pi.getId(),OptionFactory.NF_ONE))
	                        	.replaceAll("%s", pi.getBezeichnung()),
	                        "frage.png",
	                        rz.getLocale().getString("string_ja"),
	                        rz.getLocale().getString("string_nein"),
	                        this
	                );
	                rz.getDialogFactory().getDialog(di);

	                if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	                	rz.getDatabase().getProben().deleteProbe(pi.getId());
	                	rz.getFensterFactory().getFensterListe().propagateBestand(this,pi.getId());
	                	refreshAction();
	 	            }
	 	        }
	         }
    	}
    	rz.getFensterFactory().getFensterListe().propagateProbe(this,0);
    }
    /**
     * Actions enable/disable
     *
     */
    private void setActions() {
    }

    /**
     * ausgewähltes Item anzeigen
     *
     */
    private void ausgabeAction() {
    	setActions();
    }




    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"probenverzeichnis.html",this));
    }

    /**
     * ergebnisTimerEvent zeigt an, dass eine Notiz/Rezeptur dargestellt werden
     * muss,
     */
    private void ergebnisTimerEvent(){
    	if(tblListe != null) {
	        if(ergebnisTimer.isRunning()) {
				ergebnisTimer.stop();
			}
	        if (tblListe.getSelectedRow() != -1){
	        	tblListe.setRowSelectionInterval(tblListe.getSelectedRow(),tblListe.getSelectedRow());
	            final ProbenItem pi = proben.getItem(tblListe.getSelectedRow());
	        	getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
	        	getAction(ACTION_ENTSORGEN_CODE).setEnabled(true);
	        	getAction(ACTION_LOESCHEN_CODE).setEnabled(true);
	        	getAction(ACTION_ETIKETT_CODE).setEnabled(true);
	        	getAction(ACTION_DRUCKEN_CODE).setEnabled(true);
	        	getAction(ACTION_PROBENLISTE_CODE).setEnabled(true);
	        	getAction(ACTION_NICHT_ENTSORGEN_CODE).setEnabled(true);
	        	if (!pi.getLosnummer().trim().equals("")) {
		        	getAction(ACTION_HERSTELLBUCH_CODE).setEnabled(true);
	        	}else {
		        	getAction(ACTION_HERSTELLBUCH_CODE).setEnabled(false);
	        	}
	        	if(pi.isDeleted()) {
	        		btEntsorgen.setAction(getAction(ACTION_NICHT_ENTSORGEN_CODE));
	        	}else {
	        		btEntsorgen.setAction(getAction(ACTION_ENTSORGEN_CODE));
	        	}
	        	rz.getAusgabeFactory().probenAusgabe(txtAnzeige, pi);
	        }
	        else {
	        	getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
	        	getAction(ACTION_LOESCHEN_CODE).setEnabled(false);
	        	getAction(ACTION_ETIKETT_CODE).setEnabled(false);
	        	getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
	        	getAction(ACTION_HERSTELLBUCH_CODE).setEnabled(false);
	        	getAction(ACTION_ENTSORGEN_CODE).setEnabled(false);
	        	getAction(ACTION_PROBENLISTE_CODE).setEnabled(false);
	        	getAction(ACTION_NICHT_ENTSORGEN_CODE).setEnabled(false);
	        	txtAnzeige.setEditable(true);
	        	txtAnzeige.setText("");
	        	txtAnzeige.setEditable(false);
	        }
    	}
    	tblListe.requestFocus();
    }

    private void datumSelection() {
        if(chkDatum.isSelected()) {
        	picker.setComponentsEnabled(pickerPanel, true);
        }else {
        	picker.setComponentsEnabled(pickerPanel, false);
        }
    }

    private void setDatum(int mode) {

      
        refreshAction();
    }

    private void setDayBegin(Calendar c) {
    	c.set(Calendar.HOUR_OF_DAY,0);
    	c.set(Calendar.MINUTE,0);
    	c.set(Calendar.SECOND,0);
    }
    private void setDayEnd(Calendar c) {
    	c.set(Calendar.HOUR_OF_DAY,23);
    	c.set(Calendar.MINUTE,59);
    	c.set(Calendar.SECOND,59);
    }



    private void settblListenModel(JTable t) {
	    final listenColumnModel rcm = new listenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("probenfenster.tableheader_nummer"));
    		tc.setModelIndex(C_NUMMER);
    		tc.setCellRenderer(ir);
    	rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("probenfenster.tableheader_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("probenfenster.tableheader_bezeichnung"));
			tc.setModelIndex(C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("probenfenster.tableheader_losnummer"));
			tc.setModelIndex(C_LOSNUMMER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblListe.setModel(new ListenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class listenColumnModel extends DefaultTableColumnModel{
	    public listenColumnModel() {
	        super();
	    }

	}

	private  class ListenTableModel extends AbstractTableModel    {

        SimpleDateFormat df;

        public ListenTableModel() {
            df = new SimpleDateFormat("dd.MM.yyyy");
        }

	   public int getColumnCount() {
	       	return MAX_COLUMN;
        }
        public int getRowCount() {
        	if(proben != null) {
                return proben.size();
        	} else {
        		return 0;
        	}
        }

        public ProbenItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (proben != null)) {
        		return proben.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (proben != null)) {
                ret = getContent(proben.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(ProbenItem pi,int aColumn,int row) {
            Object ret = null;
            if(pi != null) {
	            switch(aColumn){
	            	case C_NUMMER:
	            		ret = pi.getId()+" ("+pi.getUser_1()+")";
	            		break;
	            	case C_DATUM :
	            	    ret = df.format(pi.getErstellt());
	            	    break;
	            	case C_BEZEICHNUNG:
	            	    ret = pi.getBezeichnung();
	            	    break;
	            	case C_LOSNUMMER:
	            	    ret = pi.getLosnummer();
	            	    break;
	            }
            }
            return ret;
        }
	}

	
	private class IconRenderer extends DefaultTableCellRenderer {

		Icon	deleted;
	    IconRenderer() {
	        super();
	        setOpaque(true);
            deleted = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/probenfenster.icon_deleted.png"));
	    }
	    public Component getTableCellRendererComponent(JTable table,
	            Object value, boolean isSelected, boolean hasFocus, int row,
	            int column)
	    {
	    	setIcon(null);
	    	ProbenItem pi = null;
	    	if((row != -1) && (proben != null)) {
	    	   pi = proben.getItem(row);
	    	}
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        if(pi.isDeleted()) {
	        	setIcon(deleted);
	        } else {
	        	setIcon(null);
	        }
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
	    }
	}

	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
	            Object value, boolean isSelected, boolean hasFocus, int row,
	            int column)
	    {
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
	    }
	}


	public void columnAdded(TableColumnModelEvent e) {
	}
	public void columnMarginChanged(ChangeEvent e) {

	}
	public void columnMoved(TableColumnModelEvent e) {

	}
	public void columnRemoved(TableColumnModelEvent e) {

	}
	public void columnSelectionChanged(ListSelectionEvent e) {
	}



}
