package de.lunqual.rzpro.fenster.mischungsfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DMDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.dialoge.KontrollDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.SortenItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.mischungen.ticketCmbData;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.options.OptionFactory;

public class TicketEingabe extends JRzFrame {

	//GUI-Variablen
		private JMenuBar mb;
	    	private JMenu mnuDatei;
	    	private JMenu mnuExtras;
	    	private JMenu mnuHilfe;
	    private JPanel mainPanel;
	    	private JPanel toolbarPanel;
	    		private JToolBar tb1;
	    	private JPanel contentPanel;
	    		private JPanel datenPanel;
	    			private JPanel cmbPanel;
	    				private JLabel lblCmb;
	    				private JComboBox cmbTyp;
	    			private JPanel bezeichnungPanel;
	    				private JLabel lblBezeichnung;
	    				private JSelectedTextField txtBezeichnung;
	    			private JPanel rezepturPanel;
	    				private JPanel rezepturButtonPanel;
		    				private JComboBox cmbSorte;
		    				private JLabel lblRezeptur;
		    				private JButton btRezeptur;
		    				private JButton btRezepturRemove;
		    			private JPanel rezepturMengenPanel;
		    				private JNumberField txtLa;
		    				private JLabel lblLa;
		    				private JNumberField txtStaerke;
		    				private JLabel lblStaerke;
		    				private JSelectedTextField txtLosnummer;
		    				private JLabel lblLosnummer;
	    		private JPanel bemerkungenPanel;
	    			private JLabel lblBemerkungen;
	    			private JScrollPane scrBemerkungen;
	    				private JTextArea txtBemerkungen;
	    			private JPanel adressPanel;
	    				private JLabel lblAdresse;
	    				private JPanel adresseButtonPanel;
	    					private JButton btAdresseAdd;
	    					private JButton btAdresseDelete;
	    			private JPanel pbPanel;
		    			private JPanel probenPanel;
		    				private JLabel lblProbe;
		    				private JIntegerField txtProbe;
							private JButton btProbe;
							private JButton btProbeDelete;
		    			private JPanel bewertungenPanel;
		    				private JLabel lblBewertung;
		    				private JButton btBewertungValue;
							private JButton btBewertung;
							private JButton btBewertungDelete;
						private JPanel kontrollPanel;
							private JLabel lblKontrolle;
							private JPanel kontrollPanelButtons;
								private JButton btKontrolle;
								private JButton btKontrolleDelete;
						private JPanel dmPanel;
							private JButton btDM;
	    				
	    	private JPanel buttonPanel;
	    		private JButton btOK;
	    		private JButton btHilfe;
	    		private JButton btCancel;

	    // ActionCodes KalkulationEingabe
	    public static final int         ACTION_SAVE_CODE = 1000;
	    public static final String      ACTION_SAVE_TEXT = "ticketeingabe.action_save";
	    public static final int         ACTION_ABBRECHEN_CODE = 1001;
	    public static final String      ACTION_ABBRECHEN_TEXT = "ticketeingabe.action_abbrechen";
	    public static final int         ACTION_HILFE_CODE = 1002;
	    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
	    public static final int         ACTION_HIDE_CODE = 1003;
	    public static final String      ACTION_HIDE_TEXT = "action_hide";
	    public static final int         ACTION_REZEPTUR_CODE = 1004;
	    public static final String      ACTION_REZEPTUR_TEXT = "ticketeingabe.action_rezeptur";
	    public static final int         ACTION_REZEPTUR_REMOVE_CODE = 1005;
	    public static final String      ACTION_REZEPTUR_REMOVE_TEXT = "ticketeingabe.action_rezeptur_remove";
	    public static final int         ACTION_ADRESSE_ADD_CODE = 1006;
	    public static final String      ACTION_ADRESSE_ADD_TEXT = "ticketeingabe.action_adresse_add";
	    public static final int         ACTION_ADRESSE_DELETE_CODE = 1007;
	    public static final String      ACTION_ADRESSE_DELETE_TEXT = "ticketeingabe.action_adresse_delete";
	    public static final int         ACTION_PROBE_CODE = 1008;
	    public static final String      ACTION_PROBE_TEXT = "ticketeingabe.action_probe";
	    public static final int         ACTION_PROBE_DELETE_CODE = 1009;
	    public static final String      ACTION_PROBE_DELETE_TEXT = "ticketeingabe.action_probe_delete";
	    public static final int         ACTION_BEWERTUNG_CODE = 1010;
	    public static final String      ACTION_BEWERTUNG_TEXT = "ticketeingabe.action_bewertung";
	    public static final int         ACTION_BEWERTUNG_DELETE_CODE = 1011;
	    public static final String      ACTION_BEWERTUNG_DELETE_TEXT = "ticketeingabe.action_bewertung_delete";
	    public static final int         ACTION_KONTROLLE_CODE = 1012;
	    public static final String      ACTION_KONTROLLE_TEXT = "ticketeingabe.action_kontrolle";
	    public static final int         ACTION_KONTROLLE_DELETE_CODE = 1013;
	    public static final String      ACTION_KONTROLLE_DELETE_TEXT = "ticketeingabe.action_kontrolle_delete";
	    public static final int         ACTION_DM_CODE = 1014;
	    public static final String      ACTION_DM_TEXT = "ticketeingabe.action_dm";
	    
	    
	    JRzFrame			origin;
	    TicketItem			ticket;
	    MischungsItem		mischung;
	    ZutatenDialog		zd;
	    Color				btBackgroundColor;
	    boolean				edit = false;
	    int					sorte=0;
	    boolean				defaultTicket = false;
	    
	    /** Creates new form AdressAuswahl */

	    public TicketEingabe(RzPro r, String name,Object extendedData) {
	        super(r,name,extendedData);
	        createActions();
	        createGUIComponents();
	        setGUIComponents();
	        getMessage((MessageItem)extendedData);
	    }

	    @Override
		public void createGUIComponents() {
	        mb = new JMenuBar();
			mnuDatei = new JMenu();
				mb.add(mnuDatei);
	        mnuExtras = new JMenu();
	        	mb.add(mnuExtras);
	        mnuHilfe = new JMenu();
	        	mb.add(mnuHilfe);
			setJMenuBar(mb);
			mainPanel = new JPanel(new BorderLayout());
				toolbarPanel = new JPanel(new BorderLayout());
					tb1 = new JToolBar();
					tb1.setFloatable(false);
					tb1.setRollover(true);
					toolbarPanel.add(tb1);
				mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel  = new JPanel(new BorderLayout());
					datenPanel = new JPanel();
						datenPanel.setLayout(new BoxLayout(datenPanel,BoxLayout.PAGE_AXIS));
							cmbPanel = new JPanel(new BorderLayout());
								lblCmb = new JLabel();
									lblCmb.setHorizontalAlignment(SwingConstants.TRAILING);
								cmbPanel.add(lblCmb,BorderLayout.WEST);
								cmbTyp = new JComboBox(rz.getDatabase().getMischungen().getTicketCmbData().toArray());
								cmbTyp.setRenderer(new DefaultListCellRenderer(){
								    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
								    Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
								    JLabel label = new JLabel();
								    ticketCmbData tcd = (ticketCmbData)value;
								    label.setOpaque(true);
								    label.setForeground(comp.getForeground());
								    label.setBackground(comp.getBackground());
								    label.setIcon(tcd.getIcon());
								    label.setText(tcd.getText());
								    return label;
								    }
								});
								cmbTyp.addActionListener(new java.awt.event.ActionListener() {
	    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    			                    cmbTypAction();
	    			                	}
	    			            	});
								cmbPanel.add(cmbTyp,BorderLayout.CENTER);
								cmbPanel.setBorder(BorderFactory.createEtchedBorder());
					datenPanel.add(cmbPanel);
						bezeichnungPanel = new JPanel(new BorderLayout());
							lblBezeichnung = new JLabel();
								lblBezeichnung.setHorizontalAlignment(SwingConstants.TRAILING);
							bezeichnungPanel.add(lblBezeichnung,BorderLayout.WEST);
							txtBezeichnung = new JSelectedTextField();
							bezeichnungPanel.add(txtBezeichnung,BorderLayout.CENTER);
							bezeichnungPanel.setBorder(BorderFactory.createEtchedBorder());
						datenPanel.add(bezeichnungPanel);
						rezepturPanel = new JPanel(new BorderLayout());
							rezepturPanel.setBorder(BorderFactory.createEtchedBorder());
								rezepturButtonPanel = new JPanel(new GridLayout(1,4));
    								cmbSorte = new JComboBox(rz.getDatabase().getMischungen().getSorten().toArray());
    								rezepturButtonPanel.add(cmbSorte);
    								lblRezeptur = new JLabel();
    								rezepturButtonPanel.add(lblRezeptur);
    								btRezeptur = new JButton();
    									btBackgroundColor = btRezeptur.getBackground();
    								rezepturButtonPanel.add(btRezeptur);
    								btRezepturRemove = new JButton();
    								rezepturButtonPanel.add(btRezepturRemove);
    						rezepturPanel.add(rezepturButtonPanel,BorderLayout.NORTH);
    							rezepturMengenPanel = new JPanel(new GridLayout(3,2));
    								txtLa = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0,0,Double.POSITIVE_INFINITY);
    								rezepturMengenPanel.add(txtLa);
    								lblLa = new JLabel();
    									lblLa.setHorizontalAlignment(SwingConstants.LEADING);
    								rezepturMengenPanel.add(lblLa);
    								txtStaerke = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_STAERKE),0,0,99.99999);
    								rezepturMengenPanel.add(txtStaerke);
    								lblStaerke = new JLabel();
    									lblStaerke.setHorizontalAlignment(SwingConstants.LEADING);
    								rezepturMengenPanel.add(lblStaerke);
    								txtLosnummer = new JSelectedTextField();
    								rezepturMengenPanel.add(txtLosnummer);
    								lblLosnummer = new JLabel();
    									lblLosnummer.setHorizontalAlignment(SwingConstants.LEADING);
    								rezepturMengenPanel.add(lblLosnummer);
    						rezepturPanel.add(rezepturMengenPanel,BorderLayout.SOUTH);
					datenPanel.add(rezepturPanel);
					
					bemerkungenPanel = new JPanel(new BorderLayout());
					bemerkungenPanel.setBorder(BorderFactory.createEtchedBorder());
						lblBemerkungen = new JLabel();
							lblBemerkungen.setHorizontalAlignment(SwingConstants.CENTER);
						bemerkungenPanel.add(lblBemerkungen,BorderLayout.NORTH);
						scrBemerkungen = new JScrollPane();
							txtBemerkungen = new JTextArea();
							scrBemerkungen.setViewportView(txtBemerkungen);
						bemerkungenPanel.add(scrBemerkungen,BorderLayout.CENTER);
						
						adressPanel = new JPanel(new BorderLayout());
							adressPanel.setBorder(BorderFactory.createEtchedBorder());
								lblAdresse = new JLabel();
									lblAdresse.setHorizontalAlignment(SwingConstants.TRAILING);
								adressPanel.add(lblAdresse,BorderLayout.CENTER);
								adresseButtonPanel = new JPanel(new GridLayout(1,2));
									btAdresseAdd = new JButton();
									adresseButtonPanel.add(btAdresseAdd);
									btAdresseDelete = new JButton();
									adresseButtonPanel.add(btAdresseDelete);
								adressPanel.add(adresseButtonPanel,BorderLayout.EAST);
								
								pbPanel = new JPanel(new GridLayout(4,1));
									probenPanel = new JPanel(new GridLayout(1,4));
										probenPanel.setBorder(BorderFactory.createEtchedBorder());
										lblProbe = new JLabel();
											lblProbe.setHorizontalAlignment(SwingConstants.TRAILING);
										probenPanel.add(lblProbe);
										txtProbe = new JIntegerField(0,0,Integer.MAX_VALUE);
										probenPanel.add(txtProbe);
										btProbe = new JButton();
										probenPanel.add(btProbe);
										btProbeDelete = new JButton();
										probenPanel.add(btProbeDelete);
									pbPanel.add(probenPanel,BorderLayout.NORTH);
									
									bewertungenPanel = new JPanel(new GridLayout(1,3));
									bewertungenPanel.setBorder(BorderFactory.createEtchedBorder());
									lblBewertung = new JLabel();
										lblBewertung.setHorizontalAlignment(SwingConstants.TRAILING);
									bewertungenPanel.add(lblBewertung);
									btBewertung = new JButton();
									bewertungenPanel.add(btBewertung);
									btBewertungDelete = new JButton();
									bewertungenPanel.add(btBewertungDelete);
								pbPanel.add(bewertungenPanel,BorderLayout.NORTH);
									
									kontrollPanel = new JPanel(new BorderLayout());
									    kontrollPanel.setBorder(BorderFactory.createEtchedBorder());
										lblKontrolle = new JLabel();
										kontrollPanel.add(lblKontrolle,BorderLayout.CENTER);
										kontrollPanelButtons = new JPanel(new GridLayout(1,2));
									 		btKontrolle = new JButton();
									 		kontrollPanelButtons.add(btKontrolle);
									 		btKontrolleDelete = new JButton();
									 		kontrollPanelButtons.add(btKontrolleDelete);
									 	kontrollPanel.add(kontrollPanelButtons,BorderLayout.EAST);
								pbPanel.add(kontrollPanel);	
								
								dmPanel = new JPanel (new BorderLayout());
									btDM = new JButton();
									dmPanel.add(btDM,BorderLayout.EAST);
								if(rz.getDatabase().getDM().isConnected()) {
									pbPanel.add(dmPanel);
								}
								
								adressPanel.add(pbPanel,BorderLayout.SOUTH);
						bemerkungenPanel.add(adressPanel,BorderLayout.SOUTH);
					contentPanel.add(bemerkungenPanel,BorderLayout.CENTER);
				contentPanel.add(datenPanel,BorderLayout.NORTH);
				buttonPanel=new JPanel(new GridLayout(1,3));
	    			btOK=new JButton();
	    				buttonPanel.add(btOK);
	    			btHilfe = new JButton();
	    				buttonPanel.add(btHilfe);
	    		    btCancel = new JButton();
	    		    	buttonPanel.add(btCancel);
				mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
				mainPanel.add(buttonPanel,BorderLayout.SOUTH);

				getContentPane().setLayout(new BorderLayout());
				getContentPane().add(mainPanel,BorderLayout.CENTER);
	    }
	    @Override
		public void setGUIComponents() {
	        setTitle(rz.getLocale().getString("ticketeingabe.titel"));

	        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
	        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
	        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
	        mnuDatei.add(getAction(ACTION_SAVE_CODE));
	        mnuDatei.addSeparator();
	        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
	        mnuExtras.add(getAction(ACTION_HIDE_CODE));
	        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

	  	  	tb1.add(getAction(ACTION_SAVE_CODE));
	  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
	  	  	tb1.addSeparator();
	  	  	tb1.add(getAction(ACTION_HIDE_CODE));
	  	  	tb1.addSeparator();
	  	  	tb1.add(getAction(ACTION_HILFE_CODE));

	        btOK.setAction(getAction(ACTION_SAVE_CODE));
	        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
	        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
	        btRezeptur.setAction(getAction(ACTION_REZEPTUR_CODE));
	        btRezepturRemove.setAction(getAction(ACTION_REZEPTUR_REMOVE_CODE));
	        btAdresseAdd.setAction(getAction(ACTION_ADRESSE_ADD_CODE));
	        btAdresseDelete.setAction(getAction(ACTION_ADRESSE_DELETE_CODE));
	        btProbe.setAction(getAction(ACTION_PROBE_CODE));
	        btProbeDelete.setAction(getAction(ACTION_PROBE_DELETE_CODE));
	        btBewertung.setAction(getAction(ACTION_BEWERTUNG_CODE));
	        btBewertungDelete.setAction(getAction(ACTION_BEWERTUNG_DELETE_CODE));
	        btKontrolle.setAction(getAction(ACTION_KONTROLLE_CODE));
	        btKontrolleDelete.setAction(getAction(ACTION_KONTROLLE_DELETE_CODE));
	        btDM.setAction(getAction(ACTION_DM_CODE));
	        
	        getAction(ACTION_PROBE_CODE).setEnabled(false);
			getAction(ACTION_PROBE_DELETE_CODE).setEnabled(false);
	        getAction(ACTION_BEWERTUNG_CODE).setEnabled(false);
			getAction(ACTION_BEWERTUNG_DELETE_CODE).setEnabled(false);
			txtProbe.setEditable(false);txtProbe.setEnabled(false);
	        
	        lblCmb.setText(rz.getLocale().getString("ticketeingabe.label_typ"));
	        lblBezeichnung.setText(rz.getLocale().getString("ticketeingabe.label_bezeichnung"));
	        lblLa.setText(rz.getLocale().getString("ticketeingabe.label_la"));
	        lblStaerke.setText(rz.getLocale().getString("ticketeingabe.label_staerke"));
	        lblBemerkungen.setText(rz.getLocale().getString("ticketeingabe.label_bemerkungen"));	        
	        lblLosnummer.setText(rz.getLocale().getString("ticketeingabe.label_losnummer"));
    		lblProbe.setText(rz.getLocale().getString("ticketeingabe.label_probe"));
	        setResizable(true);
	        rz.getFontFactory().setFrameFonts(this);
	        pack();
	        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
	    }
	    @Override
		public void getMessage(MessageItem msg) {
	        switch(msg.getMsgCode()) {
	    	case MessageItem.MSG_ACTIONPERFORMED:
	            switch(msg.getCode()){
	            case ACTION_ABBRECHEN_CODE :cancelAction();break;
				case ACTION_SAVE_CODE :saveAction();break;
	            case ACTION_HILFE_CODE: hilfeAction();break;
	            case ACTION_HIDE_CODE:hideAction();break;
	            case ACTION_REZEPTUR_CODE:selectRezepturAction();break;
	            case ACTION_REZEPTUR_REMOVE_CODE:deselectRezepturAction();break;
	            case ACTION_ADRESSE_ADD_CODE:adresseAddAction();break;
	            case ACTION_ADRESSE_DELETE_CODE: adresseDeleteAction();break;
	            case ACTION_PROBE_CODE:probenAction();break;
	            case ACTION_PROBE_DELETE_CODE:probenDeleteAction();break;
	            case ACTION_BEWERTUNG_CODE:bewertungAction();break;
	            case ACTION_BEWERTUNG_DELETE_CODE:bewertungDeleteAction();break;
	            case ACTION_KONTROLLE_CODE:kontrolleAction();break;
	            case ACTION_KONTROLLE_DELETE_CODE:kontrolleDeleteAction();break;
	            case ACTION_DM_CODE:DMAction();break;
	            default :
	                break;
	           }
	    		break;
	    	case MessageItem.MSG_REFRESH_AUSGABE:
	    		BewertungsItem bwi = (BewertungsItem)msg.getData();
	    		if(bwi != null) {
	    			if(ticket != null) {
	    				ticket.setBewertung(bwi.getId());
	    				ticket.setBewertungValue(bwi.getBewertung());
	    				rz.getDatabase().getMischungen().updateBewertung(ticket.getId(), ticket.getBewertung());
	    				fromItem();
	    			}
	    		}
	    		break;
	    	 case MessageItem.MSG_SELECT_ADRESSE_REPLY:
	             ticket.setAdresse_id(msg.getCode());
	         	 AdressItem ai = ((AdressItem)msg.getData());
	         	 ticket.setAdresse(ai.getFirma() + ","+ai.getPLZ()+" "+ai.getOrt());
	         	 lblAdresse.setText(ticket.getAdresse());
	             break;
	      	 case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
	    	 		zutatenDialogReply((ZutatenSuchItem)msg.getData());
	  			break;
	         case MessageItem.MSG_SHOW_TICKETEINGABE_EDIT:
	 			 origin = msg.getOrigin();
	 			 ticket = (TicketItem)msg.getData();
	 			 mischung = rz.getDatabase().getMischungen().getMischung(ticket.getMischung());
	 			 fromItem();
	 			 cmbTyp.setEnabled(false);
	 			 txtLa.setEnabled(false);
	 			 edit = true;
		      	 break;
	         case MessageItem.MSG_SHOW_TICKETEINGABE_EDIT_DEFAULT:
	 			 origin = msg.getOrigin();
	 			 ticket = (TicketItem)msg.getData();
	 			 mischung = new MischungsItem(rz,0);
	 			 fromItem();
	 			 cmbTyp.setEnabled(false);
	 			 txtLa.setEnabled(false);
	 			 cmbSorte.setVisible(false);
	 			 edit = true;
	 			 defaultTicket = true;
		      	 break;
	         case MessageItem.MSG_SHOW_TICKETEINGABE_DEFAULT:
	 			 origin = msg.getOrigin();
	 			 ticket = new TicketItem(rz);
	 			 mischung = new MischungsItem(rz,0);
	 			 ticket.setMischung(0);
	 			 edit = false;
	 			 sorte = msg.getCode();
	 			 ticket.setSorte(sorte);
	 			 this.cmbSorte.setVisible(false);
	 			 defaultTicket = true;
		      	 break;
	         case MessageItem.MSG_SHOW_TICKETEINGABE:
	 			 origin = msg.getOrigin();
	 			 mischung = (MischungsItem)msg.getData();
	 			 ticket = new TicketItem(rz);
	 			 ticket.setMischung(mischung.getHeader().getId());
	 			 edit = false;
		      	 break;
	         case MessageItem.MSG_PROPAGATE_PROBEN:
	        	 int probe = msg.getCode();
	        	 if(ticket != null) {
	        		 ticket.setProbe(probe);
	        		 rz.getDatabase().getMischungen().updateProbenNummer(ticket.getId(), ticket.getProbe());
	        		 setProbenLabel();
	        	 }
	        	 break;
	        default:
	            break;
	        }
	    }

	    @Override
		public void createActions(){
	        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
	        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
			actionList.put(String.valueOf(ACTION_SAVE_CODE), new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT,KeyEvent.VK_S,	InputEvent.CTRL_DOWN_MASK));
			actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
			actionList.put(String.valueOf(ACTION_REZEPTUR_CODE), new AuswahlAction(rz,this, ACTION_REZEPTUR_CODE,ACTION_REZEPTUR_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_REZEPTUR_REMOVE_CODE), new AuswahlAction(rz,this, ACTION_REZEPTUR_REMOVE_CODE,ACTION_REZEPTUR_REMOVE_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_ADRESSE_ADD_CODE), new AuswahlAction(rz,this, ACTION_ADRESSE_ADD_CODE,ACTION_ADRESSE_ADD_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_ADRESSE_DELETE_CODE), new AuswahlAction(rz,this, ACTION_ADRESSE_DELETE_CODE,ACTION_ADRESSE_DELETE_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_PROBE_CODE), new AuswahlAction(rz,this, ACTION_PROBE_CODE,ACTION_PROBE_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_PROBE_DELETE_CODE), new AuswahlAction(rz,this, ACTION_PROBE_DELETE_CODE,ACTION_PROBE_DELETE_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_BEWERTUNG_CODE), new AuswahlAction(rz,this, ACTION_BEWERTUNG_CODE,ACTION_BEWERTUNG_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_BEWERTUNG_DELETE_CODE), new AuswahlAction(rz,this, ACTION_BEWERTUNG_DELETE_CODE,ACTION_BEWERTUNG_DELETE_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_KONTROLLE_CODE), new AuswahlAction(rz,this, ACTION_KONTROLLE_CODE,ACTION_KONTROLLE_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_KONTROLLE_DELETE_CODE), new AuswahlAction(rz,this, ACTION_KONTROLLE_DELETE_CODE,ACTION_KONTROLLE_DELETE_TEXT,0, 0));
			actionList.put(String.valueOf(ACTION_DM_CODE), new AuswahlAction(rz,this, ACTION_DM_CODE,ACTION_DM_TEXT,0, 0));


	    }

	    private void DMAction() {
			DMDialog dd = new DMDialog(rz,ticket,this);
			if(dd != null){
				dd.setModal(false);
				dd.showDialog();
			}
	    }
	    
	    private void kontrolleAction() {
	    	if(ticket != null) {
	    		KontrollDialog kd = new KontrollDialog(rz,ticket);
	    		kd.showDialog();
	    		kd.dispose();
	    		setKontrolle(ticket);
	    	}
	    }
	    
	    private void kontrolleDeleteAction() {
	    	if(ticket != null) {
	    		ticket.setKontrolle("");
	    		setKontrolle(ticket);
	    	}
	    }
	    
	    private void probenDeleteAction() {
	    	txtProbe.setValue(0);
	    	if(ticket != null) {
	    		ticket.setProbe(0);
	    		rz.getDatabase().getMischungen().updateProbenNummer(ticket.getId(), 0);
	    		setProbenLabel();
	    	}
	    }
	    
	    private void probenAction() {
	    	if(ticket != null) {
	    		toItem();
	    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBEN_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_PROBENEINGABE_TICKET,0,ticket,this));
	    	}
	    }
	    

	    private void bewertungDeleteAction() {
	    	txtProbe.setValue(0);
	    	if(ticket != null) {
	    		int b = ticket.getBewertung();
		    		if(b != 0) {
		    		ticket.setBewertung(0);
		    		ticket.setBewertungValue(0.0);
		    		rz.getDatabase().getMischungen().updateBewertung(ticket.getId(), 0);
		    		rz.getDatabase().getBewertungen().deleteBewertung(b);
		    		setBewertungLabel();
		    	}
	    	}
	    }
	    
	    private void bewertungAction() {
	    	if(ticket != null) {
	    		BewertungsItem bwi ;
	    		if(ticket.getBewertung() != 0) {
						bwi = rz.getDatabase().getBewertungen().getBewertung(ticket.getBewertung());		 						
					} else {
						bwi = rz.getDatabase().getBewertungen().getBewertung(rz.getLocale().getString("bewertungen.ticket").replaceAll("%n", ticket.getNummer()),ticket.getBezeichnung());
					}
	    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSEINGABE,0,bwi,this));
	    	}
	    }
	    
	    private void adresseAddAction() {
	    	String firma = "";
	    	if(ticket != null && ticket.getAdresse_id() != 0){
	    		firma = rz.getDatabase().getAdressen().dbGetAdresse(ticket.getAdresse_id(),true).getFirma();
	    	}
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL_EINFACH,true, new MessageItem(MessageItem.MSG_SELECT_ADRESSE_REQUEST,0, firma,this));
	    }
	    
	    private void adresseDeleteAction() {
	    	if(ticket != null) {
	    		ticket.setAdresse_id(0);
	    		ticket.setAdresse("");
	    		lblAdresse.setText("");
	    	}
	    }
	    
	    
	    private void saveAction() {
	    	if(defaultTicket) {
	    		if(ticket != null) {
	    			if(toItem()) {
	    				ticket.setSorte(sorte);
	    				if(edit) {
	    					rz.getDatabase().getMischungen().updateTicket(ticket);
	    				}else {
	    					rz.getDatabase().getMischungen().saveStandardTicket(ticket);
	    				}
		    			try {
		    					origin.getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE_EDIT_TICKET,ticket.getId(),null,this ));	    					
		    			}catch(Exception e) {}
		    			closeWindow();
	    			}
	    		}
	    	}else {
	    		saveActionNoDefault();
	    	}
	    }
	    
	    private void saveActionNoDefault() {
	    	ticketCmbData typ = (ticketCmbData)cmbTyp.getSelectedItem();
	    	if(typ != null) {
	    		boolean validate = false;
	    		if(typ.getTyp() == TicketItem.TYP_WARE) {
	    			validate = validateWare();
	    		}else if(typ.getTyp() == TicketItem.TYP_ENTNAHME){
	    			validate = validateEntnahme();
	    		} else {
	    			validate = validateOther();
	    		}
	    		if(validate) {
	    			if(toItem()) {
		    			if(edit) {
		    				rz.getDatabase().getMischungen().updateTicket(ticket);
		    			}else {
		    				rz.getDatabase().getMischungen().saveEinzelTicketTransaktion(mischung,mischung.getHeader().getTank(),ticket);
		    			}
		    			
		    			try {
		    				if(edit) {
		    					origin.getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE_EDIT_TICKET,ticket.getId(),null,this ));	    					
		    				}else {
		    					origin.getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,mischung.getHeader().getId(),null,this ));
		    				}
		    				rz.getFensterFactory().getFensterListe().propagateBestand(this);
		    			}catch(Exception e) {}
		    			closeWindow();
	    			}
	    		}
	    	}
	    }
	    private boolean validateEntnahme() {
	    	if(txtBezeichnung.getText().trim().equals("")) {
	    		showDialog(rz.getLocale().getString("ticketeingabe.dialog_bezeichnung"));
	    		return false;
	    	}
	    	if(rz.isZero(txtLa.getValue())){
	    		showDialog(rz.getLocale().getString("ticketeingabe.dialog_menge"));
	    		return false;
	    	}
	    	return true;
	    }
	    
	    private boolean validateWare() {
	    	if(txtBezeichnung.getText().trim().equals("")) {
	    		showDialog(rz.getLocale().getString("ticketeingabe.dialog_bezeichnung"));
	    		return false;
	    	}
	    	if(rz.isZero(txtLa.getValue())){
	    		showDialog(rz.getLocale().getString("ticketeingabe.dialog_menge"));
	    		return false;
	    	}
	    	return true;
	    }
	    
	    private void showDialog(String text) {
	    	DialogItem di  = new DialogItem(
                    DialogControl.HINWEIS_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("ticketeingabe.dialog_unvollstaendig"),
                    rz.getLocale().getString("ticketeingabe.dialog_unvollstaendig"),
                    text,
                    "warnung.png",
                    rz.getLocale().getString("string_ok"),
                    "",
                    this
            );
            rz.getDialogFactory().getDialog(di);
	    }
	    
	    private boolean validateOther() {
	    	 if(txtBezeichnung.getText().trim().equals("")){
		    	showDialog(rz.getLocale().getString("ticketeingabe.dialog_bezeichnung"));
	    		return false;
	    	 }
	    	 return true;
	    }
	    private void cancelAction(){
	        closeWindow();
	    }

	    /**
	     * Daten vom Item in die GUI übertragen
	     *
	     */
	    private void fromItem(){
    		setProbenLabel();
    		setBewertungLabel();
	    	if(ticket.getId() != 0) {
		        getAction(ACTION_PROBE_CODE).setEnabled(true);
				getAction(ACTION_BEWERTUNG_CODE).setEnabled(true);
				getAction(ACTION_DM_CODE).setEnabled(true);
	    	} else {
		        getAction(ACTION_PROBE_CODE).setEnabled(false);
				getAction(ACTION_BEWERTUNG_CODE).setEnabled(false);
				getAction(ACTION_DM_CODE).setEnabled(false);
	    	}
	    	for(int i = 0;i < cmbTyp.getModel().getSize();i++) {
	    		if(((ticketCmbData)cmbTyp.getItemAt(i)).getTyp() == ticket.getTyp()) {
	    			cmbTyp.setSelectedIndex(i);
	    			break;
	    		}
	    	}
	    	ticket.setRezeptur_id(mischung.getHeader().getRezeptur_id());
	    	if(ticket.getRezeptur_id() != 0) {
	    		btRezeptur.setBackground(Color.YELLOW);
	    	}else {
	    		btRezeptur.setBackground(btBackgroundColor);
	    	}
	    	txtLa.setValue(ticket.getLa());
	    	txtStaerke.setValue(ticket.getStaerke());
	    	txtBezeichnung.setText(ticket.getBezeichnung());
	    	try {
	    		lblRezeptur.setText(rz.getDatabase().getRezeptur().dbGetRezepturName(ticket.getRezeptur_id()));
	    	} catch(Exception e) {}
	    	txtBemerkungen.setText(ticket.getBemerkungen());
	    	txtLosnummer.setText(ticket.getLosnummer_original());
	    	if(ticket.getAdresse_id() != 0) {
	    		lblAdresse.setText(ticket.getAdresse());
	    	}
	    	MischungsItem mi =null;
	    	if(ticket.getMischung() != 0) {
	    		 mi = rz.getDatabase().getMischungen().getMischung(ticket.getMischung());
	    	} else {
	    		mi = new MischungsItem(rz,0);
	    	}
	    	int select = 0;
	    	if (mi != null) {
		    	if(ticket.getId() == 0) {
		    		select = mi.getHeader().getSorte().getId(); 
		    	} else {
		    		select = ticket.getSorte();
		    	}
	    		for(int i = 0;i < cmbSorte.getModel().getSize();i++) {
	    			if(((SortenItem)cmbSorte.getItemAt(i)).getId() == select) {
	    				cmbSorte.setSelectedIndex(i);
	    				break;
	    			}
	    		}
	    	}
	    	setKontrolle(ticket);
	   }

	    private void setKontrolle(TicketItem ti) {
	    	if(!ti.getKontrolle().trim().equals("")) {
	    		lblKontrolle.setText(rz.getLocale().getString("ticketeingabe.label_kontrolle").replaceAll("%d", ti.getKontrolle_datum_text()).replaceAll("%s", ti.getKontrolle()));
	    	}else {
	    		lblKontrolle.setText(rz.getLocale().getString("ticketeingabe.label_kontrolle_nicht_kontrolliert"));
	    	}
	    }
	    
	    /**
	     * GUI-Daten in das Item übertragen
	     *
	     */
	    private boolean toItem(){
	    	boolean ret = true;
	    	if(ticket != null) {
	    		ticket.setProbe(txtProbe.getValue());
	    		ticket.setTyp(((ticketCmbData)cmbTyp.getSelectedItem()).getTyp());
	    		ticket.setBezeichnung(txtBezeichnung.getText().trim());
	    		ticket.setBemerkungen(txtBemerkungen.getText().trim());
	    		ticket.setLa(txtLa.getValue());
	    		ticket.setStaerke(txtStaerke.getValue());
	    		if(ticket.getMischung()!=0) {
	    			ticket.setSorte(((SortenItem)cmbSorte.getSelectedItem()).getId());
	    		}
	    		ticket.setLosnummer_original(txtLosnummer.getText().trim());
	    		if(ticket.getTyp() == TicketItem.TYP_WARE || ticket.getTyp() == TicketItem.TYP_ENTNAHME) {
		    			if(!rz.getDatabase().getMischungen().checkMischung(mischung, ticket.getSorte())) {
		    			ret = false;
		    			final DialogItem di  = new DialogItem(
	 		                    DialogControl.FRAGE_DIALOG,
	 		                    "",0.0,
	 		                    rz.getLocale().getString("ticketeingabe.question_mischung_inkompatibel"),
	 		                    rz.getLocale().getString("ticketeingabe.question_mischung_inkompatibel"),
	 		                    rz.getLocale().getString("ticketeingabe.question_mischung_inkompatibel.text")
	 		                    	.replaceAll("%m2",mischung.getHeader().getSorte().getBezeichnung())
	 		                    	.replaceAll("%m1",((SortenItem)cmbSorte.getSelectedItem()).getBezeichnung()),
	 		                    "frage.png",
	 		                    rz.getLocale().getString("string_ja"),
	 		                    rz.getLocale().getString("string_nein"),
	 		                    this
	 						);
	 		         rz.getDialogFactory().getDialog(di);
	 		         if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	 		        	 ret = true;
	 		         	}
		    		}
	    		}
	    	}
	    	return ret;
	    }

	    private void setProbenLabel() {
	    	if(ticket != null) {
	    		txtProbe.setValue(ticket.getProbe());
	    	}
	    }
	    private void setBewertungLabel() {
	    	if(ticket != null) {
	    		lblBewertung.setText(ticket.getBewertung() == 0?"":rz.getLocale().getString("ticketeingabe.label_bewertung")
	    				.replaceAll("%n", String.valueOf(ticket.getBewertung()))
	    				.replaceAll("%v",  rz.getDatabase().getBewertungen().getColorItem().getValue(ticket.getBewertungValue()) + " " + rz.getLocale().getString("punkte") + " "  + " ("+ rz.getDatabase().getBewertungen().getColorItem().getText(ticket.getBewertungValue()) +")")
	    				);
	    	}
	    }
	    
	    @Override
		public void closeWindow(){
	    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
	    }
	    @Override
		public void openWindow(){
	    	if(mischung != null) {
	    		fromItem();
	    		setVisible(true);
	    		toFront();
	    		txtBezeichnung.requestFocus();
	    	}else {
	    		closeWindow();
	    	}
	    }

	    private void cmbTypAction() {
	    	ticketCmbData tcm = (ticketCmbData)cmbTyp.getSelectedItem();
	    	if(tcm != null) {
	    		switch (tcm.getTyp()){
	    			case TicketItem.TYP_WARE:
	    				rezepturPanel.setVisible(true);
	    				lblStaerke.setVisible(true);
	    				txtStaerke.setVisible(true);
	    				lblLosnummer.setVisible(true);
	    				txtLosnummer.setVisible(true);
	    				if(ticket != null && ticket.getId() != 0) {
	    					getAction(ACTION_PROBE_CODE).setEnabled(true);
	    					getAction(ACTION_PROBE_DELETE_CODE).setEnabled(true);
	    					getAction(ACTION_BEWERTUNG_CODE).setEnabled(true);
	    					getAction(ACTION_BEWERTUNG_DELETE_CODE).setEnabled(true);
	    					txtProbe.setEditable(true);txtProbe.setEnabled(true);
	    				} else {
	    					getAction(ACTION_PROBE_CODE).setEnabled(false);
	    					getAction(ACTION_PROBE_DELETE_CODE).setEnabled(false);
	    					getAction(ACTION_BEWERTUNG_CODE).setEnabled(false);
	    					getAction(ACTION_BEWERTUNG_DELETE_CODE).setEnabled(false);
	    					txtProbe.setEditable(false);txtProbe.setEnabled(false);
	    				}
	    				break;
	    			case TicketItem.TYP_TEXT:
	    				rezepturPanel.setVisible(false);	    			
	    				lblStaerke.setVisible(false);
	    				txtStaerke.setVisible(false);
	    				lblLosnummer.setVisible(false);
	    				txtLosnummer.setVisible(false);
	    				if(ticket != null && ticket.getId() != 0) {
	    					getAction(ACTION_PROBE_CODE).setEnabled(true);
	    					getAction(ACTION_PROBE_DELETE_CODE).setEnabled(true);
	    					getAction(ACTION_BEWERTUNG_CODE).setEnabled(true);
	    					getAction(ACTION_BEWERTUNG_DELETE_CODE).setEnabled(true);
	    					txtProbe.setEditable(true);txtProbe.setEnabled(true);
	    				} else {
	    					getAction(ACTION_PROBE_CODE).setEnabled(false);
	    					getAction(ACTION_PROBE_DELETE_CODE).setEnabled(false);
	    					getAction(ACTION_BEWERTUNG_CODE).setEnabled(false);
	    					getAction(ACTION_BEWERTUNG_DELETE_CODE).setEnabled(false);
	    					txtProbe.setEditable(false);txtProbe.setEnabled(false);
	    				}
	    				break;
	    			case TicketItem.TYP_ENTNAHME:
	    				rezepturPanel.setVisible(true);
	    				lblStaerke.setVisible(false);
	    				txtStaerke.setVisible(false);
	    				lblLosnummer.setVisible(false);
	    				txtLosnummer.setVisible(false);
	    				if(ticket != null && ticket.getId() != 0) {
	    					getAction(ACTION_PROBE_CODE).setEnabled(true);
	    					getAction(ACTION_PROBE_DELETE_CODE).setEnabled(true);
	    					getAction(ACTION_BEWERTUNG_CODE).setEnabled(true);
	    					getAction(ACTION_BEWERTUNG_DELETE_CODE).setEnabled(true);
	    					txtProbe.setEditable(true);txtProbe.setEnabled(true);
	    				} else {
	    					getAction(ACTION_PROBE_CODE).setEnabled(false);
	    					getAction(ACTION_PROBE_DELETE_CODE).setEnabled(false);
	    					getAction(ACTION_BEWERTUNG_CODE).setEnabled(false);
	    					getAction(ACTION_BEWERTUNG_DELETE_CODE).setEnabled(false);
	    					txtProbe.setEditable(false);txtProbe.setEnabled(false);
	    				}
	    				break;
	    			default:
	    				rezepturPanel.setVisible(false);	    			
	    				lblStaerke.setVisible(true);
	    				txtStaerke.setVisible(true);
	    				lblLosnummer.setVisible(true);
	    				txtLosnummer.setVisible(true);
    					getAction(ACTION_PROBE_CODE).setEnabled(false);
    					getAction(ACTION_PROBE_DELETE_CODE).setEnabled(false);
    					getAction(ACTION_BEWERTUNG_CODE).setEnabled(false);
    					getAction(ACTION_BEWERTUNG_DELETE_CODE).setEnabled(false);
    					txtProbe.setEditable(false);txtProbe.setEnabled(false);
	    				break;
	    		}
	    		datenPanel.revalidate();
	    	}
	    	txtBezeichnung.requestFocus();
	    }
	    
	    private void zutatenDialogReply(ZutatenSuchItem zi) {
	    	if(zi != null) {
	    		ticket.setRezeptur_id(zi.getID());
	    		//txtBezeichnung.setText(zi.getName()+ " (" + zi.getArtikelnummer()+")");
	    		lblRezeptur.setText(zi.getName());
	    		btRezeptur.setBackground(Color.yellow);
	    	}
	    	if(zd != null) {
	    		zd.dispose();
	    		zd= null;
	    	}
	    }

	    
	    private void deselectRezepturAction() {
	    	if(ticket != null) {
	    		ticket.setRezeptur_id(0);
	    		lblRezeptur.setText("");
	    		btRezeptur.setBackground(btBackgroundColor);
	    	}
	    }
	    
	    private void selectRezepturAction() {
			int x, y;
			x = (int) (btRezeptur.getLocationOnScreen().getX() );
			y = (int) (btRezeptur.getLocationOnScreen().getY() );
			if(zd != null) {
				zd.dispose();
				zd=null;
			}
			zd = new ZutatenDialog(this, rz, x, y,txtBezeichnung.getText().trim(),ZutatenDialog.MODE_REZEPTUREN);
			zd.setVisible(true);
	    }

		//hilfe
		private void hilfeAction() {
	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"ticketeingabe.html",this));
		}

	    private void hideAction() {
	        rz.getFensterFactory().getFensterListe().sperren(this);
	    }

}
