package de.lunqual.rzpro.fenster.mischungsfenster;

/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JRzList;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.TankDialog;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.items.mischungen.*;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class MischungsEingabeFenster extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel northPanel;
	    		private JPanel bezeichnungPanel;
	    			private JPanel bezeichnungTextPanel;
	    				private JLabel lblBezeichnung;
	    				private JSelectedTextField txtBezeichnung;
	    			private JPanel bezeichnungRezepturPanel;
	    				private JButton btRezeptur;
	    				private JButton btRezepturClear;
	    			private JLabel lblBezeichnungText;
				private JPanel tankPanel;
					private JLabel lblTank;
					private JSelectedTextField txtTank;
					private JPanel tankauswahlPanel;
						private JButton btTankText;
						private JButton btTankPlan;
					private JLabel lblTankBezeichnung;
			private JPanel southPanel;
				private JPanel sortenPanel;
					private JLabel lblSorte;
					private JComboBox cmbSorte;
					private JLabel lblLager;
					private JComboBox cmbLager;
				private JPanel commentPanel;
					private JLabel lblComment;
					private JScrollPane scrComment;
						private JTextArea txtComment;
						
						private JPanel listenPanel;
						private JPanel adressen;
							private JLabel lblAdressenTitel;
							private JScrollPane adressenScrollPane;
										private JRzList lstAdressen;
							private JPanel adressenButtonPane;
								private JButton btAdressenBearbeiten;
								private JButton btAdressenLoeschen;
								
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "mischungeingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "mischungeingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    private static final int        ACTION_TANKLISTE_PLAN_CODE = 1006;
    private static final String     ACTION_TANKLISTE_PLAN_TEXT = "tankliste_plan";
    private static final int        ACTION_TANKLISTE_TEXT_CODE = 1007;
    private static final String    	ACTION_TANKLISTE_TEXT_TEXT = "tankliste_text";
    private static final int        ACTION_REZEPTUR_SET_CODE = 1008;
    private static final String    	ACTION_REZEPTUR_SET_TEXT = "mischungeingabe.action_rezeptur_set";
    private static final int        ACTION_REZEPTUR_RESET_CODE = 1009;
    private static final String    	ACTION_REZEPTUR_RESET_TEXT = "mischungeingabe.action_rezeptur_reset";
    
	public static final int ACTION_ADRESSLISTE_BEARBEITEN_CODE = 1039;
	public static final String ACTION_ADRESSLISTE_BEARBEITEN_TEXT = "mischungbearbeitenfenster.action_adressen_bearbeiten";
	public static final int ACTION_ADRESSLISTE_LOESCHEN_CODE = 1040;
	public static final String ACTION_ADRESSLISTE_LOESCHEN_TEXT = "mischungbearbeitenfenster.action_adressen_loeschen";

    JRzFrame								origin;
    TankDialog								td;
    String 									rezepturBezeichnung;
    int										rezeptur_id;
	ZutatenDialog 							zd;
    MischungsHeaderItem							mi;
    
    /** Creates new form AdressAuswahl */

    public MischungsEingabeFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        rezepturBezeichnung = "";
        rezeptur_id = 0;
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
				northPanel = new JPanel(new BorderLayout());
					northPanel.setBorder(BorderFactory.createEtchedBorder());
					bezeichnungPanel = new JPanel(new BorderLayout());
						bezeichnungTextPanel = new JPanel(new BorderLayout());
		    				lblBezeichnung = new JLabel();
		    				lblBezeichnung.setHorizontalAlignment(SwingConstants.TRAILING);
		    				bezeichnungTextPanel.add(lblBezeichnung,BorderLayout.WEST);
		    				txtBezeichnung = new JSelectedTextField();
		    				bezeichnungTextPanel.add(txtBezeichnung,BorderLayout.CENTER);
		    			bezeichnungPanel.add(bezeichnungTextPanel,BorderLayout.CENTER);
		    			bezeichnungRezepturPanel = new JPanel(new BorderLayout());
		    				btRezeptur = new JButton();
		    				bezeichnungRezepturPanel.add(btRezeptur,BorderLayout.CENTER);
		    				btRezepturClear = new JButton();
		    				bezeichnungRezepturPanel.add(btRezepturClear,BorderLayout.EAST);
		    			bezeichnungPanel.add(bezeichnungRezepturPanel,BorderLayout.EAST);
		    			lblBezeichnungText = new JLabel();
		    				lblBezeichnungText.setHorizontalAlignment(SwingConstants.CENTER);
		    			bezeichnungPanel.add(lblBezeichnungText,BorderLayout.SOUTH);
	    			northPanel.add(bezeichnungPanel,BorderLayout.NORTH);
	    				tankPanel=new JPanel(new BorderLayout());
							lblTank = new JLabel();
							lblTank.setHorizontalAlignment(SwingConstants.TRAILING);
							tankPanel.add(lblTank,BorderLayout.WEST);
							txtTank = new JSelectedTextField();
								txtTank.addFocusListener(new FocusListener() {
									public void focusGained(FocusEvent evt) {
									}
									public void focusLost(FocusEvent evt) {
										setTankLabel(rz.getDatabase().getTank().getTank(txtTank.getText().trim()));
									}
								});
								txtTank.addKeyListener(new java.awt.event.KeyAdapter() {
						            public void keyReleased(java.awt.event.KeyEvent evt) {
						                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
											setTankLabel(rz.getDatabase().getTank().getTank(txtTank.getText().trim()));
										}
						            }
						        });
							tankPanel.add(txtTank,BorderLayout.CENTER);
								tankauswahlPanel=new JPanel(new GridLayout(1,2));
									btTankText = new JButton();
									tankauswahlPanel.add(btTankText);
									btTankPlan = new JButton();
									tankauswahlPanel.add(btTankPlan);
								tankPanel.add(tankauswahlPanel,BorderLayout.EAST);
								lblTankBezeichnung = new JLabel();
									lblTankBezeichnung.setHorizontalAlignment(SwingConstants.CENTER);
								tankPanel.add(lblTankBezeichnung,BorderLayout.SOUTH);
					northPanel.add(tankPanel,BorderLayout.SOUTH);
				contentPanel.add(northPanel,BorderLayout.NORTH);
					southPanel = new JPanel(new BorderLayout());
						southPanel.setBorder(BorderFactory.createEtchedBorder());
					sortenPanel = new JPanel(new GridLayout(1,4));
						sortenPanel.setBorder(BorderFactory.createEtchedBorder());
							lblSorte = new JLabel();
							lblSorte.setHorizontalAlignment(SwingConstants.TRAILING);
							sortenPanel.add(lblSorte, BorderLayout.WEST);
							cmbSorte = new JComboBox();
								rz.getDatabase().getMischungen().setSortenCmb(cmbSorte);
							sortenPanel.add(cmbSorte,BorderLayout.CENTER);
							lblLager = new JLabel();
								lblLager.setHorizontalAlignment(SwingConstants.TRAILING);
							sortenPanel.add(lblLager);
							cmbLager = new JComboBox();
							rz.getDatabase().getLager().setLagerCmb(cmbLager,0);
							sortenPanel.add(cmbLager);
					southPanel.add(sortenPanel,BorderLayout.NORTH);
						commentPanel = new JPanel(new BorderLayout());
							lblComment = new JLabel();
							lblComment.setHorizontalAlignment(SwingConstants.CENTER);
							commentPanel.add(lblComment,BorderLayout.NORTH);
							scrComment = new JScrollPane();
								txtComment = new JTextArea();
								scrComment.setViewportView(txtComment);
							commentPanel.add(scrComment,BorderLayout.CENTER);
							
							listenPanel = new JPanel(new BorderLayout());
    						adressen = new JPanel(new BorderLayout());
							adressen.setBorder(BorderFactory.createEtchedBorder());
						listenPanel.add(adressen);
						lblAdressenTitel = new JLabel();
						lblAdressenTitel.setHorizontalAlignment(SwingConstants.CENTER);
						adressen.add(lblAdressenTitel, BorderLayout.NORTH);
						adressenScrollPane = new JScrollPane();
						adressenScrollPane
								.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
						adressenScrollPane
								.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
						//adressenScrollPane.setPreferredSize(new Dimension(100, 150));
						lstAdressen = new JRzList();
						adressenScrollPane.setViewportView(lstAdressen);
						lstAdressen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
						adressen.add(adressenScrollPane, BorderLayout.CENTER);
						adressenButtonPane = new JPanel(new GridLayout(1, 2));
						btAdressenBearbeiten = new JButton();
						adressenButtonPane.add(btAdressenBearbeiten);
						btAdressenLoeschen = new JButton();
						adressenButtonPane.add(btAdressenLoeschen);
						adressen.add(adressenButtonPane, BorderLayout.SOUTH);
						
						commentPanel.add(adressen,BorderLayout.EAST);
							
					southPanel.add(commentPanel,BorderLayout.CENTER);
				contentPanel.add(southPanel,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("mischungeingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	    tb1.add(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
  	    tb1.add(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
  	    tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

  	   btAdressenBearbeiten.setAction(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
  	   btAdressenLoeschen.setAction(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
  	  
        btOK.setAction(getAction(ACTION_OK_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btTankText.setAction(getAction(ACTION_TANKLISTE_TEXT_CODE));
		btTankPlan.setAction(getAction(ACTION_TANKLISTE_PLAN_CODE));
		btRezeptur.setAction(getAction(ACTION_REZEPTUR_SET_CODE));
		btRezepturClear.setAction(getAction(ACTION_REZEPTUR_RESET_CODE));
        
        lblBezeichnung.setText(rz.getLocale().getString("mischungeingabe.label_bezeichnung"));
        lblTank.setText(rz.getLocale().getString("mischungeingabe.label_tank"));
        lblSorte.setText(rz.getLocale().getString("mischungeingabe.label_sorte"));
        lblComment.setText(rz.getLocale().getString("mischungeingabe.label_comment"));
        lblBezeichnungText.setText(rz.getLocale().getString("mischungeingabe.label_rezeptur_leer"));
        lblTankBezeichnung.setText(" ");
		lblAdressenTitel.setText(rz.getLocale().getString("mischungeingabe.label_adressliste_titel"));
        
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
	        case ACTION_TANKLISTE_TEXT_CODE:tanklisteTextAction();break;
	        case ACTION_TANKLISTE_PLAN_CODE:tanklistePlanAction();break;
	        case ACTION_REZEPTUR_SET_CODE:rezepturSetAction();break;
	        case ACTION_REZEPTUR_RESET_CODE:rezepturResetAction();break;
	    	case ACTION_ADRESSLISTE_BEARBEITEN_CODE :
				adressListeBearbeitenAction();
				break;
			case ACTION_ADRESSLISTE_LOESCHEN_CODE :
				adressenLoeschenAction();
				break;
            default :
                break;
           }
    		break;
		case MessageItem.MSG_ZUTATEN_DIALOG_REPLY :
			rezepturSetReply((ZutatenSuchItem) msg.getData());
			break;
    	case MessageItem.MSG_TANKLISTE_REPLY :
			tanklisteReply((tankItem) msg.getData());
			break;
        case MessageItem.MSG_SHOW_MISCHUNG_EINGABE_TANK:
 			 origin = msg.getOrigin();
 			 tankItem ti = (tankItem)msg.getData();
 			 mi = new MischungsHeaderItem(rz);
 			 if(ti != null) {
 				 mi.setTank(ti.getNummer());
 				 setTankLabel(ti);
        		 fromItem();
        	 } else {
        		 mi.setTank("");
        		 setTankLabel(null);
        		 fromItem();
        	 }
	      	 break;
		case MessageItem.MSG_ADRESSLISTE_REPLY :
			if (mi != null) {
				mi.setAdressen(((StichwortListe) msg.getData()).copyList());
				lstAdressen.setListData(((StichwortListe) msg.getData()).toArray());
			}
			break;
        default:
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_PLAN_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_PLAN_CODE,ACTION_TANKLISTE_PLAN_TEXT,0,0));  
        actionList.put(String.valueOf(ACTION_TANKLISTE_TEXT_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_TEXT_CODE,ACTION_TANKLISTE_TEXT_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_REZEPTUR_SET_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_SET_CODE,ACTION_REZEPTUR_SET_TEXT,0,0));  
        actionList.put(String.valueOf(ACTION_REZEPTUR_RESET_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_RESET_CODE,ACTION_REZEPTUR_RESET_TEXT,0,0)); 
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_BEARBEITEN_CODE), new AuswahlAction(rz, this, ACTION_ADRESSLISTE_BEARBEITEN_CODE, ACTION_ADRESSLISTE_BEARBEITEN_TEXT, KeyEvent.VK_D, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_LOESCHEN_CODE), new AuswahlAction(rz, this, ACTION_ADRESSLISTE_LOESCHEN_CODE, ACTION_ADRESSLISTE_LOESCHEN_TEXT, KeyEvent.VK_L, KeyEvent.CTRL_DOWN_MASK));

    }

    /**
	 * den Dialog mit der Adressenliste anzeigen
	 * 
	 * 
	 */
	private void adressListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setAdressListe(mi.getAdressen().copyList());
		rz.getFensterFactory().getFensterListe().createWindow(
				FensterFactory.FENSTER_ADRESSAUSWAHL,
				true,
				new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST, 0, ai,
						this));
	}
	private void adressenLoeschenAction() {
		mi.getAdressen().clear();
		lstAdressen.setListData(mi.getAdressen().toArray());
	}
    
    
    private void setTankLabel(tankItem tti) {
    	String ret = "";
    	if(tti != null) {
	    	ArrayList<tankItem> liste = rz.getDatabase().getTank().getTankInhaltsListeSingle(tti.getNummer());
	    	if(liste != null && liste.size() > 0) {
		    	for(tankItem ti:liste) {
		    		String l = ti.getInhaltsListe().getInhaltBezeichnung().replaceAll("\\n", "<br>");
		    		if(l.trim().equals("")) {
		    			l=ret += rz.getLocale().getString("mischungeingabefenster.label_abschluss_t_tankinhalt_leer");
		    		}
		    		if(ti.isMischung()) {
		    			ret += rz.getLocale().getString("mischungeingabefenster.label_abschluss_t_tankinhalt_mischung").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
		    		}else if (ti.isStellplatz()){
		    			ret += rz.getLocale().getString("mischungeingabefenster.label_abschluss_t_tankinhalt_stellplatz").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
		    		} else {
		    			ret += rz.getLocale().getString("mischungeingabefenster.label_abschluss_t_tankinhalt_tank").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
		    		}
		    		ret+="<br>";
		    	}
	    	} else {
				ret += "";
	    	}
	    	while(ret.endsWith("<br>"))ret = ret.substring(0,ret.length()-4);
	    	ret = "<font color=\"blue\">" + getTankLabel2(tti) + "</font>&nbsp;&nbsp;" + ret;
    	}
    	lblTankBezeichnung.setText(ret.equals("")?"<html>"+rz.getLocale().getString("mischungeingabefenster.label_abschluss_t_tankinhalt_leer")+"</html>":"<html>"+ret+"</html>");
    }
    
	private String  getTankLabel2(tankItem ti) {
		String ret = "";
		lblTankBezeichnung.setText(" ");
		if(ti != null && ti.getId()!=0) {
			ret = rz.getLocale().getString("mischungeingabe.label_tankbezeichnung")
					.replaceAll("%o",ti.getOrtBezeichnung())
					.replaceAll("%l",rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE));
		}else {
			ret = rz.getLocale().getString("mischungeingabe.label_tankbezeichnung_nicht_definiert");
		}
		return ret;
	}
    
    private void rezepturSetAction() {
    		int x, y;
    		x = (int) (btRezeptur.getLocationOnScreen().getX());
    		y = (int) (btRezeptur.getLocationOnScreen().getY());
    		if (zd != null) {
    			zd.dispose();
    			zd = null;
    		}
    		final ZutatenDialog zd = new ZutatenDialog(this, rz, x, y, txtBezeichnung.getText().trim(),ZutatenDialog.MODE_REZEPTUREN);
    		zd.setVisible(true);
    }
    
    private void rezepturSetReply(ZutatenSuchItem zi) {
    	if(zi != null) {
    		rezeptur_id = zi.getID();
    		rezepturBezeichnung = zi.getName();
        	lblBezeichnungText.setText(rz.getLocale().getString("mischungeingabe.label_rezeptur")
        			.replaceAll("%s", rezepturBezeichnung)
        			.replaceAll("%n",String.valueOf(zi.getID()))
        		);
        	txtBezeichnung.setText(zi.getName());
    	}
    }
    
    private void rezepturResetAction() {
    	rezeptur_id = 0;
    	rezepturBezeichnung  ="";
    	lblBezeichnungText.setText(rz.getLocale().getString("mischungeingabe.label_rezeptur_leer"));
    	txtBezeichnung.setText("");
    }
    
    
	private void tanklisteReply(tankItem ti) {
		if(ti != null) {
			txtTank.setText(ti.getNummer());
			setTankLabel(ti);
		}
	}
	private void showTankDialog(String nummer) {
		int x, y;
		x = (int) (btTankText.getLocationOnScreen().getX());
		y = (int) (btTankText.getLocationOnScreen().getY());
		if (td != null) {
			td.dispose();
			td = null;
		}
		if(rz.isMain()) {
			td = new TankDialog(this,null,null, null,rz, x, y, nummer);
		}
		td.setVisible(true);
	}
	
	private void tanklisteTextAction() {
		showTankDialog(txtTank.getText().trim());
	}
	
	private void tanklistePlanAction() {
		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txtTank.getText().trim());
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
	}
    
    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
        if(toItem()) {
        	rz.getDatabase().getMischungen().saveMischung(mi,true);
	        rz.getFensterFactory().getFensterListe().propagateBestand(this);
	        rz.getFensterFactory().getFensterListe().propagateMischung(this,mi.getId());
        	closeWindow();
        }
     }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    /**
     * Daten vom Item in die GUI übertragen
     *
     */
    private void fromItem(){
    	if(mi != null) {
    		txtBezeichnung.setText(mi.getBezeichnung());
    		txtTank.setText(mi.getTank());
    		txtComment.setText(mi.getBemerkungen());
    		lstAdressen.setListData(mi.getAdressen().toArray());
    	}
    }

    /**
     * GUI-Daten in das Item übertragen
     *
     */
    private boolean toItem(){
    	mi.setRezeptur_id(rezeptur_id);
    	mi.setBezeichnung(txtBezeichnung.getText().trim());
    	mi.setTank(txtTank.getText().trim());
    	mi.setSorte(((SortenItem)cmbSorte.getSelectedItem()).getId());
    	mi.setBemerkungen(txtComment.getText().trim());
    	mi.setLager(((LagerItem)cmbLager.getSelectedItem()).getID());
    	if(mi.getBezeichnung().equals("")) {
    		DialogItem  dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
    		dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("mischungseingabe.keine_bezeichnung"));
            dlgItem.setTitel(rz.getLocale().getString("mischungseingabe.keine_bezeichnung"));
            dlgItem.setMessage(rz.getLocale().getString("mischungseingabe.keine_bezeichnung_message"));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            rz.getDialogFactory().getDialog(dlgItem);
            txtBezeichnung.requestFocus();
    		return false;
    	}
    	if(mi.getTank().equals("")) {
    		DialogItem  dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
    		dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("mischungseingabe.kein_tank"));
            dlgItem.setTitel(rz.getLocale().getString("mischungseingabe.kein_tank"));
            dlgItem.setMessage(rz.getLocale().getString("mischungseingabe.kein_tank_message"));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            rz.getDialogFactory().getDialog(dlgItem);
            txtTank.requestFocus();
    		return false;
    	}
    	if(!rz.getDatabase().getMischungen().isTankAvailable(mi.getTank())) {
    		txtTank.requestFocus();
    		return false;
    	}
    	return true;
    }

    @Override
	public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(mi!= null) {
    		if (!isVisible()) {
				setVisible(true);
			}
    		toFront();
    		txtBezeichnung.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"mischungeingabe.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}
