package de.lunqual.rzpro.fenster.mischungsfenster;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.mischungen.MischungChartItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.mischungen.TicketListe;
import de.lunqual.rzpro.options.OptionFactory;


public class MischungChartPanel extends JPanel {
	
	private static final int					C_MAX = 30;
	private static final int					C_DIFF=200;
	
	RzPro					rz;
	MischungsItem mi;
	int						centerX;
	int						centerY;
	int						durchmesser;
	Color[] 				colors;
	Color					black,white,grey;
	ArrayList<MischungChartItem>			items;
	int						fontsize=14;
	int						listCount;
	double					limit ;
	
	public MischungChartPanel(RzPro rz,int listCount) {
		super();
		this.rz = rz;
		this.listCount = listCount;
		setColors();
	}
	
	
	public void setListCountMax(int listCount) {
		this.listCount = listCount;
	}


	public void setColors() {
		black = new Color(0,0,0);
		white = new Color(255,255,255);
		grey = new Color(125,125,125);
		colors= new Color[rz.getOptionFactory().getOption("mischung.chart.max.colors",OptionFactory.MISCHUNG_CHART_MAX_COLORS)];
		for(int i=0;i<rz.getOptionFactory().getOption("mischung.chart.max.colors",OptionFactory.MISCHUNG_CHART_MAX_COLORS);i++) {
			colors[i] = rz.getOptionFactory().getRGBColor("mischung.chart.color_" + String.valueOf(i) );
		}
	}
	
	
	public void setData(MischungsItem mi,double limit) {
		this.mi = mi;
		this.limit = limit;
		if(mi != null) {
			durchmesser = this.getHeight() - this.getHeight()/10;
			centerX=10;
			centerY=10;
			items = getValues(mi,limit);
		} else {
			items = null;
		}
	}
	
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		g.setColor(Color.white);
		g.fillRect(0,0,this.getWidth(),this.getHeight());
		if(items != null && !items.isEmpty()) {
			drawItems(items,g);
		}
	}

	private void drawItems(ArrayList<MischungChartItem> map,Graphics g) {
		Graphics2D ga = (Graphics2D)g;
		ga.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		Font f = rz.getFontFactory().getTableFont();
		fontsize = f.getSize();
		double start = 90.0;
		int startTextY = fontsize*2;
		int startTextX = durchmesser + (fontsize * 2);

		for (int i=0;i<map.size();i++) {
			MischungChartItem entry = map.get(i);
			double extend = -(360*entry.getValue())/100;
			if (i==0) {
				ga.setFont(rz.getFontFactory().getTableBoldFont());
		        ga.setColor(black);
				ga.drawString(rz.getLocale().getString("mischungChartPanel.label_mischung").replaceAll("%s", entry.getTxtMischung()).replaceAll("%n", String.valueOf(entry.getTi().getMischung())) ,(int)(startTextX + (fontsize*2)),(int)(startTextY + fontsize));
				startTextY += (int)(f.getSize()*3);
			}
			ga.setColor( colors[i % colors.length]);
			ga.setFont(f);
			Area pie =new Area((Shape) new Arc2D.Double(centerX,centerY,durchmesser,durchmesser, start, extend, Arc2D.PIE));
	        ga.fill(pie);
	        ga.setColor(black);
	        if(i < map.size()-1) {
	        	ga.draw(pie);
	        }
			start+=extend;
			if(!rz.isZero(entry.getValue())){
				ga.setColor( colors[i % colors.length]);
				ga.fillRect(startTextX, startTextY-fontsize, fontsize, fontsize*2);
				ga.setColor(black);
				ga.drawRect(startTextX, startTextY-fontsize, fontsize, fontsize*2);
				String str = entry.getBezeichnung() + " (" + rz.getLocale().formatNumber(entry.getValue(),OptionFactory.NF_TWO) + " %) " + entry.getErstellt();
				ga.drawString(str, (int)(startTextX + (fontsize*2)),(int)startTextY);
				String str2 = "";
				if(entry.getTi() != null) {
					if(!entry.getTi().getNummer().equals("")){
						str2 += rz.getLocale().getString("mischungChartPanel.line2_t").replaceAll("%s",entry.getTi().getNummer());
					}
					if(!entry.getLosnummer().equals("")){
						str2 += "  " +rz.getLocale().getString("mischungChartPanel.line2_l").replaceAll("%s",entry.getLosnummer());
					}
					ga.drawString(str2 ,(int)(startTextX + (fontsize*2)),(int)(startTextY + fontsize));
				}
				startTextY += (int)(f.getSize()*3);
			}
		}	
		drawOutline(ga);
	}

	
	private ArrayList<MischungChartItem> getValues(MischungsItem mi,double limit){
		HashMap<String,MischungChartItem> ret = new HashMap<String,MischungChartItem>();
		TicketListe tl = mi.getAllTickets();
		int typ = mi.getHeader().isActive()?TicketItem.TYP_WARE:TicketItem.TYP_ENTNAHME;
		if(tl != null && !tl.isEmpty()){
			for(TicketItem ti:tl) {
				if(ti.getTyp() == typ) {
					if(ret.containsKey(ti.getNummer())) {
						if(typ == TicketItem.TYP_ENTNAHME) {
							ret.get(ti.getNummer()).addValue(ti.getNegativePercentage(),ti.getLosnummer_original(),ti.getBezeichnung());
						} else {
							ret.get(ti.getNummer()).addValue(0,ti.getLosnummer_original(),ti.getBezeichnung());
						}
					} else {
						ret.put(ti.getNummer(), new MischungChartItem(rz,ti, typ==TicketItem.TYP_ENTNAHME?ti.getNegativePercentage():ti.getPercentage() ,mi.getHeader().getBezeichnung()));
					}
				}
			}
		}
		ArrayList<MischungChartItem> liste = sort(ret);
		ArrayList<MischungChartItem> liste1 = new		ArrayList<MischungChartItem>();
		double rest = 100.0;
		for( int i=0,lc=2;i<liste.size() ;i++,lc++) {
			MischungChartItem item = liste.get(i);
			rest = rest - item.getValue();
			liste1.add(liste.get(i));
			if (rest < limit || lc > listCount) {
				if(!rz.isZero(rest)) {
					liste1.add(new MischungChartItem(rz,null,rest,""));
				}
				break;
			}
		}
		return liste1;
	}
	
	private ArrayList<MischungChartItem> sort(HashMap<String,MischungChartItem> in) {
		ArrayList<MischungChartItem> liste = new ArrayList<MischungChartItem>();
		in.entrySet().stream().sorted((k1, k2) -> -((Comparable<Double>) k1.getValue().getValue()).compareTo(k2.getValue().getValue())).forEach(k -> liste.add(k.getValue()));
		return  liste ;
	}
	  
	private void drawOutline(Graphics2D ga) {
		ga.setColor(black);
		ga.setStroke(new BasicStroke(2));
		Shape circle = new Ellipse2D.Float(centerX,centerY,durchmesser,durchmesser);
		ga.draw(circle);
	}
}
