/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.mhdfenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikFenster;
import de.lunqual.rzpro.fenster.dialoge.MhdDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.mhdItem;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mhd.mhdDialogItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.temperaturzone.temperaturZonenItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class MhdFenster extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuBearbeiten;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel vorgabePanel;
    			private JPanel datumPanel;
    				private JCheckBox chkDatum;
    					private JPanel datumCmbPanel;
    						private JLabel lblVon;
    						private JComboBox cmbVonMonat;
    						private JIntegerField txtVonJahr;
    						private JLabel lblBis;
    						private JComboBox cmbBisMonat;
    						private JIntegerField txtBisJahr;
    					private JPanel datumButtonPanel;
    						private JButton btLetztenMonat;
    						private JButton btDiesenMonat;
    						private JButton btNaechstenMonat;
    						private JButton btLetztesJahr;
    						private JButton btDiesesJahr;
    						private JButton btNaechstesJahr;
		    		private JPanel sortPanel;
		    			private JPanel sortButtonPanel;
							private ButtonGroup sortGroup;
								private JRadioButton btSortMhd;
								private JRadioButton btSortRezeptur;
						JCheckBox chkReverse;
    		private JPanel txtPanel;
				private JScrollPane scrText;
					private JTable tblMhd;
			private JButton btRefresh;
    	private JPanel buttonPanel;
    		private JButton btClose;
			private JComboBox cmbFormulare;
			private JButton btDrucken;

    public static final int         ACTION_CLOSE_CODE = 1001;
    public static final String     ACTION_CLOSE_TEXT = "hilfe.action_close";
    public static final int         ACTION_DRUCKEN_CODE = 1002;
    public static final String     ACTION_DRUCKEN_TEXT = "hilfe.action_drucken";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_REFRESH_CODE = 1004;
    public static final String     ACTION_REFRESH_TEXT = "mhd.action_refresh";
    
    private static final int			MAX_COLUMN=6;
    private static final int			C_BEZEICHNUNG=0;
    private static final int			C_ARTIKELNUMMER=1;
    private static final int			C_LOSNUMMER=2;
    private static final int			C_TEMPERATUR=3;
    private static final int			C_MHD=4;
    private static final int			C_ETIKETT=5;
    
    private static final int 			DATUM_LETZTEN_MONAT = 0;
    private static final int 			DATUM_DIESEN_MONAT = 1;
    private static final int 			DATUM_NAECHSTEN_MONAT = 2;
    private static final int 			DATUM_LETZTES_JAHR = 3;
    private static final int 			DATUM_DIESES_JAHR = 4;
    private static final int 			DATUM_NAECHSTES_JAHR = 5;
    
    ArrayList<mhdItem>				liste;
	JRzFrame								parent;
	Calendar								now;
	String[]									monate;
	
    /** Creates new form HilfeFenster */
    public MhdFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        now = Calendar.getInstance();
    	monate = new DateFormatSymbols().getMonths();
        rz.roundDatum(now);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }


    @Override
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new BorderLayout());
				txtPanel=new JPanel(new BorderLayout());
					vorgabePanel = new JPanel(new BorderLayout());
				
						sortPanel = new JPanel(new BorderLayout());
							sortButtonPanel=new JPanel(new BorderLayout());
								sortGroup=new ButtonGroup();
									btSortMhd=new JRadioButton();
		    			             btSortMhd.addActionListener(new java.awt.event.ActionListener() {
			    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
			    			                    refreshAction();
			    			                	}
			    			            	});
									sortGroup.add(btSortMhd);
									sortButtonPanel.add(btSortMhd,BorderLayout.NORTH);
									btSortRezeptur = new JRadioButton();
									btSortRezeptur.addActionListener(new java.awt.event.ActionListener() {
		    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    			                    refreshAction();
		    			                	}
		    			            	});
									sortGroup.add(btSortRezeptur);
									sortButtonPanel.add(btSortRezeptur,BorderLayout.SOUTH);
									btSortMhd.setSelected(true);
								sortPanel.setBorder(BorderFactory.createEtchedBorder());
							sortPanel.add(sortButtonPanel,BorderLayout.NORTH);
							chkReverse = new JCheckBox();
							chkReverse.addActionListener(new java.awt.event.ActionListener() {
				                public void actionPerformed(java.awt.event.ActionEvent evt) {
				                    refreshAction();
				                	}
				            	});
							sortPanel.add(chkReverse,BorderLayout.SOUTH);
							vorgabePanel.add(sortPanel, BorderLayout.SOUTH);
							datumPanel = new JPanel(new BorderLayout());
								datumPanel.setBorder(BorderFactory.createEtchedBorder());
								chkDatum = new JCheckBox();
								chkDatum.addActionListener(new ActionListener() {
						        	public void actionPerformed(ActionEvent evt) {
						        		if(chkDatum.isSelected()) {
						        		      chkDatum.setSelected(true);
						        		      btLetztenMonat.setEnabled(true);
						        		      btDiesenMonat.setEnabled(true);
						        		      btNaechstenMonat.setEnabled(true);
						        		      btLetztesJahr.setEnabled(true);
						        		      btDiesesJahr.setEnabled(true);
						        		      btNaechstesJahr.setEnabled(true);
						        		      txtVonJahr.setEnabled(true);
						        		      txtBisJahr.setEnabled(true);
						        		} else {
						        		      chkDatum.setSelected(false);
						        		      btLetztenMonat.setEnabled(false);
						        		      btDiesenMonat.setEnabled(false);
						        		      btNaechstenMonat.setEnabled(false);
						        		      btLetztesJahr.setEnabled(false);
						        		      btDiesesJahr.setEnabled(false);
						        		      btNaechstesJahr.setEnabled(false);
						        		      txtVonJahr.setEnabled(false);
						        		      txtBisJahr.setEnabled(false);
						        		}
							        	refreshAction();
						        	}
					            });
								datumPanel.add(chkDatum,BorderLayout.WEST);
								datumCmbPanel = new JPanel(new GridLayout(1,6));
	    							lblVon = new JLabel();
	    								lblVon.setHorizontalAlignment(SwingConstants.TRAILING);
	    							datumCmbPanel.add(lblVon);
	    							cmbVonMonat = new JComboBox();
	    								for(String m:monate) {cmbVonMonat.addItem(m);}
	    								cmbVonMonat.setSelectedIndex(now.get(Calendar.MONTH));
	    								cmbVonMonat.addActionListener(new ActionListener() {
	    						        	public void actionPerformed(ActionEvent evt) {
	    						        		refreshAction();
	    						        	}
	    					            });
	    							datumCmbPanel.add(cmbVonMonat);	
	    							txtVonJahr = new JIntegerField(now.get(Calendar.YEAR),2000,99999);
	    							datumCmbPanel.add(txtVonJahr);
	    							lblBis = new JLabel();
	    								lblBis.setHorizontalAlignment(SwingConstants.TRAILING);
	    							datumCmbPanel.add(lblBis);
	    							cmbBisMonat = new JComboBox();
										for(String m:monate) {cmbBisMonat.addItem(m);}
	    								cmbBisMonat.setSelectedIndex(now.get(Calendar.MONTH));
	    								cmbBisMonat.addActionListener(new ActionListener() {
	    						        	public void actionPerformed(ActionEvent evt) {
	    						        		refreshAction();
	    						        	}
	    					            });
	    							datumCmbPanel.add(cmbBisMonat);
	    							txtBisJahr = new JIntegerField(now.get(Calendar.YEAR),2000,99999);
	    							datumCmbPanel.add(txtBisJahr);
	    						datumPanel.add(datumCmbPanel,BorderLayout.NORTH);
	    					datumButtonPanel = new JPanel(new GridLayout(1,6));
	    						btLetztenMonat = new JButton();
	    							btLetztenMonat.addActionListener(new java.awt.event.ActionListener() {
		    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    			                    setDatum(DATUM_LETZTEN_MONAT);
		    			                	}
		    			            	});
	    						datumButtonPanel.add(btLetztenMonat);
	    						btDiesenMonat = new JButton();
	    						btDiesenMonat.addActionListener(new java.awt.event.ActionListener() {
	    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    			                    setDatum(DATUM_DIESEN_MONAT);
	    			                	}
	    			            	});
	    						datumButtonPanel.add(btDiesenMonat);
	    						btNaechstenMonat = new JButton();
	    						btNaechstenMonat.addActionListener(new java.awt.event.ActionListener() {
	    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    			                    setDatum(DATUM_NAECHSTEN_MONAT);
	    			                	}
	    			            	});
	    						datumButtonPanel.add(btNaechstenMonat);
	    						btLetztesJahr = new JButton();
	    						btLetztesJahr.addActionListener(new java.awt.event.ActionListener() {
	    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    			                    setDatum(DATUM_LETZTES_JAHR);
	    			                	}
	    			            	});
	    						datumButtonPanel.add(btLetztesJahr);
	    						btDiesesJahr = new JButton();
	    						btDiesesJahr.addActionListener(new java.awt.event.ActionListener() {
	    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    			                    setDatum(DATUM_DIESES_JAHR);
	    			                	}
	    			            	});
	    						datumButtonPanel.add(btDiesesJahr);
	    						btNaechstesJahr = new JButton();
	    						btNaechstesJahr.addActionListener(new java.awt.event.ActionListener() {
	    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    			                    setDatum(DATUM_NAECHSTES_JAHR);
	    			                	}
	    			            	});
	    						datumButtonPanel.add(btNaechstesJahr);
						   datumPanel.add(datumButtonPanel,BorderLayout.SOUTH);	
						vorgabePanel.add(datumPanel,BorderLayout.NORTH);
					contentPanel.add(vorgabePanel,BorderLayout.NORTH);
					scrText = new JScrollPane();
						tblMhd = new JTable();
						tblMhd.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
						tblMhd.setName("mhdfenster.spalten");
		    			tblMhd.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		    			tblMhd.setColumnSelectionAllowed(true);
		    			tblMhd.setRowSelectionAllowed(true);
		    			tblMhd.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
		    			tblMhd.setShowGrid(true);
		    			tblMhd.addMouseListener(new MouseAdapter(){
						     public void mouseClicked(MouseEvent e){
						    	  listeClickedAction();
						      }
						} );
						scrText.setViewportView(tblMhd);
				txtPanel.add(scrText,BorderLayout.CENTER);
					btRefresh=new JButton();
					txtPanel.add(btRefresh,BorderLayout.SOUTH);
				contentPanel.add(txtPanel,BorderLayout.CENTER);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				cmbFormulare=new JComboBox();
				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_MHD);
	    	    cmbFormulare.addActionListener(new ActionListener() {
		        	public void actionPerformed(ActionEvent evt) {
		        		if(cmbFormulare.getSelectedIndex() != -1) {
		        			rz.getOptionFactory().setOption("report.mhd",((ReportItem)cmbFormulare.getSelectedItem()).getID());
		        		}
		        	}
	            });
				buttonPanel.add(cmbFormulare,BorderLayout.CENTER);
				btDrucken=new JButton();
				buttonPanel.add(btDrucken,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);


    }
    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("mhd.titel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));

      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.add(getAction(ACTION_DRUCKEN_CODE));

      btSortMhd.setText(rz.getLocale().getString("mhd.sort_mhd"));
      btSortRezeptur.setText(rz.getLocale().getString("mhd.sort_rezeptur"));
      chkReverse.setText(rz.getLocale().getString("mhd.sort_reverse"));
      
      lblVon.setText(rz.getLocale().getString("mhd.label_datum_von"));
      lblBis.setText(rz.getLocale().getString("mhd.label_datum_bis"));      
      
      btLetztenMonat.setText(rz.getLocale().getString("mhd.datum_letzten_monat"));
      btDiesenMonat.setText(rz.getLocale().getString("mhd.datum_diesen_monat"));
      btNaechstenMonat.setText(rz.getLocale().getString("mhd.datum_naechsten_monat"));
      btLetztesJahr.setText(rz.getLocale().getString("mhd.datum_letztes_jahr"));
      btDiesesJahr.setText(rz.getLocale().getString("mhd.datum_dieses_jahr"));
      btNaechstesJahr.setText(rz.getLocale().getString("mhd.datum_naechstes_jahr"));      
      chkDatum.setText(rz.getLocale().getString("mhd.datum"));      
      
      chkDatum.setSelected(false);
      btLetztenMonat.setEnabled(false);
      btDiesenMonat.setEnabled(false);
      btNaechstenMonat.setEnabled(false);
      btLetztesJahr.setEnabled(false);
      btDiesesJahr.setEnabled(false);
      btNaechstesJahr.setEnabled(false);
      txtVonJahr.setEnabled(false);
      txtBisJahr.setEnabled(false);
      
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;

    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT,KeyEvent.VK_F5 ,0));

    }


    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED :
        	    switch(msg.getCode()) {
	              	case ACTION_CLOSE_CODE:closeWindow();break;
	              	case ACTION_DRUCKEN_CODE:druckenAction();break;
	              	case ACTION_HIDE_CODE:hideAction();break;
	              	case ACTION_REFRESH_CODE:refreshAction();break;
        	    }
             break;
        	case MessageItem.MSG_REFRESH_MHDLISTE:
        		refreshAction();
        		break;
            case MessageItem.MSG_SHOW_MHD:
     		    settblMhdModel(tblMhd);
            	parent=msg.getOrigin();
            	refreshAction();
            	break;
            default:
                break;
        }
    }

    @Override
	public void closeWindow() {
        //setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

   
    
    @Override
	public void openWindow() {
        setVisible(true);
        toFront();
        this.tblMhd.requestFocus();
    }

    private void setDatum(int dt) {
    	int n = txtVonJahr.getValue();
    	now = Calendar.getInstance();
    	rz.roundDatum(now);
    	switch(dt) {
    	    case DATUM_LETZTEN_MONAT :
    	    	txtVonJahr.setValue(now.get(Calendar.YEAR));
    	    	txtBisJahr.setValue(now.get(Calendar.YEAR));
    	    	n = now.get(Calendar.YEAR);
    	    	now.add(Calendar.MONTH,-1);
				cmbVonMonat.setSelectedIndex(now.get(Calendar.MONTH));
				cmbBisMonat.setSelectedIndex(now.get(Calendar.MONTH));
				if(n == 0) {
					txtVonJahr.setValue(n-1);
					txtBisJahr.setValue(n-1);
				}
    	    	break;
    	    case DATUM_DIESEN_MONAT :
    	    	txtVonJahr.setValue(now.get(Calendar.YEAR));
    	    	txtBisJahr.setValue(now.get(Calendar.YEAR));
    	    	n = now.get(Calendar.YEAR);
				cmbVonMonat.setSelectedIndex(now.get(Calendar.MONTH));
				cmbBisMonat.setSelectedIndex(now.get(Calendar.MONTH));
    	    	break;
    	    case DATUM_NAECHSTEN_MONAT :
    	    	txtVonJahr.setValue(now.get(Calendar.YEAR));
    	    	txtBisJahr.setValue(now.get(Calendar.YEAR));
    	    	n = now.get(Calendar.YEAR);
    	    	now.add(Calendar.MONTH, 1);
				cmbVonMonat.setSelectedIndex(now.get(Calendar.MONTH));
				cmbBisMonat.setSelectedIndex(now.get(Calendar.MONTH));
				if(n == 11) {
					txtVonJahr.setValue(n+1);
					txtBisJahr.setValue(n+1);
				}
    	    	break;
    	    case DATUM_LETZTES_JAHR :
    	    	now.add(Calendar.YEAR,-1);
    	    	txtVonJahr.setValue(now.get(Calendar.YEAR));
    	    	txtBisJahr.setValue(now.get(Calendar.YEAR));
    	    	cmbVonMonat.setSelectedIndex(0);
    	    	cmbBisMonat.setSelectedIndex(11);
    	    	break;
    	    case DATUM_DIESES_JAHR :
    	    	txtVonJahr.setValue(now.get(Calendar.YEAR));
    	    	txtBisJahr.setValue(now.get(Calendar.YEAR));
    	    	cmbVonMonat.setSelectedIndex(0);
    	    	cmbBisMonat.setSelectedIndex(11);
    	    	break;
    	    case DATUM_NAECHSTES_JAHR :
    	    	now.add(Calendar.YEAR,1);
    	    	txtVonJahr.setValue(now.get(Calendar.YEAR));
    	    	txtBisJahr.setValue(now.get(Calendar.YEAR));
    	    	cmbVonMonat.setSelectedIndex(0);
    	    	cmbBisMonat.setSelectedIndex(11);
    	    	break;
    	}
    	refreshAction();
    }
    
   private void refreshAction() {
	   if(chkDatum.isSelected()) {
		   Calendar von = Calendar.getInstance();
		   Calendar bis = Calendar.getInstance();
		   von.set(Calendar.YEAR,txtVonJahr.getValue());
		   von.set(Calendar.MONTH,cmbVonMonat.getSelectedIndex());
		   von.set(Calendar.DAY_OF_MONTH,von.getActualMinimum(Calendar.DAY_OF_MONTH));
		   rz.roundDatum(von);
		   bis.set(Calendar.YEAR,txtBisJahr.getValue());
		   bis.set(Calendar.MONTH,cmbBisMonat.getSelectedIndex());
		   bis.set(Calendar.DAY_OF_MONTH,bis.getActualMaximum(Calendar.DAY_OF_MONTH));
		   rz.roundDatumUp(bis);
		   liste = rz.getDatabase().getBuchungen().getMhdListe(btSortMhd.isSelected(),chkReverse.isSelected(),von,bis);
	   } else {
		   liste = rz.getDatabase().getBuchungen().getMhdListe(btSortMhd.isSelected(),chkReverse.isSelected());
	   }
       ((AbstractTableModel)tblMhd.getModel()).fireTableDataChanged();
	   if(parent != null) {
			parent.getMessage( new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,0,null,this));
	   }
   }

   
   private void listeClickedAction() {
	   mhdItem mi;
	   if(tblMhd.getSelectedRow()!= -1) {
		   mi = liste.get(tblMhd.getSelectedRow());
		   if(mi != null) {
			   int c = tblMhd.getSelectedColumn();
			   AbfrageItem abfrage = new AbfrageItem();
			   switch(c) {
				   case C_BEZEICHNUNG:
			    		abfrage.setMuster(mi.getBezeichnung());
			    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_VERWENDUNG);
			    		abfrage.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
			    		abfrage.setAdressListe(new StichwortListe());
			    		abfrage.setStichwortListe(new StichwortListe());
			    		try {
			    			parent.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, mi.getId(), abfrage,this));
			    			this.toBack();
			    			parent.toFront();
			    		}catch (Exception e) {}
					   	break;
				   case C_LOSNUMMER:
	                	if(!mi.getLosnummer().equals("")) {
	                		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^"+mi.getLosnummer()+"$",this));
	                	}
					   break;
				   case C_ARTIKELNUMMER:
			    		abfrage.setMuster(mi.getBezeichnung());
			    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
			    		abfrage.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
			    		abfrage.setAdressListe(new StichwortListe());
			    		abfrage.setStichwortListe(new StichwortListe());
			    		ErgebnisListe liste=rz.getDatabase().getErgebnis().dbGetErgebnisListe(abfrage);
			    		if(!liste.isEmpty()) {
				    		try {
				                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(MessageItem.MSG_SHOW_STATISTIK_BESTAND,StatistikFenster.NO_FILTER,liste.getItem(0),this));
				    		}catch (Exception e1) {}
			    		}
					   break;
				   case C_MHD:
					   MhdDialog dmhd=new MhdDialog(rz,this,new mhdDialogItem(rz,mi.getId(),mi.getBezeichnung(),mi.getLosnummer(),Long.toString(mi.getMhd()),String.valueOf(mi.getRezeptur_id())));
					   dmhd.showDialog();
					  
					   refreshAction();
					   break;
				   case C_ETIKETT:
					   final EtikettenListe ei = new EtikettenListe();
					   ei.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));

					   final EtikettenItem eti = new EtikettenItem(rz);
					   eti.setZeile(0,mi.getBezeichnung());
					   eti.setZeile(1,mi.getLosnummer());
					   eti.setZeile(2,rz.getLocale().getString("auswahl.mhd_etikett").replaceAll("%s",(mi.getMhd() != 0?rz.getDatabase().getBuchungen().getMhdString(mi.getMhd()):rz.getLocale().getString("auswahl.mhd_unbegrenzt"))));
					   eti.setZeile(3, "");
					   eti.setZeile(4, "");
					   eti.setLosnummer(mi.getLosnummer());
					   eti.setImage(ei.getBogen().getImage());
					   ei.addItem(eti);

	     	        	if(ei.size() != 0) {
	     	                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,(Object)ei,null));
	     	        	}
					   break;
					   
			   }
		   }
	   }
   }
   
   
   private void settblMhdModel(JTable t) {
	    final MhdColumnModel rcm = new MhdColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mhdfenster.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mhdfenster.tableheader_artikelnummer"));
	    	tc.setModelIndex(C_ARTIKELNUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mhdfenster.tableheader_losnummer"));
	    	tc.setModelIndex(C_LOSNUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
		tc = new TableColumn();
		    	tc.setHeaderValue(rz.getLocale().getString("mhdfenster.tableheader_temperatur"));
		    	tc.setModelIndex(C_TEMPERATUR);
		    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mhdfenster.tableheader_mhd"));
			tc.setModelIndex(C_MHD);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mhdfenster.tableheader_etikett"));
			tc.setModelIndex(C_ETIKETT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
       rcm.addColumnModelListener(this);
       tblMhd.setModel(new mhdTableModel());
       tblMhd.setColumnModel(rcm);
       tblMhd.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
       tblMhd.getTableHeader().setReorderingAllowed(false);
	}

	private class MhdColumnModel extends DefaultTableColumnModel{
	    public MhdColumnModel() {
	        super();
	    }

	}

	private  class mhdTableModel extends AbstractTableModel    {

	        public mhdTableModel() {
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(liste != null) {
	                return liste.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public mhdItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (liste != null)) {
	        		return liste.get(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (liste != null)) {
	                ret = getContent(liste.get(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        private Object getContent(mhdItem mi,int aColumn,int row) {
	            Object ret = null;
	            if(mi != null) {
		            switch(aColumn){
		            	 case C_BEZEICHNUNG:
		            	     ret = mi.getBezeichnung();
		            	     break;
		            	 case C_ARTIKELNUMMER:
		            		 ret=mi.getArtikelnummer();
		            		 break;
		            	 case C_TEMPERATUR:
		            		 temperaturZonenItem ti = rz.getDatabase().getTemperatur().getZone(mi.getTemperaturDurchschnitt());
		            		 ret = "<html><font color=\"" + ti.getVg()+"\" bgcolor=\""+ti.getHg()+"\">" +  
		            				 rz.getLocale().getString("ausgabe.rezeptur_temperatur_string") 
		            		     .replaceAll("%z","")
								 .replaceAll("%v",String.valueOf(mi.getTempVon()))
								 .replaceAll("%b",String.valueOf(mi.getTempBis()))
								 .replaceAll("%s",String.valueOf(mi.getTemperaturDurchschnitt())
							) + "</font>";
		            		 break;
		            	 case C_LOSNUMMER:
		            		 ret=mi.getLosnummer();
		            	     break;
		            	 case C_MHD:
		            		 ret=rz.getDatabase().getBuchungen().getMhdString(mi.getMhd());
		            		 break;
		            	 case C_ETIKETT:
		            		 ret=rz.getLocale().getString("mhdfenster.table_etikett");
		            		 break;
		            }
	            }
	            return ret;
	        }
		}
	
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon bearbeiten,etikett,verlauf,leer,abfrage,bestand;
		
	    StringRenderer() {
	        super();
	        setOpaque(true);
            bearbeiten = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mhdfenster.icon_bearbeiten.png"));
            etikett = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mhdfenster.icon_etikett.png"));
            verlauf = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mhdfenster.icon_verlauf.png"));
            leer = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mhdfenster.icon_leer.png"));
            abfrage = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mhdfenster.icon_abfrage.png"));
            bestand = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mhdfenster.icon_bestand.png"));
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	mhdItem mi = null;
	    	if((row != -1) && (liste != null)) {
	    	   mi = liste.get(row);
	    	}
    		if(isSelected) {
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setFont(rz.getFontFactory().getTableFont());
    		}
    		if(mi.isSafe()) {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
    		}else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
    		}
    		if(mi.isDue()) {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GELB));
    		}
    		switch(column) {
    			case C_BEZEICHNUNG:
    				setIcon(abfrage);
    				break;
    			case C_ARTIKELNUMMER:
    				setIcon(bestand);
    				break;
    			case C_TEMPERATUR:
    				setIcon(leer);
    				break;
    			case C_LOSNUMMER:
    				setIcon(verlauf);
    				break;
    			case C_MHD:
    				setIcon(bearbeiten);
    				break;
    			case C_ETIKETT:
    				setIcon(etikett);
    				break;
    			
    		}
    		setText((String)value);
	        return this;
        }
	}
	
   
   
   
    private void druckenAction(){
    	
    	   Calendar von = Calendar.getInstance();
		   Calendar bis = Calendar.getInstance();
		   von.set(Calendar.YEAR,txtVonJahr.getValue());
		   von.set(Calendar.MONTH,cmbVonMonat.getSelectedIndex());
		   von.set(Calendar.DAY_OF_MONTH,von.getActualMinimum(Calendar.DAY_OF_MONTH));
		   rz.roundDatum(von);
		   bis.set(Calendar.YEAR,txtBisJahr.getValue());
		   bis.set(Calendar.MONTH,cmbBisMonat.getSelectedIndex());
		   bis.set(Calendar.DAY_OF_MONTH,bis.getActualMaximum(Calendar.DAY_OF_MONTH));
		   rz.roundDatumUp(bis);
    	rz.getReportFactory().mhdReport(btSortMhd.isSelected(),chkReverse.isSelected(),chkDatum.isSelected(),von,bis,this);
    }

     private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }


	public void columnAdded(TableColumnModelEvent arg0) {
	}


	public void columnMarginChanged(ChangeEvent arg0) {
	}


	public void columnMoved(TableColumnModelEvent arg0) {
	}


	public void columnRemoved(TableColumnModelEvent arg0) {
	}


	public void columnSelectionChanged(ListSelectionEvent arg0) {
	}



}
