package de.lunqual.rzpro.fenster.losnummervorlagefenster;

/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.swing.Timer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBLosnummerVorlage;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.rzDatePicker.RzSimpleDatePicker;
import de.lunqual.rzpro.fenster.rzDatePicker.pickerDateListener;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerListeItem;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerHistoryListe;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerVorlageItem;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerVorlageListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class LosnummerListenFenster extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel topPanel;
    		private JPanel centerPanel;
    			private JPanel leftPanel;
    				private JLabel lblListenTitel;
    				private JScrollPane scrListe;
    				private JList lstListe;
    			private JPanel rightPanel;
    				private JPanel datumPanel;
    					private JPanel datumTopPanel;
    						private JLabel lblStichtag;
    						private JButton btHeute;
    						private RzSimpleDatePicker dcDatum;
    					private JPanel datumBottomPanel;
    						private JSpinner spMax;
    						private JLabel lblMax;
    				private JPanel tablePanel;
    					private JLabel lblNummernTitel;
    					private JScrollPane scrLosnummern;
    					private JTable tblListe;
    				private JPanel listenButtonPanel;
    					private JButton btDelete;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String     	 	ACTION_CLOSE_TEXT = "losnummerliste.action_close";
    public static final int         		ACTION_HILFE_CODE = 1006;
    public static final String     	 	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_HEUTE_CODE = 1010;
    public static final String     	 	ACTION_HEUTE_TEXT = "losnummerliste.action_heute";
    public static final int         		ACTION_DELETE_CODE = 1011;
    public static final String     	 	ACTION_DELETE_TEXT = "losnummerliste.action_delete";
    
    LosnummerVorlageListe				liste;
    LosnummerHistoryListe				losnummern;
    Calendar							datum;
    Timer 	  							ergebnisTimer;

    private static final int				MAX_COLUMN = 3;
    private static final int				C_DATUM = 0;
    private static final int				C_LOSNUMMER = 1;
    private static final int				C_USER = 2;
    
    private static final String		CALENDAR_FORMAT="EEEE, dd. MMMM yyyy";
    
    /** Creates new form AdressenFenster */
    public LosnummerListenFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        getCurrentDate();
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 refresh();
            }
        });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
     
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				topPanel = new JPanel(new BorderLayout());
					centerPanel = new JPanel(new BorderLayout());
						leftPanel = new JPanel(new BorderLayout());
							leftPanel.setBorder(BorderFactory.createEtchedBorder());
							lblListenTitel = new JLabel();
							lblListenTitel.setHorizontalAlignment(SwingConstants.CENTER);
							leftPanel.add(lblListenTitel,BorderLayout.NORTH);
							scrListe = new JScrollPane();
								lstListe = new JList();
								lstListe.setFont(rz.getFontFactory().getListFont());
								lstListe.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
						            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
						            	if(evt.getValueIsAdjusting()) {
											return;
										}
						                lstErgebnisValueChanged(evt);
						            }
						        });
								scrListe.setViewportView(lstListe);
							leftPanel.add(scrListe,BorderLayout.CENTER);
    					rightPanel = new JPanel(new BorderLayout());
    						rightPanel.setBorder(BorderFactory.createEtchedBorder());
    							datumPanel = new JPanel(new BorderLayout());
    								datumTopPanel = new JPanel(new BorderLayout());
    									btHeute = new JButton();
    									datumTopPanel.add(btHeute,BorderLayout.WEST);
    									lblStichtag = new JLabel();
    										lblStichtag.setHorizontalAlignment(SwingConstants.CENTER);
    										lblStichtag.setBorder(BorderFactory.createEtchedBorder());
    									datumTopPanel.add(lblStichtag,BorderLayout.NORTH);
    									dcDatum = new RzSimpleDatePicker(rz);
					        	    			dcDatum.addListener(new pickerDateListener() {

													@Override
													public void dateChanged(Date datum) {
														refresh();
													}
					        	    				
					        	    			});
					        	    			
    									datumTopPanel.add(dcDatum,BorderLayout.CENTER);
    							datumPanel.add(datumTopPanel,BorderLayout.NORTH);
    							datumBottomPanel = new JPanel(new BorderLayout());
    								spMax = new JSpinner();
    									JSpinner.DefaultEditor de = ((JSpinner.DefaultEditor)spMax.getEditor());
    									de.getTextField().setColumns(4);
										spMax.setValue(rz.getOptionFactory().getOption("losnummerlistenfenster.anzahl",DBLosnummerVorlage.DEFAULT_HISTORY));
    									spMax.addChangeListener(new javax.swing.event.ChangeListener() {
    										public void stateChanged(javax.swing.event.ChangeEvent evt) {
    											int v = ((Integer)spMax.getValue()).intValue();
									        	 if(v < 1) {
									        		 v = 1;
									        		 spMax.setValue(1);
									        	 } else if (v > DBLosnummerVorlage.MAX_HISTORY) {
									        		 v = DBLosnummerVorlage.MAX_HISTORY;
									        		 spMax.setValue(v);
									        	 }
												 rz.getOptionFactory().setOption("losnummerlistenfenster.anzahl", v);
												 rz.getOptionFactory().saveOptions();
												 refresh();
												 return;
    										}
    									});
    								
    								datumBottomPanel.add(spMax,BorderLayout.WEST);
    								lblMax = new JLabel();
    								datumBottomPanel.add(lblMax,BorderLayout.CENTER);
    							datumPanel.add(datumBottomPanel,BorderLayout.SOUTH);
    						rightPanel.add(datumPanel,BorderLayout.NORTH);
    						
    						tablePanel = new JPanel(new BorderLayout());
	    						lblNummernTitel = new JLabel();
	    						lblNummernTitel.setHorizontalAlignment(SwingConstants.CENTER);
	    						tablePanel.add(lblNummernTitel,BorderLayout.NORTH);
	    						scrLosnummern = new JScrollPane();
	    							tblListe = new JTable();
	    							tblListe.setName("losnummerliste.spalten");
	    							tblListe.setFont(rz.getFontFactory().getTableFont());
	    							tblListe.setShowGrid(true);
					    				tblListe.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
					    				tblListe.setColumnSelectionAllowed(false);
						   			tblListe.setRowSelectionAllowed(true);
						   			tblListe.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
						   			tblListe.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
							            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
							            	if(evt.getValueIsAdjusting()) {
												return;
											}
							                setActions();
							            }
							        });
	    							scrLosnummern.setViewportView(tblListe);
	    						tablePanel.add(scrLosnummern,BorderLayout.CENTER);
	    					rightPanel.add(tablePanel,BorderLayout.CENTER);
	    						listenButtonPanel = new JPanel(new BorderLayout());
	    							btDelete = new JButton();
	    						listenButtonPanel.add(btDelete,BorderLayout.WEST);
	    					rightPanel.add(listenButtonPanel,BorderLayout.SOUTH);
    				centerPanel.add(leftPanel,BorderLayout.WEST);
    				centerPanel.add(rightPanel,BorderLayout.CENTER);
    			contentPanel.add(centerPanel,BorderLayout.CENTER);
    			contentPanel.add(topPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("losnummerliste.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      lblListenTitel.setText(rz.getLocale().getString("losnummerlistenfenster.listentitel"));
      lblNummernTitel.setText(rz.getLocale().getString("losnummerlistenfenster.nummerntitel"));
      lblMax.setText(rz.getLocale().getString("losnummerlistenfenster.label_max"));
      lblStichtag.setText(rz.getLocale().getString("losnummerlistenfenster.label_stichtag"));
      
      mnuHilfe.add(getAction(ACTION_HILFE_CODE));
      mnuExtras.add(getAction(ACTION_HIDE_CODE));
      mnuDatei.add(getAction(ACTION_HEUTE_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_DELETE_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HEUTE_CODE));
      tb1.add(getAction(ACTION_DELETE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));
      
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btHeute.setAction(getAction(ACTION_HEUTE_CODE));
      btDelete.setAction(getAction(ACTION_DELETE_CODE));
      
      getAction(ACTION_DELETE_CODE).setEnabled(false);
      
      this.settblListenModel(tblListe);
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
	                case ACTION_HILFE_CODE: hilfeAction();break;
	                case ACTION_HIDE_CODE:hideAction();break;
	                case ACTION_CLOSE_CODE:closeWindow();break;
	                case ACTION_HEUTE_CODE:heuteAction();break;
	                case ACTION_DELETE_CODE:deleteAction();break;
                }
        		break;
           case MessageItem.MSG_SHOW_LOSNUMMERLISTE_ID:
        	   liste = rz.getDatabase().getLosnummerVorlage().getListe();
        	   lstListe.setListData(liste.toArray());
        	   LosnummerVorlageItem lv = (LosnummerVorlageItem)msg.getData();
        	   if(lv != null) {
        		   markupListe(lv);
        		   refresh();
        	   }
        	   break;
           case MessageItem.MSG_SHOW_LOSNUMMERLISTE_DATUM:
        	    Date di = (Date)msg.getData();
        	    if(di != null){
             	   liste = rz.getDatabase().getLosnummerVorlage().getListe();
            	   lstListe.setListData(liste.toArray());
            	   datum.setTimeInMillis(di.getTime());
            	   dcDatum.setStartDate(di);
            	   if(liste.size()>0) {
            		   lstListe.setSelectedIndex(0);
            	   }
            	   refresh();
        	    }
                break;
            default:
                break;
        }
    }


     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HEUTE_CODE),new AuswahlAction(rz,this,ACTION_HEUTE_CODE,ACTION_HEUTE_TEXT, KeyEvent.VK_H ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT, 0 ,0));
     }
     
     private void lstErgebnisValueChanged(javax.swing.event.ListSelectionEvent evt) {
     	restartTimer();
     }
     private void restartTimer() {
         if(ergebnisTimer.isRunning()) {
 			ergebnisTimer.restart();
 		} else {
 			ergebnisTimer.start();
 		}
     }

     private void getCurrentDate() {
    	 datum = Calendar.getInstance();
     }
     
     private void getLosnummern(LosnummerVorlageItem lv) {
    	 if(losnummern != null) {
    		 losnummern.clear();
    	 }
    	 losnummern = rz.getDatabase().getLosnummerVorlage().getLosnummerHistory(lv, datum, ((Integer)spMax.getValue()).intValue());
    	 lblNummernTitel.setText(rz.getLocale().getString("losnummerlistenfenster.nummerntitel").replaceAll("%s", lv.getValue()));
     }
     
     private void markupListe(LosnummerVorlageItem li) {
    	if(liste != null && !liste.isEmpty()) {
    		for(int i = 0;i < liste.size();i++) {
    			if(liste.get(i).getId() == li.getId()) {
    				lstListe.setSelectedIndex(i);
    				break;
    			}
    		}
    	}
    }
     
    private void refresh() {
    	datum = dcDatum.getCalendar();
    	ergebnisTimer.stop();
    	if(liste != null && lstListe.getSelectedIndex() > -1) {
    		LosnummerVorlageItem lv = liste.get(lstListe.getSelectedIndex());
    		if(lv != null) {
    			getLosnummern(lv);
    		}
    	}
    	((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    }
    
    private void setActions() {
    	if(tblListe.getSelectedRow() != -1) {
    		getAction(ACTION_DELETE_CODE).setEnabled(true);
    	} else {
    		getAction(ACTION_DELETE_CODE).setEnabled(false);
    	}
    }
    
    private void deleteAction() {
    	if(tblListe.getSelectedRow() != -1) {
    		LosnummerListeItem li = losnummern.getItem(tblListe.getSelectedRow());
    		if(li != null) {
    			DialogItem di = new DialogItem(
		                DialogControl.FRAGE_DIALOG,
		                "",0.0,
		                rz.getLocale().getString("losnummerliste.question_delete"),
		                rz.getLocale().getString("losnummerliste.question_delete"),
		                rz.getLocale().getString("losnummerliste.question_delete_1").replaceAll("%n",li.getLosnummer()),
		                "frage.png",
		                rz.getLocale().getString("string_ja"),
		                rz.getLocale().getString("string_nein"),
		                this
		        );
		        rz.getDialogFactory().getDialog(di);
		        if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		           rz.getDatabase().getLosnummerVorlage().deleteLosnummer(li.getId());
		           refresh();
		        }
    		}
    	}
    }
    
    private void heuteAction() {
    	dcDatum.setStartDate(new Date());
    }
    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
			lstListe.requestFocus();
		}
        toFront();
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

   

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"losnummerliste.html",this));
    }

    
    
    private void settblListenModel(JTable t) {
	    final ListenColumnModel rcm = new ListenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("losnummerlistenfenster.tableheader_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("losnummerlistenfenster.tableheader_losnummer"));
	    	tc.setModelIndex(C_LOSNUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("losnummerlistenfenster.tableheader_user"));
	    	tc.setModelIndex(C_USER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);

	    

        rcm.addColumnModelListener(this);
        tblListe.setModel(new ListenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.getTableHeader().setReorderingAllowed(false);
       // tblListe.setRowHeight((int)(tblListe.getRowHeight()*1.5));
   }
    
    private class ListenColumnModel extends DefaultTableColumnModel{
	    public ListenColumnModel() {
	        super();
	    }

	}

	private  class ListenTableModel extends AbstractTableModel    {

	        SimpleDateFormat df;

	        public ListenTableModel() {
	            df = new SimpleDateFormat("EEEEE, d. MMMMM yyyy HH:mm");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
		   
	        public int getRowCount() {
	        	int ret = 0;
	        	if(losnummern != null) {
	        		ret =  losnummern.size();
	        	}
	        	return ret;
	        		
	        }

	      
	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if(losnummern != null) {
	                ret = getContent(losnummern.getItem(rowIndex),columnIndex);
	            }
	            return ret;
	        }

	        private Object getContent(LosnummerListeItem li,int aColumn) {
	            Object ret = null;
	            if(li != null) {
		            switch(aColumn){
		            	case C_DATUM: ret = df.format(li.getDatum());break;
		            	case C_LOSNUMMER: ret = li.getLosnummer();break;
		            	case C_USER: ret=li.getUser();break;
		            }
	            }
	            return ret;
	        }
		}

	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	Color c;
    		if(isSelected) {
    		    c= rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED);
    		}else {
		   		c=rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL);
    		}
	        setBackground(c);
	        setFont(rz.getFontFactory().getTableFont());
	        if(value != null) {
	        	setText((String)value);
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
    
	@Override
	public void columnAdded(TableColumnModelEvent e) {
	}

	@Override
	public void columnRemoved(TableColumnModelEvent e) {
	}

	@Override
	public void columnMoved(TableColumnModelEvent e) {
	}

	@Override
	public void columnMarginChanged(ChangeEvent e) {
	}

	@Override
	public void columnSelectionChanged(ListSelectionEvent e) {
	}
}
