/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.loggingfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.log.LoggingItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class LoggingFenster extends JRzFrame implements TableColumnModelListener{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel northPanel;
      		private JPanel listenPanel;
      			private JScrollPane scrListe;
      				private JTable tblListe;
  		private JPanel buttonPanel;
  			private JButton btSpeichern;
      	    private JButton btHilfe;
      	    private JButton btAbbrechen;

    public static final int         		ACTION_ABBRECHEN_CODE = 1001;
    public static final String     		ACTION_ABBRECHEN_TEXT = "logging.action_close";
    public static final int         		ACTION_SAVE_CODE = 1002;
    public static final String     		ACTION_SAVE_TEXT = "logging.action_speichern";
    public static final int         		ACTION_HILFE_CODE = 1003;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1004;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";

    static final int							MAX_COLUMN = 4;
    static final int							C_DATUM=0;
    static final int							C_LEVEL =1;
    static final int							C_ORIGIN=2;
    static final int							C_MESSAGE =3;

    /** Creates new form AdressenFenster */
    public LoggingFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel=new JPanel(new BorderLayout());
				northPanel = new JPanel(new BorderLayout());

				centerPanel.add(northPanel,BorderLayout.NORTH);
				listenPanel = new JPanel(new BorderLayout());
					scrListe = new JScrollPane();
					tblListe = new JTable();
						tblListe.setName("logging.spalten");
						scrListe.setViewportView(tblListe);
					listenPanel.add(scrListe,BorderLayout.CENTER);

				centerPanel.add(listenPanel,BorderLayout.CENTER);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		    // ButtonPanel
			buttonPanel=new JPanel(new GridLayout(1,3));
				btSpeichern = new JButton();
				buttonPanel.add(btSpeichern);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
				btAbbrechen = new JButton();
				buttonPanel.add(btAbbrechen);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("logging.titel"));

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.add(getAction(ACTION_SAVE_CODE));
		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_ABBRECHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SAVE_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		btSpeichern.setAction(getAction(ACTION_SAVE_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btAbbrechen.setAction(getAction(ACTION_ABBRECHEN_CODE));

		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            	  case ACTION_SAVE_CODE:speichernAction();break;
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_ABBRECHEN_CODE:closeWindow();break;
		          default :
		              break;
           }
    		break;
         case MessageItem.MSG_SHOW_LOG :
 		     this.settblListenModel(this.tblListe);
         	break;
         case MessageItem.MSG_LOG_CHANGE:
         	updateListe();
	      	break;

        default:
            rz.getLogFactory().logMessage(2, "loggingfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, KeyEvent.VK_S ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE,0));
    }



    /**
     * die Liste updaten....
     *
     */
    private void updateListe() {
    	((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    }

    @Override
	public void openWindow(){
    	rz.getLogFactory().setNotifyFrame(this);
    	updateListe();
    	setVisible(true);
        toFront();
    }

    @Override
	public void closeWindow(){
    	rz.getLogFactory().setNotifyFrame(null);
    	//setVisible(false);
    	
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void speichernAction() {
    	String path = "";
    	final JFileChooser fc = new JFileChooser();
    	fc.setDialogTitle(rz.getLocale().getString("logging.file_titel"));
    	fc.setCurrentDirectory(null);
    	if(fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
    		path = fc.getSelectedFile().getPath();
	    	if(!path.trim().equals("")) {
	    		rz.getLogFactory().getLog().saveLog(path.trim());
	    	}
    	}
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"logging.html",this));
    }


    private void settblListenModel(JTable t) {
	    final ListenColumnModel rcm = new ListenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("logging.tableheader_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("logging.tableheader_level"));
	    	tc.setModelIndex(C_LEVEL);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("logging.tableheader_origin"));
	    	tc.setModelIndex(C_ORIGIN);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("logging.tableheader_message"));
			tc.setModelIndex(C_MESSAGE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblListe.setModel(new ListenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class ListenColumnModel extends DefaultTableColumnModel{
	    public ListenColumnModel() {
	        super();
	    }

	}

	private  class ListenTableModel extends AbstractTableModel    {

	    	Icon						erledigt;
	    	Icon						unerledigt;
	        SimpleDateFormat df;

	        public ListenTableModel() {
	            unerledigt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_unerledigt.png"));
	            df = new SimpleDateFormat("dd.MM.yyyy");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(rz.getLogFactory().getLog() != null) {
	                return rz.getLogFactory().getLog().size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public LoggingItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (rz.getLogFactory().getLog() != null)) {
	        		return rz.getLogFactory().getLog().getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (rz.getLogFactory().getLog() != null)) {
	                ret = getContent(rz.getLogFactory().getLog().getItem(rowIndex),columnIndex);
	            }
	            return ret;
	        }

	        private Object getContent(LoggingItem li,int aColumn) {
	            Object ret = null;
	            if(li != null) {
		            switch(aColumn){
		            	case C_DATUM: ret = li.getTimestamp().toString();break;
		            	case C_LEVEL: ret = li.getLevelString();break;
		            	case C_ORIGIN: ret=li.getOrigin();break;
		            	case C_MESSAGE: ret = li.getMessage();break;
		            }
	            }
	            return ret;
	        }
		}


	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	LoggingItem li;
	    	setBackground(Color.WHITE);
	    	setForeground(Color.BLACK);
	    	if((row != -1) && (rz.getLogFactory().getLog() != null)) {
	    		li = rz.getLogFactory().getLog().getItem(row);
	    		switch(li.getLevel()) {
	    			case LogFactory.LOG_ERROR:
	    				setBackground(Color.RED);
	    				setForeground(Color.WHITE);
	    				break;
	    			case LogFactory.LOG_WARN:
	    				setBackground(Color.MAGENTA);
	    				setForeground(Color.BLACK);
	    				break;
	    			default:
	    				setBackground(Color.WHITE);
	    				setForeground(Color.BLACK);
	    				break;
	    		}
	    	}
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}


    public void columnAdded(TableColumnModelEvent e) {

    }
    public void columnMarginChanged(ChangeEvent e) {

    }
    public void columnMoved(TableColumnModelEvent e) {

    }
    public void columnRemoved(TableColumnModelEvent e) {

    }
    public void columnSelectionChanged(ListSelectionEvent e) {

    }


}


