/*
 * Created on 20.09.2004
 *
 */
package de.lunqual.rzpro.fenster.lieferscheinfenster;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.lieferschein.LieferscheinAuftrag;
import de.lunqual.rzpro.items.lieferschein.LieferscheinEinfachItem;
import de.lunqual.rzpro.items.lieferschein.LieferscheinEinfachListe;
import de.lunqual.rzpro.items.lieferschein.LieferscheinItem;
import de.lunqual.rzpro.items.lieferschein.LieferscheinZeile;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class LieferscheinListenFenster extends JRzFrame  implements TableColumnModelListener{

    private JMenuBar	mb;
	private JMenu mnuDatei;
	private JMenu mnuBearbeiten;
	private JMenu mnuExtras;
	private JMenu mnuFenster;
	private JMenu mnuHilfe;
	private JPanel mainPanel;
		private JPanel contentPanel;
			private JPanel tbPanel;
				private JToolBar tb1;
			private JPanel centerPanel;
				private JPanel centerLeftPanel;
					private JPanel centerNorth;
						private JPanel filterPanel;
							private JLabel lblFilter;
							private JSelectedTextField txtFilter;
							private JButton btFilter;
						private JPanel auswahlPanel;
							private ButtonGroup auswahlGroup;
								private JRadioButton btAuswahlLosnummer;
								private JRadioButton btAuswahlAdresse;
								private JRadioButton btAuswahlNummer;
								private JButton btAdresse;
					private JPanel centerListe;
						private JScrollPane scrListe;
							private JList lstLieferscheine;
					private JPanel centerButtons;
						private JButton btNeu;
						private JButton btRefresh;
				private JPanel centerRightPanel;
					private JPanel lieferscheinDatenPanel;
						private JButton lblLieferscheinDaten;
						private JLabel lblErstellt;
						private JLabel lblGeaendert;
					private JPanel lieferscheinPanel;
						private JScrollPane scrLieferschein;
							private JTable tblLieferschein;
					private JPanel lieferscheinButtons;
						private JComboBox cmbFormulare;
						private JButton btDrucken;
						private JPanel etikettendruckPanel;
							private JButton btEtikettenDrucken;
							private JCheckBox chkAbfuelltag;
							private JPanel musterPanel;
						private JButton btBearbeiten;
						private JButton btLoeschen;
			private JPanel buttonPanel;
				private JPanel rightPanel;
					private JButton btHilfe;
					private JButton btClose;

	public static final int 			ACTION_SCHLIESSEN_CODE = 1000;
	public static final String 		ACTION_SCHLIESSEN_TEXT = "lieferscheinliste.action_schliessen";
	public static final int         	ACTION_HILFE_CODE  = 1001;
    public static final String     	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         	ACTION_HIDE_CODE  = 1002;
    public static final String     	ACTION_HIDE_TEXT = "action_hide";
	public static final int 			ACTION_DRUCKEN_CODE = 1005;
	public static final String 		ACTION_PRINT_TEXT = "lieferscheinliste.action_drucken";
	public static final int 			ACTION_FILTER_CODE = 1006;
	public static final String 		ACTION_FILTER_TEXT = "lieferscheinliste.action_filter";
	public static final int 			ACTION_NEU_CODE = 1007;
	public static final String 		ACTION_NEU_TEXT = "lieferscheinliste.action_neu";
	public static final int 			ACTION_EDIT_CODE = 1008;
	public static final String 		ACTION_EDIT_TEXT = "lieferscheinliste.action_edit";
	public static final int 			ACTION_DELETE_CODE = 1009;
	public static final String 		ACTION_DELETE_TEXT = "lieferscheinliste.action_delete";
    public static final int         	ACTION_REFRESH_CODE  = 1010;
    public static final String     	ACTION_REFRESH_TEXT = "action_refresh";
    public static final int         	ACTION_ADRESSE_CODE  = 1011;
    public static final String     	ACTION_ADRESSE_TEXT = "lieferscheinliste.action_adresse";
    public static final int         	ACTION_EINSTELLUNGSFENSTER_CODE  = 1012;
    public static final String     	ACTION_EINSTELLUNGSFENSTER_TEXT = "auswahl.action_einstellungsfenster";
	public static final int 			ACTION_ETIKETTEN_CODE = 1013;
	public static final String 		ACTION_ETIKETTEN_TEXT = "lieferscheinliste.action_etikettendruck";

	public static final int			C_MAX = 11;
	public static final int			C_BEZEICHNUNG=0;
	public static final int 		C_NUMMER=1;
	public static final int			C_LOSNUMMER=2;
	public static final int			C_COMMENT= 3;
	public static final int			C_STAERKE = 4;
	public static final int			C_BRUTTO=5;
	public static final int			C_TARA=6;
	public static final int			C_NETTO =7;
	public static final int			C_LITER=8;
	public static final int			C_LA = 9;
	public static final int			C_EAN = 10;
	
    MessageItem							mi;
	LieferscheinEinfachListe			ll;
	LieferscheinItem						li;
	Timer									ergebnisTimer;
    /**
     * @param r
     * @param name
     * @param extendedData
     */
    public LieferscheinListenFenster(RzPro r, String name, Object extendedData) {
    	super(r,name,extendedData);
	    mi = new MessageItem(MessageItem.MSG_NULL,0,null,this);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
      });
		createActions();
		createGUIComponents();
		setGUIComponents();
		getMessage((MessageItem)extendedData);
    }



    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#createGUIComponents()
     */
    @Override
	public void createGUIComponents() {
     	mb = new javax.swing.JMenuBar();
    	mnuDatei = new javax.swing.JMenu();
    	mnuBearbeiten = new JMenu();
    	mnuExtras = new JMenu();
    	mnuFenster = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuExtras);
    	mb.add(mnuFenster);
    	mb.add(mnuHilfe);
        setJMenuBar(mb);
        mainPanel = new JPanel(new BorderLayout());
	        contentPanel = new JPanel(new BorderLayout());
			//Toolbar
			tb1 = new javax.swing.JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			//Panels & buttons...
				tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.CENTER);
			contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				centerLeftPanel = new JPanel(new BorderLayout());
					centerNorth=new JPanel(new BorderLayout());
						filterPanel = new JPanel(new BorderLayout());
						lblFilter = new JLabel();
							lblFilter.setHorizontalAlignment(SwingConstants.TRAILING);
							filterPanel.add(lblFilter,BorderLayout.WEST);
							txtFilter = new JSelectedTextField();
				            txtFilter.addKeyListener(new java.awt.event.KeyAdapter() {
				                @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
				                      refreshAction();
				                    }
				                }
				            });
							filterPanel.add(txtFilter,BorderLayout.CENTER);
							btFilter = new JButton();
							filterPanel.add(btFilter,BorderLayout.EAST);
					  centerNorth.add(filterPanel,BorderLayout.NORTH);
							auswahlPanel = new JPanel(new GridLayout(3,1));
								auswahlGroup = new ButtonGroup();
									btAuswahlAdresse = new JRadioButton();
									auswahlGroup.add(btAuswahlAdresse);
									btAuswahlLosnummer = new JRadioButton();
									auswahlGroup.add(btAuswahlLosnummer);
									btAuswahlNummer = new JRadioButton();
									auswahlGroup.add(btAuswahlNummer);
									btAuswahlAdresse.setSelected(true);
		    			             btAuswahlAdresse.addActionListener(new java.awt.event.ActionListener() {
		    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    			                    auswahlAction();
		    			                	}
		    			            	});
			    			            btAuswahlLosnummer.addActionListener(new java.awt.event.ActionListener() {
			    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
			    			                    auswahlAction();
			    			                	}
			    			            	});
			    			            btAuswahlNummer.addActionListener(new java.awt.event.ActionListener() {
			    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
			    			                    auswahlAction();
			    			                	}
			    			            	});
						     auswahlPanel.add(btAuswahlAdresse,BorderLayout.NORTH);
						     auswahlPanel.add(btAuswahlLosnummer,BorderLayout.SOUTH);
						     auswahlPanel.add(btAuswahlNummer);
						centerNorth.add(auswahlPanel,BorderLayout.CENTER);
							btAdresse=new JButton();
						centerNorth.add(btAdresse,BorderLayout.SOUTH);
					centerLeftPanel.add(centerNorth,BorderLayout.NORTH);

					centerListe = new JPanel(new BorderLayout());
						scrListe = new JScrollPane();
							lstLieferscheine = new JList();
								lstLieferscheine.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
						        lstLieferscheine.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
						            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
						                lstLieferscheinValueChanged(evt);
						            }
						        });
							scrListe.setViewportView(lstLieferscheine);
						centerListe.add(scrListe,BorderLayout.CENTER);
					centerLeftPanel.add(centerListe,BorderLayout.CENTER);

					centerButtons = new JPanel(new GridLayout(1,2));
						btNeu = new JButton();
						centerButtons.add(btNeu);
						btRefresh = new JButton();
						centerButtons.add(btRefresh);
						centerLeftPanel.add(centerButtons,BorderLayout.SOUTH);
				centerPanel.add(centerLeftPanel,BorderLayout.WEST);

				centerRightPanel = new JPanel(new BorderLayout()) ;
					lieferscheinDatenPanel = new JPanel(new GridLayout(3,1));
						lblLieferscheinDaten = new JButton();
		        	    lblLieferscheinDaten.addActionListener(new ActionListener() {
	        	        		public void actionPerformed(ActionEvent evt) {
	        	        			showAdresse();
	        	        		}
		        	    	});
							lblLieferscheinDaten.setHorizontalAlignment(SwingConstants.CENTER);
						lieferscheinDatenPanel.add(lblLieferscheinDaten);
						lblErstellt = new JLabel();
							lblErstellt.setHorizontalAlignment(SwingConstants.CENTER);
							lieferscheinDatenPanel.add(lblErstellt);
						lblGeaendert = new JLabel();
							lblGeaendert.setHorizontalAlignment(SwingConstants.CENTER);
							lieferscheinDatenPanel.add(lblGeaendert);
						lieferscheinDatenPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
					centerRightPanel.add(lieferscheinDatenPanel,BorderLayout.NORTH);
					lieferscheinPanel = new JPanel(new BorderLayout());
						scrLieferschein = new JScrollPane();
							tblLieferschein = new JTable();
							tblLieferschein.setName("lieferscheinlistenfenster.spalten");
							tblLieferschein.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			    			tblLieferschein.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			                    public void valueChanged(ListSelectionEvent e) {
			        			        if (!e.getValueIsAdjusting()) {
											return;
										}
			        			        selectionChanged();
			                        }
				    			});
							scrLieferschein.setViewportView(tblLieferschein);
						lieferscheinPanel.add(scrLieferschein,BorderLayout.CENTER);
					centerRightPanel.add(scrLieferschein,BorderLayout.CENTER);
					lieferscheinButtons = new JPanel(new GridLayout(1,5));

	    			cmbFormulare = new JComboBox();
    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_LIEFERSCHEIN);
	        	    cmbFormulare.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		if(cmbFormulare.getSelectedIndex() != -1) {
        	        		    rz.getOptionFactory().setOption("report.lieferschein",((ReportItem)cmbFormulare.getSelectedItem()).getID());
        	        		    rz.getOptionFactory().saveOptions();
        	        			}
        	        		}
	        	    	});
						lieferscheinButtons.add(cmbFormulare);
						btDrucken = new JButton();
						lieferscheinButtons.add(btDrucken);
						etikettendruckPanel = new JPanel(new BorderLayout());
							btEtikettenDrucken = new JButton();
							etikettendruckPanel.add(btEtikettenDrucken,BorderLayout.NORTH);
							musterPanel=new JPanel(new BorderLayout());

							etikettendruckPanel.add(musterPanel,BorderLayout.CENTER);
							chkAbfuelltag = new JCheckBox();
							chkAbfuelltag.addActionListener(new ActionListener() {
				  	            public void actionPerformed(ActionEvent evt) {
				  	            		if(chkAbfuelltag.isSelected()) {
				  	            			rz.getOptionFactory().setOption("lieferscheinliste.abfuelltag",1);
				  	            		}else {
				  	            			rz.getOptionFactory().setOption("lieferscheinliste.abfuelltag",0);
				  	            		}
				  	            		rz.getOptionFactory().saveOptions();
				  	            	}
				  	        	});
							etikettendruckPanel.add(chkAbfuelltag,BorderLayout.SOUTH);
						lieferscheinButtons.add(etikettendruckPanel);
						btBearbeiten = new JButton();
						lieferscheinButtons.add(btBearbeiten);
						btLoeschen = new JButton();
						lieferscheinButtons.add(btLoeschen);
					centerRightPanel.add(lieferscheinButtons,BorderLayout.SOUTH);
				centerPanel.add(centerRightPanel,BorderLayout.CENTER);
			contentPanel.add(centerPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				rightPanel=new JPanel(new BorderLayout());
					btHilfe = new JButton();
					rightPanel.add(btHilfe,BorderLayout.EAST);
					btClose = new JButton();
					rightPanel.add(btClose,BorderLayout.WEST);
				buttonPanel.add(rightPanel,BorderLayout.CENTER);
				buttonPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
			contentPanel.add(buttonPanel,BorderLayout.SOUTH);
		mainPanel.add(contentPanel,BorderLayout.CENTER);
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
    }

    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#setGUIComponents()
     */
    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("lieferscheinliste.titel")+" " + rz.getDatabase().getKalender().getDatum20Now());
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);


		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
		mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
		mnuDatei.add(getAction(ACTION_ETIKETTEN_CODE));
		mnuDatei.addSeparator();
		mnuDatei.add(getAction(ACTION_SCHLIESSEN_CODE));
		mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
		mnuBearbeiten.add(getAction(ACTION_EDIT_CODE));
		mnuBearbeiten.add(getAction(ACTION_REFRESH_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_ADRESSE_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));
		mnuExtras.add(getAction(ACTION_HIDE_CODE));
		mnuFenster.add(getAction(ACTION_EINSTELLUNGSFENSTER_CODE));
		mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_SCHLIESSEN_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_NEU_CODE));
		tb1.add(getAction(ACTION_EDIT_CODE));
		tb1.add(getAction(ACTION_DELETE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ADRESSE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_DRUCKEN_CODE));
		tb1.add(getAction(ACTION_ETIKETTEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_EINSTELLUNGSFENSTER_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		btNeu.setAction(getAction(ACTION_NEU_CODE));
		btBearbeiten.setAction(getAction(ACTION_EDIT_CODE));
		btLoeschen.setAction(getAction(ACTION_DELETE_CODE));
		btFilter.setAction(getAction(ACTION_FILTER_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btClose.setAction(getAction(ACTION_SCHLIESSEN_CODE));
		btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
		btAdresse.setAction(getAction(ACTION_ADRESSE_CODE));
		btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
		btEtikettenDrucken.setAction(getAction(ACTION_ETIKETTEN_CODE));
		lblErstellt.setText(" ");
		lblGeaendert.setText(" ");
		lblLieferscheinDaten.setText(" ");

		btAuswahlAdresse.setText(rz.getLocale().getString("lieferschein.label_mit_adresse"));
		btAuswahlLosnummer.setText(rz.getLocale().getString("lieferschein.label_ohne_adresse"));
		btAuswahlNummer.setText(rz.getLocale().getString("lieferschein.label_nummer"));		
		
        chkAbfuelltag.setText(rz.getLocale().getString("lieferscheinliste.abfuelltag"));
        chkAbfuelltag.setSelected(rz.getOptionFactory().getOption("lieferscheinliste.abfuelltag",0)==0?false:true);
        
		
		setActions();
		this.setTblRezepturModel(tblLieferschein);
		setResizable(true);
		rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);
    }

    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#closeWindow()
     */
    @Override
	public void closeWindow() {
        //setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#createActions()
     */
    @Override
	public void createActions() {
		actionList.put(String.valueOf(ACTION_HIDE_CODE), new AuswahlAction(rz,this, ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5, InputEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_SCHLIESSEN_CODE), new AuswahlAction(rz,this, ACTION_SCHLIESSEN_CODE,ACTION_SCHLIESSEN_TEXT, KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_HILFE_CODE), new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1, 0));
		actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_PRINT_TEXT, KeyEvent.VK_D, InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_FILTER_CODE), new AuswahlAction(rz,this,ACTION_FILTER_CODE,ACTION_FILTER_TEXT, KeyEvent.VK_F, InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_NEU_CODE), new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT, KeyEvent.VK_N, InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_EDIT_CODE), new AuswahlAction(rz,this,ACTION_EDIT_CODE,ACTION_EDIT_TEXT, KeyEvent.VK_F2, 0));
		actionList.put(String.valueOf(ACTION_DELETE_CODE), new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT, KeyEvent.VK_DELETE, 0));
		actionList.put(String.valueOf(ACTION_REFRESH_CODE), new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5, 0));
		actionList.put(String.valueOf(ACTION_ADRESSE_CODE), new AuswahlAction(rz,this,ACTION_ADRESSE_CODE,ACTION_ADRESSE_TEXT, KeyEvent.VK_A, InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_EINSTELLUNGSFENSTER_CODE), new AuswahlAction(rz,this, ACTION_EINSTELLUNGSFENSTER_CODE,ACTION_EINSTELLUNGSFENSTER_TEXT, KeyEvent.VK_F12, 0));
		actionList.put(String.valueOf(ACTION_ETIKETTEN_CODE), new AuswahlAction(rz,this, ACTION_ETIKETTEN_CODE,ACTION_ETIKETTEN_TEXT, KeyEvent.VK_E, InputEvent.CTRL_DOWN_MASK));

    }
    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#getMessage(de.lunqual.rzpro.items.MessageItem)
     */
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            	case ACTION_NEU_CODE:neuAction();break;
            	case ACTION_HILFE_CODE: hilfeAction();break;
            	case ACTION_HIDE_CODE:hideAction();break;
            	case ACTION_SCHLIESSEN_CODE:closeWindow();break;
            	case ACTION_EDIT_CODE:editAction();
            	case ACTION_FILTER_CODE:filterAction();break;
            	case ACTION_ADRESSE_CODE:adresseAction();break;
            	case ACTION_DRUCKEN_CODE:druckenAction();break;
            	case ACTION_DELETE_CODE:loeschenAction();break;
            	case ACTION_EINSTELLUNGSFENSTER_CODE:einstellungenAction();
            	case ACTION_REFRESH_CODE:refreshAction();break;
            	case ACTION_ETIKETTEN_CODE:etikettenDruckAction();break;
        }
    	break;
        case MessageItem.MSG_SELECT_ADRESSE_REPLY:
            final AdressItem ai = (AdressItem)msg.getData();
            if(ai != null) {
                txtFilter.setText(ai.getFirma());
                btAuswahlAdresse.setSelected(true);
                auswahlAction();
            	refreshAction();
            }
            break;
	  case MessageItem.MSG_LIEFERSCHEINE:
	      mi = msg;
	  	  txtFilter.setText((String)msg.getData());
	  	  btAuswahlAdresse.setSelected(true);
	  	  getAction(ACTION_ADRESSE_CODE).setEnabled(true);
	  	  refreshAction();
	      break;
        }
    }

    private void setActions() {
        if(lstLieferscheine.getSelectedIndex() != -1) {
            getAction(ACTION_DRUCKEN_CODE).setEnabled(true);
            getAction(ACTION_ETIKETTEN_CODE).setEnabled(true);
            getAction(ACTION_EDIT_CODE).setEnabled(true);
            getAction(ACTION_DELETE_CODE).setEnabled(true);
        } else {
            getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
            getAction(ACTION_EDIT_CODE).setEnabled(false);
            getAction(ACTION_DELETE_CODE).setEnabled(false);
            getAction(ACTION_ETIKETTEN_CODE).setEnabled(false);
        }
    }

    private void ergebnisTimerEvent() {
        if (ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
        if(lstLieferscheine.getSelectedIndex() != -1) {
            li = rz.getDatabase().getLieferschein().getLieferschein(((LieferscheinEinfachItem)lstLieferscheine.getSelectedValue()).getId(),false);
            if(li != null) {
	            final String label =  ( li.getAi() == null)? li.getAdresse_string() : li.getAi().getFirma();
	            ((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
	            lblLieferscheinDaten.setText("<html><b><font color='blue'>" +
	                    li.getNummer() + " : " + label +
	                    "</font></b></html");
	            lblErstellt.setText(rz.getLocale().getString("string_erstellt").replaceAll("%s",li.getErstelltToString()).replaceAll("%v",li.getUser_1()));
	            lblGeaendert.setText(rz.getLocale().getString("string_geaendert").replaceAll("%s",li.getGeaendertToString()).replaceAll("%v",li.getUser_2()));
	        } else {
	            ((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
	            lblLieferscheinDaten.setText(" ");
	            lblErstellt.setText(" ");
	            lblGeaendert.setText(" ");
	            refreshAction();
	        }
        }
        setActions();
    }

    private void etikettenDruckAction() {
 	   final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
        if(zl != null) {
            switch (zl.getTyp()){
            	case LieferscheinZeile.ZEILE_CONTAINER:
            		zl.etikettenDruck(chkAbfuelltag.isSelected());
            		break;
            	case LieferscheinZeile.ZEILE_SUMME:
            		final LieferscheinAuftrag la = li.getAuftragsListe().getAuftrag(zl.getUid());
            		if(la != null) {
            			la.etikettenDruck(chkAbfuelltag.isSelected());
            		}
            		break;
            	default :
            		li.etikettenDruck(chkAbfuelltag.isSelected());
            		break;
            }
        } else {
        		li.etikettenDruck(chkAbfuelltag.isSelected());
        }
 }

    private void selectionChanged() {
        final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
		getAction(ACTION_ETIKETTEN_CODE).putValue(Action.NAME, rz.getLocale().getString("lieferscheinliste.action_etikettendruck"));
		getAction(ACTION_ETIKETTEN_CODE).putValue(Action.SHORT_DESCRIPTION, rz.getLocale().getString("lieferscheinliste.action_etikettendruck.1"));
        if(zl != null) {
            switch (zl.getTyp()){
            	case LieferscheinZeile.ZEILE_CONTAINER:
        	    	getAction(ACTION_ETIKETTEN_CODE).putValue(Action.NAME, rz.getLocale().getString("lieferscheinliste.action_etikettendruck_container"));
         	    	getAction(ACTION_ETIKETTEN_CODE).putValue(Action.SHORT_DESCRIPTION, rz.getLocale().getString("lieferscheinliste.action_etikettendruck_container.1"));
            		break;
            	case LieferscheinZeile.ZEILE_SUMME:
            		getAction(ACTION_ETIKETTEN_CODE).putValue(Action.NAME, rz.getLocale().getString("lieferscheinliste.action_etikettendruck_auftrag"));
            		getAction(ACTION_ETIKETTEN_CODE).putValue(Action.SHORT_DESCRIPTION, rz.getLocale().getString("lieferscheinliste.action_etikettendruck_auftrag.1"));
            	    break;
            	default:
            	break;
            }
        }
    }

    private void lstLieferscheinValueChanged(javax.swing.event.ListSelectionEvent evt) {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
        ergebnisTimer.start();
    }

    /** schaltet zwischen LieferscheinAuswahl über Adressen und Auswahl
     * ohne Adressen um
     *
     */
    private void auswahlAction() {
        if(btAuswahlAdresse.isSelected()) {
            getAction(ACTION_ADRESSE_CODE).setEnabled(true);
        }else {
            getAction(ACTION_ADRESSE_CODE).setEnabled(false);
        }
        this.txtFilter.requestFocus();
    }

    private void loeschenAction() {
        if(!txtFilter.hasFocus()) {
	        if(lstLieferscheine.getSelectedIndex() != -1) {
	            final int index = ((LieferscheinEinfachItem)lstLieferscheine.getSelectedValue()).getId();
			        final DialogItem di = new DialogItem(
			                DialogControl.FRAGE_DIALOG,
			                "",0.0,
			                rz.getLocale().getString("lieferschein.question_delete"),
			                rz.getLocale().getString("lieferschein.question_delete"),
			                rz.getLocale().getString("lieferschein.question_delete_1").replaceAll("%s",((LieferscheinEinfachItem)lstLieferscheine.getSelectedValue()).toString()),
			                "frage.png",
			                rz.getLocale().getString("string_ja"),
			                rz.getLocale().getString("string_nein"),
			                this
			        );
			        rz.getDialogFactory().getDialog(di);
			        if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
			            final boolean r = rz.getDatabase().getLieferschein().deleteLieferschein(index);
			            if(r==true) {
			                refreshAction();
			            }
			        }
	        	}
        }
    }

    private void druckenAction() {
        if(lstLieferscheine.getSelectedIndex() != -1) {
           final LieferscheinItem li = rz.getDatabase().getLieferschein().getLieferschein(((LieferscheinEinfachItem)lstLieferscheine.getSelectedValue()).getId(), true);
           rz.getReportFactory().lieferscheinReport(li,this);
        }
    }

    private void refreshAction() {
    	if(!txtFilter.getText().trim().equals("")) {
    		if (getAction(ACTION_ADRESSE_CODE).isEnabled()) {
		      ll = rz.getDatabase().getLieferschein().getEinfachListe(txtFilter.getText().trim());
    		} else {
    			if(btAuswahlLosnummer.isSelected()) {
    				ll = rz.getDatabase().getLieferschein().getLosnummerListe(txtFilter.getText().trim());
    			}else {
    				if(btAuswahlNummer.isSelected()) {
        				ll = rz.getDatabase().getLieferschein().getNummerListe(txtFilter.getText().trim());
    				}
    			}
    		}
		      lstLieferscheine.setListData(ll.toArray());
		      if(lstLieferscheine.getModel().getSize() > 0) {
		          lstLieferscheine.setSelectedIndex(0);
		      } else {
		          li = null;
		          ((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
		          lblLieferscheinDaten.setText(" ");
		          lblErstellt.setText(" ");
		          lblGeaendert.setText(" ");
		      }
    	}else {
    		li = null;
	        ll = new LieferscheinEinfachListe();
		    lstLieferscheine.setListData(ll.toArray());
	        ((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
	        lblLieferscheinDaten.setText(" ");
	        lblErstellt.setText(" ");
	        lblGeaendert.setText(" ");
    	}
    }
    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#openWindow()
     */
    private void editAction() {
        int id;
        if(lstLieferscheine.getSelectedIndex()!= -1) {
            id = ((LieferscheinEinfachItem)lstLieferscheine.getSelectedValue()).getId();
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LIEFERSCHEIN,false,new MessageItem(MessageItem.MSG_EDIT_LIEFERSCHEIN_REQUEST,id,null,this));
        }
    }

    private void showAdresse() {
    	if(lstLieferscheine.getSelectedIndex() != -1){
    		LieferscheinEinfachItem le = (LieferscheinEinfachItem)lstLieferscheine.getSelectedValue();
    		try {
    	  		String suchString =  le.getFirma().replaceAll(" ",".*");
        		suchString = suchString.replaceAll("\\)","").replaceAll("\\(", "").replaceAll("\\s\\|", "|").replaceAll("\\|\\s", "|").replaceAll("\\[","").replaceAll("\\]","");
                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEN,true,new MessageItem(MessageItem.MSG_SHOW_ADRESSE,0,suchString,this));
    		}
    		catch(Exception e) {
    		}
    	}
    }
    
    private void filterAction() {
        refreshAction();
    }
    private void adresseAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL_EINFACH,true, new MessageItem(MessageItem.MSG_SELECT_ADRESSE_REQUEST,0, txtFilter.getText().trim(),this));
    }

    private void neuAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LIEFERSCHEIN,false,new MessageItem(MessageItem.MSG_EDIT_LIEFERSCHEIN_REQUEST,0,null,this));
    }
    @Override
	public void openWindow() {
        setVisible(true);
        toFront();
        txtFilter.requestFocus();
    }

    private void einstellungenAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_EINSTELLUNGEN,true,new MessageItem(MessageItem.MSG_SHOW_EINSTELLUNGEN,0,null,this));
    }
	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"lieferscheine.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }



    public void columnAdded(TableColumnModelEvent e) {

    }
    public void columnMarginChanged(ChangeEvent e) {

    }
    public void columnMoved(TableColumnModelEvent e) {

    }
    public void columnRemoved(TableColumnModelEvent e) {

    }
    public void columnSelectionChanged(ListSelectionEvent e) {

    }
	private void setTblRezepturModel(JTable t) {
	    final RechenColumnModel rcm = new RechenColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    	tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_nummer"));
    		tc.setCellRenderer(sr);
    		tc.setModelIndex(C_NUMMER);
        rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_losnummer"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_LOSNUMMER);
		rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_comment"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_COMMENT);
		rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_staerke"));
	    	tc.setModelIndex(C_STAERKE);
	    	tc.setCellRenderer(nr);
    	rcm.addColumn(tc);
        tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_brutto"));
        	tc.setModelIndex(C_BRUTTO);
        	tc.setCellRenderer(nr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_tara"));
        	tc.setModelIndex(C_TARA);
	    	tc.setCellRenderer(nr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_netto"));
        	tc.setModelIndex(C_NETTO);
	    	tc.setCellRenderer(nr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_liter"));
        	tc.setModelIndex(C_LITER);
	    	tc.setCellRenderer(nr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_la"));
    		tc.setModelIndex(C_LA);
	    	tc.setCellRenderer(nr);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_ean"));
		tc.setModelIndex(C_EAN);
    	tc.setCellRenderer(sr);
    rcm.addColumn(tc);


        rcm.addColumnModelListener(this);
        tblLieferschein.setModel(new RechenTableModel());
        tblLieferschein.setColumnModel(rcm);
        tblLieferschein.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblLieferschein.setCellSelectionEnabled(false);
        tblLieferschein.setRowSelectionAllowed(true);
        tblLieferschein.setColumnSelectionAllowed(false);
        tblLieferschein.getTableHeader().setReorderingAllowed(false);
	}

	private class RechenColumnModel extends DefaultTableColumnModel{
	    public RechenColumnModel() {
	        super();
	    }

	}

	private  class RechenTableModel extends AbstractTableModel    {


		   public int getColumnCount() {
		       	return 8;
	        }
	        public int getRowCount() {
	            if(li != null) {
	                return	 li.getAuftragsListe().getRowCount();
	        	} else {
	        	    return 0;
	        	}
	        }

	        public LieferscheinZeile getZeileAt(int rowIndex) {
	            LieferscheinZeile zl=null;
	        	if(rowIndex != -1) {
	        	    if(li != null) {
	        	        zl = li.getAuftragsListe().getRow(rowIndex);
	        	    }
	        	}
	        	return zl;
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	    		final LieferscheinZeile z = li.getAuftragsListe().getRow(rowIndex);
	    		if(z != null) {
		            switch(z.getTyp()) {
		            	case LieferscheinZeile.ZEILE_CONTAINER:
		            	    ret = getContent(z,columnIndex);
		            	    break;
		            	case LieferscheinZeile.ZEILE_LEER:
		            	    ret = null;
		            	    break;
		            	case LieferscheinZeile.ZEILE_KOPF:
		            	    ret=null;
		            		break;
		            	case LieferscheinZeile.ZEILE_SUMME:
		            	    ret = getSumme(z,columnIndex);
		            	    break;
		            }
	    		}
	            return ret;
	        }

	        private Object getContent(LieferscheinZeile z,int aColumn) {
	            Object ret = null;
	            switch(aColumn) {
	            	case C_BEZEICHNUNG :
	            	    ret= z.getBezeichnung();
	            	    break;
	            	case C_NUMMER :
	            	    ret = z.getContainerS();
	            	    break;
	            	case C_LOSNUMMER :
	            	    ret = z.getLosnummer();
	            	    break;
	            	case C_COMMENT :
	            	    ret = z.getComment();
	            	    break;
	            	case C_STAERKE :
	            	    ret = rz.getLocale().formatNumber(z.getStaerke(),OptionFactory.NF_STAERKE);
	            	    break;
	            	case C_BRUTTO :
	            	    ret = rz.getLocale().formatNumber(z.getBrutto(),OptionFactory.NF_LIEFERSCHEIN);
	            	    break;
	            	case C_TARA:
	            	    ret = rz.getLocale().formatNumber(z.getTara(),OptionFactory.NF_LIEFERSCHEIN);
	            	    break;
	            	case C_NETTO :
	            	    ret = rz.getLocale().formatNumber(z.getNetto(),OptionFactory.NF_LIEFERSCHEIN);
	            	    break;
	            	case C_LITER :
	            	    ret = rz.getLocale().formatNumber(z.getLiter(),OptionFactory.NF_LIEFERSCHEIN);
	            	    break;
	            	case C_LA :
	            	    ret = rz.getLocale().formatNumber(z.getLa(),OptionFactory.NF_LIEFERSCHEIN);
	            	    break;
	            	case C_EAN :
	            	    ret = z.getEan();
	            	    break;
	            }
	            return ret;
	        }
	        private Object getSumme(LieferscheinZeile z,int aColumn) {
	            Object ret = null;
	            switch(aColumn) {
            	case C_BEZEICHNUNG :
            	    ret= "Summe";
            	    break;
            	case C_NUMMER :
            	    ret = " ";
            	    break;
            	case C_BRUTTO :
            	    ret = rz.getLocale().formatNumber(z.getBrutto(),OptionFactory.NF_LIEFERSCHEIN);
            	    break;
            	case C_TARA:
            	    ret = rz.getLocale().formatNumber(z.getTara(),OptionFactory.NF_LIEFERSCHEIN);
            	    break;
            	case C_NETTO :
            	    ret = rz.getLocale().formatNumber(z.getNetto(),OptionFactory.NF_LIEFERSCHEIN);
            	    break;
            	case C_LITER :
            	    ret = rz.getLocale().formatNumber(z.getLiter(),OptionFactory.NF_LIEFERSCHEIN);
            	    break;
            	case C_LA :
            	    ret = rz.getLocale().formatNumber(z.getLa(),OptionFactory.NF_LIEFERSCHEIN);
            	    break;
	            }
	            return ret;
	        }
		}

	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	        if(li != null) {
	    		LieferscheinZeile z=null;
		    	if(row != -1) {
		    	    z= li.getAuftragsListe().getRow(row);
		    		if(isSelected) {
		    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
		    		}else {
		    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
		    		}
		    	}

		        if(value != null) {
		           if(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_NORMAL) != 0 ) {
			    		if((z != null) && (z.getTyp() == LieferscheinZeile.ZEILE_SUMME)) {
				    		   setText("<html><b>" + value.toString() + "</b></html>");
				    		} else {
				    		    setText(value.toString());
				    		}
			         } else {
					setText("");
				}
		           } else {
					setText("");
				}
		        setHorizontalAlignment(SwingConstants.TRAILING);
	        }
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	        if(li != null) {
		        LieferscheinZeile z = null;
		    	if(row != -1) {
		    	    z = li.getAuftragsListe().getRow(row);
		    		if(isSelected) {
		    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
		    		}else {
		    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
		    		}
		    	}

		        if(value != null) {
		    		if((z != null) && (z.getTyp() == LieferscheinZeile.ZEILE_SUMME)) {
			    		   setText("<html><b>" + value.toString() + "</b></html>");
			    		} else {
			    		    setText(value.toString());
			    		}
		         } else {
					setText("");
				}
		        setHorizontalAlignment(SwingConstants.LEADING);
	        }
	        return this;
        }
	}

}
