/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.lagerfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.message.MessageItem;


/**
 *
 * @author  administrator
 */
public class LagerEingabe extends JRzFrame{

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel labelPanel;
        		private JLabel lblName;
        		private JSelectedTextField txtName;
        		private JLabel lblListe;
        		private JIntegerField txtListe;
        		private JLabel lblErsatztext;
        		private JSelectedTextField txtErsatztext;
				private JLabel lblHg;
				private JButton btHg;
				private JLabel lblVg;
				private JButton btVg;
            private JPanel commentPanel;
            	private JLabel lblComment;
            	private JScrollPane scrComment;
            		private JTextArea txtComment;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "lagereingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "lagereingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";

    LagerItem    	li;
    JRzFrame		origin;
    /** Creates new form AdressAuswahl */

    public LagerEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }



    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
				labelPanel = new JPanel(new GridLayout(6,2));
		        	lblName = new JLabel();
		        		lblName.setHorizontalAlignment(SwingConstants.TRAILING);
		        		labelPanel.add(lblName);
		            txtName = new JSelectedTextField();
		            	labelPanel.add(txtName,BorderLayout.NORTH);
		        	lblListe = new JLabel();
		        		lblListe.setHorizontalAlignment(SwingConstants.TRAILING);
		        		labelPanel.add(lblListe);
	        		txtListe =  new JIntegerField(0,0,Integer.MAX_VALUE);
	        			labelPanel.add(txtListe);
	        		lblErsatztext=new JLabel();
	        			lblErsatztext.setHorizontalAlignment(SwingConstants.TRAILING);
	        		    labelPanel.add(lblErsatztext);
	        		txtErsatztext = new JSelectedTextField();
	        		labelPanel.add(txtErsatztext);

	        		lblHg=new JLabel();
					lblHg.setHorizontalAlignment(SwingConstants.TRAILING);
					labelPanel.add(lblHg);
					btHg = new JButton();
	 				btHg.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		setColor(btHg,"lagereingabe.label_hg");
	    	        	}
	        	    });
					labelPanel.add(btHg);
					lblVg=new JLabel();
						lblVg.setHorizontalAlignment(SwingConstants.TRAILING);
					labelPanel.add(lblVg);
					btVg=new JButton();
	 				btVg.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		setColor(btVg,"lagereingabe.label_vg");
	    	        	}
	        	    });
					labelPanel.add(btVg);


	        		contentPanel.add(labelPanel,BorderLayout.NORTH);
	        		commentPanel = new JPanel(new BorderLayout());
		        		lblComment = new JLabel();
	        				lblComment.setHorizontalAlignment(SwingConstants.CENTER);
	        			commentPanel.add(lblComment,BorderLayout.NORTH);
	        			scrComment = new JScrollPane();
	        				txtComment = new JTextArea();
	        				txtComment.setMinimumSize(new Dimension(100,100));
	        				scrComment.setViewportView(txtComment);
	        			commentPanel.add(scrComment,BorderLayout.CENTER);
	        		contentPanel.add(commentPanel,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel)
    		    	;
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);

    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("lagereingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

        lblName.setText(rz.getLocale().getString("lagereingabe.label_name"));
        lblListe.setText(rz.getLocale().getString("lagereingabe.label_liste"));
        lblComment.setText(rz.getLocale().getString("lagereingabe.label_comment"));
        lblErsatztext.setText(rz.getLocale().getString("lagereingabe.label_ersatztext"));
        lblHg.setText(rz.getLocale().getString("lagereingabe.label_hg"));
        lblVg.setText(rz.getLocale().getString("lagereingabe.label_vg"));

         setResizable(true);
         rz.getFontFactory().setFrameFonts(this);
         pack();
         rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;

    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_EDIT_LAGER:
 			origin = msg.getOrigin();
            li = rz.getDatabase().getLager().dbGetLager(msg.getCode(),false);
            if(li != null) {
            	fromItem();
            }
	      	break;

        default:
            rz.getLogFactory().logMessage(2, "kalkulation:_eingabe", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));

    }


	/**
	 * Farben festlegen
	 * @param bt Button, der gedrückt wurde
	 * @param key   Optionskey
	 */
	private void setColor(JButton bt,String key) {
		final Color c = JColorChooser.showDialog(this,rz.getLocale().getString(key),bt.getBackground());
		if(c != null) {
			bt.setBackground(c);
		}
	}
    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
        int insertID;
        toItem();
        if(!li.getName().equals("")) {
            insertID = rz.getDatabase().getLager().dbSaveLager(li);
            closeWindow();
            origin.getMessage(new MessageItem(MessageItem.MSG_EDIT_LAGER_REPLY,insertID,null,this));
        } else {
            final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("lagereingabe.titel"));
            dlgItem.setTitel(rz.getLocale().getString("lagereingabe.titel"));
            dlgItem.setMessage(rz.getLocale().getString("lagereingabe.error_kein_name"));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            dlgItem.setOrigin(this);
            rz.getDialogFactory().getDialog(dlgItem);
        }

    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    private void fromItem(){
        txtName.setText(li.getName());
        txtListe.setValue(li.getListe());
        txtComment.setText(li.getComment());
        txtErsatztext.setText(li.getErsatztext());
		btHg.setBackground(rz.getOptionFactory().getRGBColorString(li.getHg()));
   		btVg.setBackground(rz.getOptionFactory().getRGBColorString(li.getVg()));
    }

    private void toItem(){
        li.setName(txtName.getText().trim());
        try{
            li.setListe(txtListe.getValue());
        }
        catch (final Exception e){
            li.setListe(0);
        }
        li.setComment(txtComment.getText().trim());
        li.setErsatztext(txtErsatztext.getText().trim());
		li.setHg(rz.getOptionFactory().getHexColor(btHg.getBackground()));
		li.setVg(rz.getOptionFactory().getHexColor(btVg.getBackground()));
    }

    @Override
	public void closeWindow(){
        //this.setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(li != null) {
	        if (!isVisible()) {
				setVisible(true);
			}
	        toFront();
	        txtName.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"lager_eingabe.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }


}
