/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.fenster.lagerfenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.lager.LagerBestandsListe;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class Lager extends JRzFrame  implements TableColumnModelListener{

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel leftPanel;
    			private JLabel lblListenTitel;
    			private JScrollPane scrListe;
    				private JList lstLager;
    			private JPanel leftButtonPanel;
    				private JButton btNeu;
    				private JButton btBearbeiten;
    				private JButton btRefresh;
    				private JButton btLoeschen;
    		private JPanel rightPanel;
    			private JPanel textPanel;
    				private JScrollPane scrAnzeige;
    					private JEditorPane txtAnzeige;
                private JPanel tabellenPanel;
    			    private JScrollPane scrText;
    				    private JTable tblLager;
    				private JPanel auswahlPanel;
                        private JLabel lblAuswahl;
                        private JComboBox cmbAuswahl;
    			private JPanel rightButtonPanel;
    				private JPanel anzeigePanel;
    					private JLabel lblMenge;
        				private JLabel lblPreis;
    				private JPanel druckPanel;
    					private JComboBox cmbLagerDruck;
    					private JCheckBox chkDuplex;
    					private JButton btLagerDruck;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;

    // ActionCodes Lagerfenster
    public static final int         ACTION_NEU_CODE = 1000;
    public static final String      ACTION_NEU_TEXT = "lager.action_neu";
    public static final int         ACTION_BEARBEITEN_CODE = 1001;
    public static final String      ACTION_BEARBEITEN_TEXT = "lager.action_bearbeiten";
    public static final int         ACTION_LOESCHEN_CODE = 1002;
    public static final String      ACTION_LOESCHEN_TEXT = "lager.action_loeschen";
    public static final int         ACTION_CLOSE_CODE  = 1003;
    public static final String      ACTION_CLOSE_TEXT = "lager.action_close";
    public static final int         ACTION_HILFE_CODE  = 1038;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE  = 1039;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_REFRESH_CODE = 1006;
    public static final String      ACTION_REFRESH_TEXT = "action_refresh";
    public static final int         ACTION_LISTENDRUCK_CODE = 1007;
    public static final String      ACTION_LISTENDRUCK_TEXT = "lager.action_listendruck";

    public static final int		MAX_COLUMN = 8;
    public static final int		C_BEZEICHNUNG = 0;
    public static final int		C_ARTIKELNUMMER=1;
    public static final int		C_LITER = 2;
    public static final int		C_KG = 3;
    public static final int		C_LA = 4;
    public static final int		C_ORT = 5;
    public static final int		C_GRUNDPREIS=6;
    public static final int		C_PREIS=7;
    int currentLager;

    public static final int     DEFAULT_AUSWAHL=0;

    LagerBestandsListe				lb;

    /** Creates new form LagerFenster */
    public Lager(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten = new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel  = new JPanel(new BorderLayout());
					leftPanel = new JPanel(new BorderLayout());
						lblListenTitel = new JLabel();
							lblListenTitel.setHorizontalAlignment(SwingConstants.CENTER);
						leftPanel.add(lblListenTitel,BorderLayout.NORTH);
						scrListe = new JScrollPane();
							lstLager = new JList();
							lstLager.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
					        lstLager.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					                lagerSelected();
					            }
					        });
							scrListe.setViewportView(lstLager);
						leftPanel.add(scrListe,BorderLayout.CENTER);
						leftButtonPanel = new JPanel(new GridLayout(2,2));
							btNeu = new JButton();
								leftButtonPanel.add(btNeu);
						    btBearbeiten = new JButton();
						    	leftButtonPanel.add(btBearbeiten);
						    btRefresh = new JButton();
						    	leftButtonPanel.add(btRefresh);
						    btLoeschen = new JButton();
						    	leftButtonPanel.add(btLoeschen);
						leftPanel.add(leftButtonPanel,BorderLayout.SOUTH);
				contentPanel.add(leftPanel,BorderLayout.WEST);
					rightPanel = new JPanel(new BorderLayout());
						textPanel = new JPanel(new BorderLayout());
							scrAnzeige = new JScrollPane();
								txtAnzeige = new JEditorPane();
									txtAnzeige.setEditable(false);
									txtAnzeige.setContentType("text/html");
								scrAnzeige.setViewportView(txtAnzeige);
							textPanel.add(scrAnzeige,BorderLayout.CENTER);
						rightPanel.add(textPanel,BorderLayout.NORTH);
                        tabellenPanel= new JPanel(new BorderLayout());
    						scrText = new JScrollPane();
    							tblLager = new JTable();
    							tblLager.setName("lagerfenster.spalten");
    								scrText.setViewportView(tblLager);
							tabellenPanel.add(scrText,BorderLayout.CENTER);
                        auswahlPanel=new JPanel(new BorderLayout());
                            lblAuswahl=new JLabel();
                                lblAuswahl.setHorizontalAlignment(SwingConstants.CENTER);
                            auswahlPanel.add(lblAuswahl,BorderLayout.WEST);
                            cmbAuswahl = new JComboBox();
                                cmbAuswahl.addItem(rz.getLocale().getString("lager.auswahl_alle"));
                                cmbAuswahl.addItem(rz.getLocale().getString("lager.auswahl_bestand"));
                                cmbAuswahl.addItem(rz.getLocale().getString("lager.auswahl_bestellliste"));
                                cmbAuswahl.addActionListener(new ActionListener() {
                                    public void actionPerformed(ActionEvent evt) {
                                        if(cmbAuswahl.getSelectedIndex() != -1) {
                                            rz.getOptionFactory().setOption("lager.auswahl",cmbAuswahl.getSelectedIndex());
                                            setAuswahl();
                                       }
                                    }
                                });
                                auswahlPanel.add(cmbAuswahl,BorderLayout.CENTER);
                       tabellenPanel.add(auswahlPanel,BorderLayout.SOUTH);
                    rightPanel.add(tabellenPanel,BorderLayout.CENTER);
					rightButtonPanel=new JPanel(new BorderLayout());
						anzeigePanel = new JPanel(new BorderLayout());
							lblMenge = new JLabel();
							anzeigePanel.add(lblMenge,BorderLayout.NORTH);
							lblPreis= new JLabel();
							anzeigePanel.add(lblPreis,BorderLayout.SOUTH);
						rightButtonPanel.add(anzeigePanel,BorderLayout.NORTH);
						druckPanel = new JPanel(new GridLayout(1,3));
							cmbLagerDruck = new JComboBox();
							druckPanel.add(cmbLagerDruck,BorderLayout.WEST);
		    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbLagerDruck,ReportFactory.REPORT_TYPE_LAGERBESTAND);
		    				cmbLagerDruck.addActionListener(new ActionListener() {
								public void actionPerformed(ActionEvent evt) {
		        	        		if(cmbLagerDruck.getSelectedIndex() != -1) {
		        	        			rz.getOptionFactory().setOption("report.lagerbestand",((ReportItem)cmbLagerDruck.getSelectedItem()).getID());
		        	        		}
		        	        	}
			                });
		    				chkDuplex= new JCheckBox();
							chkDuplex.setSelected((rz.getOptionFactory().getOption("lager.duplex",0) == 1?true:false));
							chkDuplex.addActionListener(new ActionListener() {
					        	public void actionPerformed(ActionEvent evt) {
					        		rz.getOptionFactory().setOption("lager.duplex", chkDuplex.isSelected()?1:0);
					        		rz.getOptionFactory().saveOptions();
					        	}
				    	    });
							druckPanel.add(chkDuplex);
							this.btLagerDruck = new JButton();
							druckPanel.add(this.btLagerDruck,BorderLayout.CENTER);
						rightButtonPanel.add(druckPanel,BorderLayout.CENTER);
					rightPanel.add(rightButtonPanel,BorderLayout.SOUTH);
				contentPanel.add(rightPanel,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
				buttonPanel = new JPanel(new BorderLayout());
					btClose = new JButton();
						buttonPanel.add(btClose,BorderLayout.WEST);
					btHilfe = new JButton();
						buttonPanel.add(btHilfe,BorderLayout.EAST);


			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }

    @Override
	public void setGUIComponents() {
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

        mnuDatei.add(getAction(ACTION_LISTENDRUCK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));

        mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
        mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_LOESCHEN_CODE));

        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuExtras.add(getAction(ACTION_REFRESH_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("lagerfenster.titel"));
        lblListenTitel.setText(rz.getLocale().getString("lagerfenster.listentitel"));

        btNeu.setAction(getAction(ACTION_NEU_CODE));
        btBearbeiten.setAction(getAction(ACTION_BEARBEITEN_CODE));
        btLoeschen.setAction(getAction(ACTION_LOESCHEN_CODE));
        btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
        btHilfe .setAction(getAction(ACTION_HILFE_CODE));
        btClose.setAction(getAction(ACTION_CLOSE_CODE));
        btLagerDruck.setAction(getAction(ACTION_LISTENDRUCK_CODE));

        lblAuswahl.setText(rz.getLocale().getString("lager.label_auswahl"));
        chkDuplex.setText(rz.getLocale().getString("lager.duplex"));

        tb1.add(getAction(ACTION_CLOSE_CODE));
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.add(getAction(ACTION_REFRESH_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_NEU_CODE));
        tb1.add(getAction(ACTION_BEARBEITEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_LOESCHEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_LISTENDRUCK_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HILFE_CODE));

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;

    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_CLOSE_CODE:closeWindow();break;
		          case ACTION_REFRESH_CODE:refreshAction();break;
		          case ACTION_NEU_CODE:neuAction();break;
		          case ACTION_BEARBEITEN_CODE:bearbeitenAction();break;
		          case ACTION_LOESCHEN_CODE:loeschenAction();break;
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_LISTENDRUCK_CODE:druckAction();break;
            default :
                break;
           }
    		break;
    	 case MessageItem.MSG_EDIT_LAGER_REPLY:
         case MessageItem.MSG_SHOW_LAGER :
         		this.settblLagerModel(tblLager);
             	currentLager = msg.getCode();
         		if(currentLager < 1) {
					currentLager=1;
				}
                cmbAuswahl.setSelectedIndex(rz.getOptionFactory().getOption("lager.auswahl",DEFAULT_AUSWAHL));
         		refreshList();
	      		openWindow();
	      		break;

        default:
            rz.getLogFactory().logMessage(2, "lagerfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }


    private void lagerSelected(){
        if(lstLager.getSelectedIndex() != -1){
            final int id = ((LagerItem)lstLager.getSelectedValue()).getID();
            rz.getAusgabeFactory().lagerAusgabe(id,txtAnzeige);
            if (id == 1){
                btLoeschen.setEnabled(false);
                btBearbeiten.setEnabled(false);
            }
            else {
                btLoeschen.setEnabled(true);
                btBearbeiten.setEnabled(true);
            }
            lb = rz.getDatabase().getLager().getBestandsListe(id,cmbAuswahl.getSelectedIndex());
            ((AbstractTableModel)tblLager.getModel()).fireTableDataChanged();
            lblMenge.setText(rz.getLocale().getString("lager.label_menge")
                    .replaceAll("%liter",rz.getLocale().formatNumber(lb.getSumme_liter(), OptionFactory.NF_NORMAL))
                    .replaceAll("%kg",rz.getLocale().formatNumber(lb.getSumme_kg(), OptionFactory.NF_NORMAL))
                    .replaceAll("%la",rz.getLocale().formatNumber(lb.getSumme_la(), OptionFactory.NF_NORMAL))
            );
            lblPreis.setText(rz.getLocale().getString("lager.label_preis")
                    .replaceAll("%s",rz.getLocale().formatNumber(lb.getSumme_kalkulation(), OptionFactory.NF_NORMAL))
                    .replaceAll("%w",rz.getDatabase().getCurrency().dbGetCurrency( rz.getOptionFactory().getOption("kalkulation.currency",1),true).getShortName())
            );
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT,KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT,KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_LOESCHEN_CODE,ACTION_LOESCHEN_TEXT,KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT,KeyEvent.VK_F5,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT,KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_LISTENDRUCK_CODE),new AuswahlAction(rz,this,ACTION_LISTENDRUCK_CODE,ACTION_LISTENDRUCK_TEXT,KeyEvent.VK_D,InputEvent.CTRL_DOWN_MASK));
    }

    private void setAuswahl() {
        lagerSelected();
    }

    private void refreshList(){
        lstLager.setListData(rz.getDatabase().getLager().dbGetLagerListe().toArray());
        if(lstLager.getModel().getSize() > 0){
            for(int i = 0;i < lstLager.getModel().getSize();i++) {
                if(currentLager == ((LagerItem)lstLager.getModel().getElementAt(i)).getID()) {
                    lstLager.setSelectedIndex(i);
                    continue;
                }
            }
        }
    }

    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();

    }

    @Override
	public void closeWindow(){
        //this.setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    // datei-menü
    // bearbeiten-menü
    private void neuAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LAGER_EINGABE,true,new MessageItem(MessageItem.MSG_EDIT_LAGER,0,null,this));
    }
    private void bearbeitenAction(){
        if (lstLager.getSelectedIndex() != -1){
            final int id = ((LagerItem)lstLager.getSelectedValue()).getID();
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LAGER_EINGABE,true,new MessageItem(MessageItem.MSG_EDIT_LAGER,id,null,this));
        }
    }
    private void loeschenAction(){
        if (lstLager.getSelectedIndex() != -1){
            final LagerItem ci = rz.getDatabase().getLager().dbGetLager(((LagerItem)lstLager.getSelectedValue()).getID(),false);
            if(ci != null){
                rz.getDatabase().getLager().dbDeleteLager(ci.getID());
                refreshAction();
            }
        }
    }

    private void druckAction() {
    	if(lb != null) {
    		rz.getReportFactory().LagerBestandsReport(lb,this,chkDuplex.isSelected());
    	}
    }

    //Extras-Men�
    private void refreshAction(){
        currentLager = 1;
        refreshList();
        lstLager.requestFocus();
    }
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"lager.html",this));
    }

    private void settblLagerModel(JTable t) {
	    final LagerColumnModel rcm = new LagerColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc;
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("lager.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
    	tc.setHeaderValue(rz.getLocale().getString("lager.tableheader_artikelnummer"));
	    	tc.setModelIndex(C_ARTIKELNUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lager.tableheader_liter"));
			tc.setModelIndex(C_LITER);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lager.tableheader_kg"));
			tc.setModelIndex(C_KG);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lager.tableheader_la"));
			tc.setModelIndex(C_LA);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lager.tableheader_ort"));
			tc.setModelIndex(C_ORT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("lager.tableheader_grundpreis"));
			tc.setModelIndex(C_GRUNDPREIS);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lager.tableheader_preis"));
			tc.setModelIndex(C_PREIS);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblLager.setModel(new LagerTableModel());
        tblLager.setColumnModel(rcm);
        tblLager.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblLager.getTableHeader().setReorderingAllowed(false);
	}

	private class LagerColumnModel extends DefaultTableColumnModel{
	    public LagerColumnModel() {
	        super();
	    }

	}

	private  class LagerTableModel extends AbstractTableModel    {

	        public LagerTableModel() {

	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }

	        public int getRowCount() {
	        	if(lb != null) {
	        		return lb.size();
	        	} else {
	        		return 0;
	        	}
	        }


	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
                if((lb != null) && (rowIndex != -1)) {
	            	switch (columnIndex) {
	            		case C_BEZEICHNUNG : ret = lb.getItem(rowIndex).getBezeichnung();break;
	            		case C_ARTIKELNUMMER : ret = lb.getItem(rowIndex).getArtikelnummer();break;
	            		case C_LITER : ret = rz.getLocale().formatNumber(lb.getItem(rowIndex).getLiter(),OptionFactory.NF_NORMAL);break;
	            		case C_KG : ret = rz.getLocale().formatNumber(lb.getItem(rowIndex).getKg(),OptionFactory.NF_NORMAL);break;
	            		case C_LA : ret = rz.getLocale().formatNumber(lb.getItem(rowIndex).getLa(),OptionFactory.NF_NORMAL);break;
	            		case C_GRUNDPREIS: ret = lb.getItem(rowIndex).getGrundpreis();break;
	            		case C_PREIS: ret = lb.getItem(rowIndex).getPreis();break;
	            		case C_ORT: ret = lb.getItem(rowIndex).getTank();break;
	            	}
                }
	            return ret;
	        }

		}


	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	        if ((row != -1) && (lb != null)) {
	            if (lb.getItem(row).isBestandWarnung()) {
	                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GELB));
	            } else {
	                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_WHITE));
	            }
	        }
	        if(value != null) {
	           if(!rz.isZero(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_NORMAL))) {
	               setText(value.toString());
	           } else {
				setText("");
			}
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	        if ((row != -1) && (lb != null)) {
	            if (lb.getItem(row).isBestandWarnung()) {
	                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GELB));
	            } else {
	                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_WHITE));
	            }
	        }
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}


	public void columnAdded(TableColumnModelEvent e) {

	}
	public void columnMarginChanged(ChangeEvent e) {

	}
	public void columnMoved(TableColumnModelEvent e) {
	}
	public void columnRemoved(TableColumnModelEvent e) {
	}
	public void columnSelectionChanged(ListSelectionEvent e) {
	}
}
