/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.laborwertfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertItem;
import de.lunqual.rzpro.items.message.MessageItem;


/**
 *
 * @author  administrator
 */
public class LaborwertlisteEingabe extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel namePanel;
    			private JLabel lblBezeichnung;
    			private JSelectedTextField txtBezeichnung;
    		private JPanel bemerkungenPanel;
    			private JLabel lblBemerkungen;
    			private JTextArea	txtBemerkungen;
        	private JPanel messwertPanel;
        		private JPanel einheitenPanel;
	    			private JLabel lblMesswert;
	    			private JComboBox cmbEinheit1;
	    			private JLabel lblCmb;
	    			private JComboBox cmbEinheit2;
	    		private JPanel fixPanel;
	    			private JCheckBox chkFix;

		private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "laborwertliste_eingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "laborwertliste_eingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";

    LaborwertItem ai;
    JRzFrame			origin;

    /** Creates new form AdressAuswahl */

    public LaborwertlisteEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
    			namePanel=new JPanel(new BorderLayout());
    				lblBezeichnung = new JLabel();
    					lblBezeichnung.setHorizontalAlignment(SwingConstants.CENTER);
    				namePanel.add(lblBezeichnung,BorderLayout.WEST);
    				txtBezeichnung = new JSelectedTextField();
    				namePanel.add(txtBezeichnung,BorderLayout.CENTER);
    			contentPanel.add(namePanel,BorderLayout.NORTH);
    			bemerkungenPanel=new JPanel(new BorderLayout());
					lblBemerkungen = new JLabel();
						lblBemerkungen.setHorizontalAlignment(SwingConstants.CENTER);
					bemerkungenPanel.add(lblBemerkungen,BorderLayout.WEST);
	 					txtBemerkungen = new JTextArea();
	 				bemerkungenPanel.add(txtBemerkungen,BorderLayout.CENTER);
    			contentPanel.add(bemerkungenPanel,BorderLayout.CENTER);
    				messwertPanel=new JPanel(new GridLayout(1,4));
    					einheitenPanel = new JPanel(new BorderLayout());
							lblMesswert = new JLabel();
								lblMesswert.setHorizontalAlignment(SwingConstants.RIGHT);
							messwertPanel.add(lblMesswert);
							cmbEinheit1=new JComboBox();
								rz.getDatabase().getEinheiten().setEinheitenCmb(cmbEinheit1,11);
							messwertPanel.add(cmbEinheit1);
							lblCmb = new JLabel();
								lblCmb.setHorizontalAlignment(SwingConstants.CENTER);
							messwertPanel.add(lblCmb);
						cmbEinheit2=new JComboBox();
							rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbEinheit2,RzPro.EINHEIT_LA);
						messwertPanel.add(cmbEinheit2);
						messwertPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
					einheitenPanel.add(messwertPanel,BorderLayout.NORTH);
					fixPanel=new JPanel(new BorderLayout());
						chkFix=new JCheckBox();
						fixPanel.add(chkFix,BorderLayout.WEST);
					einheitenPanel.add(fixPanel,BorderLayout.SOUTH);
	    			contentPanel.add(einheitenPanel,BorderLayout.SOUTH);

			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("laborwertliste_eingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

        lblBezeichnung.setText(rz.getLocale().getString("laborwertliste_eingabe.label_bezeichnung"));
        lblBemerkungen.setText(rz.getLocale().getString("laborwertliste_eingabe.label_bemerkungen"));
        lblMesswert.setText(rz.getLocale().getString("laborwertliste_eingabe.label_messwert"));
        lblCmb.setText(rz.getLocale().getString("laborwertliste_eingabe.label_cmb"));
        chkFix.setText(rz.getLocale().getString("laborwertliste_eingabe.label_fix"));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_SHOW_LABORWERTLISTE_EINGABE:
 			 origin = msg.getOrigin();
        	 ai = rz.getDatabase().getLaborwerte().getWert(msg.getCode());
        	 if(ai != null) {
        		 fromItem();
        	 }
	      	 break;

        default:
            rz.getLogFactory().logMessage(2, "laborwertlisten_eingabe", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));

    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
        toItem();
        if(!ai.getBezeichnung().trim().equals("")) {
        	final int insertID = rz.getDatabase().getLaborwerte().saveWert(ai);
        	if(ai.getId()== 0) {
        		ai.setId(insertID);
        	}
    		origin.getMessage(new MessageItem(MessageItem.MSG_LABORWERTLISTE_EINGABE_REPLY,0,ai,this ));
        	closeWindow();
        } else {
			  final DialogItem di  = new DialogItem(
	                  DialogControl.HINWEIS_DIALOG,
	                  "",0.0,
	                  rz.getLocale().getString("laborwertliste_eingabe.dialog_titel"),
	                  rz.getLocale().getString("laborwertliste_eingabe.dialog_titel"),
	                  rz.getLocale().getString("laborwertliste_eingabe.dialog_no_titel"),
	                  "warnung.png",
	                  rz.getLocale().getString("string_ok"),
	                  "",
	                  this
	          );
	          rz.getDialogFactory().getDialog(di);
        }
     }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    /**
     * Daten vom Item in die GUI übertragen
     *
     */
    private void fromItem(){
    	txtBezeichnung.setText(ai.getBezeichnung());
    	txtBemerkungen.setText(ai.getBemerkungen());
    	rz.getDatabase().getEinheiten().setEinheitenCmb(cmbEinheit1, ai.getEinheit1());
    	rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbEinheit2, ai.getEinheit2());
    	chkFix.setSelected(ai.isFix());
    }

    /**
     * GUI-Daten in das Item übertragen
     *
     */
    private void toItem(){
    	ai.setBezeichnung(txtBezeichnung.getText().trim());
    	ai.setBemerkungen(txtBemerkungen.getText().trim());
    	ai.setEinheit1(((EinheitsItem)cmbEinheit1.getSelectedItem()).getID());
    	ai.setEinheit2(((EinheitsItem)cmbEinheit2.getSelectedItem()).getID());
    	ai.setFix(chkFix.isSelected());
    }

    @Override
	public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(ai != null) {
    		if (!isVisible()) {
				setVisible(true);
			}
    		toFront();
    		txtBezeichnung.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"laborwertliste.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}
