/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.laborwertfenster;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertListe;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.ChangesListe;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class LaborwertBerechnungsFenster extends JRzFrame implements TableColumnModelListener{

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JSplitPane splHorizontal;
	    		private JPanel leftPanel;
	    			private JScrollPane scrWerte;
	    				private JList lstWerte;
	    		private JSplitPane splAusgabe;
	    			private JPanel rightPanel;
	    				private JLabel lblTitel;
	    				private JPanel tablePanel;
		    				private JScrollPane scrTable;
		    					private JTable tblWerte;
		    		private  JPanel ausgabePanel;
		    			private JScrollPane scrAusgabe;
		    				private JEditorPane txtAusgabe;

		private JPanel buttonPanel;
			private JButton btCancel;
			private JButton btSave;
			private JComboBox cmbFormulare;
			private JButton btDrucken;
    		private JButton btHilfe;

    public static final int				MAX_COLUMN =5;
    public static final int				C_REZEPTUR_BEZEICHNUNG = 0;
    public static final int				C_VALUE =1;
    public static final int				C_EINHEIT = 2;
    public static final int				C_REZEPTURMENGE=3;
    public static final int				C_REZEPTUREINHEIT=4;
    public static final int				C_MENGE	= 5;
    public static final int				C_MENGENEINHEIT = 6;


    // ActionCodes KalkulationEingabe
    public static final int         ACTION_CLOSE_CODE = 1001;
    public static final String      ACTION_CLOSE_TEXT = "laborwertberechnung.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_DRUCKEN_CODE = 1006;
    public static final String      ACTION_DRUCKEN_TEXT = "laborwertberechnung.action_drucken";
    public static final int         ACTION_SAVE_CODE = 1007;
    public static final String      ACTION_SAVE_TEXT = "laborwertberechnung.action_save";
    
    JRzFrame			origin;
    RechenItem		ri;
    boolean 			startup=true;
    LaborwertListe	liste;
    LaborwertValueListe vliste;
    int currentLW	=-1;
    int currentEinheit2 = -1;
    
    javax.swing.Timer   	ergebnisTimer;

    /** Creates new form AdressAuswahl */

    public LaborwertBerechnungsFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
				splHorizontal = new JSplitPane();
				splHorizontal.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
				splHorizontal.setDividerSize(6);

				leftPanel  = new JPanel(new BorderLayout());
					scrWerte = new JScrollPane();
						lstWerte = new JList();
				        lstWerte.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
				            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				            	if(evt.getValueIsAdjusting()) {
									return;
								}
				                if(ergebnisTimer.isRunning()) {
									ergebnisTimer.restart();
								} else {
									ergebnisTimer.start();
								}
				            }
				        });
					scrWerte.setViewportView(lstWerte);
				leftPanel.add(scrWerte,BorderLayout.CENTER);
			splHorizontal.setLeftComponent(leftPanel);
				splAusgabe = new JSplitPane();
					splAusgabe.setOrientation(JSplitPane.VERTICAL_SPLIT);
					splAusgabe.setDividerSize(6);
					rightPanel =  new JPanel(new BorderLayout());
						lblTitel = new JLabel();
							lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
							lblTitel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
						rightPanel.add(lblTitel,BorderLayout.NORTH);
						tablePanel = new JPanel(new BorderLayout());
							scrTable = new JScrollPane();
								tblWerte = new JTable();
								tblWerte.setName("laborwertberechnung.spalten");
					 	        tblWerte.addMouseListener(new MouseAdapter() {
					 	            @Override
									public void mousePressed(MouseEvent e) {
					 	            	modifyTable();
					 	            }
						 	       @Override
								public void mouseReleased(MouseEvent e) {
						 	          // maybeShowPopup(e);
						 	       }
					 	        });
								scrTable.setViewportView(tblWerte);
							tablePanel.add(scrTable,BorderLayout.CENTER);
					rightPanel.add(tablePanel,BorderLayout.CENTER);
				splAusgabe.setTopComponent(rightPanel);

					ausgabePanel=new JPanel(new BorderLayout());
						scrAusgabe = new JScrollPane();
							txtAusgabe = new JEditorPane();
							txtAusgabe.setContentType("text/html");
							scrAusgabe.setViewportView(txtAusgabe);
						ausgabePanel.add(scrAusgabe,BorderLayout.CENTER);
				splAusgabe.setBottomComponent(ausgabePanel);

				splHorizontal.setRightComponent(splAusgabe);
			contentPanel.add(splHorizontal,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,5));
		    	btCancel = new JButton();
		    		buttonPanel.add(btCancel);
		    	btSave=new JButton();
		    		buttonPanel.add(btSave);
		   		cmbFormulare = new JComboBox();
			    	rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_LABORWERT);
		    	    cmbFormulare.addActionListener(new ActionListener() {
			        	public void actionPerformed(ActionEvent evt) {
			        		if(cmbFormulare.getSelectedIndex() != -1) {
			        			rz.getOptionFactory().setOption("report.laborwerte",((ReportItem)cmbFormulare.getSelectedItem()).getID());
			        		}
			        	}
		            });
				buttonPanel.add(cmbFormulare);
					btDrucken=new JButton();	
		    			buttonPanel.add(btDrucken);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }

    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("laborwertberechnung.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
  	  	mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
        mnuDatei.add(getAction(ACTION_SAVE_CODE));
  	  	mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_CLOSE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
        tb1.add(getAction(ACTION_SAVE_CODE));
  	  	tb1.add(getAction(ACTION_DRUCKEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_CLOSE_CODE));
        btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
        btSave.setAction(getAction(ACTION_SAVE_CODE));
        
       lblTitel.setText("");

        startup=false;
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
        setDividerLocations();
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_CLOSE_CODE :cancelAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_DRUCKEN_CODE:druckenAction();break;
            case ACTION_SAVE_CODE:saveAction();break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_SHOW_LABORWERTBERECHNUNG:
 			this.settblWerteModel(tblWerte);
   		    origin = msg.getOrigin();
        	 ri = (RechenItem)msg.getData();
             lblTitel.setText(rz.getLocale().getString("laborwertberechnung.label_titel")
         		   	.replaceAll("%m",rz.getLocale().formatNumber(ri.getGesamtLiter(),OptionFactory.NF_NORMAL))
         		   	.replaceAll("%s",ri.getRezeptur().getTitel()));

        	 refreshAction();
	      	 break;

        default:
            rz.getLogFactory().logMessage(2, "laborwertlisten_eingabe", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_CLOSE_CODE), new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this, ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_SAVE_CODE), new AuswahlAction(rz,this, ACTION_SAVE_CODE,ACTION_SAVE_TEXT,0, 0));
    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splLaborwerteberechnung", this.splAusgabe.getDividerLocation());
        rz.getFensterFactory().setOption(this.getName() + ".splLaborwerteberechnung-h", this.splHorizontal.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        this.splAusgabe.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splLaborwerteberechnung",this.getHeight()/2));
        this.splHorizontal.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splLaborwerteberechnung-h",this.getWidth()/5));
    }



	private void modifyTable() {
        final int col= tblWerte.getColumnModel().getColumn(tblWerte.getSelectedColumn()).getModelIndex();
        final int selectedColumn = tblWerte.getSelectedColumn();
        final int selectedRow = tblWerte.getSelectedRow();
        switch(col) {
        	case C_VALUE:
        		tblWerte.editCellAt(selectedRow,selectedColumn);
        		break;
        }
	}

	private void ergebnisTimerEvent() {
		if (ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
			rechnenAction();
		}
	}
	
	
	private void druckenAction() {
		if(vliste!=null && !vliste.isEmpty()) {
    		if(lstWerte.getSelectedValue() != null) {
    			rz.getReportFactory().laborwerteReport(vliste, this,(LaborwertItem)lstWerte.getSelectedValue(),ri);}
		}
	}
	
    /**
     * Liste neu einlesen
     */
    private void refreshAction() {
    	liste = rz.getDatabase().getLaborwerte().getListe();
    	lstWerte.setListData(liste.toArray());
    	try {
    		if(!liste.isEmpty()) {
    			lstWerte.setSelectedIndex(0);
    			lstWerte.requestFocus();
    		}
    	}catch(final Exception e) {}
    	rechnenAction();
    }
    /**
     * ausrechnen
     */
    private void rechnenAction() {
    	if(!startup) {
    		if(lstWerte.getSelectedValue() != null) {
    			currentLW=((LaborwertItem)lstWerte.getSelectedValue()).getId() ;
    			currentEinheit2=((LaborwertItem)lstWerte.getSelectedValue()).getEinheit2() ;
    			vliste=rz.getDatabase().getLaborwerte().getValueListe(((LaborwertItem)lstWerte.getSelectedValue()).getBezeichnung(), ((LaborwertItem)lstWerte.getSelectedValue()).getId()   , ri,((LaborwertItem)lstWerte.getSelectedValue()).getEinheit2(),((LaborwertItem)lstWerte.getSelectedValue()).getBezeichnung());
    			ausgabe();
    		}
    	}
    }

    private void ausgabe() {
    	try {
    		vliste.rechnen();
    		LaborwertItem li = (LaborwertItem)lstWerte.getSelectedValue();
    		if(li != null) {
    			if(li.isFix()) {
    				getAction(ACTION_SAVE_CODE).setEnabled(false);
    			}else {
    				getAction(ACTION_SAVE_CODE).setEnabled(true);
    			}
    		}
    		rz.getAusgabeFactory().laborwertBerechnungAusgabe(ri,vliste, (LaborwertItem)lstWerte.getSelectedValue(),txtAusgabe);
    		((AbstractTableModel)tblWerte.getModel()).fireTableDataChanged();
    	} catch (final Exception e) {}
    }

    private void saveAction() {
    	if(currentLW != 0) {
    		double value=0.0;
    		if(currentEinheit2 != -1) {
	    		switch(currentEinheit2) {
	    			case RzPro.EINHEIT_LITER:value =vliste.getValue_liter()/vliste.getSumme_liter() ;break;
	    			case RzPro.EINHEIT_KG:value = vliste.getValue_kg()/vliste.getSumme_kg();break;
	    			case RzPro.EINHEIT_LA:value = vliste.getValue_la()/vliste.getSumme_la();break;
	    		}
				rz.getDatabase().getLaborwerte().saveValue(currentLW, ri.getRezeptur().getID(), value);
				try {
					origin.getMessage(new MessageItem(MessageItem.MSG_REFRESH_LABORWERTE, 0, null,this));
				}catch(Exception e) {}
			}
		}
    }
    
    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }


    @Override
	public void closeWindow(){
    	saveDividerLocations();
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(ri != null) {
    		if(liste.size() != 0) {
	    		if (!isVisible()) {
					setVisible(true);
				}
	    		toFront();
    		}else {
    			 final DialogItem di  = new DialogItem(
	                        DialogControl.HINWEIS_DIALOG,
	                        "",0.0,
	                        rz.getLocale().getString("laborwertberechnung.keine_laborwerte_titel"),
	                        rz.getLocale().getString("laborwertberechnung.keine_laborwerte_titel"),
	                        rz.getLocale().getString("laborwertberechnung.keine_laborwerte_text"),
	                        "warnung.png",
	                        rz.getLocale().getString("string_ok"),
	                        "",
	                        this
	                );
	                rz.getDialogFactory().getDialog(di);
	                closeWindow();
    		}
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"laborwertberechnung.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    private void settblWerteModel(JTable t) {
    	final JComboBox cmbEditLager=new JComboBox();
    	rz.getDatabase().getLager().setLagerCmb(cmbEditLager,-1);
	    final werteColumnModel rcm = new werteColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("laborwertberechnung.tableheader_rezepturbezeichnung"));
	    	tc.setModelIndex(C_REZEPTUR_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("laborwertberechnung.tableheader_value"));
        	tc.setModelIndex(C_VALUE);
        	tc.setCellRenderer(nr);
        rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("laborwertberechnung.tableheader_einheit"));
	    	tc.setModelIndex(C_EINHEIT);
	    	tc.setCellRenderer(sr);
    	rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("laborwertberechnung.tableheader_rezepturmenge"));
	    	tc.setModelIndex(C_REZEPTURMENGE);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
			tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("laborwertberechnung.tableheader_rezeptureinheit"));
			tc.setModelIndex(C_REZEPTUREINHEIT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("laborwertberechnung.tableheader_menge"));
	    	tc.setModelIndex(C_MENGE);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("laborwertberechnung.tableheader_mengeneinheit"));
	    	tc.setModelIndex(C_MENGENEINHEIT);
	    	tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    	tc = new TableColumn();

        rcm.addColumnModelListener(this);
        tblWerte.setModel(new werteTableModel());
        tblWerte.setColumnModel(rcm);
        tblWerte.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblWerte.setCellSelectionEnabled(true);
        tblWerte.getTableHeader().setReorderingAllowed(false);
	}




    private class werteColumnModel extends DefaultTableColumnModel{
	    public werteColumnModel() {
	        super();
	    }
	}

	private  class werteTableModel extends AbstractTableModel    {

	        SimpleDateFormat df;

	        public werteTableModel() {
	            df = new SimpleDateFormat("dd.MM.yyyy");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(vliste != null) {
	                return vliste.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public LaborwertValueItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (vliste != null)) {
	        		return vliste.getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (vliste != null)) {
	                ret = getContent(vliste.getItem(rowIndex),columnIndex);
	            }
	            return ret;
	        }

	        @Override
			public boolean isCellEditable(int row, int col){
	        	boolean ret = false;
	        	switch(col) {
	        		case C_VALUE:ret= true;break;
	        	}
	        	return ret;
	        }


	        @Override
			public void setValueAt(Object value, int row, int col) {
	        	if (row != -1) {
	        		switch (col) {
	        			case C_VALUE:
		        				LaborwertValueItem  lvi = vliste.getItem(row);
	        					Double alt = lvi.getValue();
	        					Double neu = rz.getLocale().getNumber((String)value,OptionFactory.NF_LITERGEWICHT);
	        				    BigDecimal bAlt = new BigDecimal(Double.toString(alt));
	        				    BigDecimal bNeu = new BigDecimal(Double.toString(neu));
	        				    bAlt = bAlt.setScale(rz.getOptionFactory().getOption("laborwerte.decimal_digits",OptionFactory.LABORWERTE_DECIMAL_DIGITS), RoundingMode.HALF_UP);
	        				    bNeu = bNeu.setScale(rz.getOptionFactory().getOption("laborwerte.decimal_digits",OptionFactory.LABORWERTE_DECIMAL_DIGITS), RoundingMode.HALF_UP);
	        					if(bAlt.compareTo(bNeu) != 0) {
	        						ChangesListe ch=new ChangesListe(rz,lvi.getRezeptur());
	        	    				ch.add(rz.getLocale().getString("changes.laborwert"),lvi.getLbwBezeichnung() + ":  " + bAlt.toString() + " " + lvi.getStrEinheit1() + "/"+lvi.getStrEinheit2() , bNeu.toString()  + " " + lvi.getStrEinheit1() + "/"+lvi.getStrEinheit2(),true);
	        	    				ch.commit();
	        					}
	        					vliste.getItem(row).setValue(rz.getLocale().getNumber((String)value,OptionFactory.NF_NORMAL));
	        					rz.getDatabase().getLaborwerte().saveValue(vliste.getItem(row));
	        					rechnenAction();
	        					break;
	       			}
	        	}
        	}

	        private Object getContent(LaborwertValueItem vi,int aColumn) {
	            Object ret = null;
	            switch(aColumn){
	                case C_REZEPTUR_BEZEICHNUNG: ret = vi.getRezepturBezeichnung(); break;
	                case C_VALUE: ret = rz.getLocale().formatNumber( vi.getValue(),OptionFactory.NF_NORMAL); break;
	                case C_EINHEIT:
		                if (vi.isFix()) {
		                	ret = rz.getLocale().getString("laborwert.fix");
		                } else {
		                	ret = vi.getStrEinheit1() + " / " + vi.getStrEinheit2();
		                }
	                break;
	                case C_REZEPTURMENGE: ret = rz.getLocale().formatNumber( vi.getRezepturMenge(),OptionFactory.NF_NORMAL); break;
	                case C_REZEPTUREINHEIT: ret = vi.getStrEinheit2();break;
	                case C_MENGE: ret = rz.getLocale().formatNumber( vi.getMenge(),OptionFactory.NF_NORMAL); break;
	                case C_MENGENEINHEIT: ret = vi.getStrEinheit1();break;
	            }

	            return ret;
	        }
		}


	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
            this.setFont(rz.getFontFactory().getTableFont());
	        if(value != null) {
	           if(!rz.isZero(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_NORMAL))) {
	               setText(value.toString());
	           } else {
				setText("");
			}
	         } else {
				setText("");
			}
	        if(column == C_VALUE) {
	        	this.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GELB));
	        }else {
	        	this.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_WHITE));
	        }
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
            this.setFont(rz.getFontFactory().getTableFont());
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        if(column == C_VALUE) {
	        	this.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GELB));
	        }else {
	        	this.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_WHITE));
	        }
	        return this;
        }
	}


    public void columnAdded(TableColumnModelEvent e) {

    }
    public void columnMarginChanged(ChangeEvent e) {

    }
    public void columnMoved(TableColumnModelEvent e) {

    }
    public void columnRemoved(TableColumnModelEvent e) {

    }
    public void columnSelectionChanged(ListSelectionEvent e) {

    }


}
