/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.kontraktFenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Timer;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.kontrakt.kontraktItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class KontrakteFenster extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    	
		private JSplitPane splCenter;
    		private JPanel listenPanel;
    			private JPanel selectPanel;
    				private JLabel lblSelectTitel;
    				private JPanel musterPanel;
    					private JPanel musterAdressePanel;
    						private JLabel lblMusterAdresse;
    						private JPanel musterAdresseButtonPanel;
    							private JButton btMusterAdresseSelect;
    							private JButton btMusterAdresseClear;
    					private JPanel musterTextPanel;
	    					private JLabel lblMuster;
	    					private JSelectedTextField txtMuster;
	    					private JPanel filterPanel;
	    						private JButton btFilter;
	    						private JButton btNoFilter;
    				private JPanel activeJPanel;
    					private JCheckBox chkActive;
    			private JScrollPane scrListe;
    				private JTable tblListe;
    			private JPanel listenButtonPanel;
    				private JButton btNeu;
    				private JButton btEdit;
    				private JButton btRemove;
    				private JButton btRefresh;
    		private JPanel anzeigePanel;
    			private JScrollPane scrAnzeige;
    				private JEditorPane txtAnzeige;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "kontrakte.action_close";
    public static final int         		ACTION_NEU_CODE = 1002;
    public static final String      	ACTION_NEU_TEXT = "kontrakte.action_neu";
    public static final int         		ACTION_BEARBEITEN_CODE = 1003;
    public static final String      	ACTION_BEARBEITEN_TEXT = "kontrakte.action_bearbeiten";
    public static final int         		ACTION_DELETE_CODE = 1004;
    public static final String      	ACTION_DELETE_TEXT = "kontrakte.action_delete";
    public static final int         		ACTION_HILFE_CODE = 1006;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1008;
    public static final String      	ACTION_REFRESH_TEXT = "kontrakte.action_refresh";
    public static final int         		ACTION_SUCHEN_CODE = 1009;
    public static final String      	ACTION_SUCHEN_TEXT = "kontrakte.action_suchen";    
    public static final int         		ACTION_FILTER_CODE = 1010;
    public static final String      	ACTION_FILTER_TEXT = "kontrakte.action_filter";    
    public static final int         		ACTION_NO_FILTER_CODE = 1011;
    public static final String      	ACTION_NO_FILTER_TEXT = "kontrakte.action_nofilter";  
    public static final int         		ACTION_ADRESSE_CODE = 1012;
    public static final String      	ACTION_ADRESSE_TEXT = "kontrakte.action_adresse_select";  
    public static final int         		ACTION_ADRESSE_CLEAR_CODE = 1013;
    public static final String      	ACTION_ADRESSE_CLEAR_TEXT = "kontrakte.action_adresse_clear";  
    ArrayList<kontraktItem>								liste;
    
    Timer												ergebnisTimer;

    private static final int							MAX_COLUMN=3;
    private static final int							C_NAME=0;
    private static final int							C_TYP=1;
    private static final int							C_ADRESSE=2;
    

    
    AdressItem											adresse;
    
    /** Creates new form AdressenFenster */
    public KontrakteFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
      });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				splCenter = new JSplitPane();
				splCenter.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
				splCenter.setDividerSize(6);
				listenPanel = new JPanel(new BorderLayout());
					selectPanel = new JPanel(new GridLayout(3,1));
						selectPanel.setBorder(BorderFactory.createEtchedBorder());
						lblSelectTitel=new JLabel();
							lblSelectTitel.setHorizontalAlignment(SwingConstants.CENTER);
						selectPanel.add(lblSelectTitel);
						musterPanel = new JPanel(new BorderLayout());
						
							musterAdressePanel = new JPanel(new BorderLayout());
								lblMusterAdresse = new JLabel();
									lblMusterAdresse.setHorizontalAlignment(SwingConstants.TRAILING);
									lblMusterAdresse.setBorder(BorderFactory.createEtchedBorder());
								musterAdressePanel.add(lblMusterAdresse,BorderLayout.CENTER);
								musterAdresseButtonPanel = new JPanel(new GridLayout(1,2));
									btMusterAdresseSelect = new JButton();
								musterAdresseButtonPanel.add(btMusterAdresseSelect);
									btMusterAdresseClear = new JButton();
								musterAdresseButtonPanel.add(btMusterAdresseClear);
							musterAdressePanel.add(musterAdresseButtonPanel,BorderLayout.EAST);
							musterPanel.add(musterAdressePanel,BorderLayout.NORTH);
							musterTextPanel = new JPanel(new BorderLayout());
								lblMuster = new JLabel();
									lblMuster.setHorizontalAlignment(SwingConstants.TRAILING);
								musterTextPanel.add(lblMuster,BorderLayout.WEST);
								txtMuster = new JSelectedTextField();
								txtMuster.addKeyListener(new java.awt.event.KeyAdapter() {
						            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
						                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
						                	refreshAction();
						                }
						            }
						        });
								musterTextPanel.add(txtMuster,BorderLayout.CENTER);
								filterPanel = new JPanel(new GridLayout(1,2));
									btFilter = new JButton();
									filterPanel.add(btFilter);
									btNoFilter = new JButton();
									filterPanel.add(btNoFilter);
								musterTextPanel.add(filterPanel,BorderLayout.EAST);
							musterPanel.add(musterTextPanel,BorderLayout.SOUTH);
						selectPanel.add(musterPanel); 
						activeJPanel = new JPanel(new BorderLayout());
							chkActive = new JCheckBox();
							chkActive.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		refreshAction();
		        	        	}
			        	    });
							activeJPanel.add(chkActive,BorderLayout.WEST);
						selectPanel.add(activeJPanel,BorderLayout.SOUTH);
					listenPanel.add(selectPanel,BorderLayout.NORTH);
					
					scrListe=new JScrollPane();
						tblListe  = new JTable();
				        tblListe.setName("kontraktlistenfenster.spalten");
				        tblListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
						scrListe.setViewportView(tblListe);
						tblListe.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
				            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				            	if(evt.getValueIsAdjusting()) {
									return;
								}
				                lstErgebnisValueChanged(evt);
				            }
				        });
					listenPanel.add(scrListe,BorderLayout.CENTER);
					listenButtonPanel = new JPanel(new GridLayout(2,2));
						btNeu = new JButton();
							listenButtonPanel.add(btNeu);
						btEdit = new JButton();
							listenButtonPanel.add(btEdit);
						btRemove = new JButton();
							listenButtonPanel.add(btRemove);
						btRefresh = new JButton();
							listenButtonPanel.add(btRefresh);
					listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
				splCenter.setLeftComponent(listenPanel);
				anzeigePanel=new JPanel(new BorderLayout());
					scrAnzeige = new JScrollPane();
						txtAnzeige = new JEditorPane();
							txtAnzeige.setEditable(false);
							txtAnzeige.setContentType("text/html");
						scrAnzeige.setViewportView(txtAnzeige);
					anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
					splCenter.setRightComponent(anzeigePanel);
				contentPanel.add(splCenter,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("kontrakte.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));


      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_SUCHEN_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
      mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
      mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));

      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_SUCHEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.add(getAction(ACTION_NEU_CODE));
      tb1.add(getAction(ACTION_BEARBEITEN_CODE));
      tb1.add(getAction(ACTION_DELETE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      btNeu.setAction(getAction(ACTION_NEU_CODE));
      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
      btEdit.setAction(getAction(ACTION_BEARBEITEN_CODE));
      btRemove.setAction(getAction(ACTION_DELETE_CODE));
      btFilter.setAction(getAction(ACTION_FILTER_CODE));
      btNoFilter.setAction(getAction(ACTION_NO_FILTER_CODE));
      btMusterAdresseSelect.setAction(getAction(ACTION_ADRESSE_CODE));  
      btMusterAdresseClear.setAction(getAction(ACTION_ADRESSE_CLEAR_CODE)); 
      
		getAction(ACTION_DELETE_CODE).setEnabled(false);
		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);

	  lblSelectTitel.setText(rz.getLocale().getString("kontrakte.selectTitel"));
	  chkActive.setText(rz.getLocale().getString("kontrakte.selectActive"));
	  chkActive.setSelected(true);
	  lblMuster.setText(rz.getLocale().getString("kontrakte.label_muster"));


	  this.settblModel(tblListe);
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      setDividerLocations();
    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splCenter", this.splCenter.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        splCenter.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splCenter",this.getWidth()/3));
    }
	
    
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_REFRESH_CODE:refreshAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_DELETE_CODE:deleteAction();break;
                case ACTION_NEU_CODE:neuAction();break;
                case ACTION_BEARBEITEN_CODE:editAction();break;
                case ACTION_SUCHEN_CODE:suchenAction();break;
                case ACTION_FILTER_CODE:refreshAction();break;
                case ACTION_ADRESSE_CODE:adresseAction();break;
                case ACTION_ADRESSE_CLEAR_CODE:adresseClearAction();break;
                case ACTION_NO_FILTER_CODE:
                	txtMuster.setText("");
                	refreshAction();
                	break;
                default :
                    break;
               }
        		break;
           case MessageItem.MSG_EDIT_KONTRAKT_REPLY:
        	   refreshAction();
        	   if(msg.getMsgCode() != 0) {
        		   selectKontrakt(msg.getCode());
        	   }
        	   break;
           case MessageItem.MSG_SHOW_KONTRAKTE:
        	   openWindow();
        	   refreshAction();
        	   if(msg.getMsgCode() != 0) {
        		   selectKontrakt(msg.getCode());
        	   }
               break;
           case MessageItem.MSG_SHOW_KONTRAKTE_ADRESSE:
        	   openWindow();
        	   adresse = (AdressItem)msg.getData();
        	   lblMusterAdresse.setText(adresse.getFirma());
        	   refreshAction();
        	  
               break;               
           case MessageItem.MSG_SELECT_ADRESSE_REPLY:
           	   adresse = (AdressItem)msg.getData();
           	   lblMusterAdresse.setText(adresse.getFirma());
               refreshAction();
               break;
            default:
                break;
        }
    }


     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT, KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT,KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_FILTER_CODE),new AuswahlAction(rz,this,ACTION_FILTER_CODE,ACTION_FILTER_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_NO_FILTER_CODE),new AuswahlAction(rz,this,ACTION_NO_FILTER_CODE,ACTION_NO_FILTER_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_ADRESSE_CODE),new AuswahlAction(rz,this,ACTION_ADRESSE_CODE,ACTION_ADRESSE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_ADRESSE_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_ADRESSE_CLEAR_CODE ,ACTION_ADRESSE_CLEAR_TEXT, 0 ,0));

     }
     private void ergebnisTimerEvent(){
     	ergebnisTimer.stop();
     	ausgabeAction();
     }

     private void restartTimer() {
         if(ergebnisTimer.isRunning()) {
 			ergebnisTimer.restart();
 		} else {
 			ergebnisTimer.start();
 		}
     }
     
     private void lstErgebnisValueChanged(javax.swing.event.ListSelectionEvent evt) {
     	restartTimer();
     }
     
    

    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
			tblListe.requestFocus();
		}
        toFront();
        tblListe.requestFocus();
    }

    @Override
	public void closeWindow(){
    	saveDividerLocations();
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    /**
     * suchen
     */
    private void suchenAction() {
    	if(tblListe.getSelectedRow() != -1) {
        	final kontraktItem ki = liste.get(tblListe.getSelectedRow());
        	if(ki != null) {
        		final AbfrageItem ai = new AbfrageItem();
				ai.setID(0);
				ai.setAdressListe(new StichwortListe());
				ai.setStichwortListe(new StichwortListe());
				ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
				ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" + String.valueOf(ki.getRezeptur()) + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
				try {
					rz.setWaitCursor(this);
					JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
					frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this)); 
					rz.setFreeCursor(this);
				} catch (final Exception e) {}
    		}
    	}
    }
    
    private void selectKontrakt(int id) {
    	if(liste != null && liste.size()>0) {
    		for(int i = 0;i< liste.size();i++) {
    			if(liste.get(i).getId() == id) {
    				tblListe.setRowSelectionInterval(i, i);
    				break;
    			}
    		}
    	}
    }
    /**
     * neu anlegen
     */
    private void neuAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_EDIT_KONTRAKT,false,new MessageItem(MessageItem.MSG_EDIT_KONTRAKT,0,null,this));
    }
    /**
     * ändern
     */
    private void editAction() {
    	if(tblListe.getSelectedRow() != -1) {
    		kontraktItem ki = liste.get(tblListe.getSelectedRow());
    		if(ki != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_EDIT_KONTRAKT,false,new MessageItem(MessageItem.MSG_EDIT_KONTRAKT,ki.getId(),ki,this));
    		}
    	}
    }
    /**
     * löschen
     */
    private void deleteAction() {
    	if(tblListe.getSelectedRow() != -1) {
    		kontraktItem ki = liste.get(tblListe.getSelectedRow());
    			if(ki != null) {
    				 DialogItem di = new DialogItem(
 	                        DialogControl.FRAGE_DIALOG,
 	                        "",
 	                        0.0,
 	                        rz.getLocale().getString("kontraktliste.question_delete"),
 	                        rz.getLocale().getString("kontraktliste.question_delete"),
 	                        rz.getLocale().getString("kontraktliste.question_delete_1").replaceAll("%n",ki.getName())
 	                        	.replaceAll("%m", rz.getLocale().formatNumber(ki.getMenge(),OptionFactory.NF_ONE))
 	                        	.replaceAll("%e", rz.getDatabase().getEinheiten().getGrundeinheit(ki.getEinheit()).getName())
 	                        	.replaceAll("%d", ki.getStartDateToString() + " - " + ki.getEndDateToString())
 	                        	,
 	                        "frage.png",
 	                        rz.getLocale().getString("string_ja"),
 	                        rz.getLocale().getString("string_nein"),
 	                        this
 	                );
 	                rz.getDialogFactory().getDialog(di);
 	                if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
 	                	rz.getDatabase().getKontrakte().deleteKontrakt(ki);
 	                	refreshAction();
 	                }
    			}
    		}
    }
    /**
     * Actions enable/disable
     *
     */
    private void setActions() {
    	if(tblListe.getSelectedRow() != -1) {
    		getAction(ACTION_NEU_CODE).setEnabled(true);
    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
    		getAction(ACTION_DELETE_CODE).setEnabled(true);
    	} else {
    		getAction(ACTION_NEU_CODE).setEnabled(false);
    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
    		getAction(ACTION_DELETE_CODE).setEnabled(false);
    	}
    }

    private void adresseAction() {
    	String muster = "";
    	if(adresse != null) {
    		muster = adresse.getFirma();
    	}
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL_EINFACH,true, new MessageItem(MessageItem.MSG_SELECT_ADRESSE_REQUEST,0,muster ,this));
    }
    
    private void adresseClearAction() {
    	adresse = null;
    	lblMusterAdresse.setText("");
    	refreshAction();
    }
    /**
     * ausgewähltes Item anzeigen
     *
     */
    private void ausgabeAction() {
    	setActions();
		txtAnzeige.setEditable(true);
		txtAnzeige.setText("<html><head></head><body></body></html");
		txtAnzeige.setEditable(false);
    	if(tblListe.getSelectedRow() != -1) {
    		kontraktItem ki = liste.get(tblListe.getSelectedRow());
    		rz.getAusgabeFactory().kontrakteAusgabe(txtAnzeige, ki);
    	} 
    	tblListe.requestFocus();
    }
    /**
     * Liste neu einlesen
     */
    private void refreshAction() {
    	liste = rz.getDatabase().getKontrakte().getKontrakte( txtMuster.getText().trim(),chkActive.isSelected(),adresse);
    	((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    	if(liste != null && liste.size()>0) {
    		tblListe.setRowSelectionInterval(liste.size()-1, liste.size()-1);
    	}
    	tblListe.requestFocus();
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"kontrakte.html",this));
    }

    private void settblModel(JTable t) {
  	   final srColumnModel rcm = new srColumnModel();
  	    final StringRenderer sr = new StringRenderer();
  	    TableColumn tc = new TableColumn();
      		tc.setHeaderValue(rz.getLocale().getString("kontraktliste.tableheader_name"));
      		tc.setModelIndex(C_NAME);
      		tc.setCellRenderer(sr);
      	rcm.addColumn(tc);
  	
  	   tc = new TableColumn();
	  		tc.setHeaderValue(rz.getLocale().getString("kontraktliste.tableheader_typ"));
	  		tc.setModelIndex(C_TYP);
	  		tc.setCellRenderer(sr);
	  	rcm.addColumn(tc);
	  	
  	    tc = new TableColumn();
	  		tc.setHeaderValue(rz.getLocale().getString("kontraktliste.tableheader_adresse"));
	  		tc.setModelIndex(C_ADRESSE);
	  		tc.setCellRenderer(sr);
	  	rcm.addColumn(tc);	  	
	  	
	  	
        tblListe.setModel(new srTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
  	}
    
 	private class srColumnModel extends DefaultTableColumnModel{
 	    public srColumnModel() {
 	        super();
 	    }

 	}
    
 	private  class srTableModel extends AbstractTableModel    {

        public srTableModel() {
        }

	   public int getColumnCount() {
	       	return MAX_COLUMN;
        }
        public int getRowCount() {
        	if(liste  != null) {
                return liste.size();
        	} else {
        		return 0;
        	}
        }
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (liste != null)) {
                ret = getContent(liste.get(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }


        private Object getContent(kontraktItem ki,int aColumn,int row) {
            Object ret = null;
            if(ki != null) {
	           ret = ki;
            }
            return ret;
        }
	}
    
 	
   	/** rendert alle Tabellenzeilen mit String Inhalt
   	 *  im wesentlichen heisst das rechts-ausgerichtent
   	 * @author lunqual
   	 */
   	private class StringRenderer extends DefaultTableCellRenderer {

   	    StringRenderer() {
   	        super();
   	        setOpaque(true);
   	    }
   	    @Override
   		public Component getTableCellRendererComponent(JTable table,
                   Object value, boolean isSelected, boolean hasFocus, int row,
                   int column)
   	    {
   	    	setFont(rz.getFontFactory().getTableFont());
   	    	kontraktItem ki = (kontraktItem)value;
   	    	Color c;
   			setForeground(Color.BLACK);
   	    	if(ki.isAktiv()) {
   	    		if(isSelected) {
		    	    c = rz.getOptionFactory().getColor(OptionFactory.COLOR_GREEN);
		    	}else {
	 		   		c= rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN);
   	    		}
   	    	} else {
   	    		if(isSelected) {
   	    			setForeground(Color.WHITE);
   	    		    c = rz.getOptionFactory().getColor(OptionFactory.COLOR_RED);
   	    		}else {
	 		   		c= rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT);
   	    		}
   	    	}
   	    	setBackground(c);
   	        if(value != null) {
   	        	switch(column) {
   	        		case C_TYP: setText(ki.getTypString()); break;
   	        		case C_NAME: setText(ki.getName());break;
   	        		case C_ADRESSE: setText(ki.getAdresseText());break;
   	        	}
   	         } else {
   				setText("");
   			}
   	        setHorizontalAlignment(SwingConstants.LEADING);
   	        return this;
           }
   	}
    
    
	@Override
	public void columnAdded(TableColumnModelEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void columnRemoved(TableColumnModelEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void columnMoved(TableColumnModelEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void columnMarginChanged(ChangeEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void columnSelectionChanged(ListSelectionEvent e) {
		// TODO Auto-generated method stub
		
	}
}
