/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.konformfenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.konform.konformItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class KonformFenster extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuBearbeiten;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel sortPanel;
    			private JPanel sortButtonPanel;
					private ButtonGroup sortGroup;
						private JRadioButton btSortAlpha;
						private JRadioButton btSortKonform;
				JCheckBox chkReverse;
    		private JPanel txtPanel;
				private JScrollPane scrText;
					private JTable tblKonform;
			private JButton btRefresh;
    	private JPanel buttonPanel;
    		private JButton btClose;
			private JComboBox cmbFormulare;
			private JButton btDrucken;

    public static final int         ACTION_CLOSE_CODE = 1001;
    public static final String     ACTION_CLOSE_TEXT = "hilfe.action_close";
    public static final int         ACTION_DRUCKEN_CODE = 1002;
    public static final String     ACTION_DRUCKEN_TEXT = "hilfe.action_drucken";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_REFRESH_CODE = 1004;
    public static final String     ACTION_REFRESH_TEXT = "mhd.action_refresh";
    
    private static final int			MAX_COLUMN=3;
    private static final int			C_BEZEICHNUNG=0;
    private static final int			C_DATUM=1;
    private static final int			C_BEMERKUNGEN=2;
    
    ArrayList <konformItem>		liste;
	JRzFrame								parent;
	
    /** Creates new form HilfeFenster */
    public KonformFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }


    @Override
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new BorderLayout());
				txtPanel=new JPanel(new BorderLayout());
					sortPanel = new JPanel(new BorderLayout());
						sortButtonPanel=new JPanel(new BorderLayout());
							sortGroup=new ButtonGroup();
								btSortAlpha=new JRadioButton();
	    			             btSortAlpha.addActionListener(new java.awt.event.ActionListener() {
		    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    			                    refreshAction();
		    			                	}
		    			            	});
								sortGroup.add(btSortAlpha);
								sortButtonPanel.add(btSortAlpha,BorderLayout.NORTH);
								btSortKonform = new JRadioButton();
								btSortKonform.addActionListener(new java.awt.event.ActionListener() {
	    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    			                    refreshAction();
	    			                	}
	    			            	});
								sortGroup.add(btSortKonform);
								sortButtonPanel.add(btSortKonform,BorderLayout.SOUTH);
								btSortAlpha.setSelected(true);
							sortPanel.setBorder(BorderFactory.createEtchedBorder());
						sortPanel.add(sortButtonPanel,BorderLayout.NORTH);
						chkReverse = new JCheckBox();
						chkReverse.addActionListener(new java.awt.event.ActionListener() {
			                public void actionPerformed(java.awt.event.ActionEvent evt) {
			                    refreshAction();
			                	}
			            	});
						sortPanel.add(chkReverse,BorderLayout.SOUTH);
					contentPanel.add(sortPanel,BorderLayout.NORTH);
					scrText = new JScrollPane();
						tblKonform = new JTable();
						tblKonform.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
						tblKonform.setName("konformfenster.spalten");
		    			tblKonform.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		    			tblKonform.setColumnSelectionAllowed(true);
		    			tblKonform.setRowSelectionAllowed(true);
		    			tblKonform.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
		    			tblKonform.setShowGrid(true);
		    			tblKonform.addMouseListener(new MouseAdapter(){
						     public void mouseClicked(MouseEvent e){
						    	  listeClickedAction();
						      }
						} );
						scrText.setViewportView(tblKonform);
				txtPanel.add(scrText,BorderLayout.CENTER);
					btRefresh=new JButton();
					txtPanel.add(btRefresh,BorderLayout.SOUTH);
				contentPanel.add(txtPanel,BorderLayout.CENTER);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				cmbFormulare=new JComboBox();
				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_KONFORM);
	    	    cmbFormulare.addActionListener(new ActionListener() {
		        	public void actionPerformed(ActionEvent evt) {
		        		if(cmbFormulare.getSelectedIndex() != -1) {
		        			rz.getOptionFactory().setOption("report.konform",((ReportItem)cmbFormulare.getSelectedItem()).getID());
		        		}
		        	}
	            });
				buttonPanel.add(cmbFormulare,BorderLayout.CENTER);
				btDrucken=new JButton();
				buttonPanel.add(btDrucken,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);


    }
    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("konform.titel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));

      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.add(getAction(ACTION_DRUCKEN_CODE));

      btSortAlpha.setText(rz.getLocale().getString("konform.sort_alpha"));
      btSortKonform.setText(rz.getLocale().getString("konform.sort_datum"));
      chkReverse.setText(rz.getLocale().getString("konform.sort_reverse"));
      
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;

    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT,KeyEvent.VK_F5 ,0));

    }


    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED :
        	    switch(msg.getCode()) {
	              	case ACTION_CLOSE_CODE:closeWindow();break;
	              	case ACTION_DRUCKEN_CODE:druckenAction();break;
	              	case ACTION_HIDE_CODE:hideAction();break;
	              	case ACTION_REFRESH_CODE:refreshAction();break;
        	    }
             break;
            case MessageItem.MSG_SHOW_KONFORM:
     		    settblMhdModel(tblKonform);
            	parent=msg.getOrigin();
            	refreshAction();
            	break;
            default:
                break;
        }
    }

    @Override
	public void closeWindow() {
        //setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

   
    
    @Override
	public void openWindow() {
        setVisible(true);
        toFront();
        this.tblKonform.requestFocus();
    }

   private void refreshAction() {
	   liste = rz.getDatabase().getRezeptur().getKonformListe(btSortAlpha.isSelected(),chkReverse.isSelected());
       ((AbstractTableModel)tblKonform.getModel()).fireTableDataChanged();
	   if(parent != null) {
			parent.getMessage( new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,0,null,this));
	   }
   }

   
   private void listeClickedAction() {
	   if(tblKonform.getSelectedRow()!= -1) {
		   konformItem ki = liste.get(tblKonform.getSelectedRow());
		   if(ki != null) {
			   int c = tblKonform.getSelectedColumn();
			   if(c==C_BEZEICHNUNG) {
				   ErgebnisItem ei = rz.getDatabase().getErgebnis().getErgebnisItem(ki.getRezeptur_id());
                   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_REZEPTUR, false,new MessageItem(MessageItem.MSG_EDIT_REZEPTUR,0,ei,this));
			   }
		   }
	   }
	   
   }
   
   
   private void settblMhdModel(JTable t) {
	    final KonformColumnModel rcm = new KonformColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("konformfenster.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("konformfenster.tableheader_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("konformfenster.tableheader_bemerkungen"));
	    	tc.setModelIndex(C_BEMERKUNGEN);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
		tc = new TableColumn();
		
       rcm.addColumnModelListener(this);
       tblKonform.setModel(new KonformTableModel());
       tblKonform.setColumnModel(rcm);
       tblKonform.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
       tblKonform.getTableHeader().setReorderingAllowed(false);
	}

	private class KonformColumnModel extends DefaultTableColumnModel{
	    public KonformColumnModel() {
	        super();
	    }

	}

	private  class KonformTableModel extends AbstractTableModel    {

	        public KonformTableModel() {
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(liste != null) {
	                return liste.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public konformItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (liste != null)) {
	        		return liste.get(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (liste != null)) {
	                ret = getContent(liste.get(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        private Object getContent(konformItem ki,int aColumn,int row) {
	            Object ret = null;
	            if(ki != null) {
		            switch(aColumn){
		            	 case C_BEZEICHNUNG:
		            	     ret = ki.getRezepturBezeichnung();
		            	     break;
		            	 case C_DATUM:
		            		 ret=ki.getDatumString();
		            		 break;
		            	 case C_BEMERKUNGEN:
		            		 ret = ki.getBemerkungen();
		            		 break;
		            }
	            }
	            return ret;
	        }
		}
	
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon bearbeiten;
		
	    StringRenderer() {
	        super();
	        setOpaque(true);
            bearbeiten = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/konformfenster.icon_bearbeiten.png"));
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
    		if(isSelected) {
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setFont(rz.getFontFactory().getTableFont());
    		}
    		setIcon(null);
    		switch(column) {
    			case C_BEZEICHNUNG:
    				setIcon(bearbeiten);
    				break;
    		}
    		setText((String)value);
	        return this;
        }
	}
	
   
   
   
    private void druckenAction(){
    	rz.getReportFactory().konformReport(btSortAlpha.isSelected(),chkReverse.isSelected(),this);
    }

     private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }


	public void columnAdded(TableColumnModelEvent arg0) {
	}


	public void columnMarginChanged(ChangeEvent arg0) {
	}


	public void columnMoved(TableColumnModelEvent arg0) {
	}


	public void columnRemoved(TableColumnModelEvent arg0) {
	}


	public void columnSelectionChanged(ListSelectionEvent arg0) {
	}



}
