/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.kalenderfenster;


import java.awt.BorderLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBKalender;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.rzDatePicker.RzSimpleDatePicker;
import de.lunqual.rzpro.fenster.rzDatePicker.pickerDateListener;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.kalender.KalenderItem;
import de.lunqual.rzpro.items.kalender.TerminItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class Kalender extends JRzFrame implements Printable{

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuBearbeiten;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel auswahlPanel;
    		private JPanel auswahlTypPanel;
				private ButtonGroup typGroup;
					private JRadioButton btTypMonat;
					private JRadioButton btTypWoche;
					private JRadioButton btTyp2Wochen;
				private JCheckBox chkAnzeige;
      			private JPanel auswahlenPanel;
      				private JPanel auswahlWestPanel;
      					private JPanel auswahlDatumPanel;
    						private JButton btToday;
      						private RzSimpleDatePicker picker;
      						
	    					private JLabel lblDay;
	    					private JButton btDaySubtract;
	    					private JIntegerField intDay;
	    					private JButton btDayAdd;
	    					
							private JLabel lblMonth;
							private JButton btMonthSubtract;
	    					private JComboBox cmbMonth;
	    					private JButton btMonthAdd;
	    					
							private JLabel lblYear;
	    					private JButton btYearSubtract;
							private JIntegerField intYear;
	    					private JButton btYearAdd;
	    					
	    					private JLabel lblDay20;
	    					private JButton btDay20Subtract;
	    					private JSelectedTextField txtDay20;
	    					private JButton btDay20Add;
	    					
	    					private JLabel lblDayJulian;
	    					private JButton btDayJulianSubtract;
	    					private JIntegerField intDayJulian;
	    					private JButton btDayJulianAdd;
	    					
	    					private JLabel lblKw;
	    					private JButton btKwSubtract;
	    					private JIntegerField intKw;
	    					private JButton btKwAdd;
	    					
	    					private JButton btAuftragsliste;
	    					private JButton btAuftragslisteAnfragen;
	    					
	    					private JLabel lblFontsize;
	    					private JSpinner spFontsize;
    				
    		private JPanel textPanel;
			private JScrollPane scrText;
				private JEditorPane txtKalender;
				
    	private JPanel buttonPanel;
    		private JButton btClose;
			private JButton btDrucken;

    public static final int       	  	ACTION_CLOSE_CODE = 1001;
    public static final String     		ACTION_CLOSE_TEXT = "kalender.action_close";
    public static final int         	ACTION_DRUCKEN_CODE = 1002;
    public static final String     		ACTION_DRUCKEN_TEXT = "kalender.action_drucken";
    public static final int         	ACTION_HIDE_CODE = 1003;
    public static final String     		ACTION_HIDE_TEXT = "action_hide";
    public static final int         	ACTION_TODAY_CODE = 1004;
    public static final String     		ACTION_TODAY_TEXT = "kalender.action_today";
    public static final int         	ACTION_AUFTRAGSLISTE_CODE = 1005;
    public static final String     		ACTION_AUFTRAGSLISTE_TEXT = "kalender.action_auftragsliste";
    public static final int         	ACTION_AUFTRAGSLISTE_ANFRAGEN_CODE = 1006;
    public static final String     		ACTION_AUFTRAGSLISTE_ANFRAGEN_TEXT = "kalender.action_auftragsliste_anfragen";
    
    private static final String			DATUM_FORMAT="EEEE, dd. MMMM yyyy";

    KalenderItem						kalender;
    String[] 							monate = new DateFormatSymbols().getMonths();
    Icon								add;
    Icon								subtract;
    boolean								disablePropertyChangeReaction=false;
	
    public Kalender(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        add = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/kalender.button_add.png"));
        subtract = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/kalender.button_subtract.png"));
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }


    @Override
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new BorderLayout());
				auswahlPanel = new JPanel(new BorderLayout());

					auswahlTypPanel=new JPanel(new GridLayout(4,1));
					auswahlTypPanel.setBorder(BorderFactory.createEtchedBorder());
					typGroup=new ButtonGroup();
						btTypMonat=new JRadioButton();
						btTypMonat.addActionListener(new java.awt.event.ActionListener() {
							public void actionPerformed(java.awt.event.ActionEvent evt) {
								if(kalender != null) {
									kalender.setTyp(DBKalender.KALENDER_MONAT);
									kalender.setDetail(KalenderItem.DETAIL_AUFTRAG, 0);
									kalender.setDetail(KalenderItem.DETAIL_TERMIN, 0);	
									rz.getOptionFactory().setOption("kalender.typ",DBKalender.KALENDER_MONAT);
									refreshAusgabe();
								}
							}
						});
						typGroup.add(btTypMonat);
						auswahlTypPanel.add(btTypMonat);
						btTypWoche=new JRadioButton();
						btTypWoche.addActionListener(new java.awt.event.ActionListener() {
							public void actionPerformed(java.awt.event.ActionEvent evt) {
								if(kalender != null) {
									kalender.setTyp(DBKalender.KALENDER_WOCHE);
									kalender.setDetail(KalenderItem.DETAIL_AUFTRAG, 0);
									kalender.setDetail(KalenderItem.DETAIL_TERMIN, 0);	
									rz.getOptionFactory().setOption("kalender.typ",DBKalender.KALENDER_WOCHE);
									refreshAusgabe();
								}
							}
						});
						typGroup.add(btTypWoche);
						auswahlTypPanel.add(btTypWoche);
						btTyp2Wochen=new JRadioButton();
						btTyp2Wochen.addActionListener(new java.awt.event.ActionListener() {
							public void actionPerformed(java.awt.event.ActionEvent evt) {
								if(kalender != null) {
									kalender.setTyp(DBKalender.KALENDER_2WOCHEN);
									kalender.setDetail(KalenderItem.DETAIL_AUFTRAG, 0);
									kalender.setDetail(KalenderItem.DETAIL_TERMIN, 0);	
									rz.getOptionFactory().setOption("kalender.typ",DBKalender.KALENDER_2WOCHEN);
									refreshAusgabe();
								}
							}
						});
						typGroup.add(btTyp2Wochen);
						auswahlTypPanel.add(btTyp2Wochen);
						
						chkAnzeige = new JCheckBox();
							chkAnzeige.setBorder(BorderFactory.createEtchedBorder());
							chkAnzeige.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setAnzeige(chkAnzeige.isSelected());
										kalender.setDetail(KalenderItem.DETAIL_AUFTRAG, 0);
										kalender.setDetail(KalenderItem.DETAIL_TERMIN, 0);										
										rz.getOptionFactory().setOption("kalender.anzeige",chkAnzeige.isSelected()?1:0);
										refreshAusgabe();
									}
								}
							});
						auswahlTypPanel.add(chkAnzeige);
					auswahlPanel.add(auswahlTypPanel,BorderLayout.NORTH);
				

					auswahlenPanel=new JPanel(new BorderLayout());
						auswahlWestPanel=new JPanel(new BorderLayout());
						auswahlDatumPanel=new JPanel(new GridBagLayout());
		  					final GridBagConstraints c = new GridBagConstraints();
		  					c.weightx = 1;
		  					c.fill = GridBagConstraints.BOTH;
		  					c.insets = new Insets(1, 1, 1, 1);
		  					//---------------------------------------
							c.gridx = 0;
		  					c.gridy = 0;
		  					c.gridheight = 1;
		  					c.gridwidth = 3;
		  					btToday=new JButton();
							auswahlDatumPanel.add(btToday,c);
							//---------------------------------------------
		        	    	picker = new RzSimpleDatePicker(rz);
		        	    	picker.addListener( new pickerDateListener() {
								public void dateChanged(Date datum) {
									chooseDay();
								}
		        	    		
		        	    	});
		  					
							c.gridx = 0;
		  					c.gridy = 1;
		  					c.gridheight = 1;
		  					c.gridwidth = 3;
		  					auswahlDatumPanel.add(picker,c);
		  					//-----------------------------------
							c.gridx = 0;
		  					c.gridy = 2;
		  					c.gridheight = 1;
		  					c.gridwidth = 3;
		  					auswahlDatumPanel.add(new JSeparator(SwingConstants.HORIZONTAL),c);
							//-----------------------
							lblDay=new JLabel();
								lblDay.setHorizontalAlignment(SwingConstants.CENTER);
								c.gridx = 0;
			  					c.gridy = 3;
			  					c.gridheight = 1;
			  					c.gridwidth = 3;
							auswahlDatumPanel.add(lblDay,c);
							btDaySubtract=new JButton();
							btDaySubtract.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.DATE,-1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 0;
		  					c.gridy = 4;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btDaySubtract,c);
							intDay=new JIntegerField(1,1,31);
							intDay.addKeyListener(new java.awt.event.KeyAdapter() {
      							public void keyReleased(java.awt.event.KeyEvent evt) {
      								if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
      									intDay.validate();
      									if(kalender != null) {
      										kalender.setShowDate(Calendar.DAY_OF_MONTH,intDay.getValue());
      										refreshAusgabe();
      									}
      								}
      							}
      						});
							c.gridx = 1;
		  					c.gridy = 4;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(intDay,c);
							btDayAdd=new JButton();
							btDayAdd.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.DATE,1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 2;
		  					c.gridy = 4;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btDayAdd,c);
							
							//-------------------------------
							lblMonth=new JLabel();
								lblMonth.setHorizontalAlignment(SwingConstants.CENTER);
								c.gridx = 0;
			  					c.gridy = 5;
			  					c.gridheight = 1;
			  					c.gridwidth = 3;
							auswahlDatumPanel.add(lblMonth,c);
							btMonthSubtract=new JButton();
							btMonthSubtract.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.MONTH,-1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 0;
		  					c.gridy = 6;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btMonthSubtract,c);
							cmbMonth=new JComboBox();
					        for(int i =0;i<monate.length-1;i++) {
					        	cmbMonth.addItem(monate[i]);
					        }
					        cmbMonth.addActionListener(new ActionListener() {
  		        	        	public void actionPerformed(ActionEvent evt) {
  		        	        		if(kalender != null) {
  										kalender.setShowDate(Calendar.MONTH,cmbMonth.getSelectedIndex());
  										refreshAusgabe();
  									}
  		        	        	}
  			        	    });
							c.gridx = 1;
		  					c.gridy = 6;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(cmbMonth,c);
							btMonthAdd=new JButton();
							btMonthAdd.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.MONTH,1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 2;
		  					c.gridy = 6;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btMonthAdd,c);
							
							//--------------------------------------
							lblYear=new JLabel();
								lblYear.setHorizontalAlignment(SwingConstants.CENTER);
								c.gridx = 0;
			  					c.gridy = 7;
			  					c.gridheight = 1;
			  					c.gridwidth = 3;
							auswahlDatumPanel.add(lblYear,c);
							btYearSubtract=new JButton();
							btYearSubtract.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.YEAR,-1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 0;
		  					c.gridy = 8;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btYearSubtract,c);
							intYear=new JIntegerField(1990,1990,9999);
							intYear.addKeyListener(new java.awt.event.KeyAdapter() {
      							public void keyReleased(java.awt.event.KeyEvent evt) {
      								if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
      									if(kalender != null) {
      										kalender.setShowDate(Calendar.YEAR,intYear.getValue());
      										refreshAusgabe();
      									}
      								}
      							}
      						});
							c.gridx = 1;
		  					c.gridy = 8;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(intYear,c);
							btYearAdd=new JButton();
							btYearAdd.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.YEAR,1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 2;
		  					c.gridy = 8;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btYearAdd,c);
							
							//----------------------------------------
							lblKw=new JLabel();
								lblKw.setHorizontalAlignment(SwingConstants.CENTER);
								c.gridx = 0;
			  					c.gridy = 9;
			  					c.gridheight = 1;
			  					c.gridwidth = 3;
							auswahlDatumPanel.add(lblKw,c);
							btKwSubtract=new JButton();
							btKwSubtract.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.WEEK_OF_YEAR,-1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 0;
		  					c.gridy = 10;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btKwSubtract,c);
							intKw=new JIntegerField(1,1,53);
							intKw.addKeyListener(new java.awt.event.KeyAdapter() {
	  							public void keyReleased(java.awt.event.KeyEvent evt) {
	  								if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
	  									if(kalender != null) {
	  										kalender.setShowKw(intKw.getValue());
	  										refreshAusgabe();
	  									}
	  								}
	  							}
	  						});
							c.gridx = 1;
		  					c.gridy = 10;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(intKw,c);
							btKwAdd=new JButton();
							btKwAdd.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.WEEK_OF_YEAR,1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 2;
		  					c.gridy = 10;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btKwAdd,c);
							
							
							//-------------------------------------------
							lblDay20=new JLabel();
								lblDay20.setHorizontalAlignment(SwingConstants.CENTER);
								c.gridx = 0;
			  					c.gridy = 11;
			  					c.gridheight = 1;
			  					c.gridwidth = 3;
							auswahlDatumPanel.add(lblDay20,c);
							btDay20Subtract=new JButton();
							btDay20Subtract.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.DATE,-1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 0;
		  					c.gridy = 12;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btDay20Subtract,c);
							txtDay20=new JSelectedTextField();
							txtDay20.addKeyListener(new java.awt.event.KeyAdapter() {
	  							public void keyReleased(java.awt.event.KeyEvent evt) {
	  								if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
	  									if(kalender != null) {
	  										kalender.setShowJulianDay(rz.getDatabase().getKalender().getValidDate(txtDay20.getText().trim(),intYear.getValue(),kalender.getShow().get(Calendar.DAY_OF_YEAR)));
	  										refreshAusgabe();
	  									}
	  								}
	  							}
	  						});
							c.gridx = 1;
		  					c.gridy = 12;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(txtDay20,c);
							btDay20Add=new JButton();
							btDay20Add.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.DATE,1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 2;
		  					c.gridy = 12;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btDay20Add,c);
							
							//---------------------------------------------
							lblDayJulian=new JLabel();
								lblDayJulian.setHorizontalAlignment(SwingConstants.CENTER);
								c.gridx = 0;
			  					c.gridy = 13;
			  					c.gridheight = 1;
			  					c.gridwidth = 3;
							auswahlDatumPanel.add(lblDayJulian,c);
							btDayJulianSubtract=new JButton();
							btDayJulianSubtract.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.DATE,-1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 0;
		  					c.gridy = 14;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btDayJulianSubtract,c);
							intDayJulian=new JIntegerField(1,1,366);
							intDayJulian.addKeyListener(new java.awt.event.KeyAdapter() {
	  							public void keyReleased(java.awt.event.KeyEvent evt) {
	  								if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
	  									if(kalender != null) {
	  										kalender.setShowJulianDay(intDayJulian.getValue());
	  										refreshAusgabe();
	  									}
	  								}
	  							}
	  						});
							c.gridx = 1;
		  					c.gridy = 14;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(intDayJulian,c);
							btDayJulianAdd=new JButton();
							btDayJulianAdd.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
									if(kalender != null) {
										kalender.setShowAdd(Calendar.DATE,1);
										refreshAusgabe();
									}
								}
							});
							c.gridx = 2;
		  					c.gridy = 14;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
							auswahlDatumPanel.add(btDayJulianAdd,c);
							//------------------------------
							
							c.gridx = 0;
		  					c.gridy = 15;
		  					c.gridheight = 1;
		  					c.gridwidth = 3;
		  					auswahlDatumPanel.add(new JSeparator(SwingConstants.HORIZONTAL),c);
		  					
		  					//--------------------------------------------
							btAuftragsliste = new JButton();
							c.gridx = 0;
		  					c.gridy = 16;
		  					c.gridheight = 1;
		  					c.gridwidth = 3;
		  					auswahlDatumPanel.add(btAuftragsliste,c);
		  					
		  					//-------------------------------------------
							btAuftragslisteAnfragen = new JButton();
							c.gridx = 0;
		  					c.gridy = 17;
		  					c.gridheight = 1;
		  					c.gridwidth = 3;
		  					auswahlDatumPanel.add(btAuftragslisteAnfragen,c);
		  					
		  					//-------------------------------------------
							c.gridx = 0;
		  					c.gridy = 18;
		  					c.gridheight = 1;
		  					c.gridwidth = 3;
		  					auswahlDatumPanel.add(new JSeparator(SwingConstants.HORIZONTAL),c);
		  					
		  					//-------------------------------------------
							c.gridx = 0;
		  					c.gridy = 19;
		  					c.gridheight = 1;
		  					c.gridwidth = 2;
		  					lblFontsize = new JLabel();
		  					auswahlDatumPanel.add(lblFontsize,c);
		  					
							c.gridx = 2;
		  					c.gridy = 19;
		  					c.gridheight = 1;
		  					c.gridwidth = 1;
		  					spFontsize = new JSpinner();
		  					spFontsize.setValue(rz.getOptionFactory().getOption("kalender.fontsize",KalenderItem.DEFAULT_FONTSIZE));
		  					spFontsize.addChangeListener(new javax.swing.event.ChangeListener() {
			    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
			    	                	spinnerChanged(spFontsize);
			    	            	}
			    	           });
		  					auswahlDatumPanel.add(spFontsize,c);
		  					
						auswahlWestPanel.add(auswahlDatumPanel,BorderLayout.NORTH);
					auswahlenPanel.add(auswahlWestPanel,BorderLayout.CENTER);
					
					
				auswahlPanel.add(auswahlenPanel,BorderLayout.CENTER);
			contentPanel.add(auswahlPanel,BorderLayout.WEST);
					scrText = new JScrollPane();
						txtKalender = new JEditorPane();
				        txtKalender.setContentType("text/html");
				        txtKalender.setEditable(false);
				        txtKalender.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
				            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
				                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
					                	ergebnisLinkAction(txtKalender);
				                	}
					            }
					        });
				     	txtKalender.setEditable(false);
						scrText.setViewportView(txtKalender);
					contentPanel.add(scrText,BorderLayout.CENTER);
					
				mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				btDrucken = new JButton();
				buttonPanel.add(btDrucken,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);


    }
    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("kalender.titel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));

      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      
   	  mnuExtras.add(getAction(ACTION_AUFTRAGSLISTE_CODE));
   	  mnuExtras.add(getAction(ACTION_AUFTRAGSLISTE_ANFRAGEN_CODE));
   	  mnuExtras.addSeparator();
   	  btAuftragsliste.setAction(getAction(ACTION_AUFTRAGSLISTE_CODE));
   	  btAuftragslisteAnfragen.setAction(getAction(ACTION_AUFTRAGSLISTE_ANFRAGEN_CODE));
      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btToday.setAction(getAction(ACTION_TODAY_CODE));
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_TODAY_CODE));
      tb1.addSeparator();
   	  tb1.add(getAction(ACTION_AUFTRAGSLISTE_CODE));
   	  tb1.add(getAction(ACTION_AUFTRAGSLISTE_ANFRAGEN_CODE));
   	  tb1.addSeparator();
      tb1.add(getAction(ACTION_DRUCKEN_CODE));

      lblDay.setText(rz.getLocale().getString("kalender.label_day"));
      lblMonth.setText(rz.getLocale().getString("kalender.label_month"));
      lblYear.setText(rz.getLocale().getString("kalender.label_year"));
      lblDay20.setText(rz.getLocale().getString("kalender.label_day20"));
      lblKw.setText(rz.getLocale().getString("kalender.label_kw"));
      lblDayJulian.setText(rz.getLocale().getString("kalender.label_day_julian"));
      lblFontsize.setText(rz.getLocale().getString("kalender.label_fontsize"));
      chkAnzeige.setText(rz.getLocale().getString("kalender.label_anzeige"));
      
      btTypMonat.setText(rz.getLocale().getString("kalender.label_typ_monat"));
      btTypWoche.setText(rz.getLocale().getString("kalender.label_typ_woche"));
      btTyp2Wochen.setText(rz.getLocale().getString("kalender.label_typ_2wochen"));
      
      btDayAdd.setIcon(add);
      btDay20Add.setIcon(add);
      btDayJulianAdd.setIcon(add);
      btMonthAdd.setIcon(add);
      btYearAdd.setIcon(add);
      btKwAdd.setIcon(add);

      btDaySubtract.setIcon(subtract);
      btDay20Subtract.setIcon(subtract);
      btDayJulianSubtract.setIcon(subtract);
      btMonthSubtract.setIcon(subtract);
      btYearSubtract.setIcon(subtract);
      btKwSubtract.setIcon(subtract);
      
      
      chkAnzeige.setSelected(rz.getOptionFactory().getOption("kalender.anzeige",DBKalender.KALENDER_ANZEIGE_TERMIN_DEFAULT)==0?false:true);
      
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;

    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,KeyEvent.VK_P ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_TODAY_CODE),new AuswahlAction(rz,this,ACTION_TODAY_CODE,ACTION_TODAY_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAGSLISTE_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAGSLISTE_CODE,ACTION_AUFTRAGSLISTE_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAGSLISTE_ANFRAGEN_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAGSLISTE_ANFRAGEN_CODE,ACTION_AUFTRAGSLISTE_ANFRAGEN_TEXT,0,0));
    }


    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED :
        	    switch(msg.getCode()) {
	              	case ACTION_CLOSE_CODE:closeWindow();break;
	              	case ACTION_DRUCKEN_CODE:druckenAction();break;
	              	case ACTION_HIDE_CODE:hideAction();break;
	              	case ACTION_TODAY_CODE:todayAction();break;
	              	case ACTION_AUFTRAGSLISTE_CODE:showAuftragslisteAction();break;
	              	case ACTION_AUFTRAGSLISTE_ANFRAGEN_CODE:showAuftragslisteAnfragenAction();break;	              	
        	    }
             break;
        	case MessageItem.MSG_REFRESH_AUSGABE:
            	if(kalender == null) {
            		kalender=new KalenderItem(rz,rz.getOptionFactory().getOption("kalender.typ",DBKalender.KALENDER_MONAT));
            	}
            	refreshAusgabe();
        		break;
            case MessageItem.MSG_SHOW_KALENDER:
            	if(kalender == null) {
            		kalender=new KalenderItem(rz,rz.getOptionFactory().getOption("kalender.typ",DBKalender.KALENDER_MONAT));
            	}else {
            		kalender.setShowDayToday();
            	}
            	refreshAusgabe();
            	break;
            case MessageItem.MSG_SHOW_KALENDER_DATUM:
            	if (msg.getData() != null){
                	if(kalender == null) {
                		kalender=new KalenderItem(rz,rz.getOptionFactory().getOption("kalender.typ",DBKalender.KALENDER_MONAT));
                	}
               		kalender.setShowDate((java.util.Date)msg.getData());
            	}
            	refreshAusgabe();
            	break;
            default:
                break;
        }
    }

    @Override
	public void closeWindow() {
		rz.getOptionFactory().saveOptions();
        //setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    @Override
	public void openWindow() {
        setVisible(true);
        toFront();
        this.txtKalender.requestFocus();
    }

    private void refreshAusgabe() {
    	try {
	    	if(kalender != null) {
	    		disablePropertyChangeReaction=true;
	    		intDay.setValue(kalender.getShowDay());
	    		cmbMonth.setSelectedIndex(kalender.getShowMonth());
	    		intYear.setValue(kalender.getShowYear());
	    		txtDay20.setText(kalender.getShow20());
	    		intKw.setValue(kalender.getShowKw());
	    		intDayJulian.setValue(kalender.getShowDayJulian());
	    		Calendar c = Calendar.getInstance();
	    			c.set(Calendar.YEAR,intYear.getValue());
	    			c.set(Calendar.MONTH, cmbMonth.getSelectedIndex());
	    			c.set(Calendar.DAY_OF_MONTH,intDay.getValue());
	    		picker.setStartDate(c);
    			chkAnzeige.setSelected(kalender.isAnzeige());
	    		switch(kalender.getTyp()) {
	    			case DBKalender.KALENDER_MONAT:btTypMonat.setSelected(true);break;
	    			case DBKalender.KALENDER_WOCHE:btTypWoche.setSelected(true);break;
	    			case DBKalender.KALENDER_2WOCHEN:btTyp2Wochen.setSelected(true);break;
	    		}
	    		txtKalender.setText(kalender.getHtml());
	    		disablePropertyChangeReaction=false;
	    	}
    	}catch(Exception e) {}
    }
    
    private void todayAction() {
    	picker.setStartDate(new Date());
    	kalender.setShowDayToday();
		kalender.setDetail(KalenderItem.DETAIL_AUFTRAG, 0);
		kalender.setDetail(KalenderItem.DETAIL_TERMIN, 0);	
    	refreshAusgabe();
    }
    

    private void spinnerChanged(JSpinner sp) {
    	if(kalender != null) {
    		kalender.setFontsize((Integer)sp.getValue());
    		rz.getOptionFactory().setOption("kalender.fontsize",(Integer)sp.getValue());
    		refreshAusgabe();
    	}
    }
    
    private void chooseDay() {
    	if(kalender != null) {
    		kalender.setShowDate(picker.getDate().getTime());
			kalender.setDetail(KalenderItem.DETAIL_AUFTRAG, 0);
			kalender.setDetail(KalenderItem.DETAIL_TERMIN, 0);	
    		refreshAusgabe();
    	}
    }
    
    private void druckenAction(){
        final PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        final PageFormat pf=new PageFormat();
        pf.setOrientation(PageFormat.LANDSCAPE);
        if(job.printDialog()){
        try{
            job.print();
            }
        catch(final PrinterException pe){
                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "Kalender.druckenAction:" ,  pe.getLocalizedMessage());
            }
        }
    }

    private void showAuftragslisteAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_AUFTRAGSLISTE,0,null,this));
    }

    private void showAuftragslisteAnfragenAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_AUFTRAGSLISTE_ANFRAGEN,0,null,this));
    }
    
     private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

     private void ergebnisLinkAction(JEditorPane txt) {
		 final Document d = txt.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txt.viewToModel( txt.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
		 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
		 			if(ziel.indexOf("auf:")!= -1) {
		 				try {
                    		int auftrag=Integer.parseInt(ziel.substring(4));
                    		if(auftrag != 0) {
                    				AuftragsItem ai=rz.getDatabase().getAuftrag().getAuftragsItem(auftrag);
                    				if(ai != null) {
                    					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG, false, new MessageItem(MessageItem.MSG_EDIT_AUFTRAG,0,ai,this));
                    				}
                    			}
                    	}catch(final NumberFormatException e4) {}
		 			}else if (ziel.indexOf("rec:")!=-1){
		 				try {
		 					int rezeptur=0;
                    		double menge=0.0;
                    		String bezeichnung = "";
                    		String daten[]=ziel.substring(4).split("§");
                    		if(daten.length==3) {
                    			rezeptur=Integer.parseInt(daten[0]);
                    			menge=Double.parseDouble(daten[1]);
                    			bezeichnung=daten[2];
				 				final ErgebnisItem ei1 = new ErgebnisItem(
		                        		rz,
		                        		rezeptur,
		                        		RzPro.TYP_ID_REZEPT,
		        						bezeichnung,0,0,null,null,null,0,0,0,false,0,0,"","",20,20,false,false);
		                        ei1.setLiter(menge);
		                   		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_RECHNEN,false,new MessageItem(MessageItem.MSG_RECHNEN,0,ei1,this));
                    		}
                    	}catch(final NumberFormatException e5) {}
		 			} else if (ziel.indexOf("adp:") != -1) {
		 				try {
		 					int id = Integer.parseInt(ziel.substring(4));
		 					if(id != 0) {
		 						if(kalender != null) {
		 							kalender.setDetail(KalenderItem.DETAIL_AUFTRAG,id);
		 							refreshAusgabe();
		 						}
		 					}
		 				}catch(final NumberFormatException e6) {}
		 			}else if (ziel.indexOf("tne:") != -1) {
		 				try {
		 					long time = Long.parseLong(ziel.substring(4));
		 					if(time != 0) {
		 		    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TERMINEINGABE, false, new MessageItem(MessageItem.MSG_SHOW_TERMIN,0,Long.valueOf(time),this));
		 					}
		 				}catch(final NumberFormatException e6) {}
		 			} else if (ziel.indexOf("tsh:") != -1) {
		 				try {
		 					int id = Integer.parseInt(ziel.substring(4));
		 					if(id != 0) {
		 						if(kalender != null) {
		 							kalender.setDetail(KalenderItem.DETAIL_TERMIN,id);
		 							refreshAusgabe();
		 						}
		 					}
		 				}catch(final NumberFormatException e6) {}
		 			}else if (ziel.indexOf("ted:") != -1) {
		 				try {
		 					int id = Integer.parseInt(ziel.substring(4));
		 					if(id != 0) {
		 						TerminItem ti = rz.getDatabase().getKalender().getTermin(id);
		 						if(ti != null) {
		 							rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TERMINEINGABE, false, new MessageItem(MessageItem.MSG_EDIT_TERMIN,0,ti,this));
		 						}
		 					}
		 				}catch(final NumberFormatException e6) {}
		 			}else if (ziel.indexOf("txx:") != -1) {
		 				try {
		 					int id = Integer.parseInt(ziel.substring(4));
		 					if(id != 0) {
		 						TerminItem ti = rz.getDatabase().getKalender().getTermin(id);
		 						if(ti != null) {
		 							boolean delete =false;

		 								 DialogItem di = new DialogItem(
		 				                        DialogControl.FRAGE_DIALOG,
		 				                        "",0.0,
		 				                        rz.getLocale().getString("kalender.question_delete_termin"),
		 				                        rz.getLocale().getString("kalender.question_delete_termin"),
		 				                        rz.getLocale().getString("kalender.question_delete_termin.1")
		 				                        	.replaceAll("%s",ti.getBezeichnung())
		 				                        	.replaceAll("%d", ti.getFaelligToString()),
		 				                        "frage.png",
		 				                        rz.getLocale().getString("string_ja"),
		 				                        rz.getLocale().getString("string_nein"),
		 				                        this
		 				                );
		 				                rz.getDialogFactory().getDialog(di);
		 				                if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		 				                	delete=true;
		 				                }
			 						if(delete==true) {
		 								rz.getDatabase().getKalender().deleteTermin(id);
		 								kalender.setDetail(KalenderItem.DETAIL_TERMIN,0);
		 								rz.getFensterFactory().getFensterListe().propagateBestand(this);
				 						refreshAusgabe();
			 						}	
		 						}
		 					}
		 				}catch(final NumberFormatException e6) {}
		 			}else if (ziel.indexOf("ade:") != -1) {
		 				try {
		 					int id = Integer.parseInt(ziel.substring(4));
		 					if(id != 0) {
		 						AuftragsItem ai = rz.getDatabase().getAuftrag().getAuftragSingle(id);
		 						if(ai != null) {
		 							 String d1=ai.isAnfrage()?rz.getLocale().getString("kalender.question_delete_anfrage"):rz.getLocale().getString("kalender.question_delete_auftrag");
		 							 String d2=ai.isAnfrage()?rz.getLocale().getString("kalender.question_delete_anfrage.1"):rz.getLocale().getString("kalender.question_delete_auftrag.1");
	 								 DialogItem di = new DialogItem(
	 				                        DialogControl.FRAGE_DIALOG,
	 				                        "",0.0,
	 				                        d1,
	 				                        d1,
	 				                        d2
	 				                        	.replaceAll("%s",ai.getBezeichnung())
	 				                        	.replaceAll("%d", ai.getFaelligToString()),
	 				                        "frage.png",
	 				                        rz.getLocale().getString("string_ja"),
	 				                        rz.getLocale().getString("string_nein"),
	 				                        this
	 				                );
	 				                rz.getDialogFactory().getDialog(di);
	 				                if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
			 							rz.getDatabase().getAuftrag().deleteAuftrag(ai);
		 								kalender.setDetail(KalenderItem.DETAIL_AUFTRAG,0);
		 								rz.getFensterFactory().getFensterListe().propagateBestand(this);
				 						refreshAusgabe();
	 				                }
		 						}
		 					}
		 				}catch(final NumberFormatException e6) {}
		 			} else if (ziel.indexOf("std:") != -1) {
		 				try {
		 					long time = Long.parseLong(ziel.substring(4));
		 					if(time != 0) {
		 						kalender.setShowDate(time);
		 						refreshAusgabe();
		 					}
		 				}catch(final NumberFormatException e6) {}
		 			} else if (ziel.indexOf("af0:") != -1) {
		 				try {
		 					long time = Long.parseLong(ziel.substring(4));
		 					if(time != 0) {
	 							rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG, false, new MessageItem(MessageItem.MSG_SHOW_AUFTRAG_DATUM,0,Long.valueOf(time),this));
		 					}
		 				}catch(final NumberFormatException e6) {}
		 			} else if (ziel.indexOf("an0:") != -1) {
		 				try {
		 					long time = Long.parseLong(ziel.substring(4));
		 					if(time != 0) {
	 							rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG, false, new MessageItem(MessageItem.MSG_SHOW_ANFRAGE_DATUM,0,Long.valueOf(time),this));
		 					}
		 				}catch(final NumberFormatException e6) {}
		 			} else if (ziel.indexOf("ter:") != -1) {
			 				try {
			 					int id = Integer.parseInt(ziel.substring(4));
			 					if(id != 0) {
			 						rz.getDatabase().getKalender().terminErledigen(id,true);
			 						kalender.terminErledigen(id,true);
	 								kalender.setDetail(KalenderItem.DETAIL_TERMIN,0);
	 					    		rz.getFensterFactory().getFensterListe().propagateBestand(this);
			 						refreshAusgabe();
			 					}
			 				}catch(final NumberFormatException e6) {}
			 		}else if (ziel.indexOf("teu:") != -1) {
		 				try {
		 					int id = Integer.parseInt(ziel.substring(4));
		 					if(id != 0) {
		 						rz.getDatabase().getKalender().terminErledigen(id,false);
		 						kalender.terminErledigen(id,false);
 								kalender.setDetail(KalenderItem.DETAIL_TERMIN,0);
 					    		rz.getFensterFactory().getFensterListe().propagateBestand(this);
		 						refreshAusgabe();
		 					}
		 				}catch(final NumberFormatException e6) {}
			 		}
		 		}
		 	}
		 }
     }
     
     
     
    public int print(java.awt.Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if(pageIndex != 0){
            return Printable.NO_SUCH_PAGE;
        }
        else {
            final Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(),
                          pageFormat.getImageableY());
            final int cw = txtKalender.getWidth();
            final int ch = txtKalender.getHeight();
            final double pw = pageFormat.getImageableWidth();
            final double ph = pageFormat.getImageableHeight();
            if ((cw > pw) || (ch > ph)) {
                final double scaleX = pw / cw;
                final double scaleY = ph / ch;
                final double scale = scaleX < scaleY ? scaleX : scaleY;
                g2d.scale(scale, scale);
            }
        txtKalender.printAll(g2d);
        return Printable.PAGE_EXISTS;
        }
    }

}
