
/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.inventurfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.inventur.InventurItem;
import de.lunqual.rzpro.items.inventur.InventurListe;
import de.lunqual.rzpro.items.message.MessageItem;
/**
 *
 * @author  administrator
 */
public class InventurListenFenster extends JRzFrame{

    // GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuHilfe;
    private JMenu mnuExtras;
    private JPanel mainPanel;
		private JPanel toolbarPanel;
			private JToolBar tb1;
		private JPanel contentPanel;
			private JPanel listenPanel;
				private JScrollPane scrListe;
					private JList lstInventuren;
			private JPanel listenButtonPanel;
				private JButton btNeu;
				private JButton btBearbeiten;
				private JButton btContainer;
				private JButton btLoeschen;
			private JPanel anzeigePanel;
				private JScrollPane scrAnzeige;
					private JEditorPane txtAnzeige;
		private JPanel buttonPanel;
			private JButton btClose;
			private JButton btRefresh;
			private JButton btHilfe;

    // ActionCodes StichwortAuswahl

    public static final int         ACTION_HILFE_CODE = 1000;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1001;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int			ACTION_CLOSE_CODE=1002;
    public static final String     ACTION_CLOSE_TEXT = "inventur.action_close";
    public static final int			ACTION_REFRESH_CODE=1003;
    public static final String     ACTION_REFRESH_TEXT = "inventur.action_refresh";
    public static final int			ACTION_NEU_CODE=1004;
    public static final String     ACTION_NEU_TEXT = "inventur.action_neu";
    public static final int			ACTION_EDIT_CODE=1005;
    public static final String     ACTION_EDIT_TEXT = "inventur.action_edit";
    public static final int			ACTION_DELETE_CODE=1006;
    public static final String     ACTION_DELETE_TEXT = "inventur.action_delete";
    public static final int			ACTION_CONTAINER_CODE=1007;
    public static final String     ACTION_CONTAINER_TEXT = "inventur.action_container";

    InventurListe		liste;
    MessageItem 		mi;
    /** Creates new form AdressAuswahl */

    public InventurListenFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        mi = (MessageItem)extendedData;
        this.getMessage(mi);
    }

    /** GUI-Komponenten erzeugen
     */
    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new GridLayout(1,2));
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel = new JPanel(new BorderLayout());
					listenPanel=new JPanel(new BorderLayout());
						scrListe = new JScrollPane();
							lstInventuren= new JList();
					        lstInventuren.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					            	if(evt.getValueIsAdjusting()) {
										return;
									}
					                lstInventurenValueChanged(evt);
					            }
					        });
						scrListe.setViewportView(lstInventuren);
						listenPanel.add(scrListe,BorderLayout.CENTER);
						listenButtonPanel = new JPanel(new GridLayout(2,2));
							btNeu = new JButton();
								listenButtonPanel.add(btNeu);
							btBearbeiten = new JButton();
								listenButtonPanel.add(btBearbeiten);
								btContainer = new JButton();
									listenButtonPanel.add(btContainer);
								btLoeschen = new JButton();
								listenButtonPanel.add(btLoeschen);
						listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
					contentPanel.add(listenPanel,BorderLayout.WEST);
					anzeigePanel = new JPanel(new BorderLayout());
						scrAnzeige = new JScrollPane();
							txtAnzeige = new JEditorPane();
								txtAnzeige.setContentType("text/html");
								txtAnzeige.setEditable(false);
						scrAnzeige.setViewportView(txtAnzeige);
						anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
					contentPanel.add(anzeigePanel,BorderLayout.CENTER);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel= new JPanel(new GridLayout(1,3));
				btClose = new JButton();
					buttonPanel.add(btClose);
				btRefresh = new JButton();
					buttonPanel.add(btRefresh);
				btHilfe = new JButton();
					buttonPanel.add(btHilfe);

			getContentPane().setLayout(new BorderLayout());
				getContentPane().add(toolbarPanel,BorderLayout.NORTH);
				getContentPane().add(mainPanel,BorderLayout.CENTER);
				getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    /** GUI-Komponenten mit Text usw. versehen...
     */
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("inventur.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

        mnuDatei.add(getAction(ACTION_REFRESH_CODE));
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
        mnuBearbeiten.add(getAction(ACTION_CONTAINER_CODE));
        mnuBearbeiten.add(getAction(ACTION_EDIT_CODE));
        mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

        btClose.setAction(getAction(ACTION_CLOSE_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.add(getAction(ACTION_CLOSE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_REFRESH_CODE));
        tb1.add(getAction(ACTION_NEU_CODE));
        tb1.add(getAction(ACTION_CONTAINER_CODE));
        tb1.add(getAction(ACTION_EDIT_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_DELETE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HILFE_CODE));

        btNeu.setAction(getAction(ACTION_NEU_CODE));
        btBearbeiten.setAction(getAction(ACTION_EDIT_CODE));
        btLoeschen.setAction(getAction(ACTION_DELETE_CODE));
        btContainer.setAction(getAction(ACTION_CONTAINER_CODE));
        btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
        
        getAction(ACTION_EDIT_CODE).setEnabled(false);
        getAction(ACTION_DELETE_CODE).setEnabled(false);
        getAction(ACTION_CONTAINER_CODE).setEnabled(false);

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT,KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT,KeyEvent.VK_F6 ,0));
        actionList.put(String.valueOf(ACTION_EDIT_CODE),new AuswahlAction(rz,this,ACTION_EDIT_CODE,ACTION_EDIT_TEXT,KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_CONTAINER_CODE),new AuswahlAction(rz,this,ACTION_CONTAINER_CODE,ACTION_CONTAINER_TEXT,KeyEvent.VK_F3 ,0));

    }
    /** auf Messages reagieren
     *
     */
    @Override
	public void getMessage(MessageItem msg) {
        switch (msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_CLOSE_CODE  : cancelAction();break;
                case ACTION_HILFE_CODE : hilfeAction();break;
                case ACTION_HIDE_CODE : hideAction();break;
                case ACTION_REFRESH_CODE: refreshAction();break;
                case ACTION_NEU_CODE:neuAction();break;
                case ACTION_DELETE_CODE:loeschenAction();break;
                case ACTION_EDIT_CODE:bearbeitenAction();break;
                case ACTION_CONTAINER_CODE:containerAction();break;
                default:
                    rz.getLogFactory().logMessage(2, "inventurliste:", "auswahlAction:" + msg.getCode());
                    break;
                }
        	    break;
        	case MessageItem.MSG_INVENTUR_REFRESH:
        		refreshAction();
        		break;
        	case MessageItem.MSG_SHOW_INVENTURLISTE :
        		refreshAction();
        	    break;
        }

    }


    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    @Override
	public void openWindow(){
        setVisible(true);
        toFront();
    }


    /**
     * Löschen
     */
    private void loeschenAction() {
    	if(lstInventuren.getSelectedIndex() != -1) {
    		final InventurItem ii = (InventurItem)lstInventuren.getSelectedValue();
    		if(rz.getDatabase().getInventur().deleteInventur(ii)) {
    			refreshAction();
    		}
    	}
    }
    /**
     * neue Inventur
     */
    private void neuAction() {
    	final InventurItem ii = rz.getDatabase().getInventur().getInventur(0);
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_INVENTURFENSTER,true,new MessageItem(MessageItem.MSG_SHOW_INVENTUR,0,ii,this));
        refreshAction();
    }
    /**
     * Behälterliste bearbeiten
     */
    private void containerAction() {
    	if(lstInventuren.getSelectedIndex() != -1) {
    		final InventurItem ii = (InventurItem)lstInventuren.getSelectedValue();
    	    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_INVENTUREINGABE,false,new MessageItem(MessageItem.MSG_SHOW_INVENTUREINGABE,0,ii,this));
    	}
    }
    /**
     * Inventur bearbeiten
     */
    private void bearbeitenAction() {
    	if(lstInventuren.getSelectedIndex() != -1) {
    		final InventurItem ii = (InventurItem)lstInventuren.getSelectedValue();
    	    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_INVENTURFENSTER,true,new MessageItem(MessageItem.MSG_SHOW_INVENTUR,0,ii,this));
    	}
    }
    /**
     * Actions anpassen
     */
    private void setActions() {
    	if(liste.isEmpty()) {
            getAction(ACTION_EDIT_CODE).setEnabled(false);
            getAction(ACTION_DELETE_CODE).setEnabled(false);
            getAction(ACTION_CONTAINER_CODE).setEnabled(false);
    	} else {
    		if (lstInventuren.getSelectedIndex() != -1) {
    	        getAction(ACTION_EDIT_CODE).setEnabled(true);
    	        getAction(ACTION_DELETE_CODE).setEnabled(true);
                getAction(ACTION_CONTAINER_CODE).setEnabled(true);
    		}
    	}
    }
    /**
     * Listen Action
     */
    private void lstInventurenValueChanged(javax.swing.event.ListSelectionEvent evt) {
    	setActions();
    	if(lstInventuren.getSelectedIndex() != -1) {
    		rz.getAusgabeFactory().inventurAusgabe(liste.getItem(lstInventuren.getSelectedIndex()).getId(),txtAnzeige);
    	} else {
    		txtAnzeige.setEditable(true);
    		txtAnzeige.setText("<html><head></head><body></body></html>");
    		txtAnzeige.setEditable(false);
    	}
    }
    /**
     * Liste neu einlesen
     *
     */
    private void refreshAction() {
    	liste = rz.getDatabase().getInventur().getInventurliste();
    	lstInventuren.setListData(liste.toArray());
    	if(!liste.isEmpty()) {
    		try {
    			lstInventuren.setSelectedIndex(0);
    		} catch (final Exception e) {}
    	}
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"inventur.html",this));
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }


}
