
/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.inventurfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.inventur.InventurItem;
import de.lunqual.rzpro.items.inventur.RaumItem;
import de.lunqual.rzpro.items.inventur.Raumliste;
import de.lunqual.rzpro.items.message.MessageItem;
/**
 *
 * @author  administrator
 */
public class InventurFenster extends JRzFrame{

    // GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuHilfe;
    private JMenu mnuExtras;
    private JPanel mainPanel;
		private JPanel toolbarPanel;
			private JToolBar tb1;
		private JPanel contentPanel;
			private JPanel titelPanel;
				private JPanel bezeichnungPanel;
					private JLabel lblBezeichnung;
					private JSelectedTextField txtBezeichnung;
				private JPanel bemerkungenPanel;
					private JLabel lblBemerkungen;
					private JTextArea txtBemerkungen;
			private JPanel listenPanel;
				private JLabel lblListe;
				private JScrollPane scrListe;
					private JList lstListe;
			private JPanel listenButtonPanel;
				private JButton btAdd;
				private JButton btEdit;
				private JButton btRemove;
				private JButton btClear;
		private JPanel buttonPanel;
			private JButton btSpeichern;
			private JButton btHilfe;
			private JButton btAbbrechen;

    // ActionCodes StichwortAuswahl

    public static final int         ACTION_HILFE_CODE = 1000;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1001;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int			ACTION_ABBRECHEN_CODE=1002;
    public static final String     ACTION_ABBRECHEN_TEXT = "inventurfenster.action_abbrechen";
    public static final int			ACTION_SAVE_CODE=1003;
    public static final String     ACTION_SAVE_TEXT = "inventurfenster.action_speichern";
    public static final int			ACTION_ADD_CODE=1004;
    public static final String     ACTION_ADD_TEXT = "inventurfenster.action_add";
    public static final int			ACTION_EDIT_CODE=1005;
    public static final String     ACTION_EDIT_TEXT = "inventurfenster.action_edit";
    public static final int			ACTION_REMOVE_CODE=1006;
    public static final String     ACTION_REMOVE_TEXT = "inventurfenster.action_remove";
    public static final int			ACTION_CLEAR_CODE=1007;
    public static final String     ACTION_CLEAR_TEXT = "inventurfenster.action_clear";

    
    InventurItem	ii;
    MessageItem 	mi;
    JRzFrame 		origin;

    /** Creates new form AdressAuswahl */

    public InventurFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        mi = (MessageItem)extendedData;
        getMessage(mi);
    }

    /** GUI-Komponenten erzeugen
     */
    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel = new JPanel(new BorderLayout());
					titelPanel = new JPanel(new BorderLayout());
						bezeichnungPanel=new JPanel(new BorderLayout());
							lblBezeichnung = new JLabel();
								lblBezeichnung.setHorizontalAlignment(SwingConstants.RIGHT);
							bezeichnungPanel.add(lblBezeichnung,BorderLayout.WEST);
							txtBezeichnung = new JSelectedTextField();
							bezeichnungPanel.add(txtBezeichnung,BorderLayout.CENTER);
						titelPanel.add(bezeichnungPanel,BorderLayout.NORTH);
						bemerkungenPanel=new JPanel(new BorderLayout());
							lblBemerkungen = new JLabel();
								lblBemerkungen.setHorizontalAlignment(SwingConstants.CENTER);
							bemerkungenPanel.add(lblBemerkungen,BorderLayout.NORTH);
							txtBemerkungen = new JTextArea();
								txtBemerkungen.setRows(15);
							bemerkungenPanel.add(txtBemerkungen,BorderLayout.CENTER);
						titelPanel.add(bemerkungenPanel,BorderLayout.CENTER);
					contentPanel.add(titelPanel,BorderLayout.NORTH);
					listenPanel = new JPanel(new BorderLayout());
						lblListe = new JLabel();
							lblListe.setHorizontalAlignment(SwingConstants.CENTER);
						listenPanel.add(lblListe,BorderLayout.NORTH);
						scrListe = new JScrollPane();
							lstListe = new JList();
					        lstListe.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					                lstListeChanged();
					            }
					        });
							scrListe.setViewportView(lstListe);
						listenPanel.add(scrListe,BorderLayout.CENTER);
					contentPanel.add(listenPanel,BorderLayout.CENTER);
					listenButtonPanel =new JPanel(new GridLayout(1,4));
						btAdd=new JButton();
						listenButtonPanel.add(btAdd);
						btEdit=new JButton();
						listenButtonPanel.add(btEdit);
						btRemove=new JButton();
						listenButtonPanel.add(btRemove);
						btClear=new JButton();
						listenButtonPanel.add(btClear);
						contentPanel.add(listenButtonPanel,BorderLayout.SOUTH);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel= new JPanel(new GridLayout(1,3));
				btSpeichern = new JButton();
					buttonPanel.add(btSpeichern);
				btHilfe = new JButton();
					buttonPanel.add(btHilfe);
				btAbbrechen = new JButton();
					buttonPanel.add(btAbbrechen);

			getContentPane().setLayout(new BorderLayout());
				getContentPane().add(toolbarPanel,BorderLayout.NORTH);
				getContentPane().add(mainPanel,BorderLayout.CENTER);
				getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    /** GUI-Komponenten mit Text usw. versehen...
     */
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("inventurfenster.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

        mnuDatei.add(getAction(ACTION_SAVE_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));

        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

        btAdd.setAction(getAction(ACTION_ADD_CODE));
        btEdit.setAction(getAction(ACTION_EDIT_CODE));
        btRemove.setAction(getAction(ACTION_REMOVE_CODE));
        btClear.setAction(getAction(ACTION_CLEAR_CODE));

        btAbbrechen.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btSpeichern.setAction(getAction(ACTION_SAVE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ABBRECHEN_CODE));
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.addSeparator();;
        tb1.add(getAction(ACTION_HILFE_CODE));

        lblBezeichnung.setText(rz.getLocale().getString("inventurfenster.label_bezeichnung"));
        lblBemerkungen.setText(rz.getLocale().getString("inventurfenster.label_bemerkungen"));
        lblListe.setText(rz.getLocale().getString("inventurfenster.label_raumliste"));

        getAction(ACTION_EDIT_CODE).setEnabled(false);
        getAction(ACTION_REMOVE_CODE).setEnabled(false);

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT,KeyEvent.VK_S ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ADD_CODE),new AuswahlAction(rz,this,ACTION_ADD_CODE,ACTION_ADD_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_EDIT_CODE),new AuswahlAction(rz,this,ACTION_EDIT_CODE,ACTION_EDIT_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_REMOVE_CODE),new AuswahlAction(rz,this,ACTION_REMOVE_CODE,ACTION_REMOVE_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_CLEAR_CODE,ACTION_CLEAR_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_CLEAR_CODE,ACTION_CLEAR_TEXT,0,0));
    }
    /** auf Messages reagieren
     *
     */
    @Override
	public void getMessage(MessageItem msg) {
        switch (msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_ABBRECHEN_CODE  : cancelAction();break;
                case ACTION_HILFE_CODE : hilfeAction();break;
                case ACTION_HIDE_CODE : hideAction();break;
                case ACTION_ADD_CODE:addAction();break;
                case ACTION_EDIT_CODE:editAction();break;
                case ACTION_REMOVE_CODE:removeAction();break;
                case ACTION_CLEAR_CODE:clearAction();break;
                case ACTION_SAVE_CODE:speichernAction();break;
                default:
                    rz.getLogFactory().logMessage(2, "inventurfenster:", "auswahlAction:" + msg.getCode());
                    break;
                }
        	    break;
        	case MessageItem.MSG_SHOW_INVENTUR :
    			origin = msg.getOrigin();
        		ii = (InventurItem)msg.getData();
        		fromItem();
        	    break;
        }

    }

    /**
     * ListSelectionChanged
     */
    private void lstListeChanged() {
    	if(lstListe.getSelectedIndex() != -1) {
    		getAction(ACTION_EDIT_CODE).setEnabled(true);
    		getAction(ACTION_REMOVE_CODE).setEnabled(true);
    	} else {
    		getAction(ACTION_EDIT_CODE).setEnabled(false);
    		getAction(ACTION_REMOVE_CODE).setEnabled(false);
    	}
    }
    /**
     *  einen Raum hinzufügen
     */
    private void addAction() {
    	final DialogItem di  = new DialogItem(
                DialogControl.EINGABE_DIALOG,
                "",0.0,
                rz.getLocale().getString("inventurfenster.dialog_raum"),
                rz.getLocale().getString("inventurfenster.dialog_raum_add"),
                "",
                "frage.png",
                rz.getLocale().getString("string_ok"),
                rz.getLocale().getString("string_abbrechen"),
                null
        );
        rz.getDialogFactory().getDialog(di);
        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
        	final String raum = di.getContent().trim();
        	if(!raum.equals("")) {
        		ii.getRaumliste().addItem(new RaumItem(0,ii.getId(),raum));
        		lstListe.setListData(ii.getRaumliste().toArray());
        	}
        }
    }
    /**
     * Raum löschen
     */
    private void removeAction() {
    	if(lstListe.getSelectedIndex() != -1) {
    		if(!rz.getDatabase().getInventur().checkDeleteRaum(ii.getRaumliste().getItem(lstListe.getSelectedIndex()).getId())){
    			if(ii.getRaumliste().getItem(lstListe.getSelectedIndex()).getId() != 0) {
    				rz.getDatabase().getInventur().deleteRaum(ii.getRaumliste().getItem(lstListe.getSelectedIndex()).getId() );
    			}
    			ii.getRaumliste().remove(lstListe.getSelectedIndex());
    			lstListe.setListData(ii.getRaumliste().toArray());
    		}else {
    			// wird verwendet !
  			  final DialogItem di  = new DialogItem(
	                  DialogControl.HINWEIS_DIALOG,
	                  "",0.0,
	                  rz.getLocale().getString("inventurfenster.dialog_titel"),
	                  rz.getLocale().getString("inventurfenster.dialog_titel"),
	                  rz.getLocale().getString("inventurfenster.dialog_raum_in_use").replaceAll("%s",ii.getRaumliste().getItem(lstListe.getSelectedIndex()).getBezeichnung()),
	                  "warnung.png",
	                  rz.getLocale().getString("string_ok"),
	                  "",
	                  this
	          );
	          rz.getDialogFactory().getDialog(di);
    		}
    	}
    }
    /**
     * Raum umbenennen
     */
    private void editAction() {
    	if(lstListe.getSelectedIndex() != -1) {
    		final RaumItem ri = ii.getRaumliste().getItem(lstListe.getSelectedIndex());
        	final DialogItem di  = new DialogItem(
                    DialogControl.EINGABE_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("inventurfenster.dialog_raum"),
                    rz.getLocale().getString("inventurfenster.dialog_raum_add"),
                    ri.getBezeichnung(),
                    "frage.png",
                    rz.getLocale().getString("string_ok"),
                    rz.getLocale().getString("string_abbrechen"),
                    null
            );
            rz.getDialogFactory().getDialog(di);
            if(di.getReplyCode() == DialogControl.DIALOG_OK) {
            	final String raum = di.getContent().trim();
            	if(!raum.equals("")) {
            		ri.setBezeichnung(raum);
            		lstListe.setListData(ii.getRaumliste().toArray());
            	}
            }
    	}
    }
    /**
     * raumliste löschen
     */
    private void clearAction() {
    	for(int i = 0;i < ii.getRaumliste().size();i++) {
			if(ii.getRaumliste().getItem(lstListe.getSelectedIndex()).getId() != 0) {
				rz.getDatabase().getInventur().deleteRaum(ii.getRaumliste().getItem(lstListe.getSelectedIndex()).getId() );
			}
    	}
    	ii.setRaumliste(new Raumliste());
    	lstListe.setListData(ii.getRaumliste().toArray());
    }
    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void speichernAction(){
    	toItem();
    	if(!ii.getBezeichnung().equals("") && !ii.getRaumliste().isEmpty()) {
    		if (rz.getDatabase().getInventur().saveInventur(ii)!= 0) {
	    		closeWindow();
    		} else {

    		}
    	} else {
			  final DialogItem di  = new DialogItem(
	                  DialogControl.HINWEIS_DIALOG,
	                  "",0.0,
	                  rz.getLocale().getString("inventurfenster.dialog_titel"),
	                  rz.getLocale().getString("inventurfenster.dialog_titel"),
	                  rz.getLocale().getString("inventurfenster.dialog_not_minimum"),
	                  "warnung.png",
	                  rz.getLocale().getString("string_ok"),
	                  "",
	                  this
	          );
	          rz.getDialogFactory().getDialog(di);
    	}
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    @Override
	public void closeWindow(){
    	try {
    		origin.getMessage(new MessageItem(MessageItem.MSG_INVENTUR_REFRESH,0,ii,this ));
    	}catch (final Exception e) {}
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    @Override
	public void openWindow(){
    	if(ii != null) {
    		setVisible(true);
    		toFront();
    		txtBezeichnung.requestFocus();
    	}
    }

    /**
     * Inventur anzeigen
     *
     */
    private void fromItem() {
    	if(ii != null) {
    		txtBezeichnung.setText(ii.getBezeichnung());
    		txtBemerkungen.setText(ii.getBemerkungen());
    		if(ii.getRaumliste().isEmpty()) {
    			ii.getRaumliste().addItem(new RaumItem(0,ii.getId(),rz.getLocale().getString("inventurfenster.raumliste_ka")));
    		}
    		lstListe.setListData(ii.getRaumliste().toArray());
    	}
    }

    /**
     * Daten in das InventurItem sichern
     *
     */
    private void toItem() {
    	if(ii!=null) {
    		ii.setBezeichnung(txtBezeichnung.getText().trim());
    		ii.setBemerkungen(txtBemerkungen.getText().trim());
    	}
    }
    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"inventureingabe.html",this));
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }


}
