/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.hilfefenster;


import java.awt.BorderLayout;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.ArrayList;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.HyperlinkEvent;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.hilfe.HilfeFileItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class Hilfe extends JRzFrame implements Printable{

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuBearbeiten;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JSplitPane spl1;
    			private JPanel leftPanel;
    				private JLabel lblListenTitel;
    				private JScrollPane scrHilfe;
    					private JList lstHilfe;
    			private JPanel rightPanel;
    				private JScrollPane scrText;
    					private JEditorPane txtHilfe;
    				private JPanel rightButtonPanel;
    					private JLabel lblLink;
    					private JButton btDrucken;
    	private JPanel buttonPanel;
    		private JButton btClose;

    public static final int         ACTION_CLOSE_CODE = 1001;
    public static final String     ACTION_CLOSE_TEXT = "hilfe.action_close";
    public static final int         ACTION_DRUCKEN_CODE = 1002;
    public static final String     ACTION_DRUCKEN_TEXT = "hilfe.action_drucken";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_BACK_CODE = 1004;
    public static final String     ACTION_BACK_TEXT = "hilfe.action_back";


    ArrayList							history;
    /** Creates new form HilfeFenster */
    public Hilfe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        history=new ArrayList();
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);

    }


    @Override
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new BorderLayout());
				spl1 = new JSplitPane();
				leftPanel = new JPanel(new BorderLayout());
					lblListenTitel = new JLabel();
						lblListenTitel.setHorizontalAlignment(SwingConstants.CENTER);
					leftPanel.add(lblListenTitel,BorderLayout.NORTH);
					scrHilfe = new JScrollPane();
						lstHilfe = new JList();
							lstHilfe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
					        lstHilfe.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					                if(!evt.getValueIsAdjusting()) {
						                if(lstHilfe.getSelectedIndex() != -1){
						                    final HilfeFileItem hi = (HilfeFileItem)lstHilfe.getSelectedValue();
						                    history.add(hi.getURL());
						                    setContent(hi.getURL());
						                }
					                }
					            }
					        });
							scrHilfe.setViewportView(lstHilfe);
						leftPanel.add(scrHilfe,BorderLayout.CENTER);
				rightPanel = new JPanel(new BorderLayout());
					scrText = new JScrollPane();
						txtHilfe = new JEditorPane();
				        txtHilfe.setContentType("text/html");
				        txtHilfe.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
				            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
				                txtHilfeHyperlinkUpdate(evt);
					            }
					        });
							txtHilfe.setEditable(false);
						scrText.setViewportView(txtHilfe);
					rightPanel.add(scrText,BorderLayout.CENTER);
					rightButtonPanel=new JPanel(new BorderLayout());
						lblLink = new JLabel();
							lblLink.setHorizontalAlignment(SwingConstants.CENTER);
						rightButtonPanel.add(lblLink);
						btDrucken = new JButton();
						rightButtonPanel.add(btDrucken,BorderLayout.SOUTH);
					rightPanel.add(rightButtonPanel,BorderLayout.SOUTH);
				spl1.setLeftComponent(leftPanel);
				spl1.setRightComponent(rightPanel);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			mainPanel.add(spl1,BorderLayout.CENTER);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);


    }
    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("hilfe.titel"));
      lblListenTitel.setText(rz.getLocale().getString("hilfe.listentitel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));

      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuBearbeiten.add(getAction(ACTION_BACK_CODE));
      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_BACK_CODE));
      tb1.add(getAction(ACTION_DRUCKEN_CODE));

      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      setDividerLocations();
      lstHilfe.setListData(rz.getHilfeFactory().getHilfeListe().toArray());

    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BACK_CODE),new AuswahlAction(rz,this,ACTION_BACK_CODE,ACTION_BACK_TEXT,KeyEvent.VK_LEFT ,0));

    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getWidth()/3));
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED :
        	    switch(msg.getCode()) {
	              	case ACTION_CLOSE_CODE:closeWindow();break;
	              	case ACTION_DRUCKEN_CODE:druckenAction();break;
	              	case ACTION_HIDE_CODE:hideAction();break;
	              	case ACTION_BACK_CODE:backAction();break;
        	    }
             break;
            case MessageItem.MSG_HILFE :
            	setThema((String)msg.getData());
            	setActions();
            default:
                rz.getLogFactory().logMessage(2, "HilfeFenster:", "auswahlAction:" + msg.getCode());
                break;
        }
    }

    @Override
	public void closeWindow() {
        saveDividerLocations();
       // setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    @Override
	public void openWindow() {
        setVisible(true);
        lstHilfe.requestFocus();
    }

    private void backAction() {
       if(history.size() > 1) {
           setContent(((URL)history.get(history.size()-2)));
           history.remove(history.get(history.size()-1));
       }
        setActions();
    }

    private void setActions() {
        if(history.size() < 2) {
            getAction(ACTION_BACK_CODE).setEnabled(false);
        } else {
            getAction(ACTION_BACK_CODE).setEnabled(true);
            try {
            	getAction(ACTION_BACK_CODE).putValue(Action.SHORT_DESCRIPTION,((URL)history.get(history.size()-2)).getFile());
            } catch (final Exception e) {
            	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"Hilfefenster:setActions",e.getLocalizedMessage());
            }

        }
    }
    private void txtHilfeHyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
        if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
            history.add(evt.getURL());
            setContent(evt.getURL());
        }
        else if(evt.getEventType() == HyperlinkEvent.EventType.ENTERED){
            lblLink.setText(evt.getURL().getPath());
            } else if(evt.getEventType() == HyperlinkEvent.EventType.EXITED){
                lblLink.setText("");
            }
    }

    /** lädt eine HTML-Seite aus einr URL in die JEditorPane
     * wenn aListe==true, wird auch noch das entpsrechende Element in der
     * Auswahlliste selektiert
     */
    private void setContent(URL u){
        txtHilfe.setEditable(true);
        setActions();
        try{
              txtHilfe.setPage(u);
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"Hilfe.setContent", e.getLocalizedMessage());
        }
        txtHilfe.setEditable(false);
    }

    /** wird von RzPro aufgerufen, welches seinerseits die Anforderung
     * per putMessage() erhalten hat... */
    public void setThema(String t){
        HilfeFileItem hi;
        for(int i = 0;i < lstHilfe.getModel().getSize();i++){
            hi = (HilfeFileItem)lstHilfe.getModel().getElementAt(i);
            if(hi.getName().toLowerCase().equals(t.toLowerCase())){
                setContent(hi.getURL());
                break;
            }
        }
    }

    private void druckenAction(){
        final PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        if(job.printDialog()){
        try{
            job.print();
            }
        catch(final PrinterException pe){
                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "HilfeFenster.druckenAction:" ,  pe.getLocalizedMessage());
            }
        }
    }

     private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    public int print(java.awt.Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if(pageIndex != 0){
            return Printable.NO_SUCH_PAGE;
        }
        else {
            final Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(),
                          pageFormat.getImageableY());
            final int cw = txtHilfe.getWidth();
            final int ch = txtHilfe.getHeight();
            final double pw = pageFormat.getImageableWidth();
            final double ph = pageFormat.getImageableHeight();
            if ((cw > pw) || (ch > ph)) {
                final double scaleX = pw / cw;
                final double scaleY = ph / ch;
                final double scale = scaleX < scaleY ? scaleX : scaleY;
                g2d.scale(scale, scale);
            }
        txtHilfe.printAll(g2d);
        return Printable.PAGE_EXISTS;
        }
    }

}
